
*********************************************************************************
*                                                                               *
* PROGRAM:                PDE_PUF_2008_READIN.sas                               *
*                                                                               *
* DESCRIPTION:            To read csv format PDE PUF                            *
*                         into SAS dataset                                      *
*                                                                               *
* INPUT FILES:            2008_PD_Profiles_PUF.csv                              *
*			  DRUG_NAME_TABLE.csv                                   *
*                         DRUG_MAJOR_CLASS_TABLE.csv                            *
*                         DRUG_CLASS_TABLE.csv                                  *
*                                                                               *
* OUTPUT FILES:           Bsa_partd_puf_2008.sas7bdat                           *
*                                                                               *
* OTHER OUTPUT:           Contents, proc print and freq distribution            *
*                                                                               *
*                                                                               *
*********************************************************************************;

FOOTNOTE 'PDE_PUF_2008.sas';

* Log/List Options *;
options ls=120 ps=42 missing=' ' nocenter validvarname=upcase compress=binary;

* Input File Reference *;
filename in "MYPATH\PDEfinalPUF.csv" ;  * <-- Replace MYPATH with Input File Path *;
filename lookup1 "MYPATH\DRUG_NAME_TABLE.csv" ;  * <-- Replace MYPATH with DRUG NAME Lookup File Path Here *;
filename lookup2 "MYPATH\DRUG_MAJOR_CLASS_TABLE.csv" ;  * <-- Replace MYPATH with DRUG MAJOR CLASS Lookup File Path *;
filename lookup3 "MYPATH\DRUG_CLASS_TABLE.csv" ;  * <-- Replace MYPATH with DRUG CLASS Lookup File Path Here *;

* Output SAS Library *;
libname PUF 'INSERT_OUPUT_DIRECTORY_NAME'; * <-- Place Output Library Path Here *;


*Formats Code : Uncomment the following if want to include formats *;
/*
Proc format;

Value $SEXF
        '1' = 'MALE '
        '2' = 'FEMALE'
;

Value AGEF
        1     = 'Under  65 '
        2     = '65 - 69 '
        3     = '70 - 74 '
        4     = '75 - 79 '
        5     = '80 - 84 '
        6     = '85 & Older'
;

Value $DRGTYP
        '*'     = 'Suppressed'
        '0'     = 'Unknown/Missing'
        '1'     = 'Brand Name'
        '2'     = 'Generic Name'
;

Value $PLANTYP
        '*'     = 'Suppressed'
        '1'     = 'MAPD'
        '2'     = 'PDP'
        '3'     = 'Other'
;

Value $COVGTYP
		'0'     = 'Unknown/Missing'
        '*'     = 'Suppressed'
        '1'     = 'DUAL Eligible'
        '2'     = 'Low income Subsidy'
        '3'     = 'No Subsidy'
;

Value $BENEPHA
        '*'     = 'Suppressed'
        '0'     = 'No information'
        '1'     = 'Catastrophic'
        '2'     = 'Deductible'
        '3'     = 'Initial Coverage Limit'
        '4'     = 'Non-covered Drug'
        '5'     = 'Pre-Initial Coverage Limit'
;

Value $BENETYP
        '*'     = 'Suppressed'
        '1'     = 'Defined Standard' 
        '0'     = 'No Plan Benefit Information'
        '2'     = 'Actuarially Equivalent'
        '3'     = 'Basic Alternative'        
        '4'     = 'Enhanced Alternative'
;

Value $GAPCOV
        '*'     = 'Suppressed'
        '0'     = 'Unknown/Missing'
        '1'     = 'No Gap Coverage'
        '2'     = 'Plan offers Gap Coverage'
;

Value $PRESCTYP
		'*'     = 'Suppressed'
		'1'     = 'Family Medicine' 
		'2'     = 'Internal Medicine'
        '3'     = 'Psychiatry & Neurology'
		'4'     = 'Specialist'
        '5'     = 'Other'
;

Value BENECNT 
		1		='11-15'
		2		='16-20'
		3		='21-50'
		4		='51-100'
		5		='101-500'
		6		='501+'
;

run;


data DRUG_NAME                               ;
  infile LOOKUP1 delimiter = ',' MISSOVER DSD lrecl=32767 firstobs=2 ;

  informat RXNORM_RXCUI $8. ;
  informat DRUG_NAME $546. ;
  format RXNORM_RXCUI $8. ;
  format DRUG_NAME $546. ;
  input
        RXNORM_RXCUI $
        DRUG_NAME $
  ;
run;

data drugnm_fmt;
  set drug_name;
  retain fmtname "$DRGNM";

  rename RXNORM_RXCUI=start
         DRUG_NAME=label;
run;

proc format cntlin=drugnm_fmt;
run;

PROC IMPORT OUT=drug_major
  DATAFILE=lookup2
  DBMS=csv REPLACE;
  GETNAMES=YES;
RUN;

data drugmaj_fmt;
  set drug_major;
  retain fmtname "$DRGMAJ";
  rename DRUG_MAJOR_CLASS=start
         DRUG_MAJOR_CLASS_DESC=label;
run;

proc format cntlin=drugmaj_fmt;
run;

PROC IMPORT OUT=drug_cls
  DATAFILE=lookup3
  DBMS=csv REPLACE;
  GETNAMES=YES;
RUN;

data drugcls_fmt;
  set drug_cls;
  retain fmtname "$DRGCLS";
  rename DRUG_CLASS=start
         DRUG_CLASS_DESC=label;
run;

proc format cntlin=drugcls_fmt;
run;

* END COMMENTED out SECTION ;
*/

data PUF.Bsa_partd_puf_2008(label='PRESCR DRUG EVENTS PUBLIC USE FILE');

infile in dlm = ',' dsd missover truncover firstobs = 2;


  * Input Record *;
  input     BENE_SEX_IDENT_CD    $ 
            BENE_AGE_CAT_CD   
            RXNORM_RXCUI         $
            DRUG_MAJOR_CLASS     $
            DRUG_CLASS           $
            PDE_DRUG_TYPE_CD     $
            PLAN_TYPE            $
            COVERAGE_TYPE        $
            BENEFIT_PHASE        $
            DRUG_BENEFIT_TYPE    $
            PRESCRIBER_TYPE      $
            GAP_COVERAGE         $
            TIER_ID              $
            MEAN_RXHCC_SCORE    
            AVE_DAYS_SUPPLY     
            AVE_TOT_DRUG_COST   
            AVE_PTNT_PAY_AMT    
            PDE_CNT             
            BENE_CNT_CAT        

;

  * Formats *;
*** Uncomment following to apply formats ;

/*

format
		BENE_SEX_IDENT_CD     $SEXF.
        BENE_AGE_CAT_CD       AGEF.
        RXNORM_RXCUI          $DRGNM.
		DRUG_MAJOR_CLASS 	  $DRGMAJ.
		DRUG_CLASS			  $DRGCLS.
		PDE_DRUG_TYPE_CD	  $DRGTYP.
		PLAN_TYPE             $PLANTYP.
		COVERAGE_TYPE	      $COVGTYP.
		BENEFIT_PHASE         $BENEPHA.
		DRUG_BENEFIT_TYPE     $BENETYP.
		PRESCRIBER_TYPE       $PRESCTYP. 
		GAP_COVERAGE          $GAPCOV.
		BENE_CNT_CAT 		  BENECNT.;

 */
		
  * Labels *;
  label     BENE_SEX_IDENT_CD   = "Beneficiary gender code "
            BENE_AGE_CAT_CD  = "Beneficiary age category code"
            RXNORM_RXCUI     = "RxNORM identifier"
            DRUG_MAJOR_CLASS = "Drug major class (level 0)"
            DRUG_CLASS       = "Drug class (level 1)"
            PDE_DRUG_TYPE_CD = "Drug type"  
            PLAN_TYPE        = "Plan type"
            COVERAGE_TYPE    = "Coverage type"
            benefit_phase    = "Benefit phase"
            DRUG_BENEFIT_TYPE= "Drug benefit type"
            PRESCRIBER_TYPE  = "Prescriber type"
            GAP_COVERAGE     = "Gap coverage indicator"
            TIER_ID          = "Tier id"        
            MEAN_RXHCC_SCORE = "Average RxHCC score"
            AVE_DAYS_SUPPLY  = "Average days supply"
            AVE_TOT_DRUG_COST= "Average total drug cost"
            AVE_PTNT_PAY_AMT = "Average patient payment"
            PDE_CNT          = "Number of Part D events in profile"
            BENE_CNT_CAT     = "Number of beneficiaries in profile"
;
run;


title 'PRESCR DRUG EVENTS PUBLIC USE FILE';
proc contents data=PUF.Bsa_partd_puf_2008 varnum; RUN;

proc print data=PUF.Bsa_partd_puf_2008(obs=10);
  title2 'Sample Listing - 10 Rows';
run;

proc freq data=PUF.Bsa_partd_puf_2008;
  title2 'Freqs';
  tables    BENE_SEX_IDENT_CD    
            BENE_AGE_CAT_CD   
            DRUG_MAJOR_CLASS     
            DRUG_CLASS           
            PDE_DRUG_TYPE_CD     
            PLAN_TYPE            
            COVERAGE_TYPE        
            BENEFIT_PHASE        
            DRUG_BENEFIT_TYPE    
            PRESCRIBER_TYPE      
            GAP_COVERAGE         
            TIER_ID                          
            BENE_CNT_CAT        

            /missing;
run;




* End of Program *;
