
/*********************************************************************************\

PROGRAM:                Carrier_PUF_2010.sas

DESCRIPTION:            To read csv format CARRIER PUFs to SAS dataset

INPUT FILES:            BSA_Carrier_PUF_2010.csv

OUTPUT FILES:           Carrier_PUF_2010.sas7bdat

OTHER OUTPUT:           Contents, proc print and freq distribution


\*********************************************************************************/

FOOTNOTE 'Carrier_PUF_2010.sas';

* Log/List Options *;
options ls=120 ps=42 missing=' ' nocenter validvarname=upcase compress=binary;

* Input File Reference *;
%let in= INSERT_INPUT DIRECTORY PATH ;   *<-- File Path where csv files are downloaded ;

* Output SAS Library *;
libname PUF 'INSERT_OUTPUT_DIRECTORY_NAME'; * <-- Place Output Library Path Here *;


%macro readin;
* Formats Code : Uncomment the following if want to include formats *;

/*
Proc format;

Value SEXF
        1 = 'MALE '
        2 = 'FEMALE'
;

Value AGEF
        1       = 'Under  65 '
        2       = '65 - 69 '
        3       = '70 - 74 '
        4       = '75 - 79 '
        5       = '80 - 84 '
        6       = '85 & Older'
;
run;
*/

data BSA_Carrier_PUF_2010(label="BSA CARRIER PUBLIC USE FILE");
  infile "&in.\2010_BSA_Carrier_PUF.csv" dlm = ',' dsd missover truncover firstobs = 2 ;

  * Input Record *;
  input BENE_SEX_IDENT_CD
        BENE_AGE_CAT_CD
        CAR_LINE_ICD9_DGNS_CD     :$4.
        CAR_LINE_HCPCS_CD         :$5.
        CAR_LINE_BETOS_CD         :$3.
        CAR_LINE_SRVC_CNT         :3.
        CAR_LINE_PRVDR_TYPE_CD    :$1.
        CAR_LINE_CMS_TYPE_SRVC_CD :$1.
        CAR_LINE_PLACE_OF_SRVC_CD :$2.
        CAR_HCPCS_PMT_AMT          :8.
        CAR_LINE_CNT              :8.
  ;

  * Formats *;

/*
*** Uncomment following to apply formats ;
format BENE_SEX_IDENT_CD         SEXF.
       BENE_AGE_CAT_CD           AGEF.
  ;
*/

* Labels *;
label BENE_SEX_IDENT_CD                 = "Beneficiary gender code "
      BENE_AGE_CAT_CD                   = "Beneficiary Age category code "
      CAR_LINE_ICD9_DGNS_CD             = "3 digit ICD9 Diagnosis codes"
      CAR_LINE_HCPCS_CD                 = "HCPCS Level 1 codes"
      CAR_LINE_BETOS_CD                 = "BETOS code"
      CAR_LINE_SRVC_CNT                 = "Count of services"
      CAR_LINE_PRVDR_TYPE_CD            = "Code for the type of provider furnishing the service. "
      CAR_LINE_CMS_TYPE_SRVC_CD         = "Code indicating type of service"
      CAR_LINE_PLACE_OF_SRVC_CD         = "Code indicating place of service"
      CAR_HCPCS_PMT_AMT                 = "Medicare Payment amount"
      CAR_LINE_CNT                      = "Carrier line count"
;
run;

/*Uncomment this for creating SAS DATASET with descriptions for ICD9 CODES,Provider type code,
type of service,place of service Betos codes*/

/*
data  ICD9_CODES;
infile "&in.\ICD9_CODES.csv" dsd  missover truncover firstobs=2 lrecl=1000;
input  LINE_ICD9_DGNS_CD :$4. ICD9_DESC :$175. ;
run;

data  prvdr_type_CODES;
infile "&in.\prvdr_type_CODES.csv" dsd  missover truncover firstobs=2 lrecl=1000;
input  LINE_PRVDR_TYPE_CD :$1. PRVDR_TYPE_DESC:$300. ;
run;

data  type_srvc_CODES;
infile "&in.\type_srvc_CODES.csv" dsd  missover truncover firstobs=2 lrecl=1000;
input   LINE_CMS_TYPE_SRVC_CD:$1. TYPE_SRVC_DESC :$300.;
run;

data  place_srvc_CODES;
infile "&in.\place_srvc_CODES.csv" dsd  missover truncover firstobs=2 lrecl=1000;
input  LINE_PLACE_OF_SRVC_CD:$2. PLACE_SRVC_DESC :$300.;
run;

data  BETOS_CODES;
infile "&in.\BETOS_CODES.csv" dsd  missover truncover firstobs=2 lrecl=1000;
input  CAR_LINE_BETOS_CD:$3. BETOS_DESC :$300.;
run;

proc SQL;
 create table BSA_Carrier_PUF_2010 as
 select  a.*, b.ICD9_DESC, c.PRVDR_TYPE_DESC, d.TYPE_SRVC_DESC, e.PLACE_SRVC_DESC,f.BETOS_DESC
 from BSA_Carrier_PUF_2010 as a left join ICD9_CODES as b on
 a.CAR_LINE_ICD9_DGNS_CD = b.LINE_ICD9_DGNS_CD left join prvdr_type_CODES as c on a.CAR_LINE_PRVDR_TYPE_CD=c.LINE_PRVDR_TYPE_CD
 left join type_srvc_CODES as d on a.CAR_LINE_CMS_TYPE_SRVC_CD=d.LINE_CMS_TYPE_SRVC_CD left join place_srvc_CODES as e on
 a.CAR_LINE_PLACE_OF_SRVC_CD=e.LINE_PLACE_OF_SRVC_CD LEFT JOIN BETOS_CODES AS F ON a.CAR_LINE_BETOS_CD=f.CAR_LINE_BETOS_CD;
quit;
*/

%mend;

%readin;

data PUF.Carrier_PUF_2010;
  retain BENE_SEX_IDENT_CD BENE_AGE_CAT_CD CAR_LINE_ICD9_DGNS_CD ICD9_DESC CAR_LINE_HCPCS_CD
         CAR_LINE_BETOS_CD BETOS_DESC CAR_LINE_SRVC_CNT CAR_LINE_PRVDR_TYPE_CD PRVDR_TYPE_DESC
         CAR_LINE_CMS_TYPE_SRVC_CD TYPE_SRVC_DESC CAR_LINE_PLACE_OF_SRVC_CD PLACE_SRVC_DESC CAR_HCPCS_PMT_AMT ;
set BSA_Carrier_PUF_2010;

label ICD9_DESC                              = "ICD9 Description "
      PRVDR_TYPE_DESC                        = "Provider Type Description"
      TYPE_SRVC_DESC                         = "Type of service Description"
      PLACE_SRVC_DESC                        = "Place of service Description"
      BETOS_DESC                             = "Betos Description"
  ;
run;

proc contents data=PUF.Carrier_PUF_2010 varnum ;

title "CARRIER PUBLIC USE FILE";
run;

proc print data=PUF.Carrier_PUF_2010(obs=10);
  title2 "Sample Listing - 10 Rows ";
run;

proc freq data=PUF.Carrier_PUF_2010;
  title2 "Freqs ";
  table BENE_SEX_IDENT_CD
        BENE_AGE_CAT_CD
        CAR_LINE_ICD9_DGNS_CD
        CAR_LINE_HCPCS_CD
        CAR_LINE_BETOS_CD
        CAR_LINE_SRVC_CNT
        CAR_LINE_PRVDR_TYPE_CD
        CAR_LINE_CMS_TYPE_SRVC_CD
        CAR_LINE_PLACE_OF_SRVC_CD
        CAR_HCPCS_PMT_AMT/missing ;
run;

* End of Program *;
