
/*********************************************************************************\

PROGRAM:                DME_PUF_2010_READIN.sas

DESCRIPTION:            To read csv format DME PUF to SAS dataset

INPUT FILES:            DME_PUF_2010.csv

OUTPUT FILES:           DME_PUF_2010.sas7bdat

OTHER OUTPUT:           Contents, proc print and freq distribution


\*********************************************************************************/

FOOTNOTE 'BSA_DME_PUF_2010.sas';

* Log/List Options *;
options ls=120 ps=42 missing=' ' nocenter validvarname=upcase compress=binary;

* Input File Reference *;
filename in "INSERT_INPUT_DIRECTORY_NAME\BSA_DME_PUF_2010.csv" ; * <-- Place Input File Path Here *;

* Lookup File References *;
filename icd9fmt  ".";  * <-- Place ICD9 CSV lookup File Path Here *;
filename hcpcsfmt ".";  * <-- Place HCPCS CSV lookup File Path Here *;

* Output SAS Library *;
libname PUF 'INSERT_OUTPUT_DIRECTORY_NAME'; * <-- Place Output Library Path Here *;

*Formats Code : Uncomment the following if want to include formats *;
/*
Proc format;

Value SEXF
        1 = 'MALE '
        2 = 'FEMALE'
;

Value AGEF
        1       = 'Under  65 '
        2       = '65 - 69 '
        3       = '70 - 74 '
        4       = '75 - 79 '
        5       = '80 - 84 '
        6       = '85 & Older'
;
run;
*/

data PUF.BSA_DME_PUF_2010(label='BSA DME PUBLIC USE FILE');

infile in dlm = ',' dsd missover truncover firstobs = 2;

  * Input Record *;
  input BENE_SEX_IDENT_CD
        BENE_AGE_CAT_CD
        DME_LINE_ICD9_DGNS_CD           :$4.
        DME_LINE_HCPCS_CD               :$5.
        DME_LINE_SRVC_CNT
        DME_LINE_PMT_AMT
        LINE_ITEM_CNT
  ;

  * Formats *;

*** Uncomment following to apply formats ;
/*
  format BENE_SEX_IDENT_CD             SEXF.
         BENE_AGE_CAT_CD               AGEF.
  ;
*/
  * Labels *;
  label BENE_SEX_IDENT_CD                 = "Beneficiary gender code "
        BENE_AGE_CAT_CD                   = "Beneficiary Age category code "
        DME_LINE_ICD9_DGNS_CD             = "3 Digit Diagnosis code"
        DME_LINE_HCPCS_CD                 = "HCPCS Code"
        DME_LINE_SRVC_CNT                 = "No of Services per line item"
        DME_LINE_PMT_AMT                  = "Medicare Payment"
        LINE_ITEM_CNT                     = "Line Items count"
;
run;

/*Uncomment this for creating SAS DATASET with descriptions for ICD9 CODES*/
/*
data icd9_codes;
infile icd9fmt dsd  missover truncover firstobs=2 lrecl=200;
input  icd9_cd :$4. icd9_description :$175. ;
run;

proc sql;
create table puf.bsa_dme_puf_2010 as
select a.*, b.icd9_description
from  puf.bsa_dme_puf_2010 a left join icd9_codes b
on a.dme_line_icd9_dgns_cd= b.icd9_cd;
quit;

data hcpcs_codes;
infile hcpcsfmt dsd  missover truncover firstobs=2 lrecl=40;
input hcpcs_cd :$5. hcpcs_short_desc :$30. ;
run;

proc sql;
create table puf.bsa_dme_puf_2010 as
select a.*, b.hcpcs_short_desc
from puf.bsa_dme_puf_2010 a left join hcpcs_codes b
on a.dme_line_hcpcs_cd= b.hcpcs_cd;
quit;
*/

title 'DME PUBLIC USE FILE';

proc contents data=PUF.BSA_DME_PUF_2010 varnum;

proc print data=PUF.BSA_DME_PUF_2010 (obs=10);
  title2 'Sample Listing - 10 Rows';
run;

proc freq data=PUF.BSA_DME_PUF_2010;
  title2 'Freqs';
  table BENE_SEX_IDENT_CD
        BENE_AGE_CAT_CD
        DME_LINE_ICD9_DGNS_CD
        DME_LINE_HCPCS_CD
        DME_LINE_SRVC_CNT
        DME_LINE_PMT_AMT  /missing;
run;

* End of Program *;
