
/*********************************************************************************\

PROGRAM:                BSA_IPBS_PUF_2010_READIN.sas

DESCRIPTION:            To read csv format IPBS PUF to SAS dataset

INPUT FILES:            2010_BSA_IPBS_PUF.csv

OUTPUT FILES:           BSA_IPBS_PUF_2010.sas7bdat

OTHER OUTPUT:           Contents, proc print and freq distribution


\*********************************************************************************/

FOOTNOTE 'BSA_HHA_PUF_2010.sas';

* Log/List Options *;
options ls=120 ps=42 missing=' ' nocenter validvarname=upcase compress=binary;

* Input File Reference *;
filename in '.'; * <-- Place Input File Path Here *;

* Output SAS Library *;
libname PUF '.'; * <-- Place Output Library Path Here *;

data PUF.BSA_IPBS_PUF_2010(label='IPBS PUBLIC USE FILE');

  infile in dlm = ',' dsd missover truncover firstobs = 2  lrecl=700;

  * Input Record *;
  input provider_id            :$6.
        hrr_prov               :$8.                                                                      
        facility_type          :$25.                                                                           
        bene_cnt               :$25.                                                                       
        death_bene_cnt                                                                                     
        sex_male_bene_cnt                                                                                 
        sex_female_bene_cnt                                                                              
        race_white_bene_cnt                                                                                  
        race_black_bene_cnt                                                                              
        race_hispn_bene_cnt                                                                              
        race_api_bene_cnt                                                                              
        race_natind_bene_cnt                                                                    
        race_other_bene_cnt                                                                              
        age_less_65_bene_cnt                                                                       
        age_65_69_bene_cnt                                                                               
        age_70_74_bene_cnt                                                                          
        age_75_79_bene_cnt                                                                                
        age_80_84_bene_cnt                                                                                  
        age_over_84_bene_cnt                                                                        
        dual_bene_cnt                                                                                  
        non_dual_bene_cnt                                                                            
        hrr_diff_bene_cnt                                                                             
        afib_bene_cnt                                                                                  
        alzrdsd_bene_cnt                                                                                
        alz_bene_cnt                                                                                           
        ami_bene_cnt                                                                                            
        anemia_bene_cnt                                                                                     
        asthma_bene_cnt                                                                                   
        brc_bene_cnt                                                                              
        cat_bene_cnt                                                                               
        chf_bene_cnt                                                                                
        ckd_bene_cnt                                                                              
        copd_bene_cnt                                                                               
        crc_bene_cnt                                                                            
        depr_bene_cnt                                                                                      
        diab_bene_cnt                                                                                      
        endc_bene_cnt                                                                                 
        glcm_bene_cnt                                                                                  
        hfrac_bene_cnt                                                                                      
        hyperl_bene_cnt                                                                                
        hyperp_bene_cnt                                                                               
        hypert_bene_cnt                                                                                     
        hypoth_bene_cnt                                                                                  
        ihd_bene_cnt                                                                                     
        lngc_bene_cnt                                                                                      
        ost_bene_cnt                                                                                   
        prc_bene_cnt                                                                                  
        raoa_bene_cnt                                                                                           
        strk_bene_cnt                                                                                     
        hrr_bene_desc1       :$30.                                                                                     
        hrr_bene_desc2       :$30.                                                                                       
        hrr_bene_desc3       :$30.                                                                                       
        hrr_bene_desc4       :$30.                                                                                     
        hrr_bene_desc5       :$30.                                                                                  
        hrr_bene_cnt1                                                                                         
        hrr_bene_cnt2                                                                                      
        hrr_bene_cnt3                                                                                        
        hrr_bene_cnt4                                                                                       
        hrr_bene_cnt5 
        tapq01_bene_cnt
        tapq01 
        tapq03_bene_cnt 
        tapq03 
        tapq05_bene_cnt 
        tapq05
        tapq07_bene_cnt 
        tapq07
        tapq08_bene_cnt 
        tapq08
        tapq10_bene_cnt 
        tapq10 
        tapq11_bene_cnt  
        tapq11
        tapq12_bene_cnt  
        tapq12
        tapq13_bene_cnt  
        tapq13
        tapq14_bene_cnt  
        tapq14
        tapq15_bene_cnt  
        tapq15
        tapq16_bene_cnt  
        tapq16                                                                                   
        oer_bene_cnt                                                                              
        oer                                                                                            
        ier_bene_cnt                                                                                     
        ier                                                                                              
        covered_days_bene_cnt                                                                          
        covered_days                                                                                     
        covered stays_bene_cnt                                                                                            
        covered stays                                                                                                  
        covered_stays_bene_cnt                                                                         
        covered_stays                                                                                       
        visits_bene_cnt                                                                                          
        visits                                                                                                   
        episodes_bene_cnt                                                                                    
        episodes                                                                                           
        admits_bene_cnt                                                                         
        admits                                                                                          
        readmits_bene_cnt                                                                                 
        readmits                                                                                            
        readmits_diff_prov_bene_cnt                                                              
        readmits_diff_prov                                                   
        actual_pmt                                                        
        standard_pmt                                                  
        outlier_apprvd_pmt                                                
        readmit_pmt                                                                   
        coinsurance                                                             
        deductible                                                            
        pass_thru_costs                                                                   
        avg_score                                                                                                    
        avg_lti_months_bene_cnt                                                                            
        avg_lti_months                                                                               
 ;                                               
                                                                                                                                      
   * Labels *;                                                                                                                          
  label provider_id                     = 'Provider ID'
        hrr_prov                        = 'Hospital Referral Region'                                                                    
        facility_type                   = 'Facility Type'                                                                               
        bene_cnt                        = 'Beneficiary Count'                                                                           
        death_bene_cnt                  = 'Deceased Bene Cnt'                                                                           
        sex_male_bene_cnt               = 'Male Bene Cnt'                                                                           
        sex_female_bene_cnt             = 'Female Bene Cnt'                                                                         
        race_white_bene_cnt             = 'White Bene Cnt'                                                                         
        race_black_bene_cnt             = 'Black Bene Cnt'                                                                         
        race_hispn_bene_cnt             = 'Hispanic Bene Cnt'                                                                      
        race_api_bene_cnt               = 'Asian Pacific Islander Bene Cnt'                                                                 
        race_natind_bene_cnt            = 'Alaskan \Ameri_Indian Bene Cnt'                                                                 
        race_other_bene_cnt             = 'Other Race Bene Cnt'                                                                         
        age_less_65_bene_cnt            = 'Under 65 Bene Cnt'                                                                      
        age_65_69_bene_cnt              = '65-69 Bene Cnt'                                                                          
        age_70_74_bene_cnt              = '70-74 Bene Cnt'                                                                          
        age_75_79_bene_cnt              = '75-79 Bene Cnt'                                                                          
        age_80_84_bene_cnt              = '80-84 Bene Cnt'                                                                          
        age_over_84_bene_cnt            = 'Over 84 Bene Cnt'                                                                        
        dual_bene_cnt                   = 'Dual Eligible Bene Cnt'                                                                          
        non_dual_bene_cnt               = 'Non-Dual Eligible Bene Cnt'                                                                      
        hrr_diff_bene_cnt               = 'HRR Different Bene Cnt'                                                                     
        afib_bene_cnt                   = 'CCW:Atrial Fib Bene Cnt'                                                                     
        alzrdsd_bene_cnt                = 'CCW:Alzh/Demen Bene Cnt'                                                                     
        alz_bene_cnt                    = 'CCW:Alzh Bene Cnt'                                                                           
        ami_bene_cnt                    = 'CCW:AMI Bene Cnt'                                                                            
        anemia_bene_cnt                 = 'CCW:Anemia Bene Cnt'                                                                         
        asthma_bene_cnt                 = 'CCW:Asthma Bene Cnt'                                                                         
        brc_bene_cnt                    = 'CCW:Breast Cancer Bene Cnt'                                                                  
        cat_bene_cnt                    = 'CCW:Cataract Fib Bene Cnt'                                                                   
        chf_bene_cnt                    = 'CCW:CHF Bene Cnt'                                                                            
        ckd_bene_cnt                    = 'CCW:Chronic Kidney Bene Cnt'                                                                 
        copd_bene_cnt                   = 'CCW:COPD Bene Cnt'                                                                           
        crc_bene_cnt                    = 'CCW:Colorectal Cancer Bene Cnt'                                                              
        depr_bene_cnt                   = 'CCW:Depression Bene Cnt'                                                                     
        diab_bene_cnt                   = 'CCW:Diabetes Bene Cnt'                                                                       
        endc_bene_cnt                   = 'CCW: Endometrial Cancer Bene Cnt'                                                                
        glcm_bene_cnt                   = 'CCW:Glaucoma Bene Cnt'                                                                       
        hfrac_bene_cnt                  = 'CCW:Hip Fracture Bene Cnt'                                                                      
        hyperl_bene_cnt                 = 'CCW:Hyperlipidemia Bene Cnt'                                                                      
        hyperp_bene_cnt                 = 'CCW:Hyperplasia Bene Cnt'                                                                      
        hypert_bene_cnt                 = 'CCW:Hypertension Bene Cnt'                                                                      
        hypoth_bene_cnt                 = 'CCW:Hypothyroidism Bene Cnt'                                                                      
        ihd_bene_cnt                    = 'CCW:Ischemic Heart Dis Bene Cnt'                                                                 
        lngc_bene_cnt                   = 'CCW:Lung Cancer Bene Cnt'                                                                    
        ost_bene_cnt                    = 'CCW:Osteoporosis Bene Cnt'                                                                       
        prc_bene_cnt                    = 'CCW:Prostate Cancer Bene Cnt'                                                                
        raoa_bene_cnt                   = 'CCW:RAOA Bene Cnt'                                                                           
        strk_bene_cnt                   = 'CCW:Stroke/TIA Bene Cnt'                                                                     
        hrr_bene_desc1                  = 'HRR rank 1 Desc'                                                                             
        hrr_bene_desc2                  = 'HRR rank 2 Desc'                                                                             
        hrr_bene_desc3                  = 'HRR rank 3 Desc'                                                                             
        hrr_bene_desc4                  = 'HRR rank 4 Desc'                                                                             
        hrr_bene_desc5                  = 'HRR rank 5 Desc'                                                                             
        hrr_bene_cnt1                   = 'HRR rank 1 Bene Cnt'                                                                         
        hrr_bene_cnt2                   = 'HRR rank 2 Bene Cnt'                                                                         
        hrr_bene_cnt3                   = 'HRR rank 3 Bene Cnt'                                                                         
        hrr_bene_cnt4                   = 'HRR rank 4 Bene Cnt'                                                                         
        hrr_bene_cnt5                   = 'HRR rank 5 Bene Cnt' 
        tapq01_bene_cnt                 = 'Bene Cnt Hosp Adm:Diabetes Short Term'  
        tapq01                          = 'Tot Hosp Adm:Diabetes Short Term' 
        tapq03_bene_cnt                 = 'Bene Cnt Hosp Adm:Diabetes Long Term'   
        tapq03                          = 'Tot Hosp Adm:Diabetes Long Term'  
        tapq05_bene_cnt                 = 'Bene Cnt Hosp Adm:COPD'   
        tapq05                          = 'Tot Hosp Adm:COPD'
        tapq07_bene_cnt                 = 'Bene Cnt Hosp Adm:Hypertension'    
        tapq07                          = 'Tot Hosp Adm:Hypertension'
        tapq08_bene_cnt                 = 'Bene Cnt Hosp Adm:CHF'    
        tapq08                          = 'Tot Hosp Adm:CHF' 
        tapq10_bene_cnt                 = 'Bene Cnt Hosp Adm:Dehydration'    
        tapq10                          = 'Tot Hosp Adm:Dehydration'
		tapq11_bene_cnt                 = 'Bene Cnt Hosp Adm:Pneumonia'   
        tapq11                          = 'Tot Hosp Adm:Pneumonia' 
        tapq12_bene_cnt                 = 'Bene Cnt Hosp Adm:Urinary Infection'    
        tapq12                          = 'Tot Hosp Adm:Urinary Infection' 
        tapq13_bene_cnt                 = 'Bene Cnt Hosp Adm:Angina'    
        tapq13                          = 'Tot Hosp Adm:Angina'  
        tapq14_bene_cnt                 = 'Bene Cnt Hosp Adm:Diabetes Uncontrolled'    
        tapq14                          = 'Tot Hosp Adm:Diabetes Uncontrolled'
        tapq15_bene_cnt                 = 'Bene Cnt Hosp Adm:Adult Asthma'    
        tapq15                          = 'Tot Hosp Adm:Adult Asthma' 
        tapq16_bene_cnt                 = 'Bene Cnt Hosp Adm:Lwr Extrm Amputatn'    
        tapq16                          = 'Tot Hosp Adm:Lwr Extrm Amputatn'                                                             
        oer_bene_cnt                    = 'Outpatient Emerg Bene Cnt'                                                                   
        oer                             = 'Outpatient Emerg Visits'                                                                  
        ier_bene_cnt                    = 'Inpatient Emerg Bene Cnt'                                                                    
        ier                             = 'Inpatient Emerg Visits'                                                                   
        days_bene_cnt                   = 'Days of Care Bene Cnt'                                                                       
        days                            = 'Total Days of Care'                                                                          
        covered_days_bene_cnt           = 'Covered Days of Care Bene Cnt'                                                               
        covered_days                    = 'Total Covered Days of Care'            
        covered_stays_bene_cnt          = 'Covered Stays Bene Cnt'                                                                      
        covered_stays                   = 'Total Covered Stays'                                                                         
        visits_bene_cnt                 = 'Visits Bene Cnt'                                                                             
        visits                          = 'Total Visits'                                                                                
        episodes_bene_cnt               = 'HHA episodes Bene Cnt'                                                                       
        episodes                        = 'Total HHA episodes'                                                                          
        admits_bene_cnt                 = 'Acute Index Admission Bene Cnt'                                                                
        admits                          = 'Total Acute Index Admissns'                                                                  
        readmits_bene_cnt               = 'Acute Readmission Bene Cnt'                                                                    
        readmits                        = 'Total Acute Readmissions'                                                                      
        readmits_diff_prov_bene_cnt     = 'Acute Readm-Diff Providr Bene Cnt'                                                           
        readmits_diff_prov              = 'Total Acute Readm-Diff Providr' 
        actual_pmt                      = 'Total Medicare Claim Pmt Amt' 
        standard_pmt                    = 'Total Std Medicare Claim Pmt Amt' 
        outlier_apprvd_pmt              = 'Total Outlier Claim Pmt Amt'  
        readmit_pmt                     = 'Acute Readmission Pmt Amt'        
        coinsurance                     = 'Coinsurance Amt'           
        deductible                      = 'Deductible Amt'  
        pass_thru_costs                 = 'Pass Thru Cost Amt'               
        avg_score                       = 'Avg HCC Score'                                                                               
        avg_lti_months_bene_cnt         = 'Long Term Inst Bene Cnt'                                                                     
        avg_lti_months                  = 'Avg Long Term Inst Months'                                                                   
 ;                                               

run;

title 'IPBS PUBLIC USE FILE';
proc contents data=PUF.BSA_IPBS_PUF_2010 var  ;
proc print data=PUF.BSA_IPBS_PUF_2010 (obs=10);
  title2 'Sample Listing - 10 Rows';
run;


* End of Program *;
