* pbp_Section_A.sas;

libname out '.\sas_data_sets\PBP';


options pageno=1 nocenter ls=150;

data pbp_a;
   length
   pbp_a_hnumber                        $5
   pbp_a_plan_identifier                $3
   pbp_a_ben_cov                        $1
   pbp_a_plan_type                      $2
   pbp_a_squish_id                      $8
   pbp_a_org_name                       $42
   pbp_a_plan_name                      $42
   pbp_a_hnumber                        $5
   pbp_a_plan_type                      $2
   pbp_a_ben_cov                        $1
   pbp_a_service_area                   $7
   pbp_a_plan_identifier                $3
   pbp_a_plan_geog_name                 $50
   pbp_a_continue_yesno                 $1
   pbp_a_pos_yesno                      $1
   pbp_a_pos_amo                        $1
   pbp_a_pos_choices                    $46
   pbp_a_pbp_contact_name               $50
   pbp_a_pbp_contact_position           $30
   pbp_a_pbp_contact_phone              $14
   pbp_a_pbp_contact_phone_ext          $5
   pbp_a_pbp_contact_fax                $14
   pbp_a_pbp_email                      $50
   pbp_a_pbp_address1                   $50
   pbp_a_pbp_address5                   $30
   pbp_a_pbp_address2                   $30
   pbp_a_pbp_address3                   $2
   pbp_a_pbp_address4                   $9
  ;

  infile '.\pbp\pbp_Section_A.txt'
         delimiter = '09'x dsd lrecl = 25000 firstobs = 2 missover;
input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_plan_type
   pbp_a_org_name
   pbp_a_plan_name
   pbp_a_plan_geog_name
   pbp_a_service_area
   pbp_a_ben_cov
   pbp_a_continue_yesno
   pbp_a_pos_yesno
   pbp_a_pos_choices
   pbp_a_pos_amo
   pbp_a_pbp_contact_name
   pbp_a_pbp_contact_position
   pbp_a_pbp_contact_phone
   pbp_a_pbp_contact_phone_ext
   pbp_a_pbp_contact_fax
   pbp_a_pbp_email
   pbp_a_pbp_address1
   pbp_a_pbp_address5
   pbp_a_pbp_address2
   pbp_a_pbp_address3
   pbp_a_pbp_address4
   pbp_a_squish_id;

label
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_continue_yesno            = 'Continuation Area Offered?        '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_org_name                  = 'M+C Organization Name             '
pbp_a_pbp_address1              = 'PBP Contact Street Address        '
pbp_a_pbp_address2              = 'PBP Contact City                  '
pbp_a_pbp_address3              = 'PBP Contact State                 '
pbp_a_pbp_address4              = 'PBP Contact Zipcode               '
pbp_a_pbp_address5              = 'PBP Suite/Dept./Mail Stop         '
pbp_a_pbp_contact_fax           = 'M+C Org. PBP Contact FAX          '
pbp_a_pbp_contact_name          = 'M+C Org. PBP Contact Name         '
pbp_a_pbp_contact_phone         = 'PBP Contact Phone                 '
pbp_a_pbp_contact_phone_ext     = 'PBP Contact Phone# Extension      '
pbp_a_pbp_contact_position      = 'M+C Org. PBP Contact Position     '
pbp_a_pbp_email                 = 'PBP Contact E-mail Address        '
pbp_a_plan_geog_name            = 'Plan Geog Name                    '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_name                 = 'Plan Name                         '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_a_pos_amo                   = 'POS AMO Supplemental Benefit      '
pbp_a_pos_choices               = 'Point of Service - Choices        '
pbp_a_pos_yesno                 = 'Point of Service - Yes/No         '
pbp_a_service_area              = 'Service Area(s)                   '
pbp_a_squish_id                 = 'Squish                            ';
run;

proc sort data = pbp_a out = out.pbp_a;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_a(obs = 10);
  title 'pbp a data';
run;

proc means data =  out.pbp_a;
  title 'pbp a file';
run;

proc freq data = out.pbp_a;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  pbp_a_service_area
  pbp_a_plan_geog_name
  pbp_a_continue_yesno
  pbp_a_pos_yesno
  pbp_a_pos_amo
  pbp_a_pos_choices / missing;
run;

proc contents data = out.pbp_a;
  title 'pbp a data';
run;

