* pbp_b1.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b1;
   length
   pbp_a_hnumber                        $5
   pbp_a_plan_identifier                $3
   pbp_a_ben_cov                        $1
   pbp_a_plan_type                      $2
   orgtype                              $2
   pbp_b_1a_bendec_yesno                $1
   pbp_b_1a_bendec_ad_up                $2
   pbp_b_1a_bendesc_amo_up              $1
   pbp_b_1a_bendesc_amo_ad              $1
   pbp_b_1a_bendesc_lim_ad              $1
   pbp_b_1a_maxenr_yesno                $1
   pbp_b_1a_maxenr_per                  $1
   pbp_b1a_coins_yesno                  $1
   pbp_b_1a_coins_cov_mc                $1
   pbp_b_1a_coins_cov_ad                $1
   pbp_b_1a_coins_cov_up                $1
   pbp_b_1a_ded_yesno                   $1
   pbp_b_1a_copay_yesno                 $1
   pbp_b_1a_auth                        $5
   pbp_b1a_maxplan_yesno_pos            $1
   pbp_b1a_maxpln_per_pos               $1
   pbp_b1a_maxpln_cov_pos               $1
   pbp_b1a_maxenr_yesno_pos             $1
   pbp_b1a_coins_yesno_pos              $1
   pbp_b1a_coins_cov_pos                $1
   pbp_b1a_ded_yesno_pos                $1
   pbp_b1a_copay_yesno_pos              $1
   pbp_b1a_auth_pos                     $5
   pbp_b1a_bendec_yesno_bonly           $1
   pbp_b1a_bendesc_amo_iact_bonly       $1
   pbp_b1a_bendesc_ulim_bonly           $1
   pbp_b1a_bendesc_amt_days_bonly       $4
   pbp_b1a_bendes_per_bonly             $1
   pbp_b1a_maxplan_yesno_bonly          $1
   pbp_b1a_maxplan_per_bonly            $1
   pbp_b1a_maxplan_cov_bonly            $1
   pbp_b1a_maxenr_yesno_bonly           $1
   pbp_b1a_maxenr_per_bonly             $1
   pbp_b1a_coins_yesno_bonly            $1
   pbp_b1a_coins_cov_bonly              $1
   pbp_b_1a_ded_yesno_bonly             $1
   pbp_b1a_copay_yesno_bonly            $1
   pbp_b_1a_auth_bonly                  $5
   pbp_b1a_maxplan_yesno_pos_b          $1
   pbp_b1a_maxpln_per_pos_bonly         $1
   pbp_b1a_maxpln_cov_pos_bonly         $1
   pbp_b1a_maxenr_yn_pos_bonly          $1
   pbp_b1a_coins_yesno_pos_bonly        $1
   pbp_b1a_coins_cov_pos_bonly          $1
   pbp_b1a_ded_yesno_pos_bonly          $1
   pbp_b1a_copay_yesno_pos_bonly        $1
   pbp_b1a_auth_pos_bonly               $5
   pbp_b_1b_bendec_yesno                $1
   pbp_b_1b_bendec_ad                   $1
   pbp_b_1b_bendesc_amo_ad              $1
   pbp_b_1b_bendesc_lim_ad              $1
   pbp_b_1b_maxenr_yesno                $1
   pbp_b_1b_maxenr_type                 $1
   pbp_b_1b_maxenr_per                  $1
   pbp_b1b_coins_yesno                  $1
   pbp_b_1b_coins_cov_mc                $1
   pbp_b_1b_coins_cov_ad                $1
   pbp_b_1b_ded_yesno                   $1
   pbp_b_1b_copay_yesno                 $1
   pbp_b_1b_auth                        $5
   pbp_b1b_maxplan_yesno_pos            $1
   pbp_b1b_maxplan_type_pos             $1
   pbp_b1b_maxpln_per_pos               $1
   pbp_b1b_maxplan_cov_pos              $1
   pbp_b1b_maxenr_yesno_pos             $1
   pbp_b1b_maxenr__cov_yn_pos           $1
   pbp_b1b_coins_yesno_pos              $1
   pbp_b1b_coins_cov_pos                $1
   pbp_b1b_ded_yesno_pos                $1
   pbp_b1b_copay_yesno_pos              $1
   pbp_b1b_auth_pos                     $5
   pbp_b1b_bendec_yesno_bonly           $1
   pbp_b1b_bendesc_amo_bonly            $1
   pbp_b1b_bendesc_lim_bonly            $1
   pbp_b1b_bendes_per_bonly             $1
   pbp_b1b_maxplan_yesno_bonly          $1
   pbp_b1b_maxplan_type_bonly           $1
   pbp_b1b_maxplan_per_bonly            $1
   pbp_b1b_maxplan_cov_bonly            $1
   pbp_b1b_maxenr_yesno_bonly           $1
   pbp_b1b_maxenr_type_bonly            $1
   pbp_b1b_maxenr_per_bonly             $1
   pbp_b1b_coins_yesno_bonly            $1
   pbp_b_1b_coins_cov_bonly             $1
   pbp_b1b_ded_yesno_bonly              $1
   pbp_b1b_copay_yesno_bonly            $1
   pbp_b1b_auth_bonly                   $5
   pbp_b1b_maxplan_yesno_pos_b          $1
   pbp_b1b_maxplan_type_pos_bonly       $1
   pbp_b1b_maxpln_per_pos_bonly         $1
   pbp_b1b_maxplan_cov_pos_bonly        $1
   pbp_b1b_maxenr_yesno_pos_bonly       $1
   pbp_b1b_maxenr_cov_yn_pos_b          $1
   pbp_b1b_coins_yesno_pos_bonly        $1
   pbp_b1b_coins_cov_pos_bonly          $1
   pbp_b1b_ded_yesno_pos_bonly          $1
   pbp_b1b_copay_yesno_pos_bonly        $1
   pbp_b1b_auth_pos_bonly               $5
;


infile '.\pbp\pbp_b1_inpat_hosp.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b_1a_bendec_yesno
   pbp_b_1a_bendec_ad_up
   pbp_b_1a_bendesc_amo_up
   pbp_b_1a_bendesc_amo_ad
   pbp_b_1a_bendesc_lim_ad
   pbp_b_1a_bendesc_amt_ad
   pbp_b_1a_maxenr_yesno
   pbp_b_1a_maxenr_amt
   pbp_b_1a_maxenr_per
   pbp_b1a_coins_yesno
   pbp_b_1a_coins_pct_mc
   pbp_b_1a_coins_cov_mc
   pbp_b_1a_coins_pct_ad
   pbp_b_1a_coins_cov_ad
   pbp_b_1a_coins_pct_up
   pbp_b_1a_coins_cov_up
   pbp_b_1a_ded_yesno
   pbp_b_1a_ded_amt
   pbp_b_1a_copay_yesno
   pbp_b_1a_copay_mc_amts
   pbp_b_1a_copay_mc_amtd
   pbp_b_1a_copay_ad_amtd
   pbp_b_1a_copay_up_amts
   pbp_b_1a_copay_up_amtd
   pbp_b_1a_auth
   pbp_b1a_maxplan_yesno_pos
   pbp_b1a_maxpln_amt_pos
   pbp_b1a_maxpln_per_pos
   pbp_b1a_maxpln_cov_pos
   pbp_b1a_maxenr_yesno_pos
   pbp_b1a_maxenr_amt_pos
   pbp_b1a_coins_yesno_pos
   pbp_b1a_coins_pct_pos
   pbp_b1a_coins_cov_pos
   pbp_b1a_ded_yesno_pos
   pbp_b1a_ded_amt_pos
   pbp_b1a_copay_yesno_pos
   pbp_b1a_copay_amts_pos
   pbp_b1a_copay_amtd_pos
   pbp_b1a_auth_pos
   pbp_b1a_bendec_yesno_bonly
   pbp_b1a_bendesc_amo_iact_bonly
   pbp_b1a_bendesc_ulim_bonly
   pbp_b1a_bendesc_amt_days_bonly
   pbp_b1a_bendes_per_bonly
   pbp_b1a_maxplan_yesno_bonly
   pbp_b1a_maxplan_amt_bonly
   pbp_b1a_maxplan_per_bonly
   pbp_b1a_maxplan_cov_bonly
   pbp_b1a_maxenr_yesno_bonly
   pbp_b1a_maxenr_amt_bonly
   pbp_b1a_maxenr_per_bonly
   pbp_b1a_coins_yesno_bonly
   pbp_b1a_coins_pct_bonly
   pbp_b1a_coins_cov_bonly
   pbp_b_1a_ded_yesno_bonly
   pbp_b_1a_ded_amt_bonly
   pbp_b1a_copay_yesno_bonly
   pbp_b1a_copay_amtps_bonly
   pbp_b1a_copay_amtpd_bonly
   pbp_b_1a_auth_bonly
   pbp_b1a_maxplan_yesno_pos_b
   pbp_b1a_maxpln_amt_pos_bonly
   pbp_b1a_maxpln_per_pos_bonly
   pbp_b1a_maxpln_cov_pos_bonly
   pbp_b1a_maxenr_yn_pos_bonly
   pbp_b1a_maxenr_amt_pos_bonly
   pbp_b1a_coins_yesno_pos_bonly
   pbp_b1a_coins_pct_pos_bonly
   pbp_b1a_coins_cov_pos_bonly
   pbp_b1a_ded_yesno_pos_bonly
   pbp_b1a_ded_amt_pos_bonly
   pbp_b1a_copay_yesno_pos_bonly
   pbp_b1a_copay_amts_pos_bonly
   pbp_b1a_copay_amtd_pos_bonly
   pbp_b1a_auth_pos_bonly
   pbp_b_1b_bendec_yesno
   pbp_b_1b_bendec_ad
   pbp_b_1b_bendesc_amo_ad
   pbp_b_1b_bendesc_lim_ad
   pbp_b1b_bendesc_amt_ad
   pbp_b_1b_maxenr_yesno
   pbp_b_1b_maxenr_type
   pbp_b_1b_maxenr_amt
   pbp_b_1b_maxenr_per
   pbp_b1b_coins_yesno
   pbp_b_1b_coins_pct_mc
   pbp_b_1b_coins_cov_mc
   pbp_b_1b_coins_pct_ad
   pbp_b_1b_coins_cov_ad
   pbp_b_1b_ded_yesno
   pbp_b_1b_ded_amt
   pbp_b_1b_copay_yesno
   pbp_b_1b_copay_mc_amts
   pbp_b_1b_copay_mc_amtd
   pbp_b_1b_copay_ad_amtd
   pbp_b_1b_auth
   pbp_b1b_maxplan_yesno_pos
   pbp_b1b_maxplan_type_pos
   pbp_b1b_maxpln_amt_pos
   pbp_b1b_maxpln_per_pos
   pbp_b1b_maxplan_cov_pos
   pbp_b1b_maxenr_yesno_pos
   pbp_b1b_maxenr__cov_yn_pos
   pbp_b1b_maxenr_amt_pos
   pbp_b1b_coins_yesno_pos
   pbp_b1b_coins_pct_mc_pos
   pbp_b1b_coins_cov_pos
   pbp_b1b_ded_yesno_pos
   pbp_b1b_ded_amt_pos
   pbp_b1b_copay_yesno_pos
   pbp_b1b_copay_amts_pos
   pbp_b1b_copay_amtd_pos
   pbp_b1b_auth_pos
   pbp_b1b_bendec_yesno_bonly
   pbp_b1b_bendesc_amo_bonly
   pbp_b1b_bendesc_lim_bonly
   pbp_b1b_bendesc_amt_bonly
   pbp_b1b_bendes_per_bonly
   pbp_b1b_maxplan_yesno_bonly
   pbp_b1b_maxplan_type_bonly
   pbp_b1b_maxplan_amt_bonly
   pbp_b1b_maxplan_per_bonly
   pbp_b1b_maxplan_cov_bonly
   pbp_b1b_maxenr_yesno_bonly
   pbp_b1b_maxenr_type_bonly
   pbp_b1b_maxenr_amt_bonly
   pbp_b1b_maxenr_per_bonly
   pbp_b1b_coins_yesno_bonly
   pbp_b_1b_coins_pct_bonly
   pbp_b_1b_coins_cov_bonly
   pbp_b1b_ded_yesno_bonly
   pbp_b1b_ded_amt_bonly
   pbp_b1b_copay_yesno_bonly
   pbp_b1b_copay_amtps_bonly
   pbp_b1b_copay_amtpd_bonly
   pbp_b1b_auth_bonly
   pbp_b1b_maxplan_yesno_pos_b
   pbp_b1b_maxplan_type_pos_bonly
   pbp_b1b_maxpln_amt_pos_bonly
   pbp_b1b_maxpln_per_pos_bonly
   pbp_b1b_maxplan_cov_pos_bonly
   pbp_b1b_maxenr_yesno_pos_bonly
   pbp_b1b_maxenr_cov_yn_pos_b
   pbp_b1b_maxenr_amt_pos_bonly
   pbp_b1b_coins_yesno_pos_bonly
   pbp_b1b_coins_pct_mc_pos_bonly
   pbp_b1b_coins_cov_pos_bonly
   pbp_b1b_ded_yesno_pos_bonly
   pbp_b1b_ded_amt_pos_bonly
   pbp_b1b_copay_yesno_pos_bonly
   pbp_b1b_copay_amts_pos_bonly
   pbp_b1b_copay_amtd_pos_bonly
   pbp_b1b_auth_pos_bonly
;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b1a_auth_pos                = 'Inpatient Acute Care Auth POS     '
pbp_b1a_auth_pos_bonly          = 'Inpatient Acute Care Auth         '
pbp_b1a_bendec_yesno_bonly      = 'Inpnt Acute Care Ben Des Y/N      '
pbp_b1a_bendes_per_bonly        = 'Inpnt Acute Care Ben DesPer       '
pbp_b1a_bendesc_amo_iact_bonly  = 'Inpnt Act Care Ben Des AMO        '
pbp_b1a_bendesc_amt_days_bonly  = 'Inpnt Acute Care Ben Desc Days    '
pbp_b1a_bendesc_ulim_bonly      = 'Inpnt Act Care Ben Desc Unlim     '
pbp_b1a_coins_cov_bonly         = 'Inpnt Acute Care Coins Cov        '
pbp_b1a_coins_cov_pos           = 'Inpnt Acute Care Coins Cov POS    '
pbp_b1a_coins_cov_pos_bonly     = 'Inpnt Acute Care Coins Cov        '
pbp_b1a_coins_pct_bonly         = 'Inpnt Acute Care Coin Pct         '
pbp_b1a_coins_pct_pos           = 'Inpnt Acute Care Coin Pct POS     '
pbp_b1a_coins_pct_pos_bonly     = 'Inpnt Acute Care Coin Pct         '
pbp_b1a_coins_yesno             = 'Inpnt Acute Care Coins YN         '
pbp_b1a_coins_yesno_bonly       = 'Inpnt Acute Care Coins YN         '
pbp_b1a_coins_yesno_pos         = 'Inpnt Acute Care Coins YN POS     '
pbp_b1a_coins_yesno_pos_bonly   = 'Inpnt Acute Care Coins YN         '
pbp_b1a_copay_amtd_pos          = 'Inpnt Acute Care Copay Amt Dy POS '
pbp_b1a_copay_amtd_pos_bonly    = 'Inpnt Acute Care Copay Amt Dy     '
pbp_b1a_copay_amtpd_bonly       = 'Inp Act Care Copay Amt Day        '
pbp_b1a_copay_amtps_bonly       = 'Inpnt Act Care Copay Amt Stay     '
pbp_b1a_copay_amts_pos          = 'Inpnt Acute Care Copay Amt St POS '
pbp_b1a_copay_amts_pos_bonly    = 'Inpnt Acute Care Copay Amt St     '
pbp_b1a_copay_yesno_bonly       = 'Inpnt Acute Care Copay Yes No     '
pbp_b1a_copay_yesno_pos         = 'Inpnt Acute Care Copay Yes No POS '
pbp_b1a_copay_yesno_pos_bonly   = 'Inpnt Acute Care Copay Yes No     '
pbp_b1a_ded_amt_pos             = 'Inpnt Acute Care Deductbl Amt POS '
pbp_b1a_ded_amt_pos_bonly       = 'Inpnt Acute Care Deductbl Amt     '
pbp_b1a_ded_yesno_pos           = 'Inpnt Acute Care Deduct Yes No POS'
pbp_b1a_ded_yesno_pos_bonly     = 'Inpnt Acute Care Deduct Yes No    '
pbp_b1a_maxenr_amt_bonly        = 'Inpnt Acute Care Max Enr Amt      '
pbp_b1a_maxenr_amt_pos          = 'Inpnt Acute Care Max Enr Amt POS  '
pbp_b1a_maxenr_amt_pos_bonly    = 'Inpnt Acute Care Max Enr Amt      '
pbp_b1a_maxenr_per_bonly        = 'Inpnt Acute Care Max Enr Per      '
pbp_b1a_maxenr_yesno_bonly      = 'Inpnt Acute Care Max Enr Y/N      '
pbp_b1a_maxenr_yesno_pos        = 'Inpnt Acute Care Max Enr Y/N POS  '
pbp_b1a_maxenr_yn_pos_bonly     = 'Inpnt Acute Care Max Enr Y/N      '
pbp_b1a_maxplan_amt_bonly       = 'Inpnt Acute Max Plan Amt          '
pbp_b1a_maxplan_cov_bonly       = 'Inpnt Acute Max Plan Cov Bas      '
pbp_b1a_maxplan_per_bonly       = 'Inpnt Acute Max Plan Per          '
pbp_b1a_maxplan_yesno_bonly     = 'Inpnt Acute Max Plan Yes No       '
pbp_b1a_maxplan_yesno_pos       = 'Inpnt Acute Care Max Plan Y/N POS '
pbp_b1a_maxplan_yesno_pos_b     = 'Inpnt Acute Care Max Plan Y/N     '
pbp_b1a_maxpln_amt_pos          = 'Inpnt Acute Care Max Plan Amt POS '
pbp_b1a_maxpln_amt_pos_bonly    = 'Inpnt Acute Care Max Plan Amt     '
pbp_b1a_maxpln_cov_pos          = 'Inpnt Acute Care Max Plan Cov POS '
pbp_b1a_maxpln_cov_pos_bonly    = 'Inpnt Acute Care Max Plan Cov     '
pbp_b1a_maxpln_per_pos          = 'Inpnt Acute Care Max Pln Per POS  '
pbp_b1a_maxpln_per_pos_bonly    = 'Inpnt Acute Care Max Pln Per      '
pbp_b1b_auth_bonly              = 'Inpatient Psych Auth              '
pbp_b1b_auth_pos                = 'Inpatient Psych Auth POS          '
pbp_b1b_auth_pos_bonly          = 'Inpatient Psych Auth              '
pbp_b1b_bendec_yesno_bonly      = 'Inpnt Psych Hosp Ben Des Y/N      '
pbp_b1b_bendes_per_bonly        = 'Inpnt Hosp Psych Ben Des Per      '
pbp_b1b_bendesc_amo_bonly       = 'Inpatient Psyc Ben Des AMO        '
pbp_b1b_bendesc_amt_ad          = 'Inpatient Acute Ben Desc Amt      '
pbp_b1b_bendesc_amt_bonly       = 'Inpatient Acute Ben Desc Amt      '
pbp_b1b_bendesc_lim_bonly       = 'Inpatient Psyc Ben Desc Lim       '
pbp_b1b_coins_cov_pos           = 'Inpatient Psych Coins Cov POS     '
pbp_b1b_coins_cov_pos_bonly     = 'Inpatient Psych Coins Cov         '
pbp_b1b_coins_pct_mc_pos        = 'Inpatient Psyc POS Coin Pct POS   '
pbp_b1b_coins_pct_mc_pos_bonly  = 'Inpatient Psyc POS Coin Pct       '
pbp_b1b_coins_yesno             = 'Inpatient Psyc Coinsurance YN     '
pbp_b1b_coins_yesno_bonly       = 'Inpatient Psyc Coinsurance YN     '
pbp_b1b_coins_yesno_pos         = 'Inpatient Psych Coinsurance YN POS'
pbp_b1b_coins_yesno_pos_bonly   = 'Inpatient Psych Coinsurance YN    '
pbp_b1b_copay_amtd_pos          = 'Inp Psy Copay Amt Dy POS          '
pbp_b1b_copay_amtd_pos_bonly    = 'Inp Psy Copay Amt Dy              '
pbp_b1b_copay_amtpd_bonly       = 'Inp Psych Copay Amt Per Day       '
pbp_b1b_copay_amtps_bonly       = 'Inp Psych Copay Amt Per Stay      '
pbp_b1b_copay_amts_pos          = 'Inp Psy Copay Amt St POS          '
pbp_b1b_copay_amts_pos_bonly    = 'Inp Psy Copay Amt St              '
pbp_b1b_copay_yesno_bonly       = 'Inpatient Psyc Copay Yes No       '
pbp_b1b_copay_yesno_pos         = 'Inpatient Psych Copay Yes No POS  '
pbp_b1b_copay_yesno_pos_bonly   = 'Inpatient Psych Copay Yes No      '
pbp_b1b_ded_amt_bonly           = 'Inpatient Psych Deductible Amt    '
pbp_b1b_ded_amt_pos             = 'Inpatient Psych Deductible Amt POS'
pbp_b1b_ded_amt_pos_bonly       = 'Inpatient Psych Deductible Amt    '
pbp_b1b_ded_yesno_bonly         = 'Inpatient Psych Deduct Yes No     '
pbp_b1b_ded_yesno_pos           = 'Inpatient Psych Deduct Yes No POS '
pbp_b1b_ded_yesno_pos_bonly     = 'Inpatient Psych Deduct Yes No     '
pbp_b1b_maxenr__cov_yn_pos      = 'Inpnt Psych Max Enr Cov Type POS  '
pbp_b1b_maxenr_amt_bonly        = 'Inpatient Psyc Max Enr Amt        '
pbp_b1b_maxenr_amt_pos          = 'Inpatient Psych Max Enr Amt POS   '
pbp_b1b_maxenr_amt_pos_bonly    = 'Inpatient Psych Max Enr Amt       '
pbp_b1b_maxenr_cov_yn_pos_b     = 'Inpnt Psych Max Enr Covr Type     '
pbp_b1b_maxenr_per_bonly        = 'Inpatient Psyc Max Enr Per        '
pbp_b1b_maxenr_type_bonly       = 'Inpatient Psyc Max Enr Type       '
pbp_b1b_maxenr_yesno_bonly      = 'Inpatient Psyc Max Enr Yes No     '
pbp_b1b_maxenr_yesno_pos        = 'Inpatient Psyc Max Enr Yes No POS '
pbp_b1b_maxenr_yesno_pos_bonly  = 'Inpatient Psyc Max Enr Yes No     '
pbp_b1b_maxplan_amt_bonly       = 'Inpnt Psych Max Plan Amt          '
pbp_b1b_maxplan_cov_bonly       = 'Inpnt Psych Max Plan Cov Bas      '
pbp_b1b_maxplan_cov_pos         = 'Inpatient Psych Max Plan Cov POS  '
pbp_b1b_maxplan_cov_pos_bonly   = 'Inpatient Psych Max Plan Cov      '
pbp_b1b_maxplan_per_bonly       = 'Inpnt Psych Max Plan Per          '
pbp_b1b_maxplan_type_bonly      = 'Inpnt Psych Hosp Max Plan Type    '
pbp_b1b_maxplan_type_pos        = 'Inpatient Psych Max Plan Type POS '
pbp_b1b_maxplan_type_pos_bonly  = 'Inpatient Psych Max Plan Type     '
pbp_b1b_maxplan_yesno_bonly     = 'Inpnt Psych Max Plan Yes No       '
pbp_b1b_maxplan_yesno_pos       = 'Inpatient Psych Max Plan Y/N POS  '
pbp_b1b_maxplan_yesno_pos_b     = 'Inpatient Psych Max Plan Y/N      '
pbp_b1b_maxpln_amt_pos          = 'Inpatient Psych Max Plan Amt POS  '
pbp_b1b_maxpln_amt_pos_bonly    = 'Inpatient Psych Max Plan Amt      '
pbp_b1b_maxpln_per_pos          = 'Inpatient Psych Max Pln Per POS   '
pbp_b1b_maxpln_per_pos_bonly    = 'Inpatient Psych Max Pln Per       '
pbp_b_1a_auth                   = 'Inpatient Acute Care Auth         '
pbp_b_1a_auth_bonly             = 'Inpatient Acute Care Auth         '
pbp_b_1a_bendec_ad_up           = 'Inpnt Acute Care Ben Dec AD/UP    '
pbp_b_1a_bendec_yesno           = 'Inpnt Acute Care Ben Des Y/N      '
pbp_b_1a_bendesc_amo_ad         = 'Inpnt Act Care Ben Des AMO AD     '
pbp_b_1a_bendesc_amo_up         = 'Inpnt Act Care Ben Des AMO UP     '
pbp_b_1a_bendesc_amt_ad         = 'Inpnt Acute Care Ben Desc Amt     '
pbp_b_1a_bendesc_lim_ad         = 'Inpnt Acute Care Ben Desc Lim     '
pbp_b_1a_coins_cov_ad           = 'Inpnt Acute Care AD Coins Cov     '
pbp_b_1a_coins_cov_mc           = 'Inpnt Acute Care MC Coins Cov     '
pbp_b_1a_coins_cov_up           = 'Inpnt Acute Care UP Coins Cov     '
pbp_b_1a_coins_pct_ad           = 'Inpnt Acute Care AD Coin Pct      '
pbp_b_1a_coins_pct_mc           = 'Inpnt Acute Care MC Coin Pct      '
pbp_b_1a_coins_pct_up           = 'Inpnt Acute Care UP Coin Pct      '
pbp_b_1a_copay_ad_amtd          = 'Inp Acute Care Copay AD Amt Dy    '
pbp_b_1a_copay_mc_amtd          = 'Inp Acute Care Copay MC Amt Dy    '
pbp_b_1a_copay_mc_amts          = 'Inpnt Act Care Copay MC Amt St    '
pbp_b_1a_copay_up_amtd          = 'Inp Acute Care Copay UP Amt Dy    '
pbp_b_1a_copay_up_amts          = 'Inp Acute Care Copay UP Amt St    '
pbp_b_1a_copay_yesno            = 'Inpnt Acute Care Copay Yes No     '
pbp_b_1a_ded_amt                = 'Inpnt Acute Care Deductbl Amt     '
pbp_b_1a_ded_amt_bonly          = 'Inpnt Acute Care Deductbl Amt     '
pbp_b_1a_ded_yesno              = 'Inpnt Acute Care Deduct Yes No    '
pbp_b_1a_ded_yesno_bonly        = 'Inpnt Acute Care Deduct Yes No    '
pbp_b_1a_maxenr_amt             = 'Inpnt Acute Care Max Enr Amt      '
pbp_b_1a_maxenr_per             = 'Inpnt Acute Care Max Enr Per      '
pbp_b_1a_maxenr_yesno           = 'Inpnt Acute Care Max Enr Y/N      '
pbp_b_1b_auth                   = 'Inpatient Psych Auth              '
pbp_b_1b_bendec_ad              = 'Inpatient Psy Ben Dec AD          '
pbp_b_1b_bendec_yesno           = 'Inpatient Psyc Ben Des Yes No     '
pbp_b_1b_bendesc_amo_ad         = 'Inpatient Psyc Ben Des AMO AD     '
pbp_b_1b_bendesc_lim_ad         = 'Inpatient Psyc Ben Desc Lim       '
pbp_b_1b_coins_cov_ad           = 'Inpatient Psyc AD Coins Cov       '
pbp_b_1b_coins_cov_bonly        = 'Inpatient Psyc Coins Cov          '
pbp_b_1b_coins_cov_mc           = 'Inpatient Psyc MC Coins Cov       '
pbp_b_1b_coins_pct_ad           = 'Inpatient Psyc AD Coin Pct        '
pbp_b_1b_coins_pct_bonly        = 'Inpatient Psyc Coin Pct           '
pbp_b_1b_coins_pct_mc           = 'Inpatient Psyc MC Coin Pct        '
pbp_b_1b_copay_ad_amtd          = 'Inp Psy Copay AD Amt Dy           '
pbp_b_1b_copay_mc_amtd          = 'Inp Psy Copay Medic Amt Dy        '
pbp_b_1b_copay_mc_amts          = 'Inp Psy Copay Medic Amt St        '
pbp_b_1b_copay_yesno            = 'Inpatient Psyc Copay Yes No       '
pbp_b_1b_ded_amt                = 'Inpatient Psych Deductible Amt    '
pbp_b_1b_ded_yesno              = 'Inpatient Psych Deduct Yes No     '
pbp_b_1b_maxenr_amt             = 'Inpatient Psyc Max Enr Amt        '
pbp_b_1b_maxenr_per             = 'Inpatient Psyc Max Enr Per        '
pbp_b_1b_maxenr_type            = 'Inpatient Psyc Max Enr Type       '
pbp_b_1b_maxenr_yesno           = 'Inpatient Psyc Max Enr Yes No     '
;
run;

proc sort data = pbp_b1 out = out.pbp_b1;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b1 (obs = 10);
  title 'pbp b1 data';
run;

proc means data =  out.pbp_b1;
  title 'pbp b1 file';
run;

proc freq data = out.pbp_b1;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b_1a_bendec_yesno
  pbp_b_1a_bendec_ad_up
  pbp_b_1a_bendesc_amo_up
  pbp_b_1a_bendesc_amo_ad
  pbp_b_1a_bendesc_lim_ad
  pbp_b_1b_bendec_yesno
  pbp_b_1b_bendec_ad
  pbp_b_1b_bendesc_amo_ad
  pbp_b_1b_bendesc_lim_ad
  pbp_b_1b_maxenr_yesno
  pbp_b_1b_maxenr_type
  pbp_b_1b_maxenr_per
  pbp_b1b_coins_yesno
  pbp_b1b_auth_pos_bonly / missing;
run;

proc contents data = out.pbp_b1;
  title 'pbp b1 data';
run;




