*pbp_b10.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b10;

length
   pbp_a_hnumber                     $5
   pbp_a_plan_identifier             $3
   pbp_a_ben_cov                     $1
   pbp_a_plan_type                   $2
   orgtype                           $2
   pbp_b10a_maxenr_yesno             $1
   pbp_b10a_maxenr_per               $1
   pbp_b10a_coins_yesno              $1
   pbp_b10a_coins_wav_yn             $1
   pbp_b10a_coins_cov_mc             $1
   pbp_b10a_ded_yesno                $1
   pbp_b10a_copay_yesno              $1
   pbp_b10a_copay_wav_yn             $1
   pbp_b10a_auth                     $5
   pbp_b10b_bendec_yesno             $1
   pbp_b10b_bendec_trn               $1
   pbp_b10b_bendesc_amo_pal          $1
   pbp_b10b_bendesc_lim_pal          $1
   pbp_b10b_bendes_per_pal           $1
   pbp_b10b_bendesc_tt_pal           $1
   pbp_b10b_bendesc_mt_pal           $4
   pbp_b10b_bendesc_amo_al           $1
   pbp_b10b_bendesc_lim_al           $1
   pbp_b10b_bendes_per_al            $1
   pbp_b10b_bendesc_tt_al            $1
   pbp_b10b_bendesc_mt_al            $4
   pbp_b_10b_maxplan_yesno           $1
   pbp_b10b_maxpln_per               $1
   pbp_b10b_maxplan_cov              $1
   pbp_b10b_maxenr_yesno             $1
   pbp_b10b_maxenr_per               $1
   pbp_b10b_coins_yesno              $1
   pbp_b10b_coins_cov                $1
   pbp_b10b_ded_yesno                $1
   pbp_b10b_copay_yesno              $1
   pbp_b10b_auth                     $5
;

infile '.\pbp\pbp_b10_amb_trans.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b10a_maxenr_yesno
   pbp_b10a_maxenr_amt
   pbp_b10a_maxenr_per
   pbp_b10a_coins_yesno
   pbp_b10a_coins_pct_mc
   pbp_b10a_coins_wav_yn
   pbp_b10a_coins_cov_mc
   pbp_b10a_ded_yesno
   pbp_b10a_ded_amt
   pbp_b10a_copay_yesno
   pbp_b10a_copay_mc_amt
   pbp_b10a_copay_wav_yn
   pbp_b10a_auth
   pbp_b10b_bendec_yesno
   pbp_b10b_bendec_trn
   pbp_b10b_bendesc_amo_pal
   pbp_b10b_bendesc_lim_pal
   pbp_b10b_bendesc_amt_pal
   pbp_b10b_bendes_per_pal
   pbp_b10b_bendesc_tt_pal
   pbp_b10b_bendesc_mt_pal
   pbp_b10b_bendesc_amo_al
   pbp_b10b_bendesc_lim_al
   pbp_b10b_bendesc_amt_al
   pbp_b10b_bendes_per_al
   pbp_b10b_bendesc_tt_al
   pbp_b10b_bendesc_mt_al
   pbp_b_10b_maxplan_yesno
   pbp_b10b_maxplan_amt
   pbp_b10b_maxpln_per
   pbp_b10b_maxplan_cov
   pbp_b10b_maxenr_yesno
   pbp_b10b_maxenr_amt
   pbp_b10b_maxenr_per
   pbp_b10b_coins_yesno
   pbp_b10b_coins_pct
   pbp_b10b_coins_cov
   pbp_b10b_ded_yesno
   pbp_b10b_ded_amt
   pbp_b10b_copay_yesno
   pbp_b10b_copay_amt
   pbp_b10b_auth
;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b10a_auth                   = 'Ambulance Authorization           '
pbp_b10a_coins_cov_mc           = 'Ambulance MC Coins Cov            '
pbp_b10a_coins_pct_mc           = 'Ambulance MC Coin Pct             '
pbp_b10a_coins_wav_yn           = 'Ambulance Coins Waved Y/N         '
pbp_b10a_coins_yesno            = 'Ambulance Coins Yes No            '
pbp_b10a_copay_mc_amt           = 'Ambulance MC Cpy Amt              '
pbp_b10a_copay_wav_yn           = 'Ambulance Copay Waved Y/N         '
pbp_b10a_copay_yesno            = 'Ambulance Copay Yes No            '
pbp_b10a_ded_amt                = 'Ambulance Deductible Amt          '
pbp_b10a_ded_yesno              = 'Ambulance Deductible Yes No       '
pbp_b10a_maxenr_amt             = 'Ambulance Max Enr Amt             '
pbp_b10a_maxenr_per             = 'Ambulance Max Enr Per             '
pbp_b10a_maxenr_yesno           = 'Ambulance Max Enr Yes No          '
pbp_b10b_auth                   = 'Transportation Auth               '
pbp_b10b_bendec_trn             = 'Transportation Ben Dec            '
pbp_b10b_bendec_yesno           = 'Trans Ben Des Yes No              '
pbp_b10b_bendes_per_al          = 'Transportation Ben Des Per AL     '
pbp_b10b_bendes_per_pal         = 'Transportation Ben Des Per PAL    '
pbp_b10b_bendesc_amo_al         = 'Transportation AL Ben Des AMO     '
pbp_b10b_bendesc_amo_pal        = 'Transportation PAL Ben Des AMO    '
pbp_b10b_bendesc_amt_al         = 'Transportation AL Ben Dsc Amt     '
pbp_b10b_bendesc_amt_pal        = 'Transportation PAL Ben Dsc Amt    '
pbp_b10b_bendesc_lim_al         = 'Transportation AL Ben Desc Lim    '
pbp_b10b_bendesc_lim_pal        = 'Transportation PAL Ben Dsc Lim    '
pbp_b10b_bendesc_mt_al          = 'Transportation AL Ben Desc MoT    '
pbp_b10b_bendesc_mt_pal         = 'Transportation PAL Ben Dsc MoT    '
pbp_b10b_bendesc_tt_al          = 'Transportation AL Ben Dsc ToT     '
pbp_b10b_bendesc_tt_pal         = 'Transportation PAL Ben Dsc ToT    '
pbp_b10b_coins_cov              = 'Transportation Coins Cov          '
pbp_b10b_coins_pct              = 'Transportation Coin Pct           '
pbp_b10b_coins_yesno            = 'Transportation Coins Yes No       '
pbp_b10b_copay_amt              = 'Transportation Cpy Amt            '
pbp_b10b_copay_yesno            = 'Transportation Copay Yes No       '
pbp_b10b_ded_amt                = 'Transportation Deductible Amt     '
pbp_b10b_ded_yesno              = 'Transportation Deduc Yes No       '
pbp_b10b_maxenr_amt             = 'Transportation Max Enr Amt        '
pbp_b10b_maxenr_per             = 'Transportation Max Enr Per        '
pbp_b10b_maxenr_yesno           = 'Transportation Max Enr Yes No     '
pbp_b10b_maxplan_amt            = 'Transportation Max Plan Amt       '
pbp_b10b_maxplan_cov            = 'Transportation Max Pln Cov Bas    '
pbp_b10b_maxpln_per             = 'Transportation Max Plan Per       '
pbp_b_10b_maxplan_yesno         = 'Transportation Max Plan Yes No    ';
run;

proc sort data = pbp_b10 out = out.pbp_b10;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b10 (obs = 10);
  title 'pbp b10 data';
run;

proc means data =  out.pbp_b10;
  title 'pbp b10 file';
run;

proc freq data = out.pbp_b10;
  table
  orgtype
  pbp_b10a_maxenr_yesno
  pbp_b10a_maxenr_per
  pbp_b10a_coins_yesno
  pbp_b10a_coins_wav_yn
  pbp_b10a_coins_cov_mc pbp_b10a_ded_yesno
  pbp_b10a_copay_yesno
  pbp_b10a_copay_wav_yn
  pbp_b10a_auth
  pbp_b10b_bendec_yesno
  pbp_b10b_bendec_trn
  pbp_b10b_bendesc_amo_pal
  pbp_b10b_bendesc_lim_pal
  pbp_b10b_bendes_per_pal / missing;
run;

proc contents data = out.pbp_b10;
  title 'pbp b10 data';
run;
