*pbp_b11.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b11;

length
   pbp_a_hnumber                    $5
   pbp_a_plan_identifier            $3
   pbp_a_ben_cov                    $1
   pbp_a_plan_type                  $2
   orgtype                          $2
   pbp_b11_maxenr_yesno             $1
   pbp_b11_maxenr_per               $1
   pbp_b11_coins_yesno              $1
   pbp_b11_coins_cov_mc             $2
   pbp_b11_ded_yesno                $1
   pbp_b11_copay_yesno              $1
   pbp_b11_auth                     $5
   pbp_b11_maxplan_yesno_pos        $1
   pbp_b11_maxpln_per_pos           $1
   pbp_b11_maxpln_cov_pos           $2
   pbp_b11_maxenr_yn_pos            $1
   pbp_b11_coins_yesno_pos          $1
   pbp_b11_coins_cov__pos           $2
   pbp_b11_ded_yesno_pos            $1
   pbp_b11_copay_yesno_pos          $1
   pbp_b11_auth_pos                 $5
   pbp_b11b_maxenr_yesno            $1
   pbp_b11b_maxenr_per              $1
   pbp_b11b_coins_yesno             $1
   pbp_b11b_coins_cov_mc            $2
   pbp_b11b_ded_yesno               $1
   pbp_b11b_copay_yesno             $1
   pbp_b11b_auth                    $5
   pbp_b11b_maxplan_yesno_pos       $1
   pbp_b11b_maxpln_per_pos          $1
   pbp_b11b_maxpln_cov_pos          $2
   pbp_b11b_maxenr_yn_pos           $1
   pbp_b11b_coins_yesno_pos         $1
   pbp_b11b_coins_cov__pos          $2
   pbp_b11b_ded_yesno_pos           $1
   pbp_b11b_copay_yesno_pos         $1
   pbp_b11b_auth_pos                $5
;

infile '.\pbp\pbp_b11_dme_prosth_orth_sup.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b11_maxenr_yesno
   pbp_b11_maxenr_amt
   pbp_b11_maxenr_per
   pbp_b11_coins_yesno
   pbp_b11_coins_pct_mc
   pbp_b11_coins_pct_mcmax
   pbp_b11_coins_cov_mc
   pbp_b11_coins_pct_disc
   pbp_b11_ded_yesno
   pbp_b11_ded_amt
   pbp_b11_copay_yesno
   pbp_b11_copay_mc_amt
   pbp_b11_copay_mcmax_amt
   pbp_b11_auth
   pbp_b11_maxplan_yesno_pos
   pbp_b11_maxpln_amt_pos
   pbp_b11_maxpln_per_pos
   pbp_b11_maxpln_cov_pos
   pbp_b11_maxpln_pct_prpdisc_pos
   pbp_b11_maxenr_yn_pos
   pbp_b11_maxenr_amt_pos
   pbp_b11_coins_yesno_pos
   pbp_b11_coins_pct_pos
   pbp_b11_coins_pctmax_pos
   pbp_b11_coins_cov__pos
   pbp_b11_coins_pct_prpdisc_pos
   pbp_b11_ded_yesno_pos
   pbp_b11_ded_amt_pos
   pbp_b11_copay_yesno_pos
   pbp_b11_copay_amt_pos
   pbp_b11_copay_amtmax_pos
   pbp_b11_auth_pos
   pbp_b11b_maxenr_yesno
   pbp_b11b_maxenr_amt
   pbp_b11b_maxenr_per
   pbp_b11b_coins_yesno
   pbp_b11b_coins_pct_mc
   pbp_b11b_coins_pct_mcmax
   pbp_b11b_coins_cov_mc
   pbp_b11b_coins_pct_disc
   pbp_b11b_ded_yesno
   pbp_b11b_ded_amt
   pbp_b11b_copay_yesno
   pbp_b11b_copay_mcmin_amt
   pbp_b11b_copay_mcmax_amt
   pbp_b11b_auth
   pbp_b11b_maxplan_yesno_pos
   pbp_b11b_maxpln_amt_pos
   pbp_b11b_maxpln_per_pos
   pbp_b11b_maxpln_cov_pos
   pbp_b11b_maxpln_pct_prpdis_pos
   pbp_b11b_maxenr_yn_pos
   pbp_b11b_maxenr_amt_pos
   pbp_b11b_coins_yesno_pos
   pbp_b11b_coins_pct_pos
   pbp_b11b_coins_pctmax_pos
   pbp_b11b_coins_cov__pos
   pbp_b11b_coins_pct_prpdisc_pos
   pbp_b11b_ded_yesno_pos
   pbp_b11b_ded_amt_pos
   pbp_b11b_copay_yesno_pos
   pbp_b11b_copay_amt_pos
   pbp_b11b_copay_amtmax_pos
   pbp_b11b_auth_pos
;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b11_auth                    = 'DMEPOS Auth                       '
pbp_b11_auth_pos                = 'DMEPOS Auth POS                   '
pbp_b11_coins_cov__pos          = 'DMEPOS Coins Cov POS              '
pbp_b11_coins_cov_mc            = 'DMEPOS MC Coins Cov               '
pbp_b11_coins_pct_disc          = 'DMEPOS MC Coin Pct Disc           '
pbp_b11_coins_pct_mc            = 'DMEPOS MC Min Coin Pct            '
pbp_b11_coins_pct_mcmax         = 'DMEPOS MC Max Coin Pct            '
pbp_b11_coins_pct_pos           = 'DMEPOS Min Coin Pct POS           '
pbp_b11_coins_pct_prpdisc_pos   = 'DMEPOS Coins Pct Disc PRP POS     '
pbp_b11_coins_pctmax_pos        = 'DMEPOS Max Coin Pct POS           '
pbp_b11_coins_yesno             = 'DMEPOS Coins Yes No               '
pbp_b11_coins_yesno_pos         = 'DMEPOS Coinsurance YN POS         '
pbp_b11_copay_amt_pos           = 'DMEPOS Min Copay Amt POS          '
pbp_b11_copay_amtmax_pos        = 'DMEPOS Max Copay Amt POS          '
pbp_b11_copay_mc_amt            = 'DMEPOS MC Min Cpy Amt             '
pbp_b11_copay_mcmax_amt         = 'DMEPOS MC Max Cpy Amt             '
pbp_b11_copay_yesno             = 'DMEPOS Copay Yes No               '
pbp_b11_copay_yesno_pos         = 'DMEPOS Copay Yes No POS           '
pbp_b11_ded_amt                 = 'DMEPOS Deductible Amt             '
pbp_b11_ded_amt_pos             = 'DMEPOS Deductible Amt POS         '
pbp_b11_ded_yesno               = 'DMEPOS Deductible Yes No          '
pbp_b11_ded_yesno_pos           = 'DMEPOS Deduct Yes No POS          '
pbp_b11_maxenr_amt              = 'DMEPOS Max Enr Amt                '
pbp_b11_maxenr_amt_pos          = 'DMEPOS Max Enr Amt POS            '
pbp_b11_maxenr_per              = 'DMEPOS Max Enr Per                '
pbp_b11_maxenr_yesno            = 'DMEPOS Max Enr Yes No             '
pbp_b11_maxenr_yn_pos           = 'DMEPOS Max Enr Y/N POS            '
pbp_b11_maxplan_yesno_pos       = 'DMEPOS Max Plan Y/N POS           '
pbp_b11_maxpln_amt_pos          = 'DMEPOS Max Plan Amt POS           '
pbp_b11_maxpln_cov_pos          = 'DMEPOS Max Plan Cov POS           '
pbp_b11_maxpln_pct_prpdisc_pos  = 'DMEPOS Max Plan Pct Disc PRP POS  '
pbp_b11_maxpln_per_pos          = 'DMEPOS Max Pln Per POS            '
pbp_b11b_auth                   = 'Medical Supplies Auth             '
pbp_b11b_auth_pos               = 'Medical Supplies Auth POS         '
pbp_b11b_coins_cov__pos         = 'Med Supplies Coins Cov POS        '
pbp_b11b_coins_cov_mc           = 'Med Supplies MC Coins Cov         '
pbp_b11b_coins_pct_disc         = 'Med Supplies MC Coin Pct Disc     '
pbp_b11b_coins_pct_mc           = 'Med Supplies MC Min Coin Pct      '
pbp_b11b_coins_pct_mcmax        = 'Med Supplies MC Max Coin Pct      '
pbp_b11b_coins_pct_pos          = 'Med Supplies Min Coin Pct POS     '
pbp_b11b_coins_pct_prpdisc_pos  = 'Med Suppls coins Pct Disc PRP POS '
pbp_b11b_coins_pctmax_pos       = 'Med Supplies Max Coin Pct POS     '
pbp_b11b_coins_yesno            = 'Med Supplies Coins Yes No         '
pbp_b11b_coins_yesno_pos        = 'Med Supplies Coinsurance YN POS   '
pbp_b11b_copay_amt_pos          = 'Med Supplies Min Copay Amt POS    '
pbp_b11b_copay_amtmax_pos       = 'Med Supplies Max Copay Amt POS    '
pbp_b11b_copay_mcmax_amt        = 'Med Supplies MC Max Cpy Amt       '
pbp_b11b_copay_mcmin_amt        = 'Med Supplies MC Min Cpy Amt       '
pbp_b11b_copay_yesno            = 'Med Supplies Copay Yes No         '
pbp_b11b_copay_yesno_pos        = 'Med Supplies Copay Yes No POS     '
pbp_b11b_ded_amt                = 'Med Supplies Deductible Amt       '
pbp_b11b_ded_amt_pos            = 'Med Supplies Deductible Amt POS   '
pbp_b11b_ded_yesno              = 'Med Supplies Deductible Yes No    '
pbp_b11b_ded_yesno_pos          = 'Med Supplies Deduct Yes No POS    '
pbp_b11b_maxenr_amt             = 'Med Supplies Max Enr Amt          '
pbp_b11b_maxenr_amt_pos         = 'Med Supplies Max Enr Amt POS      '
pbp_b11b_maxenr_per             = 'Med Supplies Max Enr Per          '
pbp_b11b_maxenr_yesno           = 'Med Supplies Max Enr Yes No       '
pbp_b11b_maxenr_yn_pos          = 'Med Supplies Max Enr Y/N POS      '
pbp_b11b_maxplan_yesno_pos      = 'Med Supplies Max Plan Y/N POS     '
pbp_b11b_maxpln_amt_pos         = 'Med Supplies Max Plan Amt POS     '
pbp_b11b_maxpln_cov_pos         = 'Med Supplies Max Plan Cov POS     '
pbp_b11b_maxpln_pct_prpdis_pos  = 'Med Supp Max Plan Pct Disc PRP POS'
pbp_b11b_maxpln_per_pos         = 'Med Supplies Max Pln Per POS      '
;
run;

proc sort data = pbp_b11 out = out.pbp_b11;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b11 (obs = 10);
  title 'pbp b11 data';
run;

proc means data =  out.pbp_b11;
  title 'pbp b11 file';
run;

proc freq data = out.pbp_b11;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b11_maxenr_yesno
  pbp_b11_maxenr_per
  pbp_b11_coins_yesno
  pbp_b11_coins_cov_mc
  pbp_b11_ded_yesno
  pbp_b11_copay_yesno
  pbp_b11_auth
  pbp_b11_maxplan_yesno_pos
  pbp_b11_maxpln_per_pos
  pbp_b11_maxpln_cov_pos
  pbp_b11_maxenr_yn_pos
  pbp_b11_coins_yesno_pos
  pbp_b11_coins_cov__pos
  pbp_b11_ded_yesno_pos
  pbp_b11_copay_yesno_pos
  pbp_b11_auth_pos
  pbp_b11b_maxenr_yesno
  pbp_b11b_maxenr_per
  pbp_b11b_coins_yesno / missing;
  run;

proc contents data = out.pbp_b11;
  title 'pbp b11 data';
run;
