*pbp_b12.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b12;

length
   pbp_a_hnumber                $5
   pbp_a_plan_identifier        $3
   pbp_a_ben_cov                $1
   pbp_a_plan_type              $2
   orgtype                      $2
   pbp_b12_maxenr_yesno         $1
   pbp_b12_maxenr_per           $1
   pbp_b12_coins_yesno          $1
   pbp_b12_coins_cov_ia_mc      $1
   pbp_b12_coins_cov_oa_mc      $1
   pbp_b12_ded_yesno            $1
   pbp_b12_copay_yesno          $1
   pbp_b12_auth                 $5
;

infile '.\pbp\pbp_b12_renal_dialysis.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;

input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b12_maxenr_yesno
   pbp_b12_maxenr_amt
   pbp_b12_maxenr_per
   pbp_b12_coins_yesno
   pbp_b12_coins_pct_ia_mc
   pbp_b12_coins_cov_ia_mc
   pbp_b12_coins_pct_oa_mc
   pbp_b12_coins_cov_oa_mc
   pbp_b12_ded_yesno
   pbp_b12_ded_amt
   pbp_b12_copay_yesno
   pbp_b12_copay_ia_mc_amt
   pbp_b12_copay_oa_mc_amt
   pbp_b12_auth
;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b12_auth                    = 'Renal Dialysis Auth               '
pbp_b12_coins_cov_ia_mc         = 'Renal Dialysis IA MC Coins Cov    '
pbp_b12_coins_cov_oa_mc         = 'Renal Dialysis OA MC Coins Cov    '
pbp_b12_coins_pct_ia_mc         = 'Renal Dialysis IA MC Coin Pct     '
pbp_b12_coins_pct_oa_mc         = 'Renal Dialysis OA MC Coin Pct     '
pbp_b12_coins_yesno             = 'Renal Dialysis Coins Yes No       '
pbp_b12_copay_ia_mc_amt         = 'Renal Dialysis IA MC Cpy Amt      '
pbp_b12_copay_oa_mc_amt         = 'Renal Dialysis OA MC Cpy Amt      '
pbp_b12_copay_yesno             = 'Renal Dialysis Copay Yes No       '
pbp_b12_ded_amt                 = 'Renal Dialysis Deductible Amt     '
pbp_b12_ded_yesno               = 'Renal Dialysis Deduc Yes No       '
pbp_b12_maxenr_amt              = 'Renal Dialysis Max Enr Amt        '
pbp_b12_maxenr_per              = 'Renal Dialysis Max Enr Per        '
pbp_b12_maxenr_yesno            = 'Renal Dialysis Max Enr Yes No     '
;
run;

proc sort data = pbp_b12 out= out.pbp_b12;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b12 (obs = 10);
  title 'pbp b12 data';
run;

proc means data =  out.pbp_b12;
  title 'pbp b12 file';
run;

proc freq data = out.pbp_b12;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b12_maxenr_yesno
  pbp_b12_maxenr_per
  pbp_b12_coins_yesno
  pbp_b12_coins_cov_ia_mc
  pbp_b12_coins_cov_oa_mc
  pbp_b12_ded_yesno
  pbp_b12_copay_yesno
  pbp_b12_auth / missing;
run;

proc contents data = out.pbp_b12;
  title 'pbp b12 data';
run;
