*pbp_b13.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b13;

length
   pbp_a_hnumber                        $5
   pbp_a_plan_identifier                $3
   pbp_a_ben_cov                        $1
   pbp_a_plan_type                      $2
   orgtype                              $2
   pbp_b13a_bendec_yesno                $1
   pbp_b13a_bendec                      $1
   pbp_b13a_bendesc_amo                 $1
   pbp_b13a_maxenr_yesno                $1
   pbp_b13a_maxenr_per                  $1
   pbp_b13a_coins_yesno                 $1
   pbp_b13a_coins_cov_mc                $1
   pbp_b13a_ded_yesno                   $1
   pbp_b13a_copay_yesno                 $1
   pbp_b13a_auth                        $5
   pbp_b13a_maxplan_yesno_pos           $1
   pbp_b13a_maxpln_per_pos              $1
   pbp_b13a_maxpln_cov_pos              $1
   pbp_b13a_maxenr_yn_pos               $1
   pbp_b13a_coins_yesno_pos             $1
   pbp_b13a_coins_cov__pos              $1
   pbp_b13a_ded_yesno_pos               $1
   pbp_b13a_copay_yesno_pos             $1
   pbp_b13a_auth_pos                    $5
   pbp_b13b_bendesc_yesno               $1
   pbp_b13b_bendesc_enhan               $1
   pbp_b13b_bendesc_amo                 $1
   pbp_b13b_bendesc_lim                 $1
   pbp_b13b_bendesc_per                 $1
   pbp_b13b_maxplan_yesno               $1
   pbp_b13b_maxplan_per                 $1
   pbp_b13b_maxplan_cov                 $1
   pbp_b13b_maxenr_yesno                $1
   pbp_b13b_maxenr_per                  $1
   pbp_b13b_coins_yesno                 $1
   pbp_b13b_coins_cov                   $1
   pbp_b13b_ded_yesno                   $1
   pbp_b13b_copay_yesno                 $1
   pbp_b13b_auth                        $5
   pbp_b13b_maxplan_yesno_pos           $1
   pbp_b13b_maxpln_per_pos              $1
   pbp_b13b_maxpln_cov_pos              $1
   pbp_b13b_maxenr_yesno_pos            $1
   pbp_b13b_coins_yesno_pos             $1
   pbp_b13b_coins_cov__pos              $1
   pbp_b13b_ded_yesno_pos               $1
   pbp_b13b_copay_yesno_pos             $1
   pbp_b13b_auth_pos                    $5
   pbp_b13c_bendesc_service             $55
   pbp_b13c_bendesc_amo                 $1
   pbp_b13c_maxplan_yesno               $1
   pbp_b13c_maxplan_per                 $1
   pbp_b13c_maxplan_cov                 $1
   pbp_b13c_maxenr_yesno                $1
   pbp_b13c_maxenr_per                  $1
   pbp_b13c_coins_yesno                 $1
   pbp_b13c_coins_cov                   $1
   pbp_b13c_ded_yesno                   $1
   pbp_b13c_copay_yesno                 $1
   pbp_b13c_auth                        $5
   pbp_b13c_maxplan_yesno_pos           $1
   pbp_b13c_maxpln_per_pos              $1
   pbp_b13c_maxpln_cov_pos              $1
   pbp_b13c_maxenr_yesno_pos            $1
   pbp_b13c_coins_yesno_pos             $1
   pbp_b13c_coins_cov__pos              $1
   pbp_b13c_ded_yesno_pos               $1
   pbp_b13c_copay_yesno_pos             $1
   pbp_b13c_auth_pos                    $5
   pbp_b13d_bendesc_service             $55
   pbp_b13d_bendesc_amo                 $1
   pbp_b13d_maxplan_yesno               $1
   pbp_b13d_maxplan_per                 $1
   pbp_b13d_maxplan_cov                 $1
   pbp_b13d_maxenr_yesno                $1
   pbp_b13d_maxenr_per                  $1
   pbp_b13d_coins_yesno                 $1
   pbp_b13d_coins_cov                   $1
   pbp_b13d_ded_yesno                   $1
   pbp_b13d_copay_yesno                 $1
   pbp_b13d_auth                        $5
   pbp_b13d_maxplan_yesno_pos           $1
   pbp_b13d_maxpln_per_pos              $1
   pbp_b13d_maxpln_cov_pos              $1
   pbp_b13d_maxenr_yesno_pos            $1
   pbp_b13d_coins_yesno_pos             $1
   pbp_b13d_coins_cov__pos              $1
   pbp_b13d_ded_yesno_pos               $1
   pbp_b13d_copay_yesno_pos             $1
   pbp_b13d_auth_pos                    $5
   pbp_b13e_bendesc_service             $55
   pbp_b13e_bendesc_amo                 $1
   pbp_b13e_maxplan_yesno               $1
   pbp_b13e_maxplan_per                 $1
   pbp_b13e_maxplan_cov                 $1
   pbp_b13e_maxenr_yesno                $1
   pbp_b13e_maxenr_per                  $1
   pbp_b13e_coins_yesno                 $1
   pbp_b13e_coins_cov                   $1
   pbp_b13e_ded_yesno                   $1
   pbp_b13e_copay_yesno                 $1
   pbp_b13e_auth                        $5
   pbp_b13e_maxplan_yesno_pos           $1
   pbp_b13e_maxpln_per_pos              $1
   pbp_b13e_maxpln_cov_pos              $1
   pbp_b13e_maxenr_yesno_pos            $1
   pbp_b13e_coins_yesno_pos             $1
   pbp_b13e_coins_cov__pos              $1
   pbp_b13e_ded_yesno_pos               $1
   pbp_b13e_copay_yesno_pos             $1
   pbp_b13e_auth_pos                    $5
;

infile '.\pbp\pbp_b13_other_services.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b13a_bendec_yesno
   pbp_b13a_bendec
   pbp_b13a_bendesc_amo
   pbp_b13a_maxenr_yesno
   pbp_b13a_maxenr_amt
   pbp_b13a_maxenr_per
   pbp_b13a_coins_yesno
   pbp_b13a_coins_pct_mc
   pbp_b13a_coins_cov_mc
   pbp_b13a_ded_yesno
   pbp_b13a_ded_amt
   pbp_b13a_copay_yesno
   pbp_b13a_copay_mc_amt
   pbp_b13a_auth
   pbp_b13a_maxplan_yesno_pos
   pbp_b13a_maxpln_amt_pos
   pbp_b13a_maxpln_per_pos
   pbp_b13a_maxpln_cov_pos
   pbp_b13a_maxenr_yn_pos
   pbp_b13a_maxenr_amt_pos
   pbp_b13a_coins_yesno_pos
   pbp_b13a_coins_pct_pos
   pbp_b13a_coins_cov__pos
   pbp_b13a_ded_yesno_pos
   pbp_b13a_ded_amt_pos
   pbp_b13a_copay_yesno_pos
   pbp_b13a_copay_amt_pos
   pbp_b13a_auth_pos
   pbp_b13b_bendesc_yesno
   pbp_b13b_bendesc_enhan
   pbp_b13b_bendesc_amo
   pbp_b13b_bendesc_lim
   pbp_b13b_bendesc_numv
   pbp_b13b_bendesc_per
   pbp_b13b_maxplan_yesno
   pbp_b13b_maxplan_amt
   pbp_b13b_maxplan_per
   pbp_b13b_maxplan_cov
   pbp_b13b_maxenr_yesno
   pbp_b13b_maxenr_amt
   pbp_b13b_maxenr_per
   pbp_b13b_coins_yesno
   pbp_b13b_coins_pct
   pbp_b13b_coins_cov
   pbp_b13b_ded_yesno
   pbp_b13b_ded_amt
   pbp_b13b_copay_yesno
   pbp_b13b_copay_amt
   pbp_b13b_auth
   pbp_b13b_maxplan_yesno_pos
   pbp_b13b_maxpln_amt_pos
   pbp_b13b_maxpln_per_pos
   pbp_b13b_maxpln_cov_pos
   pbp_b13b_maxenr_yesno_pos
   pbp_b13b_maxenr_amt_pos
   pbp_b13b_coins_yesno_pos
   pbp_b13b_coins_pct_pos
   pbp_b13b_coins_cov__pos
   pbp_b13b_ded_yesno_pos
   pbp_b13b_ded_amt_pos
   pbp_b13b_copay_yesno_pos
   pbp_b13b_copay_amt_pos
   pbp_b13b_auth_pos
   pbp_b13c_bendesc_service
   pbp_b13c_bendesc_amo
   pbp_b13c_maxplan_yesno
   pbp_b13c_maxplan_amt
   pbp_b13c_maxplan_per
   pbp_b13c_maxplan_cov
   pbp_b13c_maxenr_yesno
   pbp_b13c_maxenr_amt
   pbp_b13c_maxenr_per
   pbp_b13c_coins_yesno
   pbp_b13c_coins_pct
   pbp_b13c_coins_cov
   pbp_b13c_ded_yesno
   pbp_b13c_ded_amt
   pbp_b13c_copay_yesno
   pbp_b13c_copay_amt
   pbp_b13c_auth
   pbp_b13c_maxplan_yesno_pos
   pbp_b13c_maxpln_amt_pos
   pbp_b13c_maxpln_per_pos
   pbp_b13c_maxpln_cov_pos
   pbp_b13c_maxenr_yesno_pos
   pbp_b13c_maxenr_amt_pos
   pbp_b13c_coins_yesno_pos
   pbp_b13c_coins_pct_pos
   pbp_b13c_coins_cov__pos
   pbp_b13c_ded_yesno_pos
   pbp_b13c_ded_amt_pos
   pbp_b13c_copay_yesno_pos
   pbp_b13c_copay_amt_pos
   pbp_b13c_auth_pos
   pbp_b13d_bendesc_service
   pbp_b13d_bendesc_amo
   pbp_b13d_maxplan_yesno
   pbp_b13d_maxplan_amt
   pbp_b13d_maxplan_per
   pbp_b13d_maxplan_cov
   pbp_b13d_maxenr_yesno
   pbp_b13d_maxenr_amt
   pbp_b13d_maxenr_per
   pbp_b13d_coins_yesno
   pbp_b13d_coins_pct
   pbp_b13d_coins_cov
   pbp_b13d_ded_yesno
   pbp_b13d_ded_amt
   pbp_b13d_copay_yesno
   pbp_b13d_copay_amt
   pbp_b13d_auth
   pbp_b13d_maxplan_yesno_pos
   pbp_b13d_maxpln_amt_pos
   pbp_b13d_maxpln_per_pos
   pbp_b13d_maxpln_cov_pos
   pbp_b13d_maxenr_yesno_pos
   pbp_b13d_maxenr_amt_pos
   pbp_b13d_coins_yesno_pos
   pbp_b13d_coins_pct_pos
   pbp_b13d_coins_cov__pos
   pbp_b13d_ded_yesno_pos
   pbp_b13d_ded_amt_pos
   pbp_b13d_copay_yesno_pos
   pbp_b13d_copay_amt_pos
   pbp_b13d_auth_pos
   pbp_b13e_bendesc_service
   pbp_b13e_bendesc_amo
   pbp_b13e_maxplan_yesno
   pbp_b13e_maxplan_amt
   pbp_b13e_maxplan_per
   pbp_b13e_maxplan_cov
   pbp_b13e_maxenr_yesno
   pbp_b13e_maxenr_amt
   pbp_b13e_maxenr_per
   pbp_b13e_coins_yesno
   pbp_b13e_coins_pct
   pbp_b13e_coins_cov
   pbp_b13e_ded_yesno
   pbp_b13e_ded_amt
   pbp_b13e_copay_yesno
   pbp_b13e_copay_amt
   pbp_b13e_auth
   pbp_b13e_maxplan_yesno_pos
   pbp_b13e_maxpln_amt_pos
   pbp_b13e_maxpln_per_pos
   pbp_b13e_maxpln_cov_pos
   pbp_b13e_maxenr_yesno_pos
   pbp_b13e_maxenr_amt_pos
   pbp_b13e_coins_yesno_pos
   pbp_b13e_coins_pct_pos
   pbp_b13e_coins_cov__pos
   pbp_b13e_ded_yesno_pos
   pbp_b13e_ded_amt_pos
   pbp_b13e_copay_yesno_pos
   pbp_b13e_copay_amt_pos
   pbp_b13e_auth_pos
;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b13a_auth                   = 'Outpatient Blood Auth             '
pbp_b13a_auth_pos               = 'Outpnt Blood Auth POS             '
pbp_b13a_bendec                 = 'Outpnt Blood Ben Dec              '
pbp_b13a_bendec_yesno           = 'Outpnt Blood Ben Des Yes No       '
pbp_b13a_bendesc_amo            = 'Outpnt Blood Ben Des AMO          '
pbp_b13a_coins_cov__pos         = 'Outpnt Blood Coins Cov POS        '
pbp_b13a_coins_cov_mc           = 'Outpnt Blood MC Coins Cov         '
pbp_b13a_coins_pct_mc           = 'Outpnt Blood MC Coin Pct          '
pbp_b13a_coins_pct_pos          = 'Outpnt Blood Coin Pct POS         '
pbp_b13a_coins_yesno            = 'Outpnt Blood Coins Yes No         '
pbp_b13a_coins_yesno_pos        = 'Outpnt Blood Coinsurance YN POS   '
pbp_b13a_copay_amt_pos          = 'Outpnt Blood Copay Amt POS        '
pbp_b13a_copay_mc_amt           = 'Outpnt Blood MC Cpy Amt           '
pbp_b13a_copay_yesno            = 'Outpnt Blood Copay Yes No         '
pbp_b13a_copay_yesno_pos        = 'Outpnt Blood Copay Yes No POS     '
pbp_b13a_ded_amt                = 'Outpatient Blood Deduc Amt        '
pbp_b13a_ded_amt_pos            = 'Outpnt Blood Deductible Amt POS   '
pbp_b13a_ded_yesno              = 'Outpatient Blood Deduc Yes No     '
pbp_b13a_ded_yesno_pos          = 'Outpnt Blood Deduct Yes No POS    '
pbp_b13a_maxenr_amt             = 'Outpnt Blood Max Enr Amt          '
pbp_b13a_maxenr_amt_pos         = 'Outpnt Blood Max Enr Amt POS      '
pbp_b13a_maxenr_per             = 'Outpnt Blood Max Enr Per          '
pbp_b13a_maxenr_yesno           = 'Outpnt Blood Max Enr Yes No       '
pbp_b13a_maxenr_yn_pos          = 'Outpnt Blood Max Enr Y/N POS      '
pbp_b13a_maxplan_yesno_pos      = 'Outpnt Blood Max Plan Y/N POS     '
pbp_b13a_maxpln_amt_pos         = 'Outpnt Blood Max Plan Amt POS     '
pbp_b13a_maxpln_cov_pos         = 'Outpnt Blood Max Plan Cov POS     '
pbp_b13a_maxpln_per_pos         = 'Outpnt Blood Max Pln Per POS      '
pbp_b13b_auth                   = 'Acupuncture Auth                  '
pbp_b13b_auth_pos               = 'Acupuncture Auth POS              '
pbp_b13b_bendesc_amo            = 'Acupuncture Ben Desc AMO          '
pbp_b13b_bendesc_enhan          = 'Acupuncture Ben Desc Enhan        '
pbp_b13b_bendesc_lim            = 'Acupuncture Ben Desc Lim          '
pbp_b13b_bendesc_numv           = 'Acupuncture Ben Desc NumV         '
pbp_b13b_bendesc_per            = 'Acupuncture Ben Desc Per          '
pbp_b13b_bendesc_yesno          = 'Acupuncture Ben Desc Yes No       '
pbp_b13b_coins_cov              = 'Acupuncture Coinsurance Cov       '
pbp_b13b_coins_cov__pos         = 'Acupuncture Coins Cov POS         '
pbp_b13b_coins_pct              = 'Acupuncture Coinsurance Pct       '
pbp_b13b_coins_pct_pos          = 'Acupuncture Coin Pct POS          '
pbp_b13b_coins_yesno            = 'Acupuncture Coinsurance YN        '
pbp_b13b_coins_yesno_pos        = 'Acupuncture Coinsurance YN POS    '
pbp_b13b_copay_amt              = 'Acupuncture Copay Amt             '
pbp_b13b_copay_amt_pos          = 'Acupuncture Copay Amt POS         '
pbp_b13b_copay_yesno            = 'Acupuncture Copay Yes No          '
pbp_b13b_copay_yesno_pos        = 'Acupuncture Copay Yes No POS      '
pbp_b13b_ded_amt                = 'Acupuncture Deduc Amt             '
pbp_b13b_ded_amt_pos            = 'Acupuncture Deductible Amt POS    '
pbp_b13b_ded_yesno              = 'Acupuncture Deduc Yes No          '
pbp_b13b_ded_yesno_pos          = 'Acupuncture Deduct Yes No POS     '
pbp_b13b_maxenr_amt             = 'Acupuncture Max Enr Amt           '
pbp_b13b_maxenr_amt_pos         = 'Acupuncture Max Enr Amt POS       '
pbp_b13b_maxenr_per             = 'Acupuncture Max Enr Per           '
pbp_b13b_maxenr_yesno           = 'Acupuncture Max Enr Yes No        '
pbp_b13b_maxenr_yesno_pos       = 'Acupuncture Max Enr Yes No POS    '
pbp_b13b_maxplan_amt            = 'Acupuncture Max Plan Amt          '
pbp_b13b_maxplan_cov            = 'Acupuncture Max Plan Cov          '
pbp_b13b_maxplan_per            = 'Acupuncture Max Plan Per          '
pbp_b13b_maxplan_yesno          = 'Acupuncture Max Plan Yes No       '
pbp_b13b_maxplan_yesno_pos      = 'Acupuncture Max Plan Y/N POS      '
pbp_b13b_maxpln_amt_pos         = 'Acupuncture Max Plan Amt POS      '
pbp_b13b_maxpln_cov_pos         = 'Acupuncture Max Plan Cov POS      '
pbp_b13b_maxpln_per_pos         = 'Acupuncture Max Pln Per POS       '
pbp_b13c_auth                   = 'Other 1 Authorization             '
pbp_b13c_auth_pos               = 'Other 1 Auth POS                  '
pbp_b13c_bendesc_amo            = 'Other 1 Ben Desc AMO              '
pbp_b13c_bendesc_service        = 'Other 1 Name of Service           '
pbp_b13c_coins_cov              = 'Other 1 Coinsurance Cov           '
pbp_b13c_coins_cov__pos         = 'Other 1 Coins Cov POS             '
pbp_b13c_coins_pct              = 'Other 1 Coinsurance Pct           '
pbp_b13c_coins_pct_pos          = 'Other 1 Coin Pct POS              '
pbp_b13c_coins_yesno            = 'Other 1 Coinsurance YN            '
pbp_b13c_coins_yesno_pos        = 'Other 1 Coinsurance YN POS        '
pbp_b13c_copay_amt              = 'Other 1 Copay Amt                 '
pbp_b13c_copay_amt_pos          = 'Other 1 Copay Amt POS             '
pbp_b13c_copay_yesno            = 'Other 1 Copay Yes No              '
pbp_b13c_copay_yesno_pos        = 'Other 1 Copay Yes No POS          '
pbp_b13c_ded_amt                = 'Other 1 Deduc Amt                 '
pbp_b13c_ded_amt_pos            = 'Other 1 Deductible Amt POS        '
pbp_b13c_ded_yesno              = 'Other 1 Deduc Yes No              '
pbp_b13c_ded_yesno_pos          = 'Other 1 Deduct Yes No POS         '
pbp_b13c_maxenr_amt             = 'Other 1 Max Enr Amt               '
pbp_b13c_maxenr_amt_pos         = 'Other 1 Max Enr Amt POS           '
pbp_b13c_maxenr_per             = 'Other 1 Max Enr Per               '
pbp_b13c_maxenr_yesno           = 'Other 1 Max Enr Yes No            '
pbp_b13c_maxenr_yesno_pos       = 'Other 1 Max Enr Yes No POS        '
pbp_b13c_maxplan_amt            = 'Other 1 Max Plan Amt              '
pbp_b13c_maxplan_cov            = 'Other 1 Max Plan Cov              '
pbp_b13c_maxplan_per            = 'Other 1 Max Plan Per              '
pbp_b13c_maxplan_yesno          = 'Other 1 Max Plan Yes No           '
pbp_b13c_maxplan_yesno_pos      = 'Other 1 Max Plan Y/N POS          '
pbp_b13c_maxpln_amt_pos         = 'Other 1 Max Plan Amt POS          '
pbp_b13c_maxpln_cov_pos         = 'Other 1 Max Plan Cov POS          '
pbp_b13c_maxpln_per_pos         = 'Other 1 Max Pln Per POS           '
pbp_b13d_auth                   = 'Other 2 Authorization             '
pbp_b13d_auth_pos               = 'Other 2 Auth POS                  '
pbp_b13d_bendesc_amo            = 'Other 2 Ben Desc AMO              '
pbp_b13d_bendesc_service        = 'Other 2 Name of Service           '
pbp_b13d_coins_cov              = 'Other 2 Coinsurance Cov           '
pbp_b13d_coins_cov__pos         = 'Other 2 Coins Cov POS             '
pbp_b13d_coins_pct              = 'Other 2 Coinsurance Pct           '
pbp_b13d_coins_pct_pos          = 'Other 2 Coin Pct POS              '
pbp_b13d_coins_yesno            = 'Other 2 Coinsurance YN            '
pbp_b13d_coins_yesno_pos        = 'Other 2 Coinsurance YN POS        '
pbp_b13d_copay_amt              = 'Other 2 Copay Amt                 '
pbp_b13d_copay_amt_pos          = 'Other 2 Copay Amt POS             '
pbp_b13d_copay_yesno            = 'Other 2 Copay Yes No              '
pbp_b13d_copay_yesno_pos        = 'Other 2 Copay Yes No POS          '
pbp_b13d_ded_amt                = 'Other 2 Deduc Amt                 '
pbp_b13d_ded_amt_pos            = 'Other 2 Deductible Amt POS        '
pbp_b13d_ded_yesno              = 'Other 2 Deduc Yes No              '
pbp_b13d_ded_yesno_pos          = 'Other 2 Deduct Yes No POS         '
pbp_b13d_maxenr_amt             = 'Other 2 Max Enr Amt               '
pbp_b13d_maxenr_amt_pos         = 'Other 2 Max Enr Amt POS           '
pbp_b13d_maxenr_per             = 'Other 2 Max Enr Per               '
pbp_b13d_maxenr_yesno           = 'Other 2 Max Enr Yes No            '
pbp_b13d_maxenr_yesno_pos       = 'Other 2 Max Enr Yes No POS        '
pbp_b13d_maxplan_amt            = 'Other 2 Max Plan Amt              '
pbp_b13d_maxplan_cov            = 'Other 2 Max Plan Cov              '
pbp_b13d_maxplan_per            = 'Other 2 Max Plan Per              '
pbp_b13d_maxplan_yesno          = 'Other 2 Max Plan Yes No           '
pbp_b13d_maxplan_yesno_pos      = 'Other 2 Max Plan Y/N POS          '
pbp_b13d_maxpln_amt_pos         = 'Other 2 Max Plan Amt POS          '
pbp_b13d_maxpln_cov_pos         = 'Other 2 Max Plan Cov POS          '
pbp_b13d_maxpln_per_pos         = 'Other 2 Max Pln Per POS           '
pbp_b13e_auth                   = 'Other 3 Authorization             '
pbp_b13e_auth_pos               = 'Other 3 Auth POS                  '
pbp_b13e_bendesc_amo            = 'Other 3 Ben Desc AMO              '
pbp_b13e_bendesc_service        = 'Other 3 Name of Service           '
pbp_b13e_coins_cov              = 'Other 3 Coinsurance Cov           '
pbp_b13e_coins_cov__pos         = 'Other 3 Coins Cov POS             '
pbp_b13e_coins_pct              = 'Other 3 Coinsurance Pct           '
pbp_b13e_coins_pct_pos          = 'Other 3 Coin Pct POS              '
pbp_b13e_coins_yesno            = 'Other 3 Coinsurance YN            '
pbp_b13e_coins_yesno_pos        = 'Other 3 Coinsurance YN POS        '
pbp_b13e_copay_amt              = 'Other 3 Copay Amt                 '
pbp_b13e_copay_amt_pos          = 'Other 3 Copay Amt POS             '
pbp_b13e_copay_yesno            = 'Other 3 Copay Yes No              '
pbp_b13e_copay_yesno_pos        = 'Other 3 Copay Yes No POS          '
pbp_b13e_ded_amt                = 'Other 3 Deduc Amt                 '
pbp_b13e_ded_amt_pos            = 'Other 3 Deductible Amt POS        '
pbp_b13e_ded_yesno              = 'Other 3 Deduc Yes No              '
pbp_b13e_ded_yesno_pos          = 'Other 3 Deduct Yes No POS         '
pbp_b13e_maxenr_amt             = 'Other 3 Max Enr Amt               '
pbp_b13e_maxenr_amt_pos         = 'Other 3 Max Enr Amt POS           '
pbp_b13e_maxenr_per             = 'Other 3 Max Enr Per               '
pbp_b13e_maxenr_yesno           = 'Other 3 Max Enr Yes No            '
pbp_b13e_maxenr_yesno_pos       = 'Other 3 Max Enr Yes No POS        '
pbp_b13e_maxplan_amt            = 'Other 3 Max Plan Amt              '
pbp_b13e_maxplan_cov            = 'Other 3 Max Plan Cov              '
pbp_b13e_maxplan_per            = 'Other 3 Max Plan Per              '
pbp_b13e_maxplan_yesno          = 'Other 3 Max Plan Yes No           '
pbp_b13e_maxplan_yesno_pos      = 'Other 3 Max Plan Y/N POS          '
pbp_b13e_maxpln_amt_pos         = 'Other 3 Max Plan Amt POS          '
pbp_b13e_maxpln_cov_pos         = 'Other 3 Max Plan Cov POS          '
pbp_b13e_maxpln_per_pos         = 'Other 3 Max Pln Per POS           '
;
run;

proc sort data = pbp_b13 out = out.pbp_b13;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b13 (obs = 10);
  title 'pbp b13 data';
run;

proc means data =  out.pbp_b13;
  title 'pbp b13 file';
run;

proc freq data = out.pbp_b13;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b13a_auth
  pbp_b13a_maxplan_yesno_pos
  pbp_b13a_maxpln_per_pos
  pbp_b13a_maxpln_cov_pos
  pbp_b13a_maxenr_yn_pos
  pbp_b13a_coins_yesno_pos
  pbp_b13a_coins_cov__pos
  pbp_b13a_ded_yesno_pos
  pbp_b13a_copay_yesno_pos
  pbp_b13a_auth_pos
  pbp_b13b_bendesc_yesno
  pbp_b13b_bendesc_enhan
  pbp_b13b_bendesc_amo
  pbp_b13b_bendesc_lim
  pbp_b13b_bendesc_per
  pbp_b13b_maxplan_yesno
  pbp_b13b_maxplan_per
  pbp_b13b_maxplan_cov
  pbp_b13b_maxenr_yesno
  pbp_b13b_maxenr_per / missing;
run;

proc contents data = out.pbp_b13;
  title 'pbp b13 data';
run;
