*pbp_b14ad.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b14ad;

length
   pbp_a_hnumber                        $5
   pbp_a_plan_identifier                $3
   pbp_a_ben_cov                        $1
   pbp_a_plan_type                      $2
   orgtype                              $2
   pbp_b14a_bendec_yesno                $1
   pbp_b14a_bendec_ehc                  $10
   pbp_b14a_bendesc_amo_hec             $1
   pbp_b14a_bendesc_amo_nl              $1
   pbp_b14a_bendesc_amo_ntv             $1
   pbp_b14a_bendesc_amo_sc              $1
   pbp_b14a_bendesc_amo_chp             $1
   pbp_b14a_bendesc_amo_amp             $1
   pbp_b14a_bendesc_amo_mhc             $1
   pbp_b14a_bendesc_amo_nhl             $1
   pbp_b14a_bendesc_amo_dsm             $1
   pbp_b14a_bendesc_amo_oth             $1
   pbp_b14a_maxplan_yesno               $1
   pbp_b14a_maxplan_per                 $1
   pbp_b14a_maxplan_covb                $1
   pbp_b14a_maxenr_yesno                $1
   pbp_b14a_maxenr_per                  $1
   pbp_b14a_coins_yesno                 $1
   pbp_b14a_coins_cov_hec               $1
   pbp_b14a_coins_cov_nl                $1
   pbp_b14a_coins_cov_ntv               $1
   pbp_b14a_coins_cov_sc                $1
   pbp_b14a_coins_cov_chp               $1
   pbp_b14a_coins_cov_amp               $1
   pbp_b14a_coins_cov_mhc               $1
   pbp_b14a_coins_cov_nhl               $1
   pbp_b14a_coins_cov_dsm               $1
   pbp_b14a_coins_cov_oth               $1
   pbp_b14a_ded_yesno                   $1
   pbp_b14a_copay_yesno                 $1
   pbp_b14a_auth                        $5
   pbp_b14a_maxplan_yesno_pos           $1
   pbp_b14a_maxpln_per_pos              $1
   pbp_b14a_maxpln_cov_pos              $1
   pbp_b14a_maxenr_yn_pos               $1
   pbp_b14a_coins_yesno_pos             $1
   pbp_b14a_coins_cov__pos              $1
   pbp_b14a_ded_yesno_pos               $1
   pbp_b14a_copay_yesno_pos             $1
   pbp_b14a_auth_pos                    $5
   pbp_b14b_bendesc_yesno               $1
   pbp_b14b_bendesc                     $1
   pbp_b14b_bendesc_amo                 $1
   pbp_b14b_maxenr_yesno                $1
   pbp_b14b_maxenr_type                 $1
   pbp_b14b_maxenr_per                  $1
   pbp_b14b_coins_yesno                 $1
   pbp_b14b_coins_cov_mc                $1
   pbp_b14b_coins_cov_oi                $1
   pbp_b14b_ded_yesno                   $1
   pbp_b14b_copay_yesno                 $1
   pbp_b14b_cost_share                  $1
   pbp_b14b_auth                        $5
   pbp_b14b_maxplan_yesno_pos           $1
   pbp_b14b_maxplan_type_pos            $1
   pbp_b14b_maxpln_per_pos              $1
   pbp_b14b_maxpln_cov_pos              $1
   pbp_b14b_maxenr_yesno_pos            $1
   pbp_b14b_maxenr_type_pos             $1
   pbp_b14b_coins_yesno_pos             $1
   pbp_b14b_coins_cov__pos              $1
   pbp_b14b_ded_yesno_pos               $1
   pbp_b14b_copay_yesno_pos             $1
   pbp_b14b_auth_pos                    $5
   pbp_b14c_bendesc_yesno               $1
   pbp_b14c_bendesc_enhan               $1
   pbp_b14c_bendesc_amo                 $1
   pbp_b14c_bendesc_lim                 $1
   pbp_b14c_bendesc_per                 $1
   pbp_b14c_maxplan_yesno               $1
   pbp_b14c_maxplan_type                $1
   pbp_b14c_maxplan_per                 $1
   pbp_b14c_maxplan_cov                 $1
   pbp_b14c_maxenr_yesno                $1
   pbp_b14c_maxenr_type                 $1
   pbp_b14c_maxenr_per                  $1
   pbp_b14c_coins_yesno                 $1
   pbp_b14c_coins_cov                   $1
   pbp_b14c_ded_yesno                   $1
   pbp_b14c_copay_yesno                 $1
   pbp_b14c_cost_share                  $1
   pbp_b14c_auth                        $5
   pbp_b14c_maxplan_yesno_pos           $1
   pbp_b14c_maxplan_type_pos            $1
   pbp_b14c_maxpln_per_pos              $1
   pbp_b14c_maxpln_cov_pos              $1
   pbp_b14c_maxenr_yesno_pos            $1
   pbp_b14c_maxenr_type_pos             $1
   pbp_b14c_coins_yesno_pos             $1
   pbp_b14c_coins_cov__pos              $1
   pbp_b14c_ded_yesno_pos               $1
   pbp_b14c_copay_yesno_pos             $1
   pbp_b14c_auth_pos                    $5
   pbp_b14d_bendesc_yesno               $1
   pbp_b14d_bendesc_enhan               $2
   pbp_b14d_bendesc_amo_ps              $1
   pbp_b14d_bendesc_amo_pe              $1
   pbp_b14d_bendesc_ps_per              $1
   pbp_b14d_bendesc_pe_per              $1
   pbp_b14d_maxplan_yesno               $1
   pbp_b14d_maxplan_type                $1
   pbp_b14d_maxplan_per                 $1
   pbp_b14d_maxplan_cov                 $1
   pbp_b14d_maxenr_yesno                $1
   pbp_b14d_maxenr_type                 $1
   pbp_b14d_maxenr_per                  $1
   pbp_b14d_coins_yesno                 $1
   pbp_b14d_coins_cov_mcpap             $1
   pbp_b14d_coins_cov_mcpe              $1
   pbp_b14d_coins_cov_pap               $1
   pbp_b14d_coins_cov_pe                $1
   pbp_b14d_ded_yesno                   $1
   pbp_b14d_copay_yesno                 $1
   pbp_b14d_cost_share                  $1
   pbp_b14d_auth                        $5
   pbp_b14d_maxplan_yesno_pos           $1
   pbp_b14d_maxplan_type_pos            $1
   pbp_b14d_maxpln_per_pos              $1
   pbp_b14d_maxpln_cov_pos              $1
   pbp_b14d_maxenr_yesno_pos            $1
   pbp_b14d_maxenr_type_pos             $1
   pbp_b14d_coins_yesno_pos             $1
   pbp_b14d_coins_cov__pos              $1
   pbp_b14d_ded_yesno_pos               $1
   pbp_b14d_copay_yesno_pos             $1
   pbp_b14d_auth_pos                    $5
;

infile '.\pbp\pbp_b14_preventive_1.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


  input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b14a_bendec_yesno
   pbp_b14a_bendec_ehc
   pbp_b14a_bendesc_amo_hec
   pbp_b14a_bendesc_amo_nl
   pbp_b14a_bendesc_amo_ntv
   pbp_b14a_bendesc_amo_sc
   pbp_b14a_bendesc_amo_chp
   pbp_b14a_bendesc_amo_amp
   pbp_b14a_bendesc_amo_mhc
   pbp_b14a_bendesc_amo_nhl
   pbp_b14a_bendesc_amo_dsm
   pbp_b14a_bendesc_amo_oth
   pbp_b14a_maxplan_yesno
   pbp_b14a_maxplan_amt
   pbp_b14a_maxplan_per
   pbp_b14a_maxplan_covb
   pbp_b14a_maxplan_pct
   pbp_b14a_maxenr_yesno
   pbp_b14a_maxenr_amt
   pbp_b14a_maxenr_per
   pbp_b14a_coins_yesno
   pbp_b14a_coins_pct_hec
   pbp_b14a_coins_pctmax_hec
   pbp_b14a_coins_cov_hec
   pbp_b14a_coins_hec_pct
   pbp_b14a_coins_pct_nl
   pbp_b14a_coins_cov_nl
   pbp_b14a_coins_nl_pct
   pbp_b14a_coins_pct_ntv
   pbp_b14a_coins_cov_ntv
   pbp_b14a_coins_ntv_pct
   pbp_b14a_coins_pct_sc
   pbp_b14a_coins_cov_sc
   pbp_b14a_coins_sc_pct
   pbp_b14a_coins_pct_chp
   pbp_b14a_coins_cov_chp
   pbp_b14a_coins_chp_pct
   pbp_b14a_coins_pct_amp
   pbp_b14a_coins_pctmax_amp
   pbp_b14a_coins_cov_amp
   pbp_b14a_coins_amp_pct
   pbp_b14a_coins_pct_mhc
   pbp_b14a_coins_pctmax_mhc
   pbp_b14a_coins_cov_mhc
   pbp_b14a_coins_mhc_pct
   pbp_b14a_coins_pct_nhl
   pbp_b14a_coins_cov_nhl
   pbp_b14a_coins_nhl_pct
   pbp_b14a_coins_pct_dsm
   pbp_b14a_coins_pctmax_dsm
   pbp_b14a_coins_cov_dsm
   pbp_b14a_coins_dsm_pct
   pbp_b14a_coins_pct_oth
   pbp_b14a_coins_pctmax_oth
   pbp_b14a_coins_cov_oth
   pbp_b14a_coins_oth_pct
   pbp_b14a_ded_yesno
   pbp_b14a_ded_amt
   pbp_b14a_copay_yesno
   pbp_b14a_copay_hec_amt
   pbp_b14a_copay_hec_max_amt
   pbp_b14a_copay_nl_amt
   pbp_b14a_copay_ntv_amt
   pbp_b14a_copay_sc_amt
   pbp_b14a_copay_chp_amt
   pbp_b14a_copay_amp_amt
   pbp_b14a_copay_amp_amtmax
   pbp_b14a_copay_mhc_amt
   pbp_b14a_copay_mhc_amtmax
   pbp_b14a_copay_nhl_amt
   pbp_b14a_copay_dsm_amt
   pbp_b14a_copay_dsm_amtmax
   pbp_b14a_copay_oth_amt
   pbp_b14a_copay_oth_maxamt
   pbp_b14a_auth
   pbp_b14a_maxplan_yesno_pos
   pbp_b14a_maxpln_amt_pos
   pbp_b14a_maxpln_per_pos
   pbp_b14a_maxpln_cov_pos
   pbp_b14a_maxpln_pct_prpdis_pos
   pbp_b14a_maxenr_yn_pos
   pbp_b14a_maxenr_amt_pos
   pbp_b14a_coins_yesno_pos
   pbp_b14a_coins_pct_pos
   pbp_b14a_coins_pctmax_pos
   pbp_b14a_coins_cov__pos
   pbp_b14a_coins_pct_prpdisc_pos
   pbp_b14a_ded_yesno_pos
   pbp_b14a_ded_amt_pos
   pbp_b14a_copay_yesno_pos
   pbp_b14a_copay_amt_pos
   pbp_b14a_copay_amtmax_pos
   pbp_b14a_auth_pos
   pbp_b14b_bendesc_yesno
   pbp_b14b_bendesc
   pbp_b14b_bendesc_amo
   pbp_b14b_maxenr_yesno
   pbp_b14b_maxenr_type
   pbp_b14b_maxenr_amt
   pbp_b14b_maxenr_per
   pbp_b14b_coins_yesno
   pbp_b14b_coins_pct_mc
   pbp_b14b_coins_cov_mc
   pbp_b14b_coins_pct_oi
   pbp_b14b_coins_pct_maxoi
   pbp_b14b_coins_cov_oi
   pbp_b14b_ded_yesno
   pbp_b14b_ded_amt
   pbp_b14b_copay_yesno
   pbp_b14b_copay_mc_amt
   pbp_b14b_copay_oi_amt
   pbp_b14b_copay_oi_maxamt
   pbp_b14b_cost_share
   pbp_b14b_auth
   pbp_b14b_maxplan_yesno_pos
   pbp_b14b_maxplan_type_pos
   pbp_b14b_maxpln_amt_pos
   pbp_b14b_maxpln_per_pos
   pbp_b14b_maxpln_cov_pos
   pbp_b14b_maxenr_yesno_pos
   pbp_b14b_maxenr_type_pos
   pbp_b14b_maxenr_amt_pos
   pbp_b14b_coins_yesno_pos
   pbp_b14b_coins_pct_pos
   pbp_b14b_coins_pctmax_pos
   pbp_b14b_coins_cov__pos
   pbp_b14b_ded_yesno_pos
   pbp_b14b_ded_amt_pos
   pbp_b14b_copay_yesno_pos
   pbp_b14b_copay_amt_pos
   pbp_b14b_copay_amtmax_pos
   pbp_b14b_auth_pos
   pbp_b14c_bendesc_yesno
   pbp_b14c_bendesc_enhan
   pbp_b14c_bendesc_amo
   pbp_b14c_bendesc_lim
   pbp_b14c_bendesc_numv
   pbp_b14c_bendesc_per
   pbp_b14c_maxplan_yesno
   pbp_b14c_maxplan_type
   pbp_b14c_maxplan_amt
   pbp_b14c_maxplan_per
   pbp_b14c_maxplan_cov
   pbp_b14c_maxenr_yesno
   pbp_b14c_maxenr_type
   pbp_b14c_maxenr_amt
   pbp_b14c_maxenr_per
   pbp_b14c_coins_yesno
   pbp_b14c_coins_pct
   pbp_b14c_coins_cov
   pbp_b14c_ded_yesno
   pbp_b14c_ded_amt
   pbp_b14c_copay_yesno
   pbp_b14c_copay_amt
   pbp_b14c_cost_share
   pbp_b14c_auth
   pbp_b14c_maxplan_yesno_pos
   pbp_b14c_maxplan_type_pos
   pbp_b14c_maxpln_amt_pos
   pbp_b14c_maxpln_per_pos
   pbp_b14c_maxpln_cov_pos
   pbp_b14c_maxenr_yesno_pos
   pbp_b14c_maxenr_type_pos
   pbp_b14c_maxenr_amt_pos
   pbp_b14c_coins_yesno_pos
   pbp_b14c_coins_pct_pos
   pbp_b14c_coins_cov__pos
   pbp_b14c_ded_yesno_pos
   pbp_b14c_ded_amt_pos
   pbp_b14c_copay_yesno_pos
   pbp_b14c_copay_amt_pos
   pbp_b14c_auth_pos
   pbp_b14d_bendesc_yesno
   pbp_b14d_bendesc_enhan
   pbp_b14d_bendesc_amo_ps
   pbp_b14d_bendesc_amo_pe
   pbp_b14d_bendesc_numps
   pbp_b14d_bendesc_ps_per
   pbp_b14d_bendesc_numpe
   pbp_b14d_bendesc_pe_per
   pbp_b14d_maxplan_yesno
   pbp_b14d_maxplan_type
   pbp_b14d_maxplan_pct
   pbp_b14d_maxplan_per
   pbp_b14d_maxplan_cov
   pbp_b14d_maxenr_yesno
   pbp_b14d_maxenr_type
   pbp_b14d_maxenr_amt
   pbp_b14d_maxenr_per
   pbp_b14d_coins_yesno
   pbp_b14d_coins_pct_mcpap
   pbp_b14d_coins_cov_mcpap
   pbp_b14d_coins_pct_mcpe
   pbp_b14d_coins_cov_mcpe
   pbp_b14d_coins_pct_pap
   pbp_b14d_coins_cov_pap
   pbp_b14d_coins_pct_pe
   pbp_b14d_coins_cov_pe
   pbp_b14d_ded_yesno
   pbp_b14d_ded_amt
   pbp_b14d_copay_yesno
   pbp_b14d_copay_amt_mcpap
   pbp_b14d_copay_amt_mcpe
   pbp_b14d_copay_amt_pap
   pbp_b14d_copay_amt_pe
   pbp_b14d_cost_share
   pbp_b14d_auth
   pbp_b14d_maxplan_yesno_pos
   pbp_b14d_maxplan_type_pos
   pbp_b14d_maxpln_amt_pos
   pbp_b14d_maxpln_per_pos
   pbp_b14d_maxpln_cov_pos
   pbp_b14d_maxenr_yesno_pos
   pbp_b14d_maxenr_type_pos
   pbp_b14d_maxenr_amt_pos
   pbp_b14d_coins_yesno_pos
   pbp_b14d_coins_pct_pos
   pbp_b14d_coins_pctmax_pos
   pbp_b14d_coins_cov__pos
   pbp_b14d_ded_yesno_pos
   pbp_b14d_ded_amt_pos
   pbp_b14d_copay_yesno_pos
   pbp_b14d_copay_amt_pos
   pbp_b14d_copay_amtmax_pos
   pbp_b14d_auth_pos
;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b14a_auth                   = 'Health Education Auth             '
pbp_b14a_auth_pos               = 'Health Ed Auth POS                '
pbp_b14a_bendec_ehc             = 'Health Educa Ben Dec Enhc         '
pbp_b14a_bendec_yesno           = 'Health Educa Ben Des Yes No       '
pbp_b14a_bendesc_amo_amp        = 'Health Educa Ben Des AMO AMP      '
pbp_b14a_bendesc_amo_chp        = 'Health Educa Ben Des AMO CHP      '
pbp_b14a_bendesc_amo_dsm        = 'Health Educa Ben Des AMO DSM      '
pbp_b14a_bendesc_amo_hec        = 'Health Educa Ben Des AMO HEC      '
pbp_b14a_bendesc_amo_mhc        = 'Health Educa Ben Des AMO MHC      '
pbp_b14a_bendesc_amo_nhl        = 'Health Educa Ben Des AMO NHL      '
pbp_b14a_bendesc_amo_nl         = 'Health Educa Ben Des AMO NL       '
pbp_b14a_bendesc_amo_ntv        = 'Health Educa Ben Des AMO NTV      '
pbp_b14a_bendesc_amo_oth        = 'Health Educa Ben Des AMO OTH      '
pbp_b14a_bendesc_amo_sc         = 'Health Educa Ben Des AMO SC       '
pbp_b14a_coins_amp_pct          = 'Hlth Edu Coins AMP Pct            '
pbp_b14a_coins_chp_pct          = 'Hlth Edu Coins CHP Pct            '
pbp_b14a_coins_cov__pos         = 'Health Ed Coins Cov POS           '
pbp_b14a_coins_cov_amp          = 'Health Educa AMP Coins Cov        '
pbp_b14a_coins_cov_chp          = 'Health Educa CHP Coins Cov        '
pbp_b14a_coins_cov_dsm          = 'Health Educa DSM Coins Cov        '
pbp_b14a_coins_cov_hec          = 'Health Educa HEC Coins Cov        '
pbp_b14a_coins_cov_mhc          = 'Health Educa MHC Coins Cov        '
pbp_b14a_coins_cov_nhl          = 'Health Educa NHL Coins Cov        '
pbp_b14a_coins_cov_nl           = 'Health Educa NL Coins Cov         '
pbp_b14a_coins_cov_ntv          = 'Health Educa NTV Coins Cov        '
pbp_b14a_coins_cov_oth          = 'Health Educa OTH Coins Cov        '
pbp_b14a_coins_cov_sc           = 'Health Educa SC Coins Cov         '
pbp_b14a_coins_dsm_pct          = 'Hlth Edu Coins DSM Pct            '
pbp_b14a_coins_hec_pct          = 'Hlth Edu Coins HEC Pct            '
pbp_b14a_coins_mhc_pct          = 'Hlth Edu Coins MHC Pct            '
pbp_b14a_coins_nhl_pct          = 'Hlth Edu Coins NHL Pct            '
pbp_b14a_coins_nl_pct           = 'Hlth Edu Coins NL Pct             '
pbp_b14a_coins_ntv_pct          = 'Hlth Edu Coins NTV Pct            '
pbp_b14a_coins_oth_pct          = 'Hlth Edu Coins OTH Pct            '
pbp_b14a_coins_pct_amp          = 'Health Educa AMP Min Coin Pct     '
pbp_b14a_coins_pct_chp          = 'Health Educa CHP Coin Pct         '
pbp_b14a_coins_pct_dsm          = 'Health Educa DSM Min Coin Pct     '
pbp_b14a_coins_pct_hec          = 'Health Educa HEC Min Coin Pct     '
pbp_b14a_coins_pct_mhc          = 'Health Educa MHC Min Coin Pct     '
pbp_b14a_coins_pct_nhl          = 'Health Educa NHL Coin Pct         '
pbp_b14a_coins_pct_nl           = 'Health Educa NL Coin Pct          '
pbp_b14a_coins_pct_ntv          = 'Health Educa NTV Coin Pct         '
pbp_b14a_coins_pct_oth          = 'Hlth Educ OTH Min Coin Pct        '
pbp_b14a_coins_pct_pos          = 'Health Ed Min Coin Pct POS        '
pbp_b14a_coins_pct_prpdisc_pos  = 'Health Ed coins Pct Disc PRP POS  '
pbp_b14a_coins_pct_sc           = 'Health Educa SC Coin Pct          '
pbp_b14a_coins_pctmax_amp       = 'Health Educa AMP Max Coin Pct     '
pbp_b14a_coins_pctmax_dsm       = 'Health Educa DSM Max Coin Pct     '
pbp_b14a_coins_pctmax_hec       = 'Health Educa HEC Max Coin Pct     '
pbp_b14a_coins_pctmax_mhc       = 'Health Educa MHC Max Coin Pct     '
pbp_b14a_coins_pctmax_oth       = 'Hlth Educ OTH Max Coin Pct        '
pbp_b14a_coins_pctmax_pos       = 'Health Ed Max Coin Pct POS        '
pbp_b14a_coins_sc_pct           = 'Hlth Edu Coins SC Pct             '
pbp_b14a_coins_yesno            = 'Health Educa Coins Yes No         '
pbp_b14a_coins_yesno_pos        = 'Health Ed Coinsurance YN POS      '
pbp_b14a_copay_amp_amt          = 'Health Educa AMP Min Cpy Amt      '
pbp_b14a_copay_amp_amtmax       = 'Health Educa AMP Max Cpy Amt      '
pbp_b14a_copay_amt_pos          = 'Health Ed Min Copay Amt POS       '
pbp_b14a_copay_amtmax_pos       = 'Health Ed Max Copay Amt POS       '
pbp_b14a_copay_chp_amt          = 'Health Educa CHP Cpy Amt          '
pbp_b14a_copay_dsm_amt          = 'Health Educa DSM Min Cpy Amt      '
pbp_b14a_copay_dsm_amtmax       = 'Health Educa DSM Max Cpy Amt      '
pbp_b14a_copay_hec_amt          = 'Health Educa HEC Cpy Min Amt      '
pbp_b14a_copay_hec_max_amt      = 'Health Educa HEC Cpy Max Amt      '
pbp_b14a_copay_mhc_amt          = 'Health Educa MHC Min Cpy Amt      '
pbp_b14a_copay_mhc_amtmax       = 'Health Educa MHC Max Cpy Amt      '
pbp_b14a_copay_nhl_amt          = 'Health Educa NHL Cpy Amt          '
pbp_b14a_copay_nl_amt           = 'Health Educa NL Cpy Amt           '
pbp_b14a_copay_ntv_amt          = 'Health Educa NTV Cpy Amt          '
pbp_b14a_copay_oth_amt          = 'Health Educa OTH Min Cpy Amt      '
pbp_b14a_copay_oth_maxamt       = 'Health Educa OTH Max Cpy Amt      '
pbp_b14a_copay_sc_amt           = 'Health Educa SC Cpy Amt           '
pbp_b14a_copay_yesno            = 'Health Educa Copay Yes No         '
pbp_b14a_copay_yesno_pos        = 'Health Ed Copay Yes No POS        '
pbp_b14a_ded_amt                = 'Health Education Deduc Amt        '
pbp_b14a_ded_amt_pos            = 'Health Ed Deductible Amt POS      '
pbp_b14a_ded_yesno              = 'Health Education Deduc Yes No     '
pbp_b14a_ded_yesno_pos          = 'Health Ed Deduct Yes No POS       '
pbp_b14a_maxenr_amt             = 'Health Educa Max Enr Amt          '
pbp_b14a_maxenr_amt_pos         = 'Health Ed Max Enr Amt POS         '
pbp_b14a_maxenr_per             = 'Health Educa Max Enr Per          '
pbp_b14a_maxenr_yesno           = 'Health Educa Max Enr Yes No       '
pbp_b14a_maxenr_yn_pos          = 'Health Ed Max Enr Y/N POS         '
pbp_b14a_maxplan_amt            = 'Health Educa Max Plan Amt         '
pbp_b14a_maxplan_covb           = 'Health Educa Max Plan Cov Bas     '
pbp_b14a_maxplan_pct            = 'Hlth Education Max Plan Pct       '
pbp_b14a_maxplan_per            = 'Health Education Max Plan Per     '
pbp_b14a_maxplan_yesno          = 'Health Educa Max Plan Yes No      '
pbp_b14a_maxplan_yesno_pos      = 'Health Ed Max Plan Y/N POS        '
pbp_b14a_maxpln_amt_pos         = 'Health Ed Max Plan Amt POS        '
pbp_b14a_maxpln_cov_pos         = 'Health Ed Max Plan Cov POS        '
pbp_b14a_maxpln_pct_prpdis_pos  = 'Health Ed Max Pln Pct Disc PRP POS'
pbp_b14a_maxpln_per_pos         = 'Health Ed Max Pln Per POS         '
pbp_b14b_auth                   = 'Immunizations Auth                '
pbp_b14b_auth_pos               = 'Immunizations Auth POS            '
pbp_b14b_bendesc                = 'Immunizations Ben Dec             '
pbp_b14b_bendesc_amo            = 'Immunizations Ben Des AMO         '
pbp_b14b_bendesc_yesno          = 'Immunizations Ben Des Yes No      '
pbp_b14b_coins_cov__pos         = 'Immunizations Coins Cov POS       '
pbp_b14b_coins_cov_mc           = 'Immunizations MC Coins Cov        '
pbp_b14b_coins_cov_oi           = 'Immunizations OI Coins Cov        '
pbp_b14b_coins_pct_maxoi        = 'Immunizations OI Max Coin Pct     '
pbp_b14b_coins_pct_mc           = 'Immunizations MC Coin Pct         '
pbp_b14b_coins_pct_oi           = 'Immunizations OI Min Coin Pct     '
pbp_b14b_coins_pct_pos          = 'Immunizations Min Coin Pct POS    '
pbp_b14b_coins_pctmax_pos       = 'Immunizations Max Coin Pct POS    '
pbp_b14b_coins_yesno            = 'Immunizations Coins Yes No        '
pbp_b14b_coins_yesno_pos        = 'Immunizations Coinsurance YN POS  '
pbp_b14b_copay_amt_pos          = 'Immunizations Min Copay Amt POS   '
pbp_b14b_copay_amtmax_pos       = 'Immunizations Max Copay Amt POS   '
pbp_b14b_copay_mc_amt           = 'Immunizations MC Cpy Amt          '
pbp_b14b_copay_oi_amt           = 'Immunizations OI Min Cpy Amt      '
pbp_b14b_copay_oi_maxamt        = 'Immunizations OI Max Cpy Amt      '
pbp_b14b_copay_yesno            = 'Immunizations Copay Yes No        '
pbp_b14b_copay_yesno_pos        = 'Immunizations Copay Yes No POS    '
pbp_b14b_cost_share             = 'Immunizations Cost Share          '
pbp_b14b_ded_amt                = 'Immunizations Deductible Amt      '
pbp_b14b_ded_amt_pos            = 'Immunizations Deductible Amt POS  '
pbp_b14b_ded_yesno              = 'Immunizations Deduc Yes No        '
pbp_b14b_ded_yesno_pos          = 'Immunizations Deduct Yes No POS   '
pbp_b14b_maxenr_amt             = 'Immunizations Max Enr Amt         '
pbp_b14b_maxenr_amt_pos         = 'Immunizations Max Enr Amt POS     '
pbp_b14b_maxenr_per             = 'Immunizations Max Enr Per         '
pbp_b14b_maxenr_type            = 'Immunizations Max Enr Type        '
pbp_b14b_maxenr_type_pos        = 'Immunizations Max Enr Type POS    '
pbp_b14b_maxenr_yesno           = 'Immunizations Max Enr Yes No      '
pbp_b14b_maxenr_yesno_pos       = 'Immunizations Max Enr Yes No POS  '
pbp_b14b_maxplan_type_pos       = 'Immunizations Max Plan Type POS   '
pbp_b14b_maxplan_yesno_pos      = 'Immunizations Max Plan Y/N POS    '
pbp_b14b_maxpln_amt_pos         = 'Immunizations Max Plan Amt POS    '
pbp_b14b_maxpln_cov_pos         = 'Immunizations Max Plan Cov POS    '
pbp_b14b_maxpln_per_pos         = 'Immunizations Max Pln Per POS     '
pbp_b14c_auth                   = 'Routine Phys Auth                 '
pbp_b14c_auth_pos               = 'Rtn Phys Exams Auth POS           '
pbp_b14c_bendesc_amo            = 'Routine Phys Ben Desc AMO         '
pbp_b14c_bendesc_enhan          = 'Routine Phys Ben Desc Enhan       '
pbp_b14c_bendesc_lim            = 'Routine Phys Ben Desc Lim         '
pbp_b14c_bendesc_numv           = 'Routine Phys Ben Desc NumV        '
pbp_b14c_bendesc_per            = 'Routine Phys Ben Desc Per         '
pbp_b14c_bendesc_yesno          = 'Routine Phys Ben Desc Yes No      '
pbp_b14c_coins_cov              = 'Routine Phys Coinsurance Cov      '
pbp_b14c_coins_cov__pos         = 'Rtn Phys Exams Coins Cov POS      '
pbp_b14c_coins_pct              = 'Routine Phys Coinsurance Pct      '
pbp_b14c_coins_pct_pos          = 'Rtn Phys Exams Coin Pct POS       '
pbp_b14c_coins_yesno            = 'Routine Phys Coinsurance YN       '
pbp_b14c_coins_yesno_pos        = 'Rtn Phys Exam Coinsurance YN POS  '
pbp_b14c_copay_amt              = 'Routine Phys Copay Amt            '
pbp_b14c_copay_amt_pos          = 'Rtn Phys Exams Copay Amt POS      '
pbp_b14c_copay_yesno            = 'Routine Phys Copay Yes No         '
pbp_b14c_copay_yesno_pos        = 'Rtn Phys Exams Copay Yes No POS   '
pbp_b14c_cost_share             = 'Routine Phys Cost Share           '
pbp_b14c_ded_amt                = 'Routine Phys Deduc Amt            '
pbp_b14c_ded_amt_pos            = 'Rtn Phys Exams Deductible Amt POS '
pbp_b14c_ded_yesno              = 'Routine Phys Deduc Yes No         '
pbp_b14c_ded_yesno_pos          = 'Rtn Phys Exams Deduct Yes No POS  '
pbp_b14c_maxenr_amt             = 'Routine Phys Max Enr Amt          '
pbp_b14c_maxenr_amt_pos         = 'Rtn Phys Exam Max Enr Amt POS     '
pbp_b14c_maxenr_per             = 'Routine Phys Max Enr Per          '
pbp_b14c_maxenr_type            = 'Routine Phys Max Enr Type         '
pbp_b14c_maxenr_type_pos        = 'Routine Phys Max Enr Type POS     '
pbp_b14c_maxenr_yesno           = 'Routine Phys Max Enr Yes No       '
pbp_b14c_maxenr_yesno_pos       = 'Rtn Phys Exam Max Enr Yes No POS  '
pbp_b14c_maxplan_amt            = 'Rtn Phys Exam Max Plan Amt        '
pbp_b14c_maxplan_cov            = 'Routine Phys Max Plan Cov         '
pbp_b14c_maxplan_per            = 'Routine Phys Max Plan Per         '
pbp_b14c_maxplan_type           = 'Routine Phys Max Plan Type        '
pbp_b14c_maxplan_type_pos       = 'Rtn Phys Exam Max Plan Type POS   '
pbp_b14c_maxplan_yesno          = 'Routine Phys Max Plan Yes No      '
pbp_b14c_maxplan_yesno_pos      = 'Rtn Phys Exam Max Plan Y/N POS    '
pbp_b14c_maxpln_amt_pos         = 'Rtn Phys Exam Max Plan Amt POS    '
pbp_b14c_maxpln_cov_pos         = 'Rtn Phys Exam Max Plan Cov POS    '
pbp_b14c_maxpln_per_pos         = 'Rtn Phys Exam Max Pln Per POS     '
pbp_b14d_auth                   = 'Pap/Pelvic Auth                   '
pbp_b14d_auth_pos               = 'Pap/Pelvic Screening Auth POS     '
pbp_b14d_bendesc_amo_pe         = 'Add Pelvic Exams Ben Desc AMO     '
pbp_b14d_bendesc_amo_ps         = 'Add Pap Smears Ben Desc AMO       '
pbp_b14d_bendesc_enhan          = 'Pap/Pelvic Ben Desc Enhan         '
pbp_b14d_bendesc_numpe          = 'Pelvic Exams Ben Desc # Addtnl    '
pbp_b14d_bendesc_numps          = 'Pap Smears Ben Desc # Addtnl      '
pbp_b14d_bendesc_pe_per         = 'Pelvic Exams Ben Desc Per         '
pbp_b14d_bendesc_ps_per         = 'Pap Smears Ben Desc Per           '
pbp_b14d_bendesc_yesno          = 'Pap/Pelvic Ben Desc Yes No        '
pbp_b14d_coins_cov__pos         = 'Pap/Pelvic Coins Cov POS          '
pbp_b14d_coins_cov_mcpap        = 'Pap Smears MC Coins Cov           '
pbp_b14d_coins_cov_mcpe         = 'Pelvic Exams MC Coins Cov         '
pbp_b14d_coins_cov_pap          = 'Pap Smears Coins Cov              '
pbp_b14d_coins_cov_pe           = 'Pelvic Exams Coins Cov            '
pbp_b14d_coins_pct_mcpap        = 'Pap Smears MC Coin Pct            '
pbp_b14d_coins_pct_mcpe         = 'Pelvic Exams MC Coin Pct          '
pbp_b14d_coins_pct_pap          = 'Pap Smears Coin Pct               '
pbp_b14d_coins_pct_pe           = 'Pelvic Exams Coin Pct             '
pbp_b14d_coins_pct_pos          = 'Pap/Pelvic Min Coin Pct POS       '
pbp_b14d_coins_pctmax_pos       = 'Pap/Pelvic Max Coin Pct POS       '
pbp_b14d_coins_yesno            = 'Pap/Pelvic Coins Yes No           '
pbp_b14d_coins_yesno_pos        = 'Pap/Pelvic Coinsurance YN POS     '
pbp_b14d_copay_amt_mcpap        = 'Pap Smears MC Copay Amt           '
pbp_b14d_copay_amt_mcpe         = 'Pelvic Exams MC Copay Amt         '
pbp_b14d_copay_amt_pap          = 'Pap Smears Copay Amt              '
pbp_b14d_copay_amt_pe           = 'Pelvic Exams Copay Amt            '
pbp_b14d_copay_amt_pos          = 'Pap/Pelvic Min Copay Amt POS      '
pbp_b14d_copay_amtmax_pos       = 'Pap/Pelvic Max Copay Amt POS      '
pbp_b14d_copay_yesno            = 'Pap/Pelvic Copay Yes No           '
pbp_b14d_copay_yesno_pos        = 'Pap/Pelvic Copay Yes No POS       '
pbp_b14d_cost_share             = 'Pap/Pelvic Cost Share             '
pbp_b14d_ded_amt                = 'Pap/Pelvic Deduc Amt              '
pbp_b14d_ded_amt_pos            = 'Pap/Pelvic Deductible Amt POS     '
pbp_b14d_ded_yesno              = 'Pap/Pelvic Deduc Yes No           '
pbp_b14d_ded_yesno_pos          = 'Pap/Pelvic Deduct Yes No POS      '
pbp_b14d_maxenr_amt             = 'Pap/Pelvic Max Enr Amt            '
pbp_b14d_maxenr_amt_pos         = 'Pap/Pelvic Max Enr Amt POS        '
pbp_b14d_maxenr_per             = 'Pap/Pelvic Max Enr Per            '
pbp_b14d_maxenr_type            = 'Pap/Pelvic Max Enr Type           '
pbp_b14d_maxenr_type_pos        = 'Pap/Pelvic Max Enr Type POS       '
pbp_b14d_maxenr_yesno           = 'Pap/Pelvic Max Enr Yes No         '
pbp_b14d_maxenr_yesno_pos       = 'Pap/Pelvic Max Enr Yes No POS     '
pbp_b14d_maxplan_cov            = 'Pap/Pelvic Max Plan Cov           '
pbp_b14d_maxplan_pct            = 'Pap/Pelvic Max Plan Pct           '
pbp_b14d_maxplan_per            = 'Pap/Pelvic Max Plan Per           '
pbp_b14d_maxplan_type           = 'Pap/Pelvic Max Plan Type          '
pbp_b14d_maxplan_type_pos       = 'Pap/Pelvic Max Plan Type POS      '
pbp_b14d_maxplan_yesno          = 'Pap/Pelvic Max Plan Yes No        '
pbp_b14d_maxplan_yesno_pos      = 'Pap/Pelvic Max Plan Y/N POS       '
pbp_b14d_maxpln_amt_pos         = 'Pap/Pelvic Max Plan Amt POS       '
pbp_b14d_maxpln_cov_pos         = 'Pap/Pelvic Max Plan Cov POS       '
pbp_b14d_maxpln_per_pos         = 'Pap/Pelvic Max Pln Per POS        '
;
run;

proc sort data = pbp_b14ad out = out.pbp_b14ad;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b14ad(obs = 10);
  title 'pbp b14ad data';
run;

proc means data =  out.pbp_b14ad;
  title 'pbp b14ad file';
run;

proc freq data = out.pbp_b14ad;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b14a_bendec_yesno
  pbp_b14a_bendec_ehc
  pbp_b14a_bendesc_amo_hec
  pbp_b14a_bendesc_amo_nl
  pbp_b14a_bendesc_amo_ntv
  pbp_b14a_bendesc_amo_sc
  pbp_b14a_bendesc_amo_chp
  pbp_b14a_bendesc_amo_amp
  pbp_b14a_bendesc_amo_mhc
  pbp_b14a_bendesc_amo_nhl
  pbp_b14a_bendesc_amo_dsm
  pbp_b14a_bendesc_amo_oth
  pbp_b14a_maxplan_yesno
  pbp_b14a_maxplan_per
  pbp_b14a_maxplan_covb
  pbp_b14a_maxenr_yesno
  pbp_b14a_maxenr_per
  pbp_b14a_coins_yesno / missing;
run;

proc contents data = out.pbp_b14ad;
  title 'pbp b14ad data';
run;
