*pbp_b14ei.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b14ei;

length
   pbp_a_hnumber                        $5
   pbp_a_plan_identifier                $3
   pbp_a_ben_cov                        $1
   pbp_a_plan_type                      $2
   orgtype                              $2
   pbp_b14e_bendesc_yesno               $1
   pbp_b14e_bendesc                     $1
   pbp_b14e_bendesc_amo                 $1
   pbp_b14e_bendesc_as_per              $1
   pbp_b14e_maxplan_yesno               $1
   pbp_b14e_maxplan_type                $1
   pbp_b14e_maxplan_per                 $1
   pbp_b14e_maxplan_cov                 $1
   pbp_b14e_maxenr_yesno                $1
   pbp_b14e_maxenr_type                 $1
   pbp_b14e_maxenr_per                  $1
   pbp_b14e_coins_yesno                 $1
   pbp_b14e_coins_cov                   $1
   pbp_b14e_as_coins_cov                $1
   pbp_b14e_ded_yesno                   $1
   pbp_b14e_copay_yesno                 $1
   pbp_b14e_cost_share                  $1
   pbp_b14e_auth                        $5
   pbp_b14e_maxplan_yesno_pos           $1
   pbp_b14e_maxplan_type_pos            $1
   pbp_b14e_maxpln_per_pos              $1
   pbp_b14e_maxpln_cov_pos              $1
   pbp_b14e_maxenr_yesno_pos            $1
   pbp_b14e_maxenr_type_pos             $1
   pbp_b14e_coins_yesno_pos             $1
   pbp_b14e_coins_cov__pos              $1
   pbp_b14e_ded_yesno_pos               $1
   pbp_b14e_copay_yesno_pos             $1
   pbp_b14e_auth_pos                    $5
   pbp_b14f_bendesc_yesno               $1
   pbp_b14f_bendesc                     $1
   pbp_b14f_bendesc_amo                 $1
   pbp_b14f_bendesc_as_per              $1
   pbp_b14f_maxplan_yesno               $1
   pbp_b14f_maxplan_type                $1
   pbp_b14f_maxplan_per                 $1
   pbp_b14f_maxplan_cov                 $1
   pbp_b14f_maxenr_yesno                $1
   pbp_b14f_maxenr_type                 $1
   pbp_b14f_maxenr_per                  $1
   pbp_b14f_coins_yesno                 $1
   pbp_b14f_coins_cov                   $1
   pbp_b14f_as_coins_cov                $1
   pbp_b14f_ded_yesno                   $1
   pbp_b14f_copay_yesno                 $1
   pbp_b14f_cost_share                  $1
   pbp_b14f_auth                        $5
   pbp_b14f_maxplan_yesno_pos           $1
   pbp_b14f_maxplan_type_pos            $1
   pbp_b14f_maxpln_per_pos              $1
   pbp_b14f_maxpln_cov_pos              $1
   pbp_b14f_maxenr_yesno_pos            $1
   pbp_b14f_maxenr_type_pos             $1
   pbp_b14f_coins_yesno_pos             $1
   pbp_b14f_coins_cov__pos              $1
   pbp_b14f_ded_yesno_pos               $1
   pbp_b14f_copay_yesno_pos             $1
   pbp_b14f_auth_pos                    $5
   pbp_b14g_maxenr_yn                   $1
   pbp_b14g_maxenr_type                 $1
   pbp_b14g_coins_yesno                 $1
   pbp_b14g_coins_cov                   $1
   pbp_b14g_ded_yesno                   $1
   pbp_b14g_copay_yesno                 $1
   pbp_b14g_cost_share                  $1
   pbp_b14g_auth                        $5
   pbp_b14g_maxplan_yesno_pos           $1
   pbp_b14g_maxplan_type_pos            $1
   pbp_b14g_maxpln_per_pos              $1
   pbp_b14g_maxpln_cov_pos              $1
   pbp_b14g_maxenr_yesno_pos            $1
   pbp_b14g_maxenr_type_pos             $1
   pbp_b14g_coins_yesno_pos             $1
   pbp_b14g_coins_cov__pos              $1
   pbp_b14g_ded_yesno_pos               $1
   pbp_b14g_copay_yesno_pos             $1
   pbp_b14g_auth_pos                    $5
   pbp_b14h_bendesc_yesno               $1
   pbp_b14h_bendesc                     $1
   pbp_b14h_bendesc_amo                 $1
   pbp_b14h_bendesc_as_per              $1
   pbp_b14h_maxplan_yesno               $1
   pbp_b14h_maxplan_type                $1
   pbp_b14h_maxplan_per                 $1
   pbp_b14h_maxplan_cov                 $1
   pbp_b14h_maxenr_yesno                $1
   pbp_b14h_maxenr_type                 $1
   pbp_b14h_maxenr_per                  $1
   pbp_b14h_coins_yesno                 $1
   pbp_b14h_coins_cov                   $1
   pbp_b14h_as_coins_cov                $1
   pbp_b14h_ded_yesno                   $1
   pbp_b14h_copay_yesno                 $1
   pbp_b14h_cost_share                  $1
   pbp_b14h_auth                        $5
   pbp_b14h_maxplan_yesno_pos           $1
   pbp_b14h_maxplan_type_pos            $1
   pbp_b14h_maxpln_per_pos              $1
   pbp_b14h_maxpln_cov_pos              $1
   pbp_b14h_maxenr_yesno_pos            $1
   pbp_b14h_maxenr_type_pos             $1
   pbp_b14h_coins_yesno_pos             $1
   pbp_b14h_coins_cov__pos              $1
   pbp_b14h_ded_yesno_pos               $1
   pbp_b14h_copay_yesno_pos             $1
   pbp_b14h_auth_pos                    $5
   pbp_b14i_maxenr_yesno                $1
   pbp_b14i_maxenr_type                 $1
   pbp_b14i_maxenr_per                  $1
   pbp_b14i_coins_yesno                 $1
   pbp_b14i_coins_cov                   $1
   pbp_b14i_ded_yesno                   $1
   pbp_b14i_copay_yesno                 $1
   pbp_b14i_cost_share                  $1
   pbp_b14i_auth                        $5
   pbp_b14i_maxplan_yesno_pos           $1
   pbp_b14i_maxplan_type_pos            $1
   pbp_b14i_maxpln_per_pos              $1
   pbp_b14i_maxpln_cov_pos              $1
   pbp_b14i_maxenr_yesno_pos            $1
   pbp_b14i_maxenr_type_pos             $1
   pbp_b14i_coins_yesno_pos             $1
   pbp_b14i_coins_cov__pos              $1
   pbp_b14i_ded_yesno_pos               $1
   pbp_b14i_copay_yesno_pos             $1
   pbp_b14i_auth_pos                    $5
;

infile '.\pbp\pbp_b14_preventive_2.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;

  input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b14e_bendesc_yesno
   pbp_b14e_bendesc
   pbp_b14e_bendesc_amo
   pbp_b14e_bendesc_numps
   pbp_b14e_bendesc_as_per
   pbp_b14e_maxplan_yesno
   pbp_b14e_maxplan_type
   pbp_b14e_maxplan_pct
   pbp_b14e_maxplan_per
   pbp_b14e_maxplan_cov
   pbp_b14e_maxenr_yesno
   pbp_b14e_maxenr_type
   pbp_b14e_maxenr_amt
   pbp_b14e_maxenr_per
   pbp_b14e_coins_yesno
   pbp_b14e_coins_pct
   pbp_b14e_coins_cov
   pbp_b14e_ad_coins_pct
   pbp_b14e_as_coins_cov
   pbp_b14e_ded_yesno
   pbp_b14e_ded_amt
   pbp_b14e_copay_yesno
   pbp_b14e_copay_amt
   pbp_b14e_as_copay_amt
   pbp_b14e_cost_share
   pbp_b14e_auth
   pbp_b14e_maxplan_yesno_pos
   pbp_b14e_maxplan_type_pos
   pbp_b14e_maxpln_amt_pos
   pbp_b14e_maxpln_per_pos
   pbp_b14e_maxpln_cov_pos
   pbp_b14e_maxenr_yesno_pos
   pbp_b14e_maxenr_type_pos
   pbp_b14e_maxenr_amt_pos
   pbp_b14e_coins_yesno_pos
   pbp_b14e_coins_pct_pos
   pbp_b14e_coins_cov__pos
   pbp_b14e_ded_yesno_pos
   pbp_b14e_ded_amt_pos
   pbp_b14e_copay_yesno_pos
   pbp_b14e_copay_amt_pos
   pbp_b14e_auth_pos
   pbp_b14f_bendesc_yesno
   pbp_b14f_bendesc
   pbp_b14f_bendesc_amo
   pbp_b14f_bendesc_numps
   pbp_b14f_bendesc_as_per
   pbp_b14f_maxplan_yesno
   pbp_b14f_maxplan_type
   pbp_b14f_maxplan_pct
   pbp_b14f_maxplan_per
   pbp_b14f_maxplan_cov
   pbp_b14f_maxenr_yesno
   pbp_b14f_maxenr_type
   pbp_b14f_maxenr_amt
   pbp_b14f_maxenr_per
   pbp_b14f_coins_yesno
   pbp_b14f_coins_pct
   pbp_b14f_coins_max_pct
   pbp_b14f_coins_cov
   pbp_b14f_as_coins_pct
   pbp_b14f_as_coins_max_pct
   pbp_b14f_as_coins_cov
   pbp_b14f_ded_yesno
   pbp_b14f_ded_amt
   pbp_b14f_copay_yesno
   pbp_b14f_copay_mc_min_amt
   pbp_b14f_copay_mc_max_amt
   pbp_b14f_copay_as_min_amt
   pbp_b14f_copay_as_max_amt
   pbp_b14f_cost_share
   pbp_b14f_auth
   pbp_b14f_maxplan_yesno_pos
   pbp_b14f_maxplan_type_pos
   pbp_b14f_maxpln_amt_pos
   pbp_b14f_maxpln_per_pos
   pbp_b14f_maxpln_cov_pos
   pbp_b14f_maxenr_yesno_pos
   pbp_b14f_maxenr_type_pos
   pbp_b14f_maxenr_amt_pos
   pbp_b14f_coins_yesno_pos
   pbp_b14f_coins_pct_pos
   pbp_b14f_coins_pctmax_pos
   pbp_b14f_coins_cov__pos
   pbp_b14f_ded_yesno_pos
   pbp_b14f_ded_amt_pos
   pbp_b14f_copay_yesno_pos
   pbp_b14f_copay_amt_pos
   pbp_b14f_copay_amtmax_pos
   pbp_b14f_auth_pos
   pbp_b14g_maxenr_yn
   pbp_b14g_maxenr_type
   pbp_b14g_maxenr_amt
   pbp_b14g_coins_yesno
   pbp_b14g_coins_pct
   pbp_b14g_coins_cov
   pbp_b14g_ded_yesno
   pbp_b14g_ded_amt
   pbp_b14g_copay_yesno
   pbp_b14g_copay_amt
   pbp_b14g_cost_share
   pbp_b14g_auth
   pbp_b14g_maxplan_yesno_pos
   pbp_b14g_maxplan_type_pos
   pbp_b14g_maxpln_amt_pos
   pbp_b14g_maxpln_per_pos
   pbp_b14g_maxpln_cov_pos
   pbp_b14g_maxenr_yesno_pos
   pbp_b14g_maxenr_type_pos
   pbp_b14g_maxenr_amt_pos
   pbp_b14g_coins_yesno_pos
   pbp_b14g_coins_pct_pos
   pbp_b14g_coins_cov__pos
   pbp_b14g_ded_yesno_pos
   pbp_b14g_ded_amt_pos
   pbp_b14g_copay_yesno_pos
   pbp_b14g_copay_amt_pos
   pbp_b14g_auth_pos
   pbp_b14h_bendesc_yesno
   pbp_b14h_bendesc
   pbp_b14h_bendesc_amo
   pbp_b14h_bendesc_numps
   pbp_b14h_bendesc_as_per
   pbp_b14h_maxplan_yesno
   pbp_b14h_maxplan_type
   pbp_b14h_maxplan_pct
   pbp_b14h_maxplan_per
   pbp_b14h_maxplan_cov
   pbp_b14h_maxenr_yesno
   pbp_b14h_maxenr_type
   pbp_b14h_maxenr_amt
   pbp_b14h_maxenr_per
   pbp_b14h_coins_yesno
   pbp_b14h_coins_pct
   pbp_b14h_coins_cov
   pbp_b14h_ad_coins_pct
   pbp_b14h_as_coins_cov
   pbp_b14h_ded_yesno
   pbp_b14h_ded_amt
   pbp_b14h_copay_yesno
   pbp_b14h_copay_amt
   pbp_b14h_as_copay_amt
   pbp_b14h_cost_share
   pbp_b14h_auth
   pbp_b14h_maxplan_yesno_pos
   pbp_b14h_maxplan_type_pos
   pbp_b14h_maxpln_amt_pos
   pbp_b14h_maxpln_per_pos
   pbp_b14h_maxpln_cov_pos
   pbp_b14h_maxenr_yesno_pos
   pbp_b14h_maxenr_type_pos
   pbp_b14h_maxenr_amt_pos
   pbp_b14h_coins_yesno_pos
   pbp_b14h_coins_pct_pos
   pbp_b14h_coins_cov__pos
   pbp_b14h_ded_yesno_pos
   pbp_b14h_ded_amt_pos
   pbp_b14h_copay_yesno_pos
   pbp_b14h_copay_amt_pos
   pbp_b14h_auth_pos
   pbp_b14i_maxenr_yesno
   pbp_b14i_maxenr_type
   pbp_b14i_maxenr_amt
   pbp_b14i_maxenr_per
   pbp_b14i_coins_yesno
   pbp_b14i_coins_pct
   pbp_b14i_coins_max_pct
   pbp_b14i_coins_cov
   pbp_b14i_ded_yesno
   pbp_b14i_ded_amt
   pbp_b14i_copay_yesno
   pbp_b14i_copay_mc_min_amt
   pbp_b14i_copay_mc_max_amt
   pbp_b14i_cost_share
   pbp_b14i_auth
   pbp_b14i_maxplan_yesno_pos
   pbp_b14i_maxplan_type_pos
   pbp_b14i_maxpln_amt_pos
   pbp_b14i_maxpln_per_pos
   pbp_b14i_maxpln_cov_pos
   pbp_b14i_maxenr_yesno_pos
   pbp_b14i_maxenr_type_pos
   pbp_b14i_maxenr_amt_pos
   pbp_b14i_coins_yesno_pos
   pbp_b14i_coins_pct_pos
   pbp_b14i_coins_pctmax_pos
   pbp_b14i_coins_cov__pos
   pbp_b14i_ded_yesno_pos
   pbp_b14i_ded_amt_pos
   pbp_b14i_copay_yesno_pos
   pbp_b14i_copay_amt_pos
   pbp_b14i_copay_amtmax_pos
   pbp_b14i_auth_pos
;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b14e_ad_coins_pct           = 'Prostate Cancer AS Coin Pct       '
pbp_b14e_as_coins_cov           = 'Prostate Cancer AS Coins Cov      '
pbp_b14e_as_copay_amt           = 'Prostate Cancer AS Copay Amt      '
pbp_b14e_auth                   = 'Prostate Cancer Auth              '
pbp_b14e_auth_pos               = 'Prostate Cancer Screening Auth POS'
pbp_b14e_bendesc                = 'Prostate Screening Ben Dec        '
pbp_b14e_bendesc_amo            = 'Prostate Scrn Ben Des AMO         '
pbp_b14e_bendesc_as_per         = 'Prostate Scrn Ben Desc Per        '
pbp_b14e_bendesc_numps          = 'Prostate Scr Ben Desc # Addtnl    '
pbp_b14e_bendesc_yesno          = 'Prostate Scrn Ben Des Yes No      '
pbp_b14e_coins_cov              = 'Prostate Cancer MC Coins Cov      '
pbp_b14e_coins_cov__pos         = 'Prostate Cancer Coins Cov POS     '
pbp_b14e_coins_pct              = 'Prostate Cancer MC Coin Pct       '
pbp_b14e_coins_pct_pos          = 'Prostate Cancer Coin Pct POS      '
pbp_b14e_coins_yesno            = 'Prostate Cancer Coins Yes No      '
pbp_b14e_coins_yesno_pos        = 'Prostate Cancer Coinsurance YN POS'
pbp_b14e_copay_amt              = 'Prostate Cancer MC Copay Amt      '
pbp_b14e_copay_amt_pos          = 'Prostate Cancer Copay Amt POS     '
pbp_b14e_copay_yesno            = 'Prostate Cancer Copay Yes No      '
pbp_b14e_copay_yesno_pos        = 'Prostate Cancer Copay Yes No POS  '
pbp_b14e_cost_share             = 'Prostate Screenings Cost Share    '
pbp_b14e_ded_amt                = 'Prostate Cancer Deduc Amt         '
pbp_b14e_ded_amt_pos            = 'Prostate Cancer Deductible Amt POS'
pbp_b14e_ded_yesno              = 'Prostate Cancer Deduc Yes No      '
pbp_b14e_ded_yesno_pos          = 'Prostate Cancer Deduct Yes No POS '
pbp_b14e_maxenr_amt             = 'Prostate Scrn Max Enr Amt         '
pbp_b14e_maxenr_amt_pos         = 'Prostate Cancer Max Enr Amt POS   '
pbp_b14e_maxenr_per             = 'Prostate Scrn Max Enr Per         '
pbp_b14e_maxenr_type            = 'Prostate Scrn Max Enr Type        '
pbp_b14e_maxenr_type_pos        = 'Prostate Scrn Max Enr Type POS    '
pbp_b14e_maxenr_yesno           = 'Prostate Scrn Max Enr Yes No      '
pbp_b14e_maxenr_yesno_pos       = 'Prostate Cancer Max Enr Yes No POS'
pbp_b14e_maxplan_cov            = 'Prostate Scrn Max Plan Cov        '
pbp_b14e_maxplan_pct            = 'Prostate Scrn Max Plan Pct        '
pbp_b14e_maxplan_per            = 'Prostate Scrn Max Plan Per        '
pbp_b14e_maxplan_type           = 'Prostate Scrn Max Plan Type       '
pbp_b14e_maxplan_type_pos       = 'Prostate Cancer Max Plan Type POS '
pbp_b14e_maxplan_yesno          = 'Prostate Scrn Max Plan Yes No     '
pbp_b14e_maxplan_yesno_pos      = 'Prostate Cancer Max Plan Y/N POS  '
pbp_b14e_maxpln_amt_pos         = 'Prostate Cancer Max Plan Amt POS  '
pbp_b14e_maxpln_cov_pos         = 'Prostate Cancer Max Plan Cov POS  '
pbp_b14e_maxpln_per_pos         = 'Prostate Cancer Max Pln Per POS   '
pbp_b14f_as_coins_cov           = 'Colorectl Scrn AS Coin Cov        '
pbp_b14f_as_coins_max_pct       = 'Colorectl Scrn AS Max Coin Pct    '
pbp_b14f_as_coins_pct           = 'Colorectl Scrn AS Min Coin Pct    '
pbp_b14f_auth                   = 'Colorectal Scrn Auth              '
pbp_b14f_auth_pos               = 'Colorectal Screening Auth POS     '
pbp_b14f_bendesc                = 'Colorectal Screening Ben Dec      '
pbp_b14f_bendesc_amo            = 'Colorectal Scrn Ben Des AMO       '
pbp_b14f_bendesc_as_per         = 'Colorectal Ben Desc Per           '
pbp_b14f_bendesc_numps          = 'Colorctl Scr Ben Desc # Addtnl    '
pbp_b14f_bendesc_yesno          = 'Colorectal Scrn Ben Des Yes No    '
pbp_b14f_coins_cov              = 'Colorctl Scrn MC Coins Cov        '
pbp_b14f_coins_cov__pos         = 'Colorectal Scrn Coins Cov POS     '
pbp_b14f_coins_max_pct          = 'Colorctl Scrn Max MC Coin Pct     '
pbp_b14f_coins_pct              = 'Colorctl Scrn Min MC Coin Pct     '
pbp_b14f_coins_pct_pos          = 'Colorectal Scrn Min Coin Pct POS  '
pbp_b14f_coins_pctmax_pos       = 'Colorectal Scrn Max Coin Pct POS  '
pbp_b14f_coins_yesno            = 'Colorectal Scrn Coins Yes No      '
pbp_b14f_coins_yesno_pos        = 'Colorectal Scrn Coinsurance YN POS'
pbp_b14f_copay_amt_pos          = 'Colorectal Scrn Min Copay Amt POS '
pbp_b14f_copay_amtmax_pos       = 'Colorectal Scrn Max Copay Amt POS '
pbp_b14f_copay_as_max_amt       = 'Colorctl Scrn Max AS Copay Amt    '
pbp_b14f_copay_as_min_amt       = 'Colorctl Scrn Min AS Copay Amt    '
pbp_b14f_copay_mc_max_amt       = 'Colorctl Scrn Max MC Copay Amt    '
pbp_b14f_copay_mc_min_amt       = 'Colorctl Scrn Min MC Copay Amt    '
pbp_b14f_copay_yesno            = 'Colorectal Scrn Copay Yes No      '
pbp_b14f_copay_yesno_pos        = 'Colorectal Scrn Copay Yes No POS  '
pbp_b14f_cost_share             = 'Colorectal Scrnings Cost Share    '
pbp_b14f_ded_amt                = 'Colorectal Scrn Deduc Amt         '
pbp_b14f_ded_amt_pos            = 'Colorectal Scrn Deductible Amt POS'
pbp_b14f_ded_yesno              = 'Colorectal Scrn Deduc Yes No      '
pbp_b14f_ded_yesno_pos          = 'Colorectal Scrn Deduct Yes No POS '
pbp_b14f_maxenr_amt             = 'Colorectal Scrn Max Enr Amt       '
pbp_b14f_maxenr_amt_pos         = 'Colorectal Scrn Max Enr Amt POS   '
pbp_b14f_maxenr_per             = 'Colorectal Scrn Max Enr Per       '
pbp_b14f_maxenr_type            = 'Colorectal Scrn Max Enr Type      '
pbp_b14f_maxenr_type_pos        = 'Colorectal Scrn Max Enr Type POS  '
pbp_b14f_maxenr_yesno           = 'Colorectal Scrn Max Enr Yes No    '
pbp_b14f_maxenr_yesno_pos       = 'Colorectal Scrn Max Enr Yes No POS'
pbp_b14f_maxplan_cov            = 'Colorectal Scrn Max Plan Cov      '
pbp_b14f_maxplan_pct            = 'Colorectal Scrn Max Plan Amt      '
pbp_b14f_maxplan_per            = 'Colorectal Scrn Max Plan Per      '
pbp_b14f_maxplan_type           = 'Colorectal Scrn Max Plan Type     '
pbp_b14f_maxplan_type_pos       = 'Colorectal Scrn Max Plan Type POS '
pbp_b14f_maxplan_yesno          = 'Colorectl Scrn Max Plan Yes No    '
pbp_b14f_maxplan_yesno_pos      = 'Colorectal Scrn Max Plan Y/N POS  '
pbp_b14f_maxpln_amt_pos         = 'Colorectal Scrn Max Plan Amt POS  '
pbp_b14f_maxpln_cov_pos         = 'Colorectal Scrn Max Plan Cov POS  '
pbp_b14f_maxpln_per_pos         = 'Colorectal Scrn Max Pln Per POS   '
pbp_b14g_auth                   = 'Bone Mass Meas Auth               '
pbp_b14g_auth_pos               = 'Bone Mass Measurement Auth POS    '
pbp_b14g_coins_cov              = 'Bone Mass Meas Coins Cov          '
pbp_b14g_coins_cov__pos         = 'Bone Mass Meas Coins Cov POS      '
pbp_b14g_coins_pct              = 'Bone Mass Meas Coin Pct           '
pbp_b14g_coins_pct_pos          = 'Bone Mass Meas Coin Pct POS       '
pbp_b14g_coins_yesno            = 'Bone Mass Meas Coins Yes No       '
pbp_b14g_coins_yesno_pos        = 'Bone Mass Meas Coinsurance YN POS '
pbp_b14g_copay_amt              = 'Bone Mass Meas Copay Amt          '
pbp_b14g_copay_amt_pos          = 'Bone Mass Meas Copay Amt POS      '
pbp_b14g_copay_yesno            = 'Bone Mass Meas Copay Yes No       '
pbp_b14g_copay_yesno_pos        = 'Bone Mass Meas Copay Yes No POS   '
pbp_b14g_cost_share             = 'Bone Mass Meas Cost Share         '
pbp_b14g_ded_amt                = 'Bone Mass Meas Deduc Amt          '
pbp_b14g_ded_amt_pos            = 'Bone Mass Meas Deductible Amt POS '
pbp_b14g_ded_yesno              = 'Bone Mass Meas Deduc Yes No       '
pbp_b14g_ded_yesno_pos          = 'Bone Mass Meas Deduct Yes No POS  '
pbp_b14g_maxenr_amt             = 'Bone Mass Meas Max Enr Amt        '
pbp_b14g_maxenr_amt_pos         = 'Bone Mass Meas Max Enr Amt POS    '
pbp_b14g_maxenr_type            = 'Bone Mass Meas Max Enr Type       '
pbp_b14g_maxenr_type_pos        = 'Bone Mass Meas Max Enr Type POS   '
pbp_b14g_maxenr_yesno_pos       = 'Bone Mass Meas Max Enr Yes No POS '
pbp_b14g_maxenr_yn              = 'Bone Mass Meas Max Enroll Y/N     '
pbp_b14g_maxplan_type_pos       = 'Bone Mass Meas Max Plan Type POS  '
pbp_b14g_maxplan_yesno_pos      = 'Bone Mass Meas Max Plan Y/N POS   '
pbp_b14g_maxpln_amt_pos         = 'Bone Mass Meas Max Plan Amt POS   '
pbp_b14g_maxpln_cov_pos         = 'Bone Mass Meas Max Plan Cov POS   '
pbp_b14g_maxpln_per_pos         = 'Bone Mass Meas Max Pln Per POS    '
pbp_b14h_ad_coins_pct           = 'Mammography AS Coin Pct           '
pbp_b14h_as_coins_cov           = 'Mammography AS Coins Cov          '
pbp_b14h_as_copay_amt           = 'Mammography AS Copay Amt          '
pbp_b14h_auth                   = 'Mammography Auth                  '
pbp_b14h_auth_pos               = 'Mammography Screening Auth POS    '
pbp_b14h_bendesc                = 'Mammography Ben Dec               '
pbp_b14h_bendesc_amo            = 'Mammography Ben Des AMO           '
pbp_b14h_bendesc_as_per         = 'Mammography Ben Desc Per          '
pbp_b14h_bendesc_numps          = 'Mammography Ben Desc # Addtnl     '
pbp_b14h_bendesc_yesno          = 'Mammography Ben Des Yes No        '
pbp_b14h_coins_cov              = 'Mammography MC Coins Cov          '
pbp_b14h_coins_cov__pos         = 'Mammography Coins Cov POS         '
pbp_b14h_coins_pct              = 'Mammography MC Coin Pct           '
pbp_b14h_coins_pct_pos          = 'Mammography Coin Pct POS          '
pbp_b14h_coins_yesno            = 'Mammography Coins Yes No          '
pbp_b14h_coins_yesno_pos        = 'Mammography Coinsurance YN POS    '
pbp_b14h_copay_amt              = 'Mammography MC Copay Amt          '
pbp_b14h_copay_amt_pos          = 'Mammography Copay Amt POS         '
pbp_b14h_copay_yesno            = 'Mammography Copay Yes No          '
pbp_b14h_copay_yesno_pos        = 'Mammography Copay Yes No POS      '
pbp_b14h_cost_share             = 'Mammography Cost Share            '
pbp_b14h_ded_amt                = 'Mammography Deduc Amt             '
pbp_b14h_ded_amt_pos            = 'Mammography Deductible Amt POS    '
pbp_b14h_ded_yesno              = 'Mammography Deduc Yes No          '
pbp_b14h_ded_yesno_pos          = 'Mammography Deduct Yes No POS     '
pbp_b14h_maxenr_amt             = 'Mammography Max Enr Amt           '
pbp_b14h_maxenr_amt_pos         = 'Mammography Max Enr Amt POS       '
pbp_b14h_maxenr_per             = 'Mammography Max Enr Per           '
pbp_b14h_maxenr_type            = 'Mammography Max Enr Type          '
pbp_b14h_maxenr_type_pos        = 'Mammography Max Enr Type POS      '
pbp_b14h_maxenr_yesno           = 'Mammography Max Enr Yes No        '
pbp_b14h_maxenr_yesno_pos       = 'Mammography Max Enr Yes No POS    '
pbp_b14h_maxplan_cov            = 'Mammography Max Plan Cov          '
pbp_b14h_maxplan_pct            = 'Mammography Max Plan Amt          '
pbp_b14h_maxplan_per            = 'Mammography Max Plan Per          '
pbp_b14h_maxplan_type           = 'Mammography Max Plan Type         '
pbp_b14h_maxplan_type_pos       = 'Mammography Max Plan Type POS     '
pbp_b14h_maxplan_yesno          = 'Mammography Max Plan Yes No       '
pbp_b14h_maxplan_yesno_pos      = 'Mammography Max Plan Y/N POS      '
pbp_b14h_maxpln_amt_pos         = 'Mammography Max Plan Amt POS      '
pbp_b14h_maxpln_cov_pos         = 'Mammography Max Plan Cov POS      '
pbp_b14h_maxpln_per_pos         = 'Mammography Max Pln Per POS       '
pbp_b14i_auth                   = 'Diabetes Scrn Auth                '
pbp_b14i_auth_pos               = 'Diabetes Monitoring Auth POS      '
pbp_b14i_coins_cov              = 'Diabetes Mnt MC Coins Cov         '
pbp_b14i_coins_cov__pos         = 'Diabetes Mnt Coins Cov POS        '
pbp_b14i_coins_max_pct          = 'Diabetes Mnt Max MC Coin Pct      '
pbp_b14i_coins_pct              = 'Diabetes Mnt Min MC Coin Pct      '
pbp_b14i_coins_pct_pos          = 'Diabetes Mnt Min Coin Pct POS     '
pbp_b14i_coins_pctmax_pos       = 'Diabetes Mnt Max Coin Pct POS     '
pbp_b14i_coins_yesno            = 'Diabetes Mnt Coins Yes No         '
pbp_b14i_coins_yesno_pos        = 'Diabetes Mnt Coinsurance YN POS   '
pbp_b14i_copay_amt_pos          = 'Diabetes Mnt Min Copay Amt POS    '
pbp_b14i_copay_amtmax_pos       = 'Diabetes Mnt Max Copay Amt POS    '
pbp_b14i_copay_mc_max_amt       = 'Diabetes Mnt Max MC Copay Amt     '
pbp_b14i_copay_mc_min_amt       = 'Diabetes Mnt Min MC Copay Amt     '
pbp_b14i_copay_yesno            = 'Diabetes Mnt Copay Yes No         '
pbp_b14i_copay_yesno_pos        = 'Diabetes Mnt Copay Yes No POS     '
pbp_b14i_cost_share             = 'Diabetes Scrnings Cost Share      '
pbp_b14i_ded_amt                = 'Diabetes Mnt Deduc Amt            '
pbp_b14i_ded_amt_pos            = 'Diabetes Mnt Deductible Amt POS   '
pbp_b14i_ded_yesno              = 'Diabetes Mnt Deduc Yes No         '
pbp_b14i_ded_yesno_pos          = 'Diabetes Mnt Deduct Yes No POS    '
pbp_b14i_maxenr_amt             = 'Diabetes Mnt Max Enr Amt          '
pbp_b14i_maxenr_amt_pos         = 'Diabetes Mnt Max Enr Amt POS      '
pbp_b14i_maxenr_per             = 'Diabetes Mnt Max Enr Per          '
pbp_b14i_maxenr_type            = 'Diabetes Mnt Max Enr Type         '
pbp_b14i_maxenr_type_pos        = 'Diabetes Mont Max Enr Type POS    '
pbp_b14i_maxenr_yesno           = 'Diabetes Mnt Max Enr Yes No       '
pbp_b14i_maxenr_yesno_pos       = 'Diabetes Mnt Max Enr Yes No POS   '
pbp_b14i_maxplan_type_pos       = 'Diabetes Mnt Max Plan Type POS    '
pbp_b14i_maxplan_yesno_pos      = 'Diabetes Mnt Max Plan Y/N POS     '
pbp_b14i_maxpln_amt_pos         = 'Diabetes Mnt Max Plan Amt POS     '
pbp_b14i_maxpln_cov_pos         = 'Diabetes Mnt Max Plan Cov POS     '
pbp_b14i_maxpln_per_pos         = 'Diabetes Mnt Max Pln Per POS      '
;
run;

proc sort data = pbp_b14ei out = out.pbp_b14ei;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b14ei(obs = 10);
  title 'pbp b14ei data';
run;

proc means data =  out.pbp_b14ei;
  title 'pbp b14ei file';
run;

proc freq data = out.pbp_b14ei;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b14e_bendesc_yesno
  pbp_b14e_bendesc
  pbp_b14e_bendesc_amo
  pbp_b14e_bendesc_as_per
  pbp_b14e_maxplan_yesno
  pbp_b14e_maxplan_type
  pbp_b14e_maxplan_per
  pbp_b14e_maxplan_cov
  pbp_b14e_maxenr_yesno
  pbp_b14e_maxenr_type
  pbp_b14e_maxenr_per
  pbp_b14e_coins_yesno
  pbp_b14e_coins_cov
  pbp_b14e_as_coins_cov
  pbp_b14e_ded_yesno
  pbp_b14e_copay_yesno
  pbp_b14e_cost_share pbp_b14e_auth / missing;
run;

proc contents data = out.pbp_b14ei;
  title 'pbp b14ei data';
run;
