* pbp_b15.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b15;
  length
   pbp_a_hnumber                         $5
   pbp_a_plan_identifier                 $3
   pbp_a_ben_cov                         $1
   pbp_a_plan_type                       $2
   orgtype                               $2
   pbp_b15_bendesc_yesno                 $1
   pbp_b15_bendesc_amo                   $1
   pbp_b15_bendec_ehc_yn                 $1
   pbp_b15_bendec_for                    $3
   pbp_b15_bendesc_yn_nfor               $1
   pbp_b15_bendec_nfor                   $2
   pbp_b15_maxplan1_yesno                $1
   pbp_b15_maxplan_us_yesno              $1
   pbp_b15_maxplan_yesno                 $1
   pbp_b15copay_fb_yn                    $1
   pbp_b15_maxplan_cdt                   $5
   pbp_b15_maxplan_per_cdt               $5
   pbp_b15_maxplan_cov_cdt               $2
   pbp_b15_maxplan_less_copay            $1
   pbp_b15_maxplan_gen_unlm              $1
   pbp_b15_maxenr_yesno                  $1
   pbp_b15_maxenr_cdt                    $5
   pbp_b15_coins_yesno                   $1
   pbp_b15_coins_cov_mc                  $2
   pbp_b15_ded_yesno                     $1
   pbp_b15_deduct_cdt                    $5
   pbp_b15_copay_mc_yn                   $1
   pbp_b15_auth                          $5
   pbp_b15_auth_nonform                  $5
   pbp_b15_maxplan_fg_yesno              $1
   pbp_b15_maxplan_per_fgen              $5
   pbp_b15_maxplan_cov_gen               $2
   pbp_b15_maxplan_fg_less_copay         $1
   pbp_b15_fg_place                      $4
   pbp_b15_coins_fg_yn                   $1
   pbp_b15_coins_cov_gen                 $2
   pbp_b15copay_fgen_yn                  $1
   pbp_b15_maxplan_fpb_yesno             $1
   pbp_b15_maxplan_per_pb                $5
   pbp_b15_maxplan_cov_pb                $2
   pbp_b15_maxplan_fpb_less_copay        $1
   pbp_b15_fpb_place                     $4
   pbp_b15_coins_fpb_yn                  $1
   pbp_b15_coins_cov_pb                  $2
   pbp_b15copay_fpb_yn                   $1
   pbp_b15_maxplan_per_fbyn              $1
   pbp_b15_maxplan_per_fb                $5
   pbp_b15_maxplan_cov_fb                $2
   pbp_b15_maxplan_fb_less_copay         $1
   pbp_b15_fb_place                      $4
   pbp_b15_coins_fb_yn                   $1
   pbp_b15_coins_cov_b                   $2
   pbp_b15_copay_add_fb_yn               $1
   pbp_b15_maxplan_yn_nfg                $1
   pbp_b15_maxplan_per_nfg               $5
   pbp_b15_maxplan_cov_nfg               $2
   pbp_b15_maxplan_nfg_less_copay        $1
   pbp_b15_nfg_place                     $4
   pbp_b15_coins_yn_nfg                  $1
   pbp_b15_coins_cov_nfg                 $2
   pbp_b15copay_nfgen_yn                 $1
   pbp_b15_maxplan_yn_nfb                $1
   pbp_b15_maxplan_per_nfb               $5
   pbp_b15_maxplan_cov_nfb               $2
   pbp_b15_maxplan_nfb_less_copay        $1
   pbp_b15_nfb_place                     $4
   pbp_b15_coins_yn_nfb                  $1
   pbp_b15_coins_cov_nfb                 $2
   pbp_b15copay_nfb_yn                   $1
   pbp_b15_copay_add_nfb_yn              $1
;

  infile '.\pbp\pbp_b15_drugs.txt'
         delimiter = '09'x dsd lrecl = 10000 firstobs = 2 missover;
input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b15_copay_fpbhmo_amt
   pbp_b15_copay_fpbmo_amt
   pbp_b15_copay_fpbo_amt
   pbp_b15_fpbdrp_days
   pbp_b15_fpbhmo_days
   pbp_b15_fpbmo_days
   pbp_b15_fpbo_days
   pbp_b15_maxplan_per_fbyn
   pbp_b15_maxplan_per_fb
   pbp_b15_maxplan_amt_fby
   pbp_b15_maxplan_amt_fb6m
   pbp_b15_maxplan_amt_fb3m
   pbp_b15_maxplan_amt_fbm
   pbp_b15_maxplan_amt_fbo
   pbp_b15_maxplan_cov_fb
   pbp_b15_maxplan_fb_less_copay
   pbp_b15_maxplan_prp_fbpct
   pbp_b15_maxplan_awpf_fbamt
   pbp_b15_maxplan_awpf_fbamt_max
   pbp_b15_maxplan_awpd_fbpct
   pbp_b15_maxplan_mcoacp_fbamt
   pbp_b15_fb_place
   pbp_b15_coins_fb_yn
   pbp_b15_coins_pct_fb_drp
   pbp_b15_coins_pct_fb_hmo
   pbp_b15_coins_pct_fb_mo
   pbp_b15_coins_pct_fb_oth
   pbp_b15_coins_cov_b
   pbp_b15_coins_prp_fbpct
   pbp_b15_coins_awpf_fbamt
   pbp_b15_bendesc_yesno
   pbp_b15_bendesc_amo
   pbp_b15_bendec_ehc_yn
   pbp_b15_bendec_for
   pbp_b15_bendesc_yn_nfor
   pbp_b15_bendec_nfor
   pbp_b15_maxplan1_yesno
   pbp_b15_maxplan_us_yesno
   pbp_b15_maxplan_yesno
   pbp_b15_maxplan_cdt
   pbp_b15_maxplan_per_cdt
   pbp_b15_maxplan_amt_cdt_an
   pbp_b15_maxplan_amts_cdt_qt
   pbp_b15_maxplan_amt_cdt_qt
   pbp_b15_maxplan_amt_cdt_mo
   pbp_b15_maxplan_amt_cdt_oth
   pbp_b15_maxplan_cov_cdt
   pbp_b15_maxplan_less_copay
   pbp_b15_maxplan_prp_cdtpct
   pbp_b15_maxplan_awpf_cdtamt
   pbp_b15_maxpln_awpf_cdtamt_max
   pbp_b15_maxplan_awpd_cdtpct
   pbp_b15_maxplan_mcoacp_cdtamt
   pbp_b15_maxplan_gen_unlm
   pbp_b15_maxenr_yesno
   pbp_b15_maxenr_cdt
   pbp_b15_maxenr_amt
   pbp_b15_coins_yesno
   pbp_b15_coins_pct_mc
   pbp_b15_coins_cov_mc
   pbp_b15_coins_prp_mcpct
   pbp_b15_coins_awpf_mcamt
   pbp_b15_coins_awpf_mcamt_max
   pbp_b15_coins_awpd_mcpct
   pbp_b15_coins_mcoacp_mcamt
   pbp_b15_ded_yesno
   pbp_b15_deduct_cdt
   pbp_b15_ded_amt
   pbp_b15_copay_mc_yn
   pbp_b15_copay_min_mcb
   pbp_b15_copay_max_mcb
   pbp_b15_auth
   pbp_b15_auth_nonform
   pbp_b15_maxplan_fg_yesno
   pbp_b15_maxplan_per_fgen
   pbp_b15_maxplan_amt_gen_an
   pbp_b15_maxplan_amt_gen_s
   pbp_b15_maxplan_amt_gen_qt
   pbp_b15_maxplan_amt_gen_ml
   pbp_b15_maxplan_amt_gen_oth
   pbp_b15_maxplan_cov_gen
   pbp_b15_maxplan_fg_less_copay
   pbp_b15_maxplan_prp_gpct
   pbp_b15_maxplan_awpf_gamt
   pbp_b15_maxplan_awpf_gamt_max
   pbp_b15_maxplan_awpd_gpct
   pbp_b15_maxplan_mcoacp_gamt
   pbp_b15_fg_place
   pbp_b15_coins_fg_yn
   pbp_b15_coins_pct_fgenr
   pbp_b15_coins_pct_fgenh
   pbp_b15_coins_pct_fgenmo
   pbp_b15_coins_pct_fgeno
   pbp_b15_coins_cov_gen
   pbp_b15_coins_prp_genpct
   pbp_b15_coins_awpf_genamt
   pbp_b15_coins_awpf_genamt_max
   pbp_b15_coins_awpd_genpct
   pbp_b15_coins_mcoacp_genamt
   pbp_b15copay_fgen_yn
   pbp_b15_copay_fgenr_amt
   pbp_b15_copay_fgenhmo_amt
   pbp_b15_copay_fgenmo_amt
   pbp_b15_copay_fgeno_amt
   pbp_b15_fgdrp_days
   pbp_b15_fghmo_days
   pbp_b15_fgmo_days
   pbp_b15_fgo_days
   pbp_b15_maxplan_fpb_yesno
   pbp_b15_maxplan_per_pb
   pbp_b15_maxplan_amt_pb_an
   pbp_b15_maxplan_amt_pb_qt
   pbp_b15_maxplan_amt_pb_3ms
   pbp_b15_maxplan_amt_pb_ml
   pbp_b15_maxplan_amt_pb_oth
   pbp_b15_maxplan_cov_pb
   pbp_b15_maxplan_fpb_less_copay
   pbp_b15_maxplan_prp_pbpct
   pbp_b15_maxplan_awpf_pbamt
   pbp_b15_maxplan_awpf_pbamt_max
   pbp_b15_maxplan_awpd_pbpct
   pbp_b15_maxplan_mcoacp_pbamt
   pbp_b15_fpb_place
   pbp_b15_coins_fpb_yn
   pbp_b15_coins_pct_fpb_drp
   pbp_b15_coins_pct_fpb_hmo
   pbp_b15_coins_pct_fpb_mo
   pbp_b15_coins_pct_fpb_o
   pbp_b15_coins_cov_pb
   pbp_b15_coins_prp_pbpct
   pbp_b15_coins_awpf_pbamt
   pbp_b15_coins_awpf_pbamt_max
   pbp_b15_coins_awpd_pbpct
   pbp_b15_coins_mcoacp_pbamt
   pbp_b15copay_fpb_yn
   pbp_b15_copay_fpbr_amt
   pbp_b15_coins_awpf_fbamt_max
   pbp_b15_coins_awpd_fbpct
   pbp_b15_coins_mcoacp_fbamt
   pbp_b15copay_fb_yn
   pbp_b15_copay_fbr_amt
   pbp_b15_copay_fbhmo_amt
   pbp_b15_copay_fbmo_amt
   pbp_b15_copay_fbo_amt
   pbp_b15_fbdrp_days
   pbp_b15_fbhmo_days
   pbp_b15_fbmo_days
   pbp_b15_fbo_days
   pbp_b15_copay_add_fb_yn
   pbp_b15_maxplan_yn_nfg
   pbp_b15_maxplan_per_nfg
   pbp_b15_maxplan_amt_nfg_an
   pbp_b15_maxplan_amt_nfg_ba
   pbp_b15_maxplan_amt_nfg_q
   pbp_b15_maxplan_amt_nfg_m
   pbp_b15_maxplan_amt_nfg_o
   pbp_b15_maxplan_cov_nfg
   pbp_b15_maxplan_nfg_less_copay
   pbp_b15_maxplan_prp_nfgpct
   pbp_b15_maxplan_awpf_nfgamt
   pbp_b15_maxpln_awpf_nfgamt_max
   pbp_b15_maxplan_awpd_nfgpct
   pbp_b15_maxplan_mcoacp_nfgamt
   pbp_b15_nfg_place
   pbp_b15_coins_yn_nfg
   pbp_b15_coins_pct_nfg_drp
   pbp_b15_coins_pct_nfg_hmo
   pbp_b15_coins_pct_nfg_mo
   pbp_b15_coins_pct_nfg_oth
   pbp_b15_coins_cov_nfg
   pbp_b15_coins_prp_nfgpct
   pbp_b15_coins_awpf_nfgamt
   pbp_b15_coins_awpf_nfgamt_max
   pbp_b15_coins_awpd_nfgpct
   pbp_b15_coins_mcoacp_nfgamt
   pbp_b15copay_nfgen_yn
   pbp_b15_copay_nfgenr_amt
   pbp_b15_copay_nfgenhmo_amt
   pbp_b15_copay_nfgenmo_amt
   pbp_b15_copay_nfgeno_amt
   pbp_b15_nfgdrp_days
   pbp_b15_nfghmo_days
   pbp_b15_nfgmo_days
   pbp_b15_nfgo_days
   pbp_b15_maxplan_yn_nfb
   pbp_b15_maxplan_per_nfb
   pbp_b15_maxplan_amt_nfban
   pbp_b15_maxplan_amt_nfbba
   pbp_b15_maxplan_amt_nfbq
   pbp_b15_maxplan_amt_nfbm
   pbp_b15_maxplan_amt_nfbo
   pbp_b15_maxplan_cov_nfb
   pbp_b15_maxplan_nfb_less_copay
   pbp_b15_maxplan_prp_nfbpct
   pbp_b15_maxplan_awpf_nfbamt
   pbp_b15_maxpln_awpf_nfbamt_max
   pbp_b15_maxplan_awpd_nfbpct
   pbp_b15_maxplan_mcoacp_nfbamt
   pbp_b15_nfb_place
   pbp_b15_coins_yn_nfb
   pbp_b15_coins_pct_nfbdrp
   pbp_b15_coins_pct_nfbhmo
   pbp_b15_coins_pct_nfbmo
   pbp_b15_coins_pct_nfboth
   pbp_b15_coins_cov_nfb
   pbp_b15_coins_prp_nfbpct
   pbp_b15_coins_awpf_nfbamt
   pbp_b15_coins_awpf_nfbamt_max
   pbp_b15_coins_awpd_nfbpct
   pbp_b15_coins_mcoacp_nfbamt
   pbp_b15copay_nfb_yn
   pbp_b15_copay_nfbr_amt
   pbp_b15_copay_nfbhmo_amt
   pbp_b15_copay_nfbmo_amt
   pbp_b15_copay_nfbo_amt
   pbp_b15_nfbdrp_days
   pbp_b15_nfbhmo_days
   pbp_b15_nfbmo_days
   pbp_b15_nfbo_days
   pbp_b15_copay_add_nfb_yn
;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b15_auth                    = 'Outpatient Drugs Auth F           '
pbp_b15_auth_nonform            = 'Outpatient Drugs Auth NF          '
pbp_b15_bendec_ehc_yn           = 'Outpnt Drugs Ben Dec FOR YN       '
pbp_b15_bendec_for              = 'Outpnt Drugs FOR Ben Dec Enhc     '
pbp_b15_bendec_nfor             = 'Outpnt Drugs NFOR Ben Dec Enhc    '
pbp_b15_bendesc_amo             = 'Outpnt Drugs Ben Des AMO          '
pbp_b15_bendesc_yesno           = 'Outpnt Drugs Ben Desc Yes No      '
pbp_b15_bendesc_yn_nfor         = 'Outpnt Drugs Ben Des YN NFOR      '
pbp_b15_coins_awpd_fbpct        = 'Outpnt Drgs AWPD Coins FBPct      '
pbp_b15_coins_awpd_genpct       = 'Outpnt Drgs AWPD Coins GENPct     '
pbp_b15_coins_awpd_mcpct        = 'Outpnt Drgs AWPD Coins MCPct      '
pbp_b15_coins_awpd_nfbpct       = 'Outpnt Drgs AWPD Coins NFBPct     '
pbp_b15_coins_awpd_nfgpct       = 'Outpnt Drgs AWPD Coins NFGPct     '
pbp_b15_coins_awpd_pbpct        = 'Outpnt Drgs AWPD Coins PBPct      '
pbp_b15_coins_awpf_fbamt        = 'Outpnt Drgs AWPF Coins FBMIN      '
pbp_b15_coins_awpf_fbamt_max    = 'Outpnt Drgs AWPF Coins FBMAX      '
pbp_b15_coins_awpf_genamt       = 'Outpnt Drgs AWPF Coins GENMIN     '
pbp_b15_coins_awpf_genamt_max   = 'Outpnt Drgs AWPF Coins GENMAX     '
pbp_b15_coins_awpf_mcamt        = 'Outpnt Drgs AWPF Coins MCMIN      '
pbp_b15_coins_awpf_mcamt_max    = 'Outpnt Drgs AWPF Coins MCMAX      '
pbp_b15_coins_awpf_nfbamt       = 'Outpnt Drgs AWPF Coins NFBMIN     '
pbp_b15_coins_awpf_nfbamt_max   = 'Outpnt Drgs AWPF Coins NFBMAX     '
pbp_b15_coins_awpf_nfgamt       = 'Outpnt Drgs AWPF Coins NFGMIN     '
pbp_b15_coins_awpf_nfgamt_max   = 'Outpnt Drgs AWPF Coins NFGMAX     '
pbp_b15_coins_awpf_pbamt        = 'Outpnt Drgs AWPF Coins PBMIN      '
pbp_b15_coins_awpf_pbamt_max    = 'Outpnt Drgs AWPF Coins PBMAX      '
pbp_b15_coins_cov_b             = 'Outpnt Drugs B Coins Cov          '
pbp_b15_coins_cov_gen           = 'Outpnt Drugs GEN Coins Cov        '
pbp_b15_coins_cov_mc            = 'Outpnt Drugs MC Coins Cov         '
pbp_b15_coins_cov_nfb           = 'Outpnt Drugs NFB Coins Cov        '
pbp_b15_coins_cov_nfg           = 'Outpnt Drugs NFG Coins Cov        '
pbp_b15_coins_cov_pb            = 'Outpnt Drugs PB Coins Cov         '
pbp_b15_coins_fb_yn             = 'Outpnt Drugs Coins FB Y/N         '
pbp_b15_coins_fg_yn             = 'Outpnt Drugs Coins FG Y/N         '
pbp_b15_coins_fpb_yn            = 'Outpnt Drugs Coins FPB Y/N        '
pbp_b15_coins_mcoacp_fbamt      = 'Outpnt Drgs OACP Coins FBAMT      '
pbp_b15_coins_mcoacp_genamt     = 'Outpnt Drgs OACP Coins GENAMT     '
pbp_b15_coins_mcoacp_mcamt      = 'Outpnt Drgs OACP Coins MCAMT      '
pbp_b15_coins_mcoacp_nfbamt     = 'Outpnt Drgs OACP Coins NFBAMT     '
pbp_b15_coins_mcoacp_nfgamt     = 'Outpnt Drgs OACP Coins NFGAMT     '
pbp_b15_coins_mcoacp_pbamt      = 'Outpnt Drgs OACP Coins PBAMT      '
pbp_b15_coins_pct_fb_drp        = 'Outpnt Drugs FB Coin Pct DRP      '
pbp_b15_coins_pct_fb_hmo        = 'Outpnt Drugs FB Coin Pct HMO      '
pbp_b15_coins_pct_fb_mo         = 'Outpnt Drugs FB Coin Pct MO       '
pbp_b15_coins_pct_fb_oth        = 'Outpnt Drugs FB Coin Pct Oth      '
pbp_b15_coins_pct_fgenh         = 'Outpnt Drugs RGENH Coin Pct       '
pbp_b15_coins_pct_fgenmo        = 'Outpnt Drugs RGENMO Coin Pct      '
pbp_b15_coins_pct_fgeno         = 'Outpnt Drugs RGENO Coin Pct       '
pbp_b15_coins_pct_fgenr         = 'Outpnt Drugs RGENR Coin Pct       '
pbp_b15_coins_pct_fpb_drp       = 'Outpnt Drugs FPB Coin Pct DRP     '
pbp_b15_coins_pct_fpb_hmo       = 'Outpnt Drugs FPB Coin Pct HMO     '
pbp_b15_coins_pct_fpb_mo        = 'Outpnt Drugs FPB Coin Pct MO      '
pbp_b15_coins_pct_fpb_o         = 'Outpnt Drugs FPB Coin Pct O       '
pbp_b15_coins_pct_mc            = 'Outpnt Drugs MC Coin Pct          '
pbp_b15_coins_pct_nfbdrp        = 'Outpnt Drugs NFB Coin Pct DRP     '
pbp_b15_coins_pct_nfbhmo        = 'Outpnt Drugs NFB Coin Pct HMO     '
pbp_b15_coins_pct_nfbmo         = 'Outpnt Drugs NFB Coin Pct MO      '
pbp_b15_coins_pct_nfboth        = 'Outpnt Drugs NFB Coin Pct OTH     '
pbp_b15_coins_pct_nfg_drp       = 'Outpnt Drugs NFG Coin Pct DRP     '
pbp_b15_coins_pct_nfg_hmo       = 'Outpnt Drugs NFG Coin Pct HMO     '
pbp_b15_coins_pct_nfg_mo        = 'Outpnt Drugs NFG Coin Pct MO      '
pbp_b15_coins_pct_nfg_oth       = 'Outpnt Drugs NFG Coin Pct OTH     '
pbp_b15_coins_prp_fbpct         = 'Outpnt Drgs PRP Coins FBPct       '
pbp_b15_coins_prp_genpct        = 'Outpnt Drgs PRP Coins GENPct      '
pbp_b15_coins_prp_mcpct         = 'Outpnt Drgs PRP Coins MCPct       '
pbp_b15_coins_prp_nfbpct        = 'Outpnt Drgs PRP Coins NFBPct      '
pbp_b15_coins_prp_nfgpct        = 'Outpnt Drgs PRP Coins NFGPct      '
pbp_b15_coins_prp_pbpct         = 'Outpnt Drgs PRP Coins PBPct       '
pbp_b15_coins_yesno             = 'Outpnt Drugs Coins Yes No         '
pbp_b15_coins_yn_nfb            = 'Outpnt Drugs NFB Coin Y/N         '
pbp_b15_coins_yn_nfg            = 'Outpnt Drugs NFG Coin Y/N         '
pbp_b15_copay_add_fb_yn         = 'Outpnt Drugs Add Cpy FB YN        '
pbp_b15_copay_add_nfb_yn        = 'Outpnt Drugs Add Cpy NFB YN       '
pbp_b15_copay_fbhmo_amt         = 'Outpnt Drugs Copay FBHMO Amt      '
pbp_b15_copay_fbmo_amt          = 'Outpnt Drugs Copay FBMO Amt       '
pbp_b15_copay_fbo_amt           = 'Outpnt Drugs Copay FBO Amt        '
pbp_b15_copay_fbr_amt           = 'Outpnt Drugs Copay FBR Amt        '
pbp_b15_copay_fgenhmo_amt       = 'Outpnt Drugs Copay FGENHMO Amt    '
pbp_b15_copay_fgenmo_amt        = 'Outpnt Drugs Copay FGENMO Amt     '
pbp_b15_copay_fgeno_amt         = 'Outpnt Drugs Copay FGENO Amt      '
pbp_b15_copay_fgenr_amt         = 'Outpnt Drugs Copay FGENR Amt      '
pbp_b15_copay_fpbhmo_amt        = 'Outpnt Drugs Copay FPBHMO Amt     '
pbp_b15_copay_fpbmo_amt         = 'Outpnt Drugs Copay FPBMO Amt      '
pbp_b15_copay_fpbo_amt          = 'Outpnt Drugs Copay FPBO Amt       '
pbp_b15_copay_fpbr_amt          = 'Outpnt Drugs Copay FPBR Amt       '
pbp_b15_copay_max_mcb           = 'Outpnt Drugs Copay Max MCB        '
pbp_b15_copay_mc_yn             = 'Outpnt Drugs Copay MC YN          '
pbp_b15_copay_min_mcb           = 'Outpnt Drugs Copay Min MCB        '
pbp_b15_copay_nfbhmo_amt        = 'Outpnt Drug Copay NFBHMO Amt      '
pbp_b15_copay_nfbmo_amt         = 'Outpnt Drugs Copay NFBMO Amt      '
pbp_b15_copay_nfbo_amt          = 'Outpnt Drugs Copay NFBO Amt       '
pbp_b15_copay_nfbr_amt          = 'Outpnt Drugs Copay NFBR Amt       '
pbp_b15_copay_nfgenhmo_amt      = 'Outpnt Drug Copay NFGENHMO Amt    '
pbp_b15_copay_nfgenmo_amt       = 'Outpnt Drugs Copay NFGENMO Amt    '
pbp_b15_copay_nfgeno_amt        = 'Outpnt Drugs Copay NFGENO Amt     '
pbp_b15_copay_nfgenr_amt        = 'Outpnt Drugs Copay NFGENR Amt     '
pbp_b15_ded_amt                 = 'Outpatient Drugs Deduc Amt        '
pbp_b15_ded_yesno               = 'Outpatient Drugs Deduc Yes No     '
pbp_b15_deduct_cdt              = 'Outpnt Drugs CDT Deductible       '
pbp_b15_fb_place                = 'Outpnt Drugs FB Place             '
pbp_b15_fbdrp_days              = 'Outpnt Drugs FB DRP # Days        '
pbp_b15_fbhmo_days              = 'Outpnt Drugs FB HMO # Days        '
pbp_b15_fbmo_days               = 'Outpnt Drugs FB MO # Days         '
pbp_b15_fbo_days                = 'Outpnt Drugs FB Oth # Days        '
pbp_b15_fg_place                = 'Outpnt Drugs FG Place             '
pbp_b15_fgdrp_days              = 'Outpnt Drugs FGDRP # Days         '
pbp_b15_fghmo_days              = 'Outpnt Drugs FG HMO # Days        '
pbp_b15_fgmo_days               = 'Outpnt Drugs FG MO # Days         '
pbp_b15_fgo_days                = 'Outpnt Drugs FG Oth # Days        '
pbp_b15_fpb_place               = 'Outpnt Drugs FPB Place            '
pbp_b15_fpbdrp_days             = 'Outpnt Drugs FPB DRP # Days       '
pbp_b15_fpbhmo_days             = 'Outpnt Drugs FPB HMO # Days       '
pbp_b15_fpbmo_days              = 'Outpnt Drugs FPB MO # Days        '
pbp_b15_fpbo_days               = 'Outpnt Drugs FPB Oth # Days       '
pbp_b15_maxenr_amt              = 'Outpnt Drugs Max Enr Amt          '
pbp_b15_maxenr_cdt              = 'Outpnt Drugs CDT Max Enrollee     '
pbp_b15_maxenr_yesno            = 'Outpnt Drugs Max Enr Yes No       '
pbp_b15_maxplan1_yesno          = 'Outpnt Drugs Max Plan 1 Yes No    '
pbp_b15_maxplan_amt_cdt_an      = 'Outpnt Drugs A CDT Max Pln Amt    '
pbp_b15_maxplan_amt_cdt_mo      = 'Outpnt Drugs M CDT Max Pln Amt    '
pbp_b15_maxplan_amt_cdt_oth     = 'Outpnt Drugs O CDT Max Pln Amt    '
pbp_b15_maxplan_amt_cdt_qt      = 'Outpnt Drugs Q CDT Max Pln Amt    '
pbp_b15_maxplan_amt_fb3m        = 'Outpnt Drugs FB Q Max Pln Amt     '
pbp_b15_maxplan_amt_fb6m        = 'Outpnt Drugs FB BA Max Pln Amt    '
pbp_b15_maxplan_amt_fbm         = 'Outpnt Drugs FB M Max Pln Amt     '
pbp_b15_maxplan_amt_fbo         = 'Outpnt Drugs FB O Max Pln Amt     '
pbp_b15_maxplan_amt_fby         = 'Outpnt Drugs FB A Max Pln Amt     '
pbp_b15_maxplan_amt_gen_an      = 'Outpnt Drugs Gen A Max Pln Amt    '
pbp_b15_maxplan_amt_gen_ml      = 'Outpnt Drugs Gen M Max Pln Amt    '
pbp_b15_maxplan_amt_gen_oth     = 'Outpnt Drugs Gen O Max Pln Amt    '
pbp_b15_maxplan_amt_gen_qt      = 'Outpnt Drugs Gen Q Max Pln Amt    '
pbp_b15_maxplan_amt_gen_s       = 'Outpnt Drugs Gen S Max Pln Amt    '
pbp_b15_maxplan_amt_nfban       = 'Outpnt Drgs NFB A Max Plan Amt    '
pbp_b15_maxplan_amt_nfbba       = 'Outpnt Drgs NFB BA Max Pln Amt    '
pbp_b15_maxplan_amt_nfbm        = 'Outpnt Drgs NFB M Max Pln Amt     '
pbp_b15_maxplan_amt_nfbo        = 'Outpnt Drgs NFB O Max Pln Amt     '
pbp_b15_maxplan_amt_nfbq        = 'Outpnt Drgs NFB Q Max Pln Amt     '
pbp_b15_maxplan_amt_nfg_an      = 'Outpnt Drgs NFG A Max Plan Amt    '
pbp_b15_maxplan_amt_nfg_ba      = 'Outpnt Drgs NFG BA Max Pln Amt    '
pbp_b15_maxplan_amt_nfg_m       = 'Outpnt Drgs NFG M Max Pln Amt     '
pbp_b15_maxplan_amt_nfg_o       = 'Outpnt Drgs NFG O Max Pln Amt     '
pbp_b15_maxplan_amt_nfg_q       = 'Outpnt Drgs NFG Q Max Pln Amt     '
pbp_b15_maxplan_amt_pb_3ms      = 'Outpnt Drugs PB 3M Max Pln Amt    '
pbp_b15_maxplan_amt_pb_an       = 'Outpnt Drugs PB A Max Pln Amt     '
pbp_b15_maxplan_amt_pb_ml       = 'Outpnt Drugs PB M Max Pln Amt     '
pbp_b15_maxplan_amt_pb_oth      = 'Outpnt Drugs PB O Max Pln Amt     '
pbp_b15_maxplan_amt_pb_qt       = 'Outpnt Drugs PB 6M Max Pln Amt    '
pbp_b15_maxplan_amts_cdt_qt     = 'Outpnt Drugs S CDT Max Pln Amt    '
pbp_b15_maxplan_awpd_cdtpct     = 'Outpnt Drgs AWPD Mx Pln CDTPct    '
pbp_b15_maxplan_awpd_fbpct      = 'Outpnt Drgs AWPD Mx Pln FB Pct    '
pbp_b15_maxplan_awpd_gpct       = 'Outpnt Drugs AWPD Max Pln GPct    '
pbp_b15_maxplan_awpd_nfbpct     = 'Outpnt Drg AWPD Max Pln NFBPct    '
pbp_b15_maxplan_awpd_nfgpct     = 'Outpnt Drg AWPD Max Pln NFGPct    '
pbp_b15_maxplan_awpd_pbpct      = 'Outpnt Drgs AWPD Max Pln PBPct    '
pbp_b15_maxplan_awpf_cdtamt     = 'Outpnt Drgs AWPF Mx Pln CDTMIN    '
pbp_b15_maxplan_awpf_fbamt      = 'Outpnt Drgs AWPF Mx Pln FB MIN    '
pbp_b15_maxplan_awpf_fbamt_max  = 'Outpnt Drgs AWPF Mx Pln FB MAX    '
pbp_b15_maxplan_awpf_gamt       = 'Outpnt Drugs AWPF Max Pln GMIN    '
pbp_b15_maxplan_awpf_gamt_max   = 'Outpnt Drugs AWPF Max Pln GMAX    '
pbp_b15_maxplan_awpf_nfbamt     = 'Outpnt Drg AWPF Max Pln NFBMIN    '
pbp_b15_maxplan_awpf_nfgamt     = 'Outpnt Drg AWPF Max Pln NFGMIN    '
pbp_b15_maxplan_awpf_pbamt      = 'Outpnt Drgs AWPF Max Pln PBMIN    '
pbp_b15_maxplan_awpf_pbamt_max  = 'Outpnt Drgs AWPF Max Pln PBMAX    '
pbp_b15_maxplan_cdt             = 'Outpnt Drugs CDT Max Plan         '
pbp_b15_maxplan_cov_cdt         = 'Outpnt Drugs CDT Max Plan Cov     '
pbp_b15_maxplan_cov_fb          = 'Outpnt Drugs FB Max Plan Cov      '
pbp_b15_maxplan_cov_gen         = 'Outpnt Drugs Gen Max Plan Cov     '
pbp_b15_maxplan_cov_nfb         = 'Outpnt Drugs NFB Max Plan Cov     '
pbp_b15_maxplan_cov_nfg         = 'Outpnt Drugs NFG Max Plan Cov     '
pbp_b15_maxplan_cov_pb          = 'Outpnt Drugs PB Max Plan Cov      '
pbp_b15_maxplan_fb_less_copay   = 'Outpnt Drugs Max Pln FB LCpy      '
pbp_b15_maxplan_fg_less_copay   = 'Outpnt Drugs Max Pln FG LCpy      '
pbp_b15_maxplan_fg_yesno        = 'Outpnt Drugs Max Plan FG Y/N      '
pbp_b15_maxplan_fpb_less_copay  = 'Outpnt Drugs Max Pln FPB LCpy     '
pbp_b15_maxplan_fpb_yesno       = 'Outpnt Drugs Max Plan FPB Y/N     '
pbp_b15_maxplan_gen_unlm        = 'Outpnt Drugs Max Pln Gen Unlm     '
pbp_b15_maxplan_less_copay      = 'Outpnt Drugs Max Pln Less Cpy     '
pbp_b15_maxplan_mcoacp_cdtamt   = 'Outpnt Drgs OACP Mx Pln CDTAMT    '
pbp_b15_maxplan_mcoacp_fbamt    = 'Outpnt Drgs OACP Mx Pln FB AMT    '
pbp_b15_maxplan_mcoacp_gamt     = 'Outpnt Drugs OACP Max Pln GAMT    '
pbp_b15_maxplan_mcoacp_nfbamt   = 'Outpnt Drg OACP Max Pln NFBAMT    '
pbp_b15_maxplan_mcoacp_nfgamt   = 'Outpnt Drg OACP Max Pln NFGAMT    '
pbp_b15_maxplan_mcoacp_pbamt    = 'Outpnt Drgs OACP Max Pln PBAMT    '
pbp_b15_maxplan_nfb_less_copay  = 'Outpnt Drugs Max Pln NFB LCpy     '
pbp_b15_maxplan_nfg_less_copay  = 'Outpnt Drugs Max Pln NFG LCpy     '
pbp_b15_maxplan_per_cdt         = 'Outpnt Drugs CDT Max Plan Per     '
pbp_b15_maxplan_per_fb          = 'Outpnt Drugs FB Max Plan Per      '
pbp_b15_maxplan_per_fbyn        = 'Outpnt Drugs FB Max Plan Y/N      '
pbp_b15_maxplan_per_fgen        = 'Outpnt Drugs FGen Max Plan Per    '
pbp_b15_maxplan_per_nfb         = 'Outpnt Drugs NFB Max Plan Per     '
pbp_b15_maxplan_per_nfg         = 'Outpnt Drugs NFG Max Plan Per     '
pbp_b15_maxplan_per_pb          = 'Outpnt Drugs PB Max Plan Per      '
pbp_b15_maxplan_prp_cdtpct      = 'Outpnt Drgs PRP Max Pln CDTPct    '
pbp_b15_maxplan_prp_fbpct       = 'Outpnt Drgs PRP Max Pln FB Pct    '
pbp_b15_maxplan_prp_gpct        = 'Outpnt Drugs PRP Max Plan GPct    '
pbp_b15_maxplan_prp_nfbpct      = 'Outpnt Drgs PRP Max Pln NFBPct    '
pbp_b15_maxplan_prp_nfgpct      = 'Outpnt Drug PRP Max Pln NFGPct    '
pbp_b15_maxplan_prp_pbpct       = 'Outpnt Drugs PRP Max Pln PBPct    '
pbp_b15_maxplan_us_yesno        = 'Outpnt Drugs Max Pln Unused YN    '
pbp_b15_maxplan_yesno           = 'Outpnt Drugs Max Plan Yes No      '
pbp_b15_maxplan_yn_nfb          = 'Outpnt Drugs NFB Max Plan Y/N     '
pbp_b15_maxplan_yn_nfg          = 'Outpnt Drugs NFG Max Plan Y/N     '
pbp_b15_maxpln_awpf_cdtamt_max  = 'Outpnt Drgs AWPF Mx Pln CDTMAX    '
pbp_b15_maxpln_awpf_nfbamt_max  = 'Outpnt Drgs AWPF Mx Pln FB MAX    '
pbp_b15_maxpln_awpf_nfgamt_max  = 'Outpnt Drugs AWPF Max Pln GMAX    '
pbp_b15_nfb_place               = 'Outpnt Drugs NFB Place            '
pbp_b15_nfbdrp_days             = 'Outpnt Drugs NFB DRP # Days       '
pbp_b15_nfbhmo_days             = 'Outpnt Drugs NFB HMO # Days       '
pbp_b15_nfbmo_days              = 'Outpnt Drug NFB MO # Days         '
pbp_b15_nfbo_days               = 'Outpnt Drugs NFB Oth # Days       '
pbp_b15_nfg_place               = 'Outpnt Drugs NFG Place            '
pbp_b15_nfgdrp_days             = 'Outpnt Drugs NFG DRP # Days       '
pbp_b15_nfghmo_days             = 'Outpnt Drugs NFG HMO # Days       '
pbp_b15_nfgmo_days              = 'Outpnt Drug NFG MO # Days         '
pbp_b15_nfgo_days               = 'Outpnt Drugs NFG Oth # Days       '
pbp_b15copay_fb_yn              = 'Outpnt Drugs Copay FB YN          '
pbp_b15copay_fgen_yn            = 'Outpnt Drugs Copay FGEN YN        '
pbp_b15copay_fpb_yn             = 'Outpnt Drugs Copay FPB YN         '
pbp_b15copay_nfb_yn             = 'Outpnt Drugs Copay NFB YN         '
pbp_b15copay_nfgen_yn           = 'Outpnt Drugs Copay NFGEN YN       '
;
run;

proc sort data = pbp_b15 out = out.pbp_b15;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b15 (obs = 10);
  title 'pbp b15 data';
run;

proc means data =  out.pbp_b15;
  title 'pbp b15 file';
run;

proc freq data = out.pbp_b15;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b15_bendesc_yesno
  pbp_b15_bendesc_amo
  pbp_b15_bendec_ehc_yn
  pbp_b15_bendec_for
  pbp_b15_bendesc_yn_nfor
  pbp_b15_bendec_nfor
  pbp_b15_maxplan1_yesno
  pbp_b15_maxplan_us_yesno
  pbp_b15_maxplan_yesno
  pbp_b15_maxplan_cdt
  pbp_b15_maxplan_per_cdt
  pbp_b15_maxplan_cov_cdt / missing;
  run;

proc contents data = out.pbp_b15;
  title 'pbp b15 data';
run;
