*pbp_b16.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b16;
  length
   pbp_a_hnumber                       $5
   pbp_a_plan_identifier               $3
   pbp_a_ben_cov                       $1
   pbp_a_plan_type                     $2
   orgtype                             $2
   pbp_b16a_bendesc_yesno              $1
   pbp_b16a_bendec_ehc                 $4
   pbp_b16a_bendesc_amo_pc             $1
   pbp_b16a_bendesc_lim_pc             $1
   pbp_b16a_bendesc_per_pc             $1
   pbp_b16a_bendesc_amo_ft             $1
   pbp_b16a_bendesc_lim_ft             $1
   pbp_b16a_bendesc_per_ft             $1
   pbp_b16a_bendesc_amo_dx             $1
   pbp_b16a_bendesc_lim_dx             $1
   pbp_b16a_bendesc_per_dx             $1
   pbp_b16a_bendesc_amo_oe             $1
   pbp_b16a_bendesc_lim_oe             $1
   pbp_b16a_bendesc_per_oe             $1
   pbp_b16a_maxplan_yesno              $1
   pbp_b16a_maxplan_per                $1
   pbp_b16a_maxplan_cov                $1
   pbp_b16a_maxenr_yesno               $1
   pbp_b16a_maxenr_per                 $1
   pbp_b16a_coins_yesno                $1
   pbp_b16a_coins_cov_pc               $1
   pbp_b16a_coins_cov_ft               $1
   pbp_b16a_coins_cov_dx               $1
   pbp_b16a_coins_cov_oe               $1
   pbp_b16a_ded_yesno                  $1
   pbp_b16a_copay_yesno                $1
   pbp_b16a_auth                       $5
   pbp_b16a_maxplan_yesno_pos          $1
   pbp_b16a_maxpln_per_pos             $1
   pbp_b16a_maxpln_cov_pos             $1
   pbp_b16a_maxenr_yn_pos              $1
   pbp_b16a_coins_yesno_pos            $1
   pbp_b16a_coins_cov__pos             $1
   pbp_b16a_ded_yesno_pos              $1
   pbp_b16a_copay_yesno_pos            $1
   pbp_b16a_auth_pos                   $5
   pbp_b16b_bendesc_yesno              $1
   pbp_b16b_bendec_ehc                 $5
   pbp_b16b_bendesc_amo_es             $1
   pbp_b16b_bendesc_lim_es             $1
   pbp_b16b_bendesc_per_es             $1
   pbp_b16b_bendesc_amo_ds             $1
   pbp_b16b_bendesc_lim_ds             $1
   pbp_b16b_bendesc_per_ds             $1
   pbp_b16b_bendesc_amo_rs             $1
   pbp_b16b_bendesc_lim_rs             $1
   pbp_b16b_bendesc_per_rs             $1
   pbp_b16b_bendesc_amo_epe            $1
   pbp_b16b_bendesc_lim_epe            $1
   pbp_b16b_bendesc_per_epe            $1
   pbp_b16b_bendesc_amo_poo            $1
   pbp_b16b_bendesc_lim_poo            $1
   pbp_b16b_bendesc_per_poo            $1
   pbp_b16b_maxplan_yesno              $1
   pbp_b16b_maxbene_type               $1
   pbp_b16b_maxplan_per                $1
   pbp_b16b_maxplan_covb               $1
   pbp_b16b_maxenr_yesno               $1
   pbp_b16b_maxenr_type                $1
   pbp_b16b_maxenr_per                 $1
   pbp_b16b_coins_yesno                $1
   pbp_b16b_coins_cov_mc               $1
   pbp_b16b_coins_cov_es               $1
   pbp_b16b_coins_cov_ds               $1
   pbp_b16b_coins_cov_rs               $1
   pbp_b16b_coins_cov_epe              $1
   pbp_b16b_coins_cov_poo              $1
   pbp_b16b_ded_yesno                  $1
   pbp_b16b_copay_yesno                $1
   pbp_b16b_auth                       $5
   pbp_b16b_maxplan_yesno_pos          $1
   pbp_b16b_maxplan_type_pos           $1
   pbp_b16b_maxpln_per_pos             $1
   pbp_b16b_maxpln_cov_pos             $1
   pbp_b16b_maxenr_yesno_pos           $1
   pbp_b16b_maxenr_type_pos            $1
   pbp_b16b_coins_yesno_pos            $1
   pbp_b16b_coins_cov__pos             $1
   pbp_b16b_ded_yesno_pos              $1
   pbp_b16b_copay_yesno_pos            $1
   pbp_b16b_auth_pos                   $5
  ;

infile '.\pbp\pbp_b16_dental.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;
input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b16a_bendesc_yesno
   pbp_b16a_bendec_ehc
   pbp_b16a_bendesc_amo_pc
   pbp_b16a_bendesc_lim_pc
   pbp_b16a_bendesc_numv_pc
   pbp_b16a_bendesc_per_pc
   pbp_b16a_bendesc_amo_ft
   pbp_b16a_bendesc_lim_ft
   pbp_b16a_bendesc_numv_ft
   pbp_b16a_bendesc_per_ft
   pbp_b16a_bendesc_amo_dx
   pbp_b16a_bendesc_lim_dx
   pbp_b16a_bendesc_numv_dx
   pbp_b16a_bendesc_per_dx
   pbp_b16a_bendesc_amo_oe
   pbp_b16a_bendesc_lim_oe
   pbp_b16a_bendesc_numv_oe
   pbp_b16a_bendesc_per_oe
   pbp_b16a_maxplan_yesno
   pbp_b16a_maxplan_amt
   pbp_b16a_maxplan_per
   pbp_b16a_maxplan_cov
   pbp_b16a_maxenr_yesno
   pbp_b16a_maxenr_amt
   pbp_b16a_maxenr_per
   pbp_b16a_coins_yesno
   pbp_b16a_coins_pct_pc
   pbp_b16a_coins_pct_maxpc
   pbp_b16a_coins_cov_pc
   pbp_b16a_coins_pct_ft
   pbp_b16a_coins_pct_maxft
   pbp_b16a_coins_cov_ft
   pbp_b16a_coins_pct_dx
   pbp_b16a_coins_pct_maxdx
   pbp_b16a_coins_cov_dx
   pbp_b16a_coins_pct_oe
   pbp_b16a_coins_pct_maxoe
   pbp_b16a_coins_cov_oe
   pbp_b16a_ded_yesno
   pbp_b16a_ded_amt
   pbp_b16a_copay_yesno
   pbp_b16a_copay_amt_pcmin
   pbp_b16a_copay_amt_pcmax
   pbp_b16a_copay_amt_ftmin
   pbp_b16a_copay_amt_ftmax
   pbp_b16a_copay_amt_dxmin
   pbp_b16a_copay_amt_dxmax
   pbp_b16a_copay_amt_oemin
   pbp_b16a_copay_amt_oemax
   pbp_b16a_auth
   pbp_b16a_maxplan_yesno_pos
   pbp_b16a_maxpln_amt_pos
   pbp_b16a_maxpln_per_pos
   pbp_b16a_maxpln_cov_pos
   pbp_b16a_maxenr_yn_pos
   pbp_b16a_maxenr_amt_pos
   pbp_b16a_coins_yesno_pos
   pbp_b16a_coins_pct_pos
   pbp_b16a_coins_pctmax_pos
   pbp_b16a_coins_cov__pos
   pbp_b16a_ded_yesno_pos
   pbp_b16a_ded_amt_pos
   pbp_b16a_copay_yesno_pos
   pbp_b16a_copay_minamt_pos
   pbp_b16a_copay_maxamt_pos
   pbp_b16a_auth_pos
   pbp_b16b_bendesc_yesno
   pbp_b16b_bendec_ehc
   pbp_b16b_bendesc_amo_es
   pbp_b16b_bendesc_lim_es
   pbp_b16b_bendesc_numv_es
   pbp_b16b_bendesc_per_es
   pbp_b16b_bendesc_amo_ds
   pbp_b16b_bendesc_lim_ds
   pbp_b16b_bendesc_numv_ds
   pbp_b16b_bendesc_per_ds
   pbp_b16b_bendesc_amo_rs
   pbp_b16b_bendesc_lim_rs
   pbp_b16b_bendesc_numv_rs
   pbp_b16b_bendesc_per_rs
   pbp_b16b_bendesc_amo_epe
   pbp_b16b_bendesc_lim_epe
   pbp_b16b_bendesc_numv_epe
   pbp_b16b_bendesc_per_epe
   pbp_b16b_bendesc_amo_poo
   pbp_b16b_bendesc_lim_poo
   pbp_b16b_bendesc_numv_poo
   pbp_b16b_bendesc_per_poo
   pbp_b16b_maxplan_yesno
   pbp_b16b_maxbene_type
   pbp_b16b_maxplan_amt
   pbp_b16b_maxplan_per
   pbp_b16b_maxplan_covb
   pbp_b16b_maxenr_yesno
   pbp_b16b_maxenr_type
   pbp_b16b_maxenr_amt
   pbp_b16b_maxenr_per
   pbp_b16b_coins_yesno
   pbp_b16b_coins_pct_mc
   pbp_b16b_coins_pctmax_mc
   pbp_b16b_coins_cov_mc
   pbp_b16b_coins_pct_es
   pbp_b16b_coins_pct_maxes
   pbp_b16b_coins_cov_es
   pbp_b16b_coins_pct_ds
   pbp_b16b_coins_pct_maxds
   pbp_b16b_coins_cov_ds
   pbp_b16b_coins_pct_rs
   pbp_b16b_coins_pct_maxrs
   pbp_b16b_coins_cov_rs
   pbp_b16b_coins_pct_epe
   pbp_b16b_coins_pct_maxepe
   pbp_b16b_coins_cov_epe
   pbp_b16b_coins_pct_poo
   pbp_b16b_coins_pct_maxpoo
   pbp_b16b_coins_cov_poo
   pbp_b16b_ded_yesno
   pbp_b16b_ded_amt
   pbp_b16b_copay_yesno
   pbp_b16b_copay_mc_amt
   pbp_b16b_copay_mcmax_amt
   pbp_b16b_copay_amt_esmin
   pbp_b16b_copay_amt_esmax
   pbp_b16b_copay_amt_dsmin
   pbp_b16b_copay_amt_dsmax
   pbp_b16b_copay_amt_rsmin
   pbp_b16b_copay_amt_rsmax
   pbp_b16b_copay_amt_epemin
   pbp_b16b_copay_amt_epemax
   pbp_b16b_copay_amt_poomin
   pbp_b16b_copay_amt_poomax
   pbp_b16b_auth
   pbp_b16b_maxplan_yesno_pos
   pbp_b16b_maxplan_type_pos
   pbp_b16b_maxpln_amt_pos
   pbp_b16b_maxpln_per_pos
   pbp_b16b_maxpln_cov_pos
   pbp_b16b_maxenr_yesno_pos
   pbp_b16b_maxenr_type_pos
   pbp_b16b_maxenr_amt_pos
   pbp_b16b_coins_yesno_pos
   pbp_b16b_coins_pct_pos
   pbp_b16b_coins_pctmax_pos
   pbp_b16b_coins_cov__pos
   pbp_b16b_ded_yesno_pos
   pbp_b16b_ded_amt_pos
   pbp_b16b_copay_yesno_pos
   pbp_b16b_copay_minamt_pos
   pbp_b16b_copay_maxamt_pos
   pbp_b16b_auth_pos
;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b16a_auth                   = 'Dental Preventive Auth            '
pbp_b16a_auth_pos               = 'Dental Preventive Auth POS        '
pbp_b16a_bendec_ehc             = 'Dental Prev Ben Dec Enhc          '
pbp_b16a_bendesc_amo_dx         = 'Dental Prev DX Ben Des AMO        '
pbp_b16a_bendesc_amo_ft         = 'Dental Prev FT Ben Des AMO        '
pbp_b16a_bendesc_amo_oe         = 'Dental Prev OE Ben Des AMO        '
pbp_b16a_bendesc_amo_pc         = 'Dental Prev PC Ben Des AMO        '
pbp_b16a_bendesc_lim_dx         = 'Dental Prev DX Ben Desc Lim       '
pbp_b16a_bendesc_lim_ft         = 'Dental Prev FT Ben Desc Lim       '
pbp_b16a_bendesc_lim_oe         = 'Dental Prev OE Ben Desc Lim       '
pbp_b16a_bendesc_lim_pc         = 'Dental Prev PC Ben Desc Lim       '
pbp_b16a_bendesc_numv_dx        = 'Dental Prev DX Ben Desc NumV      '
pbp_b16a_bendesc_numv_ft        = 'Dental Prev FT Ben Desc NumV      '
pbp_b16a_bendesc_numv_oe        = 'Dental Prev OE Ben Desc NumV      '
pbp_b16a_bendesc_numv_pc        = 'Dental Prev PC Ben Desc NumV      '
pbp_b16a_bendesc_per_dx         = 'Dental Prev DX Ben Desc Per       '
pbp_b16a_bendesc_per_ft         = 'Dental Prev FT Ben Desc Per       '
pbp_b16a_bendesc_per_oe         = 'Dental Prev OE Ben Desc Per       '
pbp_b16a_bendesc_per_pc         = 'Dental Prev PC Ben Desc Per       '
pbp_b16a_bendesc_yesno          = 'Dental Prev Ben Desc Yes No       '
pbp_b16a_coins_cov__pos         = 'Dental Prev Coins Cov POS         '
pbp_b16a_coins_cov_dx           = 'Dental Prev DX Coinsurance Cov    '
pbp_b16a_coins_cov_ft           = 'Dental Prev FT Coinsurance Cov    '
pbp_b16a_coins_cov_oe           = 'Dental Prev OE Coinsurance Cov    '
pbp_b16a_coins_cov_pc           = 'Dental Prev PC Coinsurance Cov    '
pbp_b16a_coins_pct_dx           = 'Dental Prev DX Min Coins Pct      '
pbp_b16a_coins_pct_ft           = 'Dental Prev FT Min Coins Pct      '
pbp_b16a_coins_pct_maxdx        = 'Dental Prev DX Max Coins Pct      '
pbp_b16a_coins_pct_maxft        = 'Dental Prev FT Max Coins Pct      '
pbp_b16a_coins_pct_maxoe        = 'Dental Prev OE Max Coins Pct      '
pbp_b16a_coins_pct_maxpc        = 'Dental Prev PC Max Coins Pct      '
pbp_b16a_coins_pct_oe           = 'Dental Prev OE Min Coins Pct      '
pbp_b16a_coins_pct_pc           = 'Dental Prev PC Min Coins Pct      '
pbp_b16a_coins_pct_pos          = 'Dental Prev Min Coin Pct POS      '
pbp_b16a_coins_pctmax_pos       = 'Dental Prev Max Coin Pct POS      '
pbp_b16a_coins_yesno            = 'Dental Prev Coinsurance YN        '
pbp_b16a_coins_yesno_pos        = 'Dental Prev Coinsurance YN POS    '
pbp_b16a_copay_amt_dxmax        = 'Dental Prev DX Max Cpy Amt        '
pbp_b16a_copay_amt_dxmin        = 'Dental Prev DX Min Cpy Amt        '
pbp_b16a_copay_amt_ftmax        = 'Dental Prev FT Max Cpy Amt        '
pbp_b16a_copay_amt_ftmin        = 'Dental Prev FT Min Cpy Amt        '
pbp_b16a_copay_amt_oemax        = 'Dental Prev OE Max Cpy Amt        '
pbp_b16a_copay_amt_oemin        = 'Dental Prev OE Min Cpy Amt        '
pbp_b16a_copay_amt_pcmax        = 'Dental Prev PC Max Cpy Amt        '
pbp_b16a_copay_amt_pcmin        = 'Dental Prev PC Min Cpy Amt        '
pbp_b16a_copay_maxamt_pos       = 'Dental Prev Max Copay Amt POS     '
pbp_b16a_copay_minamt_pos       = 'Dental Prev Min Copay Amt POS     '
pbp_b16a_copay_yesno            = 'Dental Prev Copay Yes No          '
pbp_b16a_copay_yesno_pos        = 'Dental Prev Copay Yes No POS      '
pbp_b16a_ded_amt                = 'Dental Prev Deduc Amt             '
pbp_b16a_ded_amt_pos            = 'Dental Prev Deductible Amt POS    '
pbp_b16a_ded_yesno              = 'Dental Prev Deduc Yes No          '
pbp_b16a_ded_yesno_pos          = 'Dental Prev Deduct Yes No POS     '
pbp_b16a_maxenr_amt             = 'Dental Prev Max Enr Amt           '
pbp_b16a_maxenr_amt_pos         = 'Dental Prev Max Enr Amt POS       '
pbp_b16a_maxenr_per             = 'Dental Prev Max Enr Per           '
pbp_b16a_maxenr_yesno           = 'Dental Prev Max Enr Yes No        '
pbp_b16a_maxenr_yn_pos          = 'Dental Prev Max Enr Y/N POS       '
pbp_b16a_maxplan_amt            = 'Dental Prev Max Plan Amt          '
pbp_b16a_maxplan_cov            = 'Dental Prev Max Plan Cov Bas      '
pbp_b16a_maxplan_per            = 'Dental Prev Max Plan Per          '
pbp_b16a_maxplan_yesno          = 'Dental Prev Max Plan Yes No       '
pbp_b16a_maxplan_yesno_pos      = 'Dental Prev Max Plan Y/N POS      '
pbp_b16a_maxpln_amt_pos         = 'Dental Prev Max Plan Amt POS      '
pbp_b16a_maxpln_cov_pos         = 'Dental Prev Max Plan Cov POS      '
pbp_b16a_maxpln_per_pos         = 'Dental Prev Max Pln Per POS       '
pbp_b16b_auth                   = 'Dental Comp Auth                  '
pbp_b16b_auth_pos               = 'Dental Comp Auth POS              '
pbp_b16b_bendec_ehc             = 'Dental Comp Ben Dec Enhc          '
pbp_b16b_bendesc_amo_ds         = 'Dental Comp DS Ben Des AMO        '
pbp_b16b_bendesc_amo_epe        = 'Dental Comp EPE Ben Des AMO       '
pbp_b16b_bendesc_amo_es         = 'Dental Comp ES Ben Des AMO        '
pbp_b16b_bendesc_amo_poo        = 'Dental Comp POO Ben Des AMO       '
pbp_b16b_bendesc_amo_rs         = 'Dental Comp RS Ben Des AMO        '
pbp_b16b_bendesc_lim_ds         = 'Dental Comp DS Ben Desc Lim       '
pbp_b16b_bendesc_lim_epe        = 'Dental Comp EPE Ben Desc Lim      '
pbp_b16b_bendesc_lim_es         = 'Dental Comp ES Ben Desc Lim       '
pbp_b16b_bendesc_lim_poo        = 'Dental Comp POO Ben Desc Lim      '
pbp_b16b_bendesc_lim_rs         = 'Dental Comp RS Ben Desc Lim       '
pbp_b16b_bendesc_numv_ds        = 'Dental Comp DS Ben Desc NumV      '
pbp_b16b_bendesc_numv_epe       = 'Dental Comp EPE Ben Desc NumV     '
pbp_b16b_bendesc_numv_es        = 'Dental Comp ES Ben Desc NumV      '
pbp_b16b_bendesc_numv_poo       = 'Dental Comp POO Ben Desc NumV     '
pbp_b16b_bendesc_numv_rs        = 'Dental Comp RS Ben Desc NumV      '
pbp_b16b_bendesc_per_ds         = 'Dental Comp DS Ben Desc Per       '
pbp_b16b_bendesc_per_epe        = 'Dental Comp EPE Ben Desc Per      '
pbp_b16b_bendesc_per_es         = 'Dental Comp ES Ben Desc Per       '
pbp_b16b_bendesc_per_poo        = 'Dental Comp POO Ben Desc Per      '
pbp_b16b_bendesc_per_rs         = 'Dental Comp RS Ben Desc Per       '
pbp_b16b_bendesc_yesno          = 'Dental Comp Ben Desc Yes No       '
pbp_b16b_coins_cov__pos         = 'Dental Comp Coins Cov POS         '
pbp_b16b_coins_cov_ds           = 'Dental Comp DS Coinsurance Cov    '
pbp_b16b_coins_cov_epe          = 'Dental Cmp EPE Coinsurance Cov    '
pbp_b16b_coins_cov_es           = 'Dental Comp ES Coinsurance Cov    '
pbp_b16b_coins_cov_mc           = 'Dental Comp MC Coinsurance Cov    '
pbp_b16b_coins_cov_poo          = 'Dental Cmp POO Coinsurance Cov    '
pbp_b16b_coins_cov_rs           = 'Dental Comp RS Coinsurance Cov    '
pbp_b16b_coins_pct_ds           = 'Dental Comp DS Min Coins Pct      '
pbp_b16b_coins_pct_epe          = 'Dental Cmp EPE Min Coins Pct      '
pbp_b16b_coins_pct_es           = 'Dental Comp ES Min Coins Pct      '
pbp_b16b_coins_pct_maxds        = 'Dental Comp DS Max Coins Pct      '
pbp_b16b_coins_pct_maxepe       = 'Dental Cmp EPE Max Coins Pct      '
pbp_b16b_coins_pct_maxes        = 'Dental Comp ES Max Coins Pct      '
pbp_b16b_coins_pct_maxpoo       = 'Dental Cmp POO Max Coins Pct      '
pbp_b16b_coins_pct_maxrs        = 'Dental Comp RS Max Coins Pct      '
pbp_b16b_coins_pct_mc           = 'Dental Comp MC Min Coins Pct      '
pbp_b16b_coins_pct_poo          = 'Dental Cmp POO Min Coins Pct      '
pbp_b16b_coins_pct_pos          = 'Dental Comp Min Coin Pct POS      '
pbp_b16b_coins_pct_rs           = 'Dental Comp RS Min Coins Pct      '
pbp_b16b_coins_pctmax_mc        = 'Dental Comp MC Max Coins Pct      '
pbp_b16b_coins_pctmax_pos       = 'Dental Comp Max Coin Pct POS      '
pbp_b16b_coins_yesno            = 'Dental Comp Coinsurance YN        '
pbp_b16b_coins_yesno_pos        = 'Dental Comp Coinsurance YN POS    '
pbp_b16b_copay_amt_dsmax        = 'Dental Comp DS Max Cpy Amt        '
pbp_b16b_copay_amt_dsmin        = 'Dental Comp DS Min Cpy Amt        '
pbp_b16b_copay_amt_epemax       = 'Dental Comp EPE Max Cpy Amt       '
pbp_b16b_copay_amt_epemin       = 'Dental Comp EPE Min Cpy Amt       '
pbp_b16b_copay_amt_esmax        = 'Dental Comp ES Max Cpy Amt        '
pbp_b16b_copay_amt_esmin        = 'Dental Comp ES Min Cpy Amt        '
pbp_b16b_copay_amt_poomax       = 'Dental Comp POO Max Cpy Amt       '
pbp_b16b_copay_amt_poomin       = 'Dental Comp POO Min Cpy Amt       '
pbp_b16b_copay_amt_rsmax        = 'Dental Comp RS Max Cpy Amt        '
pbp_b16b_copay_amt_rsmin        = 'Dental Comp RS Min Cpy Amt        '
pbp_b16b_copay_maxamt_pos       = 'Dental Comp Max Copay Amt POS     '
pbp_b16b_copay_mc_amt           = 'Dental Comp MC Min Cpy Amt        '
pbp_b16b_copay_mcmax_amt        = 'Dental Comp MC Max Cpy Amt        '
pbp_b16b_copay_minamt_pos       = 'Dental Comp Min Copay Amt POS     '
pbp_b16b_copay_yesno            = 'Dental Cmp Copay Yes No           '
pbp_b16b_copay_yesno_pos        = 'Dental Comp Copay Yes No POS      '
pbp_b16b_ded_amt                = 'Dental Comp Deductible Amt        '
pbp_b16b_ded_amt_pos            = 'Dental Comp Deductible Amt POS    '
pbp_b16b_ded_yesno              = 'Dental Cmp Deduc Yes No           '
pbp_b16b_ded_yesno_pos          = 'Dental Cmp Deduc Yes No POS       '
pbp_b16b_maxbene_type           = 'Dental Comp Max Bene Type         '
pbp_b16b_maxenr_amt             = 'Dental Comp Max Enr Amt           '
pbp_b16b_maxenr_amt_pos         = 'Dental Comp Max Enr Amt POS       '
pbp_b16b_maxenr_per             = 'Dental Comp Max Enr Per           '
pbp_b16b_maxenr_type            = 'Dental Comp Max Enr Type          '
pbp_b16b_maxenr_type_pos        = 'Dental Comp Max Enr Type POS      '
pbp_b16b_maxenr_yesno           = 'Dental Comp Max Enr Yes No        '
pbp_b16b_maxenr_yesno_pos       = 'Dental Comp Max Enr Yes No POS    '
pbp_b16b_maxplan_amt            = 'Dental Comp Max Plan Amt          '
pbp_b16b_maxplan_covb           = 'Dental Comp Max Plan Cov Bas      '
pbp_b16b_maxplan_per            = 'Dental Comp Max Pln Per           '
pbp_b16b_maxplan_type_pos       = 'Dental Comp Max Plan Type POS     '
pbp_b16b_maxplan_yesno          = 'Dental Comp Max Plan Yes No       '
pbp_b16b_maxplan_yesno_pos      = 'Dental Comp Max Plan Y/N POS      '
pbp_b16b_maxpln_amt_pos         = 'Dental Comp Max Plan Amt POS      '
pbp_b16b_maxpln_cov_pos         = 'Dental Comp Max Plan Cov POS      '
pbp_b16b_maxpln_per_pos         = 'Dental Comp Max Pln Per POS       '
;
run;

proc sort data = pbp_b16 out = out.pbp_b16;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b16(obs = 10);
  title 'pbp b16 data';
run;

proc means data =  out.pbp_b16;
  title 'pbp b16 file';
run;

proc freq data = out.pbp_b16;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b16a_bendesc_yesno
  pbp_b16a_bendec_ehc
  pbp_b16a_bendesc_amo_pc
  pbp_b16a_bendesc_lim_pc
  pbp_b16a_bendesc_per_pc
  pbp_b16a_bendesc_amo_ft
  pbp_b16a_bendesc_lim_ft
  pbp_b16a_bendesc_per_ft
  pbp_b16a_bendesc_amo_dx
  pbp_b16a_bendesc_lim_dx
  pbp_b16a_bendesc_per_dx
  pbp_b16a_bendesc_amo_oe
  pbp_b16a_bendesc_lim_oe
  pbp_b16a_bendesc_per_oe
  pbp_b16a_maxplan_yesno
  pbp_b16a_maxplan_per
  pbp_b16a_maxplan_cov
  pbp_b16a_maxenr_yesno
  pbp_b16a_maxenr_per
  pbp_b16a_coins_yesno
  pbp_b16a_coins_cov_pc
  pbp_b16a_coins_cov_ft
  pbp_b16a_coins_cov_dx
  pbp_b16a_coins_cov_oe
  pbp_b16a_ded_yesno
  pbp_b16a_copay_yesno
  pbp_b16a_auth
  pbp_b16a_maxplan_yesno_pos
  pbp_b16a_maxpln_per_pos
  pbp_b16a_maxpln_cov_pos
  pbp_b16a_maxenr_yn_pos
  pbp_b16a_coins_yesno_pos
  pbp_b16a_coins_cov__pos
  pbp_b16a_ded_yesno_pos
  pbp_b16a_copay_yesno_pos / missing;
run;

proc contents data = out.pbp_b16;
  title 'pbp b16 data';
run;
