*pbp_b17.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b17;

length
   pbp_a_hnumber                           $5
   pbp_a_plan_identifier                   $3
   pbp_a_ben_cov                           $1
   pbp_a_plan_type                         $2
   orgtype                                 $2
   pbp_b17a_bendec_yesno                   $1
   pbp_b17a_bendec_enh                     $1
   pbp_b17a_bendesc_rex_amo                $1
   pbp_b17a_bendesc_lim                    $1
   pbp_b17a_bendesc_per                    $1
   pbp_b17a_maxplan_yesno                  $1
   pbp_b17a_maxplan_per                    $1
   pbp_b17a_maxplan_cov                    $1
   pbp_b17a_maxenr_yesno                   $1
   pbp_b17a_maxenr_per                     $1
   pbp_b17a_coins_yesno                    $1
   pbp_b17a_coins_mccov                    $1
   pbp_b17a_coins_rexcov                   $1
   pbp_b17a_ded_yesno                      $1
   pbp_b17a_copay_yesno                    $1
   pbp_b17a_auth                           $5
   pbp_b17a_maxplan_yesno_pos              $1
   pbp_b17a_maxpln_per_pos                 $1
   pbp_b17a_maxpln_cov_pos                 $1
   pbp_b17a_maxenr_yn_pos                  $1
   pbp_b17a_coins_yesno_pos                $1
   pbp_b17a_coins_cov__pos                 $1
   pbp_b17a_ded_yesno_pos                  $1
   pbp_b17a_copay_yesno_pos                $1
   pbp_b17a_auth_pos                       $5
   pbp_b17b_bendec_yesno                   $1
   pbp_b17b_bendec_enh                     $5
   pbp_b17b_bendesc_cl_amo                 $1
   pbp_b17b_bendesc_lim_cl                 $1
   pbp_b17b_bendesc_per_cl                 $1
   pbp_b17b_bendesc_amo_egs                $1
   pbp_b17b_bendesc_lim_egs                $1
   pbp_b17b_bendesc_per_egs                $1
   pbp_b17b_bendesc_amo_egi                $1
   pbp_b17b_bendesc_lim_egl                $1
   pbp_b17b_bendesc_per_egl                $1
   pbp_b17b_bendesc_amo_egf                $1
   pbp_b17b_bendesc_lim_egf                $1
   pbp_b17b_bendesc_per_egf                $1
   pbp_b17b_bendesc_amo_upg                $1
   pbp_b17b_maxplan_yesno                  $1
   pbp_b17b_maxplan_per                    $1
   pbp_b17b_maxplan_cov                    $1
   pbp_b17b_maxenr_yesno                   $1
   pbp_b17b_maxenr_type                    $1
   pbp_b17b_maxenr_per                     $1
   pbp_b17b_disct_yesno                    $1
   pbp_b17b_disct_cov_mc                   $1
   pbp_b17b_disct_cov_cl                   $1
   pbp_b17b_disct_cov_egs                  $1
   pbp_b17b_disct_cov_egl                  $1
   pbp_b17b_disct_cov_egf                  $1
   pbp_b17b_disct_cov_upg                  $1
   pbp_b17b_ded_yesno                      $1
   pbp_b17b_copay_yesno                    $1
   pbp_b17b_auth                           $5
   pbp_b17b_maxplan_yesno_pos              $1
   pbp_b17b_maxpln_per_pos                 $1
   pbp_b17b_maxpln_cov_pos                 $1
   pbp_b17b_maxenr_yn_pos                  $1
   pbp_b17b_maxenr_type_pos                $1
   pbp_b17b_disct_yesno_pos                $1
   pbp_b17b_disct_cov__pos                 $1
   pbp_b17b_ded_yesno_pos                  $1
   pbp_b17b_copay_yesno_pos                $1
   pbp_b17b_auth_pos                       $5
;

  infile '.\pbp\pbp_b17_eye_exams_wear.txt'
         delimiter = '09'x dsd lrecl = 20000 firstobs = 2 missover;
input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b17a_bendec_yesno
   pbp_b17a_bendec_enh
   pbp_b17a_bendesc_rex_amo
   pbp_b17a_bendesc_lim
   pbp_b17a_bendesc_numv
   pbp_b17a_bendesc_per
   pbp_b17a_maxplan_yesno
   pbp_b17a_maxplan_amt
   pbp_b17a_maxplan_per
   pbp_b17a_maxplan_cov
   pbp_b17a_maxenr_yesno
   pbp_b17a_maxenr_amt
   pbp_b17a_maxenr_per
   pbp_b17a_coins_yesno
   pbp_b17a_coins_mcmin_pct
   pbp_b17a_coins_mcmax_pct
   pbp_b17a_coins_mccov
   pbp_b17a_coins_rexmin_pct
   pbp_b17a_coins_rexmax_pct
   pbp_b17a_coins_rexcov
   pbp_b17a_ded_yesno
   pbp_b17a_ded_amt
   pbp_b17a_copay_yesno
   pbp_b17a_copay_mcminamt
   pbp_b17a_copay_mcmaxamt
   pbp_b17a_copay_rexmin_amt
   pbp_b17a_copay_rexmax_amt
   pbp_b17a_auth
   pbp_b17a_maxplan_yesno_pos
   pbp_b17a_maxpln_amt_pos
   pbp_b17a_maxpln_per_pos
   pbp_b17a_maxpln_cov_pos
   pbp_b17a_maxenr_yn_pos
   pbp_b17a_maxenr_amt_pos
   pbp_b17a_coins_yesno_pos
   pbp_b17a_coins_pct_pos
   pbp_b17a_coins_cov__pos
   pbp_b17a_ded_yesno_pos
   pbp_b17a_ded_amt_pos
   pbp_b17a_copay_yesno_pos
   pbp_b17a_copay_rexamt_pos
   pbp_b17a_auth_pos
   pbp_b17b_bendec_yesno
   pbp_b17b_bendec_enh
   pbp_b17b_bendesc_cl_amo
   pbp_b17b_bendesc_lim_cl
   pbp_b17b_bendesc_numv_cl
   pbp_b17b_bendesc_per_cl
   pbp_b17b_bendesc_amo_egs
   pbp_b17b_bendesc_lim_egs
   pbp_b17b_bendesc_numv_egs
   pbp_b17b_bendesc_per_egs
   pbp_b17b_bendesc_amo_egi
   pbp_b17b_bendesc_lim_egl
   pbp_b17b_bendesc_numv_egl
   pbp_b17b_bendesc_per_egl
   pbp_b17b_bendesc_amo_egf
   pbp_b17b_bendesc_lim_egf
   pbp_b17b_bendesc_numv_egf
   pbp_b17b_bendesc_per_egf
   pbp_b17b_bendesc_amo_upg
   pbp_b17b_maxplan_yesno
   pbp_b17b_maxplan_amt
   pbp_b17b_maxplan_per
   pbp_b17b_maxplan_cov
   pbp_b17b_maxplan_pct
   pbp_b17b_maxenr_yesno
   pbp_b17b_maxenr_type
   pbp_b17b_maxenr_amt
   pbp_b17b_maxenr_per
   pbp_b17b_disct_yesno
   pbp_b17b_disct_pct_mc
   pbp_b17b_disct_cov_mc
   pbp_b17b_disct_pct_cl
   pbp_b17b_disct_cov_cl
   pbp_b17b_disct_pct_egs
   pbp_b17b_disct_cov_egs
   pbp_b17b_disct_pct_egl
   pbp_b17b_disct_cov_egl
   pbp_b17b_disct_pct_egf
   pbp_b17b_disct_cov_egf
   pbp_b17b_disct_pct_upg
   pbp_b17b_disct_cov_upg
   pbp_b17b_ded_yesno
   pbp_b17b_ded_amt
   pbp_b17b_copay_yesno
   pbp_b17b_copay_amt_mc
   pbp_b17b_copay_amt_cl
   pbp_b17b_copay_amt_egs
   pbp_b17b_copay_amt_egl
   pbp_b17b_copay_amt_egf
   pbp_b17b_copay_amt_upg
   pbp_b17b_auth
   pbp_b17b_maxplan_yesno_pos
   pbp_b17b_maxpln_amt_pos
   pbp_b17b_maxpln_per_pos
   pbp_b17b_maxpln_cov_pos
   pbp_b17b_maxplan_pctprp_pos
   pbp_b17b_maxenr_yn_pos
   pbp_b17b_maxenr_type_pos
   pbp_b17b_maxenr_amt_pos
   pbp_b17b_disct_yesno_pos
   pbp_b17b_disct_pct_pos
   pbp_b17b_disct_pctmax_pos
   pbp_b17b_disct_cov__pos
   pbp_b17b_ded_yesno_pos
   pbp_b17b_ded_amt_pos
   pbp_b17b_copay_yesno_pos
   pbp_b17b_copay_amt_pos
   pbp_b17b_copay_amtmax_pos
   pbp_b17b_auth_pos
;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b17a_auth                   = 'Eye Exams Auth                    '
pbp_b17a_auth_pos               = 'Eye Exams Auth POS                '
pbp_b17a_bendec_enh             = 'Eye Exams Ben Dec                 '
pbp_b17a_bendec_yesno           = 'Eye Exams Ben Des Yes No          '
pbp_b17a_bendesc_lim            = 'Eye Exams Ben Desc Lim            '
pbp_b17a_bendesc_numv           = 'Eye Exams Ben Desc NumV           '
pbp_b17a_bendesc_per            = 'Eye Exams Ben Desc Per            '
pbp_b17a_bendesc_rex_amo        = 'Eye Exams Ben Des AMO REX         '
pbp_b17a_coins_cov__pos         = 'Eye Exams Coins Cov POS           '
pbp_b17a_coins_mccov            = 'Eye Exams MC Coinsurance Cov      '
pbp_b17a_coins_mcmax_pct        = 'Eye Exams MC Max Coins Pct        '
pbp_b17a_coins_mcmin_pct        = 'Eye Exams MC Min Coins Pct        '
pbp_b17a_coins_pct_pos          = 'Eye Exams Coin Pct POS            '
pbp_b17a_coins_rexcov           = 'Eye Exams REX Coinsurance Cov     '
pbp_b17a_coins_rexmax_pct       = 'Eye Exams REX Max Coins Pct       '
pbp_b17a_coins_rexmin_pct       = 'Eye Exams REX Min Coins Pct       '
pbp_b17a_coins_yesno            = 'Eye Exams Coinsurance YN          '
pbp_b17a_coins_yesno_pos        = 'Eye Exams Coinsurance YN POS      '
pbp_b17a_copay_mcmaxamt         = 'Eye Exams MC Max Copay Amt        '
pbp_b17a_copay_mcminamt         = 'Eye Exams MC Min Copay Amt        '
pbp_b17a_copay_rexamt_pos       = 'Eye Exams Rex Copay Amt POS       '
pbp_b17a_copay_rexmax_amt       = 'Eye Exams REX Max Copay Amt       '
pbp_b17a_copay_rexmin_amt       = 'Eye Exams REX Min Copay Amt       '
pbp_b17a_copay_yesno            = 'Eye Exams Copay Yes No            '
pbp_b17a_copay_yesno_pos        = 'Eye Exams Copay Yes No POS        '
pbp_b17a_ded_amt                = 'Eye Exams Deduc Amt               '
pbp_b17a_ded_amt_pos            = 'Eye Exams Deductible Amt POS      '
pbp_b17a_ded_yesno              = 'Eye Exams Deduc Yes No            '
pbp_b17a_ded_yesno_pos          = 'Eye Exams Deduct Yes No POS       '
pbp_b17a_maxenr_amt             = 'Eye Exams Max Enr Amt             '
pbp_b17a_maxenr_amt_pos         = 'Eye Exams Max Enr Amt POS         '
pbp_b17a_maxenr_per             = 'Eye Exams Max Enr Per             '
pbp_b17a_maxenr_yesno           = 'Eye Exams Max Enr Yes No          '
pbp_b17a_maxenr_yn_pos          = 'Eye Exams Max Enr Y/N POS         '
pbp_b17a_maxplan_amt            = 'Eye Exams Max Plan Amt            '
pbp_b17a_maxplan_cov            = 'Eye Exams Max Plan Cov            '
pbp_b17a_maxplan_per            = 'Eye Exams Max Plan Per            '
pbp_b17a_maxplan_yesno          = 'Eye Exams Max Plan Yes No         '
pbp_b17a_maxplan_yesno_pos      = 'Eye Exams Max Plan Y/N POS        '
pbp_b17a_maxpln_amt_pos         = 'Eye Exams Max Plan Amt POS        '
pbp_b17a_maxpln_cov_pos         = 'Eye Exams Max Plan Cov POS        '
pbp_b17a_maxpln_per_pos         = 'Eye Exams Max Pln Per POS         '
pbp_b17b_auth                   = 'Eye Wear Auth                     '
pbp_b17b_auth_pos               = 'Eye Wear Auth POS                 '
pbp_b17b_bendec_enh             = 'Eye Wear Ben Dec                  '
pbp_b17b_bendec_yesno           = 'Eye Wear Ben Des Yes No           '
pbp_b17b_bendesc_amo_egf        = 'Eye Wear Ben Des AMO EGF          '
pbp_b17b_bendesc_amo_egi        = 'Eye Wear Ben Des AMO EGL          '
pbp_b17b_bendesc_amo_egs        = 'Eye Wear Ben Des AMO EGS          '
pbp_b17b_bendesc_amo_upg        = 'Eye Wear Ben Des AMO UPG          '
pbp_b17b_bendesc_cl_amo         = 'Eye Wear Ben Des AMO CL           '
pbp_b17b_bendesc_lim_cl         = 'Eye Wear CL Ben Desc Lim          '
pbp_b17b_bendesc_lim_egf        = 'Eye Wear EGF Ben Desc Lim         '
pbp_b17b_bendesc_lim_egl        = 'Eye Wear EGL Ben Desc Lim         '
pbp_b17b_bendesc_lim_egs        = 'Eye Wear EGS Ben Desc Lim         '
pbp_b17b_bendesc_numv_cl        = 'Eye Wear CL Ben Desc NumV         '
pbp_b17b_bendesc_numv_egf       = 'Eye Wear EGF Ben Desc NumV        '
pbp_b17b_bendesc_numv_egl       = 'Eye Wear EGL Ben Desc NumV        '
pbp_b17b_bendesc_numv_egs       = 'Eye Wear EGS Ben Desc NumV        '
pbp_b17b_bendesc_per_cl         = 'Eye Wear CL Ben Desc Per          '
pbp_b17b_bendesc_per_egf        = 'Eye Wear EGF Ben Desc Per         '
pbp_b17b_bendesc_per_egl        = 'Eye Wear EGL Ben Desc Per         '
pbp_b17b_bendesc_per_egs        = 'Eye Wear EGS Ben Desc Per         '
pbp_b17b_copay_amt_cl           = 'Eye Wear Copay Amt CL             '
pbp_b17b_copay_amt_egf          = 'Eye Wear Copay Amt EGF            '
pbp_b17b_copay_amt_egl          = 'Eye Wear Copay Amt EGL            '
pbp_b17b_copay_amt_egs          = 'Eye Wear Copay Amt EGS            '
pbp_b17b_copay_amt_mc           = 'Eye Wear Copay Amt MC             '
pbp_b17b_copay_amt_pos          = 'Eye Wear Min Copay Amt POS        '
pbp_b17b_copay_amt_upg          = 'Eye Wear Copay Amt UPG            '
pbp_b17b_copay_amtmax_pos       = 'Eye Wear Max Copay Amt POS        '
pbp_b17b_copay_yesno            = 'Eye Exams Copay Yes No            '
pbp_b17b_copay_yesno_pos        = 'Eye Wear Copay Yes No POS         '
pbp_b17b_ded_amt                = 'Eye Wear Deduc Amt                '
pbp_b17b_ded_amt_pos            = 'Eye Wear Deductible Amt POS       '
pbp_b17b_ded_yesno              = 'Eye Wear Deduc Yes No             '
pbp_b17b_ded_yesno_pos          = 'Eye Wear Deduct Yes No POS        '
pbp_b17b_disct_cov__pos         = 'Eye Exams Coins Cov POS           '
pbp_b17b_disct_cov_cl           = 'Eye Wear Coins Cov CL             '
pbp_b17b_disct_cov_egf          = 'Eye Wear Coins Cov EGF            '
pbp_b17b_disct_cov_egl          = 'Eye Wear Coins Cov EGL            '
pbp_b17b_disct_cov_egs          = 'Eye Wear Coins Cov EGS            '
pbp_b17b_disct_cov_mc           = 'Eye Wear Coins Cov MC             '
pbp_b17b_disct_cov_upg          = 'Eye Wear Coins Cov UPG            '
pbp_b17b_disct_pct_cl           = 'Eye Wear Coins Pct CL             '
pbp_b17b_disct_pct_egf          = 'Eye Wear Coins Pct EGF            '
pbp_b17b_disct_pct_egl          = 'Eye Wear Coins Pct EGL            '
pbp_b17b_disct_pct_egs          = 'Eye Wear Coins Pct EGS            '
pbp_b17b_disct_pct_mc           = 'Eye Wear Coins Pct MC             '
pbp_b17b_disct_pct_pos          = 'Eye Exams Min Coins Pct POS       '
pbp_b17b_disct_pct_upg          = 'Eye Wear Coins Pct UPG            '
pbp_b17b_disct_pctmax_pos       = 'Eye Exams Max Coins Pct POS       '
pbp_b17b_disct_yesno            = 'Eye Wear Coins YN                 '
pbp_b17b_disct_yesno_pos        = 'Eye Wear Coinsurance YN POS       '
pbp_b17b_maxenr_amt             = 'Eye Wear Max Enr Amt              '
pbp_b17b_maxenr_amt_pos         = 'Eye Wear Max Enr Amt POS          '
pbp_b17b_maxenr_per             = 'Eye Wear Max Enr Per              '
pbp_b17b_maxenr_type            = 'Hearing Aids Max Enr Type         '
pbp_b17b_maxenr_type_pos        = 'Hearing Aids Max Enr Type POS     '
pbp_b17b_maxenr_yesno           = 'Eye Wear Max Enr Yes No           '
pbp_b17b_maxenr_yn_pos          = 'Eye Wear Max Enr Y/N POS          '
pbp_b17b_maxplan_amt            = 'Eye Wear Max Plan Amt             '
pbp_b17b_maxplan_cov            = 'Eye Wear Max Plan Cov             '
pbp_b17b_maxplan_pct            = 'Eye Wear Max Plan Pct             '
pbp_b17b_maxplan_pctprp_pos     = 'Eye Wear Max Plan PRP Pct POS     '
pbp_b17b_maxplan_per            = 'Eye Wear Max Plan Per             '
pbp_b17b_maxplan_yesno          = 'Eye Wear Max Plan Yes No          '
pbp_b17b_maxplan_yesno_pos      = 'Eye Wear Max Plan Y/N POS         '
pbp_b17b_maxpln_amt_pos         = 'Eye Wear Max Plan Amt POS         '
pbp_b17b_maxpln_cov_pos         = 'Eye Wear Max Plan Cov POS         '
pbp_b17b_maxpln_per_pos         = 'Eye Wear Max Pln Per POS          '
;
run;

proc sort data = pbp_b17 out = out.pbp_b17;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b17(obs = 10);
  title 'pbp b17 data';
run;

proc means data =  out.pbp_b17;
  title 'pbp b17 file';
run;

proc freq data = out.pbp_b17;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b17a_bendec_yesno
  pbp_b17a_bendec_enh
  pbp_b17a_bendesc_rex_amo
  pbp_b17a_bendesc_lim
  pbp_b17a_bendesc_per
  pbp_b17a_maxplan_yesno
  pbp_b17a_maxplan_per
  pbp_b17a_maxplan_cov
  pbp_b17a_maxenr_yesno
  pbp_b17a_maxenr_per
  pbp_b17a_coins_yesno
  pbp_b17a_coins_mccov / missing;
run;

proc contents data = out.pbp_b17;
  title 'pbp b17 data';
run;
