*pbp_b18.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b18;

length
   pbp_a_hnumber                       $5
   pbp_a_plan_identifier               $3
   pbp_a_ben_cov                       $1
   pbp_a_plan_type                     $2
   orgtype                             $2
   pbp_b18a_bendec_yesno               $1
   pbp_b18a_bendec_enh                 $2
   pbp_b18a_bendesc_rht_amo            $1
   pbp_b18a_bendesc_lim_rht            $1
   pbp_b18a_bendesc_per_rht            $1
   pbp_b18a_bendesc_fha_amo            $1
   pbp_b18a_bendesc_lim_fha            $1
   pbp_b18a_bendesc_per_fha            $1
   pbp_b18a_maxplan_yesno              $1
   pbp_b18a_maxplan_per                $1
   pbp_b18a_maxplan_cov                $1
   pbp_b18a_maxenr_yesno               $1
   pbp_b18a_maxenr_per                 $1
   pbp_b18a_coins_yesno                $1
   pbp_b18a_coins_cov                  $1
   pbp_b18a_coins_cov_rht              $1
   pbp_b18a_coins_cov_fha              $1
   pbp_b18a_ded_yesno                  $1
   pbp_b18a_copay_yesno                $1
   pbp_b18a_auth                       $5
   pbp_b18a_maxplan_yesno_pos          $1
   pbp_b18a_maxpln_per_pos             $1
   pbp_b18a_maxpln_cov_pos             $1
   pbp_b18a_maxenr_yn_pos              $1
   pbp_b18a_coins_yesno_pos            $1
   pbp_b18a_coins_cov_pos              $1
   pbp_b18a_ded_yesno_pos              $1
   pbp_b18a_copay_yesno_pos            $1
   pbp_b18a_auth_pos                   $5
   pbp_b18b_bendec_yesno               $1
   pbp_b18b_bendec_enh                 $4
   pbp_b18b_bendesc_ie_amo             $1
   pbp_b18b_bendesc_lim_ie             $1
   pbp_b18b_bendesc_per_ie             $1
   pbp_b18b_bendesc_oe_amo             $1
   pbp_b18b_bendesc_lim_oe             $1
   pbp_b18b_bendesc_per_oe             $1
   pbp_b18b_bendesc_ote_amo            $1
   pbp_b18b_bendesc_lim_ote            $1
   pbp_b18b_bendesc_per_ote            $1
   pbp_b18b_bendesc_rb_amo             $1
   pbp_b18b_bendesc_lim_rb             $1
   pbp_b18b_bendesc_per_rb             $1
   pbp_b18b_maxplan_yesno              $1
   pbp_b18b_maxplan_type               $1
   pbp_b18b_maxplan_per                $1
   pbp_b18b_maxplan_cov                $1
   pbp_b18b_maxenr_yesno               $1
   pbp_b18b_maxenr_type                $1
   pbp_b18b_maxenr_per                 $1
   pbp_b18b_disct_yesno                $1
   pbp_b18b_disct_cov_ie               $1
   pbp_b18b_disct_cov_oe               $1
   pbp_b18b_disct_cov_ote              $1
   pbp_b18b_disct_cov_rb               $1
   pbp_b18b_ded_yesno                  $1
   pbp_b18b_copay_yesno                $1
   pbp_b18b_auth                       $5
   pbp_b18b_maxplan_yesno_pos          $1
   pbp_b18b_maxplan_type_pos           $1
   pbp_b18b_maxpln_per_pos             $1
   pbp_b18b_maxpln_cov_pos             $1
   pbp_b18b_maxenr_yn_pos              $1
   pbp_b18b_maxenr_type_pos            $1
   pbp_b18b_disct_yesno_pos            $1
   pbp_b18b_disct_cov_pos              $1
   pbp_b18b_ded_yesno_pos              $1
   pbp_b18b_copay_yesno_pos            $1
   pbp_b18b_auth_pos                   $5
;

infile '.\pbp\pbp_b18_hearing_exams_aids.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b18a_bendec_yesno
   pbp_b18a_bendec_enh
   pbp_b18a_bendesc_rht_amo
   pbp_b18a_bendesc_lim_rht
   pbp_b18a_bendesc_numv_cl
   pbp_b18a_bendesc_per_rht
   pbp_b18a_bendesc_fha_amo
   pbp_b18a_bendesc_lim_fha
   pbp_b18a_bendesc_numv_fha
   pbp_b18a_bendesc_per_fha
   pbp_b18a_maxplan_yesno
   pbp_b18a_maxplan_amt
   pbp_b18a_maxplan_per
   pbp_b18a_maxplan_cov
   pbp_b18a_maxenr_yesno
   pbp_b18a_maxenr_amt
   pbp_b18a_maxenr_per
   pbp_b18a_coins_yesno
   pbp_b18a_med_coins_pct
   pbp_b18a_coins_cov
   pbp_b18a_coins_pct_rht
   pbp_b18a_coins_pct_max_rht
   pbp_b18a_coins_cov_rht
   pbp_b18a_coins_pct_fha
   pbp_b18a_coins_pct_max_fha
   pbp_b18a_coins_cov_fha
   pbp_b18a_ded_yesno
   pbp_b18a_ded_amt
   pbp_b18a_copay_yesno
   pbp_b18a_copay_amt
   pbp_b18a_copay_amt_rht
   pbp_b18a_copay_amt_max_rht
   pbp_b18a_copay_amt_fha
   pbp_b18a_copay_amt_max_fha
   pbp_b18a_auth
   pbp_b18a_maxplan_yesno_pos
   pbp_b18a_maxpln_amt_pos
   pbp_b18a_maxpln_per_pos
   pbp_b18a_maxpln_cov_pos
   pbp_b18a_maxenr_yn_pos
   pbp_b18a_maxenr_amt_pos
   pbp_b18a_coins_yesno_pos
   pbp_b18a_coins_pct_pos
   pbp_b18a_coins_pctmax_pos
   pbp_b18a_coins_cov_pos
   pbp_b18a_ded_yesno_pos
   pbp_b18a_ded_amt_pos
   pbp_b18a_copay_yesno_pos
   pbp_b18a_copay_amt_pos
   pbp_b18a_copay_amtmax_pos
   pbp_b18a_auth_pos
   pbp_b18b_bendec_yesno
   pbp_b18b_bendec_enh
   pbp_b18b_bendesc_ie_amo
   pbp_b18b_bendesc_lim_ie
   pbp_b18b_bendesc_numv_ie
   pbp_b18b_bendesc_per_ie
   pbp_b18b_bendesc_oe_amo
   pbp_b18b_bendesc_lim_oe
   pbp_b18b_bendesc_numv_oe
   pbp_b18b_bendesc_per_oe
   pbp_b18b_bendesc_ote_amo
   pbp_b18b_bendesc_lim_ote
   pbp_b18b_bendesc_numv_ote
   pbp_b18b_bendesc_per_ote
   pbp_b18b_bendesc_rb_amo
   pbp_b18b_bendesc_lim_rb
   pbp_b18b_bendesc_numv_rb
   pbp_b18b_bendesc_per_rb
   pbp_b18b_maxplan_yesno
   pbp_b18b_maxplan_type
   pbp_b18b_maxplan_amt
   pbp_b18b_maxplan_per
   pbp_b18b_maxplan_cov
   pbp_b18b_maxplan_pct
   pbp_b18b_maxenr_yesno
   pbp_b18b_maxenr_type
   pbp_b18b_maxenr_amt
   pbp_b18b_maxenr_per
   pbp_b18b_disct_yesno
   pbp_b18b_disct_pct_ie
   pbp_b18b_disct_cov_ie
   pbp_b18b_disct_pct_oe
   pbp_b18b_disct_cov_oe
   pbp_b18b_disct_pct_ote
   pbp_b18b_disct_cov_ote
   pbp_b18b_disct_pct_rb
   pbp_b18b_disct_cov_rb
   pbp_b18b_ded_yesno
   pbp_b18b_ded_amt
   pbp_b18b_copay_yesno
   pbp_b18b_copay_amt_per_ie
   pbp_b18b_copay_amt_per2_ie
   pbp_b18b_copay_amt_per_oe
   pbp_b18b_copay_amt_per2_oe
   pbp_b18b_copay_amt_per_ote
   pbp_b18b_copay_amt_per2_ote
   pbp_b18b_copay_amt_per_rb
   pbp_b18b_copay_amt_per2_rb
   pbp_b18b_auth
   pbp_b18b_maxplan_yesno_pos
   pbp_b18b_maxplan_type_pos
   pbp_b18b_maxpln_amt_pos
   pbp_b18b_maxpln_per_pos
   pbp_b18b_maxpln_cov_pos
   pbp_b18b_maxplan_pctprp_pos
   pbp_b18b_maxenr_yn_pos
   pbp_b18b_maxenr_type_pos
   pbp_b18b_maxenr_amt_pos
   pbp_b18b_disct_yesno_pos
   pbp_b18b_disct_pct_pos
   pbp_b18b_disct_pctmax_pos
   pbp_b18b_disct_cov_pos
   pbp_b18b_disct_pctprp_pos
   pbp_b18b_ded_yesno_pos
   pbp_b18b_ded_amt_pos
   pbp_b18b_copay_yesno_pos
   pbp_b18b_copay_amt_pos
   pbp_b18b_copay_amtmax_pos
   pbp_b18b_auth_pos
;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b18a_auth                   = 'Hearing Exams Auth                '
pbp_b18a_auth_pos               = 'Hearing Exams Auth POS            '
pbp_b18a_bendec_enh             = 'Hearing Exams Ben Dec             '
pbp_b18a_bendec_yesno           = 'Hearing Exams Ben Des Yes No      '
pbp_b18a_bendesc_fha_amo        = 'Hearing Exams Ben Des AMO FHA     '
pbp_b18a_bendesc_lim_fha        = 'Hearing Exams FHA Ben Desc Lim    '
pbp_b18a_bendesc_lim_rht        = 'Hearing Exams RHT Ben Desc Lim    '
pbp_b18a_bendesc_numv_cl        = 'Hearing Exams RHT Ben Dsc NumV    '
pbp_b18a_bendesc_numv_fha       = 'Hearing Exams FHA Ben Dsc NumV    '
pbp_b18a_bendesc_per_fha        = 'Hearing Exams FHA Ben Desc Per    '
pbp_b18a_bendesc_per_rht        = 'Hearing Exams RHT Ben Desc Per    '
pbp_b18a_bendesc_rht_amo        = 'Hearing Exams Ben Des AMO RHT     '
pbp_b18a_coins_cov              = 'Hearing Exms Coins Cov            '
pbp_b18a_coins_cov_fha          = 'Hearing Exms Coins Cov FHA        '
pbp_b18a_coins_cov_pos          = 'Hearing Exams Coins Cov POS       '
pbp_b18a_coins_cov_rht          = 'Hearing Exms Coins Cov RHT        '
pbp_b18a_coins_pct_fha          = 'Hearing Exms Min Coins Pct FHA    '
pbp_b18a_coins_pct_max_fha      = 'Hearing Exms Max Coins Pct FHA    '
pbp_b18a_coins_pct_max_rht      = 'Hearing Exms Max Coins Pct RHT    '
pbp_b18a_coins_pct_pos          = 'Hearing Exams Min Coin Pct POS    '
pbp_b18a_coins_pct_rht          = 'Hearing Exms Min Coins Pct RHT    '
pbp_b18a_coins_pctmax_pos       = 'Hearing Exams Max Coin Pct POS    '
pbp_b18a_coins_yesno            = 'Hearing Exams Coinsurance YN      '
pbp_b18a_coins_yesno_pos        = 'Hearing Exams Coinsurance YN POS  '
pbp_b18a_copay_amt              = 'Hearing Exms Medicar Copay Amt    '
pbp_b18a_copay_amt_fha          = 'Hearing Exms Min Copay Amt FHA    '
pbp_b18a_copay_amt_max_fha      = 'Hearing Exms Max Copay Amt FHA    '
pbp_b18a_copay_amt_max_rht      = 'Hearing Exms Max Copay Amt RHT    '
pbp_b18a_copay_amt_pos          = 'Hearing Exams Min Copay Amt POS   '
pbp_b18a_copay_amt_rht          = 'Hearing Exms Min Copay Amt RHT    '
pbp_b18a_copay_amtmax_pos       = 'Hearing Exams Max Copay Amt POS   '
pbp_b18a_copay_yesno            = 'Hearing Exams Copay Yes No        '
pbp_b18a_copay_yesno_pos        = 'Hearing Exams Copay Yes No POS    '
pbp_b18a_ded_amt                = 'Hearing Exams Deduc Amt           '
pbp_b18a_ded_amt_pos            = 'Hearing Exams Deductible Amt POS  '
pbp_b18a_ded_yesno              = 'Hearing Exams Deduc Yes No        '
pbp_b18a_ded_yesno_pos          = 'Hearing Exams Deduct Yes No POS   '
pbp_b18a_maxenr_amt             = 'Hearing Exams Max Enr Amt         '
pbp_b18a_maxenr_amt_pos         = 'Hearing Exams Max Enr Amt POS     '
pbp_b18a_maxenr_per             = 'Hearing Exams Max Enr Per         '
pbp_b18a_maxenr_yesno           = 'Hearing Exams Max Enr Yes No      '
pbp_b18a_maxenr_yn_pos          = 'Hearing Exams Max Enr Y/N POS     '
pbp_b18a_maxplan_amt            = 'Hearing Exams Max Plan Amt        '
pbp_b18a_maxplan_cov            = 'Hearing Exams Max Plan Cov        '
pbp_b18a_maxplan_per            = 'Hearing Exams Max Plan Per        '
pbp_b18a_maxplan_yesno          = 'Hearing Exams Max Plan Yes No     '
pbp_b18a_maxplan_yesno_pos      = 'Hearing Exams Max Plan Y/N POS    '
pbp_b18a_maxpln_amt_pos         = 'Hearing Exams Max Plan Amt POS    '
pbp_b18a_maxpln_cov_pos         = 'Hearing Exams Max Plan Cov POS    '
pbp_b18a_maxpln_per_pos         = 'Hearing Exams Max Pln Per POS     '
pbp_b18a_med_coins_pct          = 'Hearing Exms Medicare Coins %     '
pbp_b18b_auth                   = 'Hearing Aids Auth                 '
pbp_b18b_auth_pos               = 'Hearing Aids Auth POS             '
pbp_b18b_bendec_enh             = 'Hearing Aids Ben Dec ENH          '
pbp_b18b_bendec_yesno           = 'Hearing Aids Ben Des Yes No       '
pbp_b18b_bendesc_ie_amo         = 'Hearing Aids Ben Des AMO IE       '
pbp_b18b_bendesc_lim_ie         = 'Hearing Aids IE Ben Desc Lim      '
pbp_b18b_bendesc_lim_oe         = 'Hearing Aids OE Ben Desc Lim      '
pbp_b18b_bendesc_lim_ote        = 'Hearing Aids OTE Ben Desc Lim     '
pbp_b18b_bendesc_lim_rb         = 'Hearing Aids RB Ben Desc Lim      '
pbp_b18b_bendesc_numv_ie        = 'Hearing Aids IE Ben Dsc NumV      '
pbp_b18b_bendesc_numv_oe        = 'Hearing Aids OE Ben Dsc NumV      '
pbp_b18b_bendesc_numv_ote       = 'Hearing Aids OTE Ben Dsc NumV     '
pbp_b18b_bendesc_numv_rb        = 'Hearing Aids RB Ben Dsc NumV      '
pbp_b18b_bendesc_oe_amo         = 'Hearing Aids Ben Des AMO OE       '
pbp_b18b_bendesc_ote_amo        = 'Hearing Aids Ben Des AMO OTE      '
pbp_b18b_bendesc_per_ie         = 'Hearing Aids IE Ben Desc Per      '
pbp_b18b_bendesc_per_oe         = 'Hearing Aids OE Ben Desc Per      '
pbp_b18b_bendesc_per_ote        = 'Hearing Aids OTE Ben Desc Per     '
pbp_b18b_bendesc_per_rb         = 'Hearing Aids RB Ben Desc Per      '
pbp_b18b_bendesc_rb_amo         = 'Hearing Aids Ben Des AMO RB       '
pbp_b18b_copay_amt_per2_ie      = 'Hearing Aids Copay Amt 2 IE       '
pbp_b18b_copay_amt_per2_oe      = 'Hearing Aids Copay Amt 2 OE       '
pbp_b18b_copay_amt_per2_ote     = 'Hearing Aids Copay Amt 2 OTE      '
pbp_b18b_copay_amt_per2_rb      = 'Hearing Aids Copay Amt 2 RB       '
pbp_b18b_copay_amt_per_ie       = 'Hearing Exams Copay Amt IE        '
pbp_b18b_copay_amt_per_oe       = 'Hearing Exams Copay Amt OE        '
pbp_b18b_copay_amt_per_ote      = 'Hearing Exams Copay Amt OTE       '
pbp_b18b_copay_amt_per_rb       = 'Hearing Exams Copay Amt RB        '
pbp_b18b_copay_amt_pos          = 'Hearing Aids Min Copay Amt POS    '
pbp_b18b_copay_amtmax_pos       = 'Hearing Aids Max Copay Amt POS    '
pbp_b18b_copay_yesno            = 'Hearing Aids Copay Yes No         '
pbp_b18b_copay_yesno_pos        = 'Hearing Aids Copay Yes No POS     '
pbp_b18b_ded_amt                = 'Hearing Aids Deduc Amt            '
pbp_b18b_ded_amt_pos            = 'Hearing Aids Deductible Amt POS   '
pbp_b18b_ded_yesno              = 'Hearing Aids Deduc Yes No         '
pbp_b18b_ded_yesno_pos          = 'Hearing Aids Deduct Yes No POS    '
pbp_b18b_disct_cov_ie           = 'Hearing Aids Coins Cov IE         '
pbp_b18b_disct_cov_oe           = 'Hearing Aids Coins Cov OE         '
pbp_b18b_disct_cov_ote          = 'Hearing Aids Coins Cov OTE        '
pbp_b18b_disct_cov_pos          = 'Hearing Aids Coinsurance Cov POS  '
pbp_b18b_disct_cov_rb           = 'Hearing Aids Coins Cov RB         '
pbp_b18b_disct_pct_ie           = 'Hearing Aids Coins Pct IE         '
pbp_b18b_disct_pct_oe           = 'Hearing Aids Coins Pct OE         '
pbp_b18b_disct_pct_ote          = 'Hearing Aids Coins Pct OTE        '
pbp_b18b_disct_pct_pos          = 'Hearing Aids Min Coins Pct POS    '
pbp_b18b_disct_pct_rb           = 'Hearing Aids Coins Pct RB         '
pbp_b18b_disct_pctmax_pos       = 'Hearing Aids Max Coins Pct POS    '
pbp_b18b_disct_pctprp_pos       = 'Hearing Aids Disct PRP Pct POS    '
pbp_b18b_disct_yesno            = 'Hearing Aids Coins YN             '
pbp_b18b_disct_yesno_pos        = 'Hearing Aids Coinsurance YN POS   '
pbp_b18b_maxenr_amt             = 'Hearing Aids Max Enr Amt          '
pbp_b18b_maxenr_amt_pos         = 'Hearing Aids Max Enr Amt POS      '
pbp_b18b_maxenr_per             = 'Hearing Aids Max Enr Per          '
pbp_b18b_maxenr_type            = 'Hearing Aids Max Enr Type         '
pbp_b18b_maxenr_type_pos        = 'Hearing Aids Max Enr Type POS     '
pbp_b18b_maxenr_yesno           = 'Hearing Aids Max Enr Yes No       '
pbp_b18b_maxenr_yn_pos          = 'Hearing Aids Max Enr Cov Y/N POS  '
pbp_b18b_maxplan_amt            = 'Hearing Aids Max Plan Amt         '
pbp_b18b_maxplan_cov            = 'Hearing Aids Max Plan Cov         '
pbp_b18b_maxplan_pct            = 'Hearing Aids Max Plan Pct         '
pbp_b18b_maxplan_pctprp_pos     = 'Hearing Aids Max Plan PRP Pct POS '
pbp_b18b_maxplan_per            = 'Hearing Aids Max Plan Per         '
pbp_b18b_maxplan_type           = 'Hearing Aids Max Plan Type        '
pbp_b18b_maxplan_type_pos       = 'Hearing Aids Max Plan Type POS    '
pbp_b18b_maxplan_yesno          = 'Hearing Aids Max Plan Yes No      '
pbp_b18b_maxplan_yesno_pos      = 'Hearing Aids Max Plan Y/N POS     '
pbp_b18b_maxpln_amt_pos         = 'Hearing Aids Max Plan Amt POS     '
pbp_b18b_maxpln_cov_pos         = 'Hearing Aids Max Plan Cov POS     '
pbp_b18b_maxpln_per_pos         = 'Hearing Aids Max Pln Per POS      '
;
run;

proc sort data = pbp_b18 out = out.pbp_b18;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b18(obs = 10);
  title 'pbp b18 data';
run;

proc means data =  out.pbp_b18;
  title 'pbp b18 file';
run;

proc freq data = out.pbp_b18;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b18a_bendec_yesno
  pbp_b18a_bendec_enh
  pbp_b18a_bendesc_rht_amo
  pbp_b18a_bendesc_lim_rht
  pbp_b18a_bendesc_per_rht
  pbp_b18a_bendesc_fha_amo
  pbp_b18a_bendesc_lim_fha
  pbp_b18a_bendesc_per_fha
  pbp_b18a_maxplan_yesno
  pbp_b18a_maxplan_per
  pbp_b18a_maxplan_cov
  pbp_b18a_maxenr_yesno
  pbp_b18a_maxenr_per
  pbp_b18a_coins_yesno
  pbp_b18a_coins_cov / missing;
run;

proc contents data = out.pbp_b18;
  title 'pbp b18 data';
run;
