* pbp_b19.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b19;
   length
   pbp_a_hnumber                     $5
   pbp_a_plan_identifier             $3
   pbp_a_ben_cov                     $1
   pbp_a_plan_type                   $2
   orgtype                           $2
   pbp_b19_vistrv_yesno              $1
   pbp_b19_vistrv_amo                $1
   pbp_b19_maxplan_yesno             $1
   pbp_b19_maxpln_per                $1
   pbp_b19_maxpln_cov                $1
   pbp_b19_maxenr_yesno              $1
   pbp_b19_maxenr_per                $1
   pbp_b19_coins_yesno               $1
   pbp_b19_coins_costs_apply         $1
   pbp_b19_coins_cov                 $1
   pbp_b19_ded_yesno                 $1
   pbp_b19_copay_yesno               $1
   pbp_b19_copay_costs_apply         $1
   pbp_b19_auth                      $5
  ;

infile '.\pbp\pbp_b19_visitor_travel.txt'
delimiter = '09'x dsd lrecl = 20000 firstobs = 2 missover;

input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b19_vistrv_yesno
   pbp_b19_vistrv_amo
   pbp_b19_vistrv_numd
   pbp_b19_vistrv_max_numd
   pbp_b19_maxplan_yesno
   pbp_b19_maxpln_amt
   pbp_b19_maxpln_per
   pbp_b19_maxpln_cov
   pbp_b19_maxenr_yesno
   pbp_b19_maxenr_amt
   pbp_b19_maxenr_per
   pbp_b19_coins_yesno
   pbp_b19_coins_costs_apply
   pbp_b19_coins_min_pct
   pbp_b19_coins_max_pct
   pbp_b19_coins_cov
   pbp_b19_ded_yesno
   pbp_b19_ded_amt
   pbp_b19_copay_yesno
   pbp_b19_copay_costs_apply
   pbp_b19_copay_min_amt
   pbp_b19_copay_max_amt
   pbp_b19_auth
;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b19_auth                    = 'Visitor/Traveler Auth             '
pbp_b19_coins_costs_apply       = 'Visitor/Traveler Coins CA         '
pbp_b19_coins_cov               = 'Visitor/Traveler Coins Cov        '
pbp_b19_coins_max_pct           = 'Visitor/Traveler Coins Max Pct    '
pbp_b19_coins_min_pct           = 'Visitor/Traveler Coins Min Pct    '
pbp_b19_coins_yesno             = 'Visitor/Traveler Coins YN         '
pbp_b19_copay_costs_apply       = 'Visitor/Traveler Copay CA         '
pbp_b19_copay_max_amt           = 'Visitor/Traveler Copay Max Amt    '
pbp_b19_copay_min_amt           = 'Visitor/Traveler Copay Min Amt    '
pbp_b19_copay_yesno             = 'Visitor/Traveler Copay YN         '
pbp_b19_ded_amt                 = 'Visitor/Traveler Deduc Amt        '
pbp_b19_ded_yesno               = 'Visitor/Traveler Deduc Yes No     '
pbp_b19_maxenr_amt              = 'Visitor/Traveler Max Enr Amt      '
pbp_b19_maxenr_per              = 'Visitor/Traveler Max Enr Per      '
pbp_b19_maxenr_yesno            = 'Visitor/Traveler Max Enr YesNo    '
pbp_b19_maxplan_yesno           = 'Visitor/Travel Max Plan Yes No    '
pbp_b19_maxpln_amt              = 'Visitor/Traveler Max Plan Amt     '
pbp_b19_maxpln_cov              = 'Visitor/Traveler Max Plan Cov     '
pbp_b19_maxpln_per              = 'Visitor/Traveler Max Pln Per      '
pbp_b19_vistrv_amo              = 'Visitor/Travel AMO                '
pbp_b19_vistrv_max_numd         = 'Visitor/Traveler Num Day Max      '
pbp_b19_vistrv_numd             = 'Visitor/Traveler Num Day Prior    '
pbp_b19_vistrv_yesno            = 'Visitor/Travel Yes No             '
;
run;

proc sort data = pbp_b19 out = out.pbp_b19;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b19(obs = 10);
  title 'pbp b19 data';
run;

proc means data =  out.pbp_b19;
  title 'pbp b19 file';
run;

proc freq data = out.pbp_b19;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b19_vistrv_yesno
  pbp_b19_vistrv_amo
  pbp_b19_maxplan_yesno
  pbp_b19_maxpln_per
  pbp_b19_maxpln_cov
  pbp_b19_maxenr_yesno
  pbp_b19_maxenr_per
  pbp_b19_coins_yesno
  pbp_b19_coins_costs_apply
  pbp_b19_coins_cov
  pbp_b19_ded_yesno
  pbp_b19_copay_yesno
  pbp_b19_copay_costs_apply
  pbp_b19_auth / missing;
run;

proc contents data = out.pbp_b19;
  title 'pbp b19 data';
run;
