*pbp_b2.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b2;
   length
   pbp_a_hnumber                        $5
   pbp_a_plan_identifier                $3
   pbp_a_ben_cov                        $1
   pbp_a_plan_type                      $2
   orgtype                              $2
   pbp_b2_bendec_yesno                  $1
   pbp_b2_bendec_pr_al_ad_cs            $3
   pbp_b2_bendesc_amo_pr                $1
   pbp_b2_bendesc_amo_al                $1
   pbp_b2_bendesc_amo_ad                $1
   pbp_b2_maxenr_yesno                  $1
   pbp_b2_maxenr_per                    $1
   pbp_b2_coins_yesno                   $1
   pbp_b2_coins_cov_ps                  $1
   pbp_b2_coins_cov_120                 $1
   pbp_b2_coins_cov_21100               $1
   pbp_b2_coins_cov_ad                  $1
   pbp_b2_coins_cov_cs                  $1
   pbp_b_2_ded_yesno                    $1
   pbp_b2_copay_yesno                   $1
   pbp_b2_auth                          $5
   pbp_b2_maxplan_yesno_pos             $1
   pbp_b2_maxpln_per_pos                $1
   pbp_b2_maxpln_cov_pos                $1
   pbp_b2_maxenr_yn_pos                 $1
   pbp_b2_coins_yesno_pos               $1
   pbp_b2_coins_cov_pos                 $1
   pbp_b2_ded_yesno_pos                 $1
   pbp_b2_copay_yesno_pos               $1
   pbp_b2_auth_pos                      $5
   pbp_b2_bendec_yesno_bonly            $1
   pbp_b2_bendesc_snfcare_amo_b         $1
   pbp_b2_bendesc_snf_unlm_bonly        $1
   pbp_b2_bendes_snf_per_bonly          $1
   pbp_b2_maxplan_yesno_bonly           $1
   pbp_b2_maxplan_per_bonly             $1
   pbp_b2_maxplan_cov_bonly             $1
   pbp_b2_maxenr_yesno_bonly            $1
   pbp_b2_maxenr_per_bonly              $1
   pbp_b2_coins_yesno_bonly             $1
   pbp_b2_coins_cov_bonly               $1
   pbp_b_2_ded_yesno_bonly              $1
   pbp_b2_copay_yesno_bonly             $1
   pbp_b2_auth_bonly                    $5
   pbp_b2_maxplan_yesno_pos_bonly       $1
   pbp_b2_maxpln_per_pos_bonly          $1
   pbp_b2_maxpln_cov_pos_bonly          $1
   pbp_b2_maxenr_yn_pos_bonly           $1
   pbp_b2_coins_yesno_pos_bonly         $1
   pbp_b2_coins_cov_pos_bonly           $1
   pbp_b2_ded_yesno_pos_bonly           $1
   pbp_b2_copay_yesno_pos_bonly         $1
   pbp_b2_auth_pos_bonly                $5
;

infile '.\pbp\pbp_b2_snf.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b2_bendec_yesno
   pbp_b2_bendec_pr_al_ad_cs
   pbp_b2_bendesc_amo_pr
   pbp_b2_bendesc_al_ad_prior
   pbp_b2_bendesc_amo_al
   pbp_b2_bendesc_al_ad
   pbp_b2_bendesc_amo_ad
   pbp_b2_bendesc_ad
   pbp_b2_maxenr_yesno
   pbp_b2_maxenr_amt
   pbp_b2_maxenr_per
   pbp_b2_coins_yesno
   pbp_b2_coins_pct_ps
   pbp_b2_coins_cov_ps
   pbp_b2_coins_pct_120
   pbp_b2_coins_cov_120
   pbp_b2_coins_pct_21100
   pbp_b2_coins_cov_21100
   pbp_b2_coins_pct_ad
   pbp_b2_coins_cov_ad
   pbp_b2_coins_pct_cs
   pbp_b2_coins_cov_cs
   pbp_b_2_ded_yesno
   pbp_b_2_ded_amt
   pbp_b2_copay_yesno
   pbp_b2_copay_ps_amts
   pbp_b2_copay_120_amts
   pbp_b2_copay_21100_amts
   pbp_b2_copay_ad_amts
   pbp_b2_copay_nmed_amts
   pbp_b2_auth
   pbp_b2_maxplan_yesno_pos
   pbp_b2_maxpln_amt_pos
   pbp_b2_maxpln_per_pos
   pbp_b2_maxpln_cov_pos
   pbp_b2_maxenr_yn_pos
   pbp_b2_maxenr_amt_pos
   pbp_b2_coins_yesno_pos
   pbp_b2_coins_pct_pos
   pbp_b2_coins_cov_pos
   pbp_b2_ded_yesno_pos
   pbp_b2_ded_amt_pos
   pbp_b2_copay_yesno_pos
   pbp_b2_copay_amts_pos
   pbp_b2_copay_amtd_pos
   pbp_b2_auth_pos
   pbp_b2_bendec_yesno_bonly
   pbp_b2_bendesc_snfcare_amo_b
   pbp_b2_bendesc_snf_unlm_bonly
   pbp_b2_bendesc_al_ad_prior_b
   pbp_b2_bendes_snf_per_bonly
   pbp_b2_maxplan_yesno_bonly
   pbp_b2_maxpln_amt_pos_bonly
   pbp_b2_maxplan_per_bonly
   pbp_b2_maxplan_cov_bonly
   pbp_b2_maxenr_yesno_bonly
   pbp_b2_maxenr_amt_bonly
   pbp_b2_maxenr_per_bonly
   pbp_b2_coins_yesno_bonly
   pbp_b2_coins_pct_bonly
   pbp_b2_coins_cov_pos_bonly
   pbp_b_2_ded_yesno_bonly
   pbp_b_2_ded_amt_bonly
   pbp_b2_copay_yesno_bonly
   pbp_b2_copay_ps_amts_bonly
   pbp_b2_copay_pd_amts_bonly
   pbp_b2_auth_bonly
   pbp_b2_maxplan_yesno_pos_bonly
   pbp_b2_maxplan_amt_bonly
   pbp_b2_maxpln_per_pos_bonly
   pbp_b2_maxpln_cov_pos_bonly
   pbp_b2_maxenr_yn_pos_bonly
   pbp_b2_maxenr_amt_pos_bonly
   pbp_b2_coins_yesno_pos_bonly
   pbp_b2_coins_pct_pos_bonly
   pbp_b2_coins_cov_bonly
   pbp_b2_ded_yesno_pos_bonly
   pbp_b2_ded_amt_pos_bonly
   pbp_b2_copay_yesno_pos_bonly
   pbp_b2_copay_amts_pos_bonly
   pbp_b2_copay_amtd_pos_bonly
   pbp_b2_auth_pos_bonly
;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b2_auth                     = 'SNF Auth                          '
pbp_b2_auth_bonly               = 'SNF Auth                          '
pbp_b2_auth_pos                 = 'SNF Auth POS                      '
pbp_b2_auth_pos_bonly           = 'SNF Auth                          '
pbp_b2_bendec_pr_al_ad_cs       = 'SNF Ben Dec PR/AL/AD/CS           '
pbp_b2_bendec_yesno             = 'SNF Ben Des Yes No                '
pbp_b2_bendec_yesno_bonly       = 'SNF Ben Des Yes No                '
pbp_b2_bendes_snf_per_bonly     = 'SNF Ben Desc Per                  '
pbp_b2_bendesc_ad               = 'SNF Ben Des Num of Add Days       '
pbp_b2_bendesc_al_ad            = 'SNF Ben Des Num > 30 days         '
pbp_b2_bendesc_al_ad_prior      = 'SNF Ben Des Num of Days 0-2       '
pbp_b2_bendesc_al_ad_prior_b    = 'SNF Ben Des Num of Days 0-2       '
pbp_b2_bendesc_amo_ad           = 'SNF Ben Des AMO Add Days          '
pbp_b2_bendesc_amo_al           = 'SNF Ben Des AMO 30 days           '
pbp_b2_bendesc_amo_pr           = 'SNF Ben Des AMO <3 Prior          '
pbp_b2_bendesc_snf_unlm_bonly   = 'SNF Ben Des SNF Care Unlm         '
pbp_b2_bendesc_snfcare_amo_b    = 'SNF Ben Des SNF Care              '
pbp_b2_coins_cov_120            = 'SNF 1-20 Coins Cov                '
pbp_b2_coins_cov_21100          = 'SNF 21-100 Coins Cov              '
pbp_b2_coins_cov_ad             = 'SNF Add Days Coins Cov            '
pbp_b2_coins_cov_bonly          = 'SNF Coins Cov                     '
pbp_b2_coins_cov_cs             = 'SNF CS Coins Cov                  '
pbp_b2_coins_cov_pos            = 'SNF Coins Cov POS                 '
pbp_b2_coins_cov_pos_bonly      = 'SNF Coins Cov                     '
pbp_b2_coins_cov_ps             = 'SNF Per Stay Coins Cov            '
pbp_b2_coins_pct_120            = 'SNF 1-20 Coin Pct                 '
pbp_b2_coins_pct_21100          = 'SNF 21-100 Coin Pct               '
pbp_b2_coins_pct_ad             = 'SNF Add Days Coin Pct             '
pbp_b2_coins_pct_bonly          = 'SNF Coin Pct                      '
pbp_b2_coins_pct_cs             = 'SNF CS Coin Pct                   '
pbp_b2_coins_pct_pos            = 'SNF Coin Pct POS                  '
pbp_b2_coins_pct_pos_bonly      = 'SNF Coin Pct                      '
pbp_b2_coins_pct_ps             = 'SNF Per Stay Coin Pct             '
pbp_b2_coins_yesno              = 'SNF Coins Yes No                  '
pbp_b2_coins_yesno_bonly        = 'SNF Coins Yes No                  '
pbp_b2_coins_yesno_pos          = 'SNF Coinsurance YN POS            '
pbp_b2_coins_yesno_pos_bonly    = 'SNF Coinsurance YN                '
pbp_b2_copay_120_amts           = 'SNF 1-20 Copay Amt                '
pbp_b2_copay_21100_amts         = 'SNF 21-100 Copay Amt              '
pbp_b2_copay_ad_amts            = 'SNF Add Days Copay Amt            '
pbp_b2_copay_amtd_pos           = 'SNF Copay Amt Day POS             '
pbp_b2_copay_amtd_pos_bonly     = 'SNF Copay Amt Dy                  '
pbp_b2_copay_amts_pos           = 'SNF Copay Amt Per Stay POS        '
pbp_b2_copay_amts_pos_bonly     = 'SNF Copay Amt Per Stay            '
pbp_b2_copay_nmed_amts          = 'SNF Non-Medicare Copay Amt        '
pbp_b2_copay_pd_amts_bonly      = 'SNF Per Day Copay Amt             '
pbp_b2_copay_ps_amts            = 'SNF Per Stay Copay Amt            '
pbp_b2_copay_ps_amts_bonly      = 'SNF Per Stay Copay Amt            '
pbp_b2_copay_yesno              = 'SNF Copay Yes No                  '
pbp_b2_copay_yesno_bonly        = 'SNF Copay Yes No                  '
pbp_b2_copay_yesno_pos          = 'SNF Copay Yes No POS              '
pbp_b2_copay_yesno_pos_bonly    = 'SNF Copay Yes No                  '
pbp_b2_ded_amt_pos              = 'SNF Deductible Amt POS            '
pbp_b2_ded_amt_pos_bonly        = 'SNF Deductible Amt                '
pbp_b2_ded_yesno_pos            = 'SNF Deduct Yes No POS             '
pbp_b2_ded_yesno_pos_bonly      = 'SNF Deduct Yes No                 '
pbp_b2_maxenr_amt               = 'SNF Max Enr Amt                   '
pbp_b2_maxenr_amt_bonly         = 'SNF Max Enr Amt                   '
pbp_b2_maxenr_amt_pos           = 'SNF Max Enr Amt POS               '
pbp_b2_maxenr_amt_pos_bonly     = 'SNF Max Enr Amt                   '
pbp_b2_maxenr_per               = 'SNF Max Enr Per                   '
pbp_b2_maxenr_per_bonly         = 'SNF Max Enr Per                   '
pbp_b2_maxenr_yesno             = 'SNF Max Enr Yes No                '
pbp_b2_maxenr_yesno_bonly       = 'SNF Max Enr Yes No                '
pbp_b2_maxenr_yn_pos            = 'SNF Max Enr Yes/No POS            '
pbp_b2_maxenr_yn_pos_bonly      = 'SNF Max Enr Yes/No                '
pbp_b2_maxplan_amt_bonly        = 'SNF Max Plan Amt                  '
pbp_b2_maxplan_cov_bonly        = 'SNF Max Plan Cov Bas              '
pbp_b2_maxplan_per_bonly        = 'SNF Max Plan Per                  '
pbp_b2_maxplan_yesno_bonly      = 'SNF Max Plan Yes No               '
pbp_b2_maxplan_yesno_pos        = 'SNF Max Plan Y/N POS              '
pbp_b2_maxplan_yesno_pos_bonly  = 'SNF Max Plan Y/N                  '
pbp_b2_maxpln_amt_pos           = 'SNF Max Plan Amt POS              '
pbp_b2_maxpln_amt_pos_bonly     = 'SNF Max Plan Amt                  '
pbp_b2_maxpln_cov_pos           = 'SNF Max Plan Cov POS              '
pbp_b2_maxpln_cov_pos_bonly     = 'SNF Max Plan Cov                  '
pbp_b2_maxpln_per_pos           = 'SNF Max Pln Per POS               '
pbp_b2_maxpln_per_pos_bonly     = 'SNF Max Pln Per                   '
pbp_b_2_ded_amt                 = 'SNF Deductible Amt                '
pbp_b_2_ded_amt_bonly           = 'SNF Deductible Amt                '
pbp_b_2_ded_yesno               = 'SNF Deductible Yes No             '
pbp_b_2_ded_yesno_bonly         = 'SNF Deductible Yes No             ';
run;

proc sort data = pbp_b2 out = out.pbp_b2;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b2 (obs = 10);
  title 'pbp b2 data';
run;

proc means data =  out.pbp_b2;
  title 'pbp b2 file';
run;

proc freq data = out.pbp_b2;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b2_bendec_yesno
  pbp_b2_bendec_pr_al_ad_cs
  pbp_b2_bendesc_amo_pr
  pbp_b2_bendesc_amo_al
  pbp_b2_bendesc_amo_ad
  pbp_b2_maxenr_yesno
  pbp_b2_maxenr_per
  pbp_b2_coins_yesno
  pbp_b2_coins_cov_ps
  pbp_b2_auth_pos_bonly / missing;
run;

proc contents data = out.pbp_b2;
  title 'pbp b2 data';
run;
