*pbp_b3.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b3;

length
   pbp_a_hnumber                $5
   pbp_a_plan_identifier        $3
   pbp_a_ben_cov                $1
   pbp_a_plan_type              $2
   orgtype                      $2
   pbp_b3_maxenr_yesno          $1
   pbp_b3_maxenr_per            $1
   pbp_b3_coins_yesno           $1
   pbp_b3_coins_cov_mc          $1
   pbp_b_3_ded_yesno            $1
   pbp_b3_copay_yesno           $1
   pbp_b3_auth                  $5
   pbp_b3_maxplan_yesno_pos     $1
   pbp_b3_maxpln_per_pos        $1
   pbp_b3_maxpln_cov_pos        $1
   pbp_b3_maxenr_yn_pos         $1
   pbp_b3_coins_yesno_pos       $1
   pbp_b3_coins_cov_pos         $1
   pbp_b3_ded_yesno_pos         $1
   pbp_b3_copay_yesno_pos       $1
   pbp_b3_auth_pos              $5
;

infile '.\pbp\pbp_b3_corf.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b3_maxenr_yesno
   pbp_b3_maxenr_amt
   pbp_b3_maxenr_per
   pbp_b3_coins_yesno
   pbp_b3_coins_pct_mc
   pbp_b3_coins_cov_mc
   pbp_b_3_ded_yesno
   pbp_b_3_ded_amt
   pbp_b3_copay_yesno
   pbp_b3_copay_amt
   pbp_b3_auth
   pbp_b3_maxplan_yesno_pos
   pbp_b3_maxpln_amt_pos
   pbp_b3_maxpln_per_pos
   pbp_b3_maxpln_cov_pos
   pbp_b3_maxenr_yn_pos
   pbp_b3_maxenr_amt_pos
   pbp_b3_coins_yesno_pos
   pbp_b3_coins_pct_pos
   pbp_b3_coins_cov_pos
   pbp_b3_ded_yesno_pos
   pbp_b3_ded_amt_pos
   pbp_b3_copay_yesno_pos
   pbp_b3_copay_amtv_pos
   pbp_b3_auth_pos
;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b3_auth                     = 'CORF Auth                         '
pbp_b3_auth_pos                 = 'CORF Auth POS                     '
pbp_b3_coins_cov_mc             = 'CORF Medicare Coins Cov           '
pbp_b3_coins_cov_pos            = 'CORF Coins Cov POS                '
pbp_b3_coins_pct_mc             = 'CORF Medicare Coin Pct            '
pbp_b3_coins_pct_pos            = 'CORF Coin Pct POS                 '
pbp_b3_coins_yesno              = 'CORF Coins Yes No                 '
pbp_b3_coins_yesno_pos          = 'CORF Coinsurance YN POS           '
pbp_b3_copay_amt                = 'CORF Copay Amt                    '
pbp_b3_copay_amtv_pos           = 'CORF Copay Amt Visit POS          '
pbp_b3_copay_yesno              = 'CORF Copay Yes No                 '
pbp_b3_copay_yesno_pos          = 'CORF Copay Yes No POS             '
pbp_b3_ded_amt_pos              = 'CORF Deductible Amt POS           '
pbp_b3_ded_yesno_pos            = 'CORF Deduct Yes No POS            '
pbp_b3_maxenr_amt               = 'CORF Max Enr Amt                  '
pbp_b3_maxenr_amt_pos           = 'CORF Max Enr Amt POS              '
pbp_b3_maxenr_per               = 'CORF Max Enr Per                  '
pbp_b3_maxenr_yesno             = 'CORF Max Enr Yes No               '
pbp_b3_maxenr_yn_pos            = 'CORF Max Enr Yes/No POS           '
pbp_b3_maxplan_yesno_pos        = 'CORF Max Plan Y/N POS             '
pbp_b3_maxpln_amt_pos           = 'CORF Max Plan Amt POS             '
pbp_b3_maxpln_cov_pos           = 'CORF Max Plan Cov POS             '
pbp_b3_maxpln_per_pos           = 'CORF Max Pln Per POS              '
pbp_b_3_ded_amt                 = 'CORF Deductible Amt               '
pbp_b_3_ded_yesno               = 'CORF Deductible Yes No            '
;
run;

proc sort data = pbp_b3 out = out.pbp_b3;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b3 (obs = 10);
  title 'pbp b3 data';
run;

proc means data =  out.pbp_b3;
  title 'pbp b3 file';
run;

proc freq data = out.pbp_b3;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b3_maxenr_yesno
  pbp_b3_maxenr_per
  pbp_b3_coins_yesno
  pbp_b3_coins_cov_mc
  pbp_b_3_ded_yesno
  pbp_b3_copay_yesno
  pbp_b3_auth
  pbp_b3_maxplan_yesno_pos
  pbp_b3_maxpln_per_pos
  pbp_b3_maxpln_cov_pos
  pbp_b3_maxenr_yn_pos
  pbp_b3_coins_yesno_pos
  pbp_b3_coins_cov_pos
  pbp_b3_ded_yesno_pos
  pbp_b3_copay_yesno_pos
  pbp_b3_auth_pos / missing;
run;

proc contents data = out.pbp_b3;
  title 'pbp b3 data';
run;
