*pbp_b4.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b4;

length
   pbp_a_hnumber               $5
   pbp_a_plan_identifier       $3
   pbp_a_ben_cov               $1
   pbp_a_plan_type             $2
   orgtype                     $2
   pbp_b4a_bendec_yesno        $1
   pbp_b4a_bendec_emg          $1
   pbp_b4a_bendesc_amo         $1
   pbp_b4a_maxenr_yesno        $1
   pbp_b4a_maxenr_per          $1
   pbp_b4a_coins_yesno         $1
   pbp_b4a_coins_wavdia_yn     $1
   pbp_b4a_coins_wavdia_dh     $1
   pbp_b4a_coins_cov_mcia      $1
   pbp_b4a_coins_cov_mcww      $1
   pbp_b4a_coins_wavdww_yn     $1
   pbp_b_4a_ded_yesno          $1
   pbp_b4a_copay_yesno         $1
   pbp_b4a_copay_wavdia_yn     $1
   pbp_b4a_copay_wavdia_mi_dh  $1
   pbp_b4a_copay_wavdww_yn     $1
   pbp_b4b_bendec_yesno        $1
   pbp_b4b_bendec_urg          $1
   pbp_b4b_bendesc_amo         $1
   pbp_b4b_maxenr_yesno        $1
   pbp_b4b_maxenr_type         $1
   pbp_b4b_maxenr_per          $1
   pbp_b4b_coins_yesno         $1
   pbp_b4b_coins_wavdmc_yn     $1
   pbp_b4b_coins_wavd_mcdh     $1
   pbp_b4b_coins_cov_mcmin     $1
   pbp_b4b_coins_cov_mcww      $1
   pbp_b4b_coins_wavdww_yn     $1
   pbp_b4b_ded_yesno           $1
   pbp_b4b_copay_yesno         $1
   pbp_b4b_copay_wavdia_yn     $1
   pbp_b4b_copay_wavd_mcdh     $1
   pbp_b4b_copay_wavdww_yn     $1
;

infile '.\pbp\pbp_b4_emerg_urgent.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;

input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b4a_bendec_yesno
   pbp_b4a_bendec_emg
   pbp_b4a_bendesc_amo
   pbp_b4a_maxenr_yesno
   pbp_b4a_maxenr_amt
   pbp_b4a_maxenr_per
   pbp_b4a_coins_yesno
   pbp_b4a_coins_pct_mc_in
   pbp_b4a_coins_pct_mc_out
   pbp_b4a_coins_wavdia_yn
   pbp_b4a_coins_wavdia_dh
   pbp_b4a_coins_wavd_dh
   pbp_b4a_coins_cov_mcia
   pbp_b4a_coins_pct_ww
   pbp_b4a_coins_cov_mcww
   pbp_b4a_coins_wavdww_yn
   pbp_b_4a_ded_yesno
   pbp_b_4a_ded_amt
   pbp_b4a_copay_yesno
   pbp_b4a_copay_mciaamt
   pbp_b4a_copay_mcoa_amt
   pbp_b4a_copay_wavdia_yn
   pbp_b4a_copay_wavdia_mi_dh
   pbp_b4a_copay_wavd_dh
   pbp_b4a_copay_mcww_amt
   pbp_b4a_copay_wavdww_yn
   pbp_b4b_bendec_yesno
   pbp_b4b_bendec_urg
   pbp_b4b_bendesc_amo
   pbp_b4b_maxenr_yesno
   pbp_b4b_maxenr_type
   pbp_b4b_maxenr_amt
   pbp_b4b_maxenr_per
   pbp_b4b_coins_yesno
   pbp_b4b_coins_pct_mc_min
   pbp_b4b_coins_pct_mc_max
   pbp_b4b_coins_wavdmc_yn
   pbp_b4b_coins_wavd_mcdh
   pbp_b4b_coins_wavdmc_dh
   pbp_b4b_coins_cov_mcmin
   pbp_b4b_coins_pct_ww
   pbp_b4b_coins_cov_mcww
   pbp_b4b_coins_wavdww_yn
   pbp_b4b_ded_yesno
   pbp_b4b_ded_amt
   pbp_b4b_copay_yesno
   pbp_b4b_copay_mciaamt
   pbp_b4b_copay_mcoa_amt
   pbp_b4b_copay_wavdia_yn
   pbp_b4b_copay_wavd_mcdh
   pbp_b4b_copay_wavdmc_dh
   pbp_b4b_copay_mcww_amt
   pbp_b4b_copay_wavdww_yn
;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b4a_bendec_emg              = 'Emg Care Ben Dec                  '
pbp_b4a_bendec_yesno            = 'Emg Care Ben Des Yes No           '
pbp_b4a_bendesc_amo             = 'Emg Care Ben Des AMO              '
pbp_b4a_coins_cov_mcia          = 'Emg Care MC Coins Cov             '
pbp_b4a_coins_cov_mcww          = 'Emg Care MC WW Coins Cov          '
pbp_b4a_coins_pct_mc_in         = 'Emg Care MC Min Coin Pct          '
pbp_b4a_coins_pct_mc_out        = 'Emg Care MC Max Coin Pct          '
pbp_b4a_coins_pct_ww            = 'Emg Care World Wide Coin Pct      '
pbp_b4a_coins_wavd_dh           = 'Emg Care Coins Waived D/H         '
pbp_b4a_coins_wavdia_dh         = 'Emg Care Coins Waived D/H         '
pbp_b4a_coins_wavdia_yn         = 'Emg Care MC Coins Waived Y/N      '
pbp_b4a_coins_wavdww_yn         = 'Emg Care Coins Waived (WW) Y/N    '
pbp_b4a_coins_yesno             = 'Emg Care Coins Yes No             '
pbp_b4a_copay_mciaamt           = 'Emg Care MC Minimum Copay Amt     '
pbp_b4a_copay_mcoa_amt          = 'Emg Care MC Maximum Copay Amt     '
pbp_b4a_copay_mcww_amt          = 'Emg Care WW Copay Amt             '
pbp_b4a_copay_wavd_dh           = 'Emg Care Copay Waived D/H         '
pbp_b4a_copay_wavdia_mi_dh      = 'Emg Care Copay Waived D/H         '
pbp_b4a_copay_wavdia_yn         = 'Emg Care MC Copay Waived Y/N      '
pbp_b4a_copay_wavdww_yn         = 'Emg Care Copay Waived (WW) Y/N    '
pbp_b4a_copay_yesno             = 'Emg Care Copay Yes No             '
pbp_b4a_maxenr_amt              = 'Emg Care Max Enr Amt              '
pbp_b4a_maxenr_per              = 'Emg Care Max Enr Per              '
pbp_b4a_maxenr_yesno            = 'Emg Care Max Enr Yes No           '
pbp_b4b_bendec_urg              = 'Urg Care Ben Dec                  '
pbp_b4b_bendec_yesno            = 'Urg Care Ben Des Yes No           '
pbp_b4b_bendesc_amo             = 'Urg Care Ben Des AMO              '
pbp_b4b_coins_cov_mcmin         = 'Urg Care MC Coins Cov             '
pbp_b4b_coins_cov_mcww          = 'Urg Care WW Coins Cov             '
pbp_b4b_coins_pct_mc_max        = 'Urg Care MC Maximum Coin Pct      '
pbp_b4b_coins_pct_mc_min        = 'Urg Care MC Minimum Coin Pct      '
pbp_b4b_coins_pct_ww            = 'Urg Care World Wide Coin Pct      '
pbp_b4b_coins_wavd_mcdh         = 'Urg Care MC Coins Waived D/H      '
pbp_b4b_coins_wavdmc_dh         = 'Urg Care MC Coins Waived D/H      '
pbp_b4b_coins_wavdmc_yn         = 'Urg Care MC Coins Waived Y/N      '
pbp_b4b_coins_wavdww_yn         = 'Urg Care Coins Waived (WW) Y/N    '
pbp_b4b_coins_yesno             = 'Urg Care Coins Yes No             '
pbp_b4b_copay_mciaamt           = 'Urg Care MC Min Copay Amt         '
pbp_b4b_copay_mcoa_amt          = 'Urg Care MC Maximum Copay Amt     '
pbp_b4b_copay_mcww_amt          = 'Urg Care WW Copay Amt             '
pbp_b4b_copay_wavd_mcdh         = 'Urg Care MC Copay Waived D/H      '
pbp_b4b_copay_wavdia_yn         = 'Urg Care Copay Waived (IA) Y/N    '
pbp_b4b_copay_wavdmc_dh         = 'Urg Care MC Copay Waived D/H      '
pbp_b4b_copay_wavdww_yn         = 'Urg Care Copay Waived (WW) Y/N    '
pbp_b4b_copay_yesno             = 'Urg Care Copay Yes No             '
pbp_b4b_ded_amt                 = 'Urg Care Deductible Amt           '
pbp_b4b_ded_yesno               = 'Urg Care Deductible Yes No        '
pbp_b4b_maxenr_amt              = 'Urg Care Max Enr Amt              '
pbp_b4b_maxenr_per              = 'Urg Care Max Enr Per              '
pbp_b4b_maxenr_type             = 'Urg Care Max Enr Type             '
pbp_b4b_maxenr_yesno            = 'Urg Care Max Enr Yes No           '
pbp_b_4a_ded_amt                = 'Emerg Care Deductible Amt         '
pbp_b_4a_ded_yesno              = 'Emerg Care Deductible Yes No      '
;
run;

proc sort data = pbp_b4 out = out.pbp_b4;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b4 (obs = 10);
  title 'pbp b4 data';
run;

proc means data =  out.pbp_b4;
  title 'pbp b4 file';
run;

proc freq data = out.pbp_b4;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b4a_bendec_yesno
  pbp_b4a_bendec_emg
  pbp_b4a_bendesc_amo
  pbp_b4a_maxenr_yesno
  pbp_b4a_maxenr_per
  pbp_b4a_coins_yesno
  pbp_b4a_coins_wavdia_yn
  pbp_b4a_coins_wavdia_dh
  pbp_b4a_coins_cov_mcia
  pbp_b4a_coins_cov_mcww
  pbp_b4a_coins_wavdww_yn
  pbp_b_4a_ded_yesno
  pbp_b4a_copay_yesno
  pbp_b4a_copay_wavdia_yn
  pbp_b4a_copay_wavdia_mi_dh
  pbp_b4a_copay_wavdww_yn
  pbp_b4b_bendec_yesno
  pbp_b4b_bendec_urg
  pbp_b4b_bendesc_amo
  pbp_b4b_maxenr_yesno
  pbp_b4b_maxenr_type
  pbp_b4b_maxenr_per
  pbp_b4b_coins_yesno
  pbp_b4b_coins_wavdmc_yn
  pbp_b4b_coins_wavd_mcdh
  pbp_b4b_coins_cov_mcmin
  pbp_b4b_coins_cov_mcww
  pbp_b4b_coins_wavdww_yn
  pbp_b4b_ded_yesno
  pbp_b4b_copay_yesno
  pbp_b4b_copay_wavdia_yn
  pbp_b4b_copay_wavd_mcdh
  pbp_b4b_copay_wavdww_yn / missing;
run;

proc contents data = out.pbp_b4;
  title 'pbp b4 data';
run;
