*pbp_b5.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b5;

length
   pbp_a_hnumber               $5
   pbp_a_plan_identifier       $3
   pbp_a_ben_cov               $1
   pbp_a_plan_type             $2
   orgtype                     $2
   pbp_b5_maxenr_yesno         $1
   pbp_b5_maxenr_per           $1
   pbp_b5_coins_yesno          $1
   pbp_b5_coins_cov            $1
   pbp_b5_ded_yesno            $1
   pbp_b5_copay_yesno          $1
   pbp_b5_auth                 $5
   pbp_b5_maxplan_yesno_pos    $1
   pbp_b5_maxpln_per_pos       $1
   pbp_b5_maxpln_cov_pos       $1
   pbp_b5_maxenr_yn_pos        $1
   pbp_b5_coins_yesno_pos      $1
   pbp_b5_coins_cov_pos        $1
   pbp_b5_ded_yesno_pos        $1
   pbp_b5_copay_yesno_pos      $1
   pbp_b5_auth_pos             $5
;

infile '.\pbp\pbp_b5_partial_hosp.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b5_maxenr_yesno
   pbp_b5_maxenr_amt
   pbp_b5_maxenr_per
   pbp_b5_coins_yesno
   pbp_b5_coins_pct
   pbp_b5_coins_cov
   pbp_b5_ded_yesno
   pbp_b5_ded_amt
   pbp_b5_copay_yesno
   pbp_b5_copay_mciaamt
   pbp_b5_auth
   pbp_b5_maxplan_yesno_pos
   pbp_b5_maxpln_amt_pos
   pbp_b5_maxpln_per_pos
   pbp_b5_maxpln_cov_pos
   pbp_b5_maxenr_yn_pos
   pbp_b5_maxenr_amt_pos
   pbp_b5_coins_yesno_pos
   pbp_b5_coins_pct_pos
   pbp_b5_coins_cov_pos
   pbp_b5_ded_yesno_pos
   pbp_b5_ded_amt_pos
   pbp_b5_copay_yesno_pos
   pbp_b5_copay_amtd_pos
   pbp_b5_auth_pos
 ;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b5_auth                     = 'Partial Hospital Auth             '
pbp_b5_auth_pos                 = 'Partial Hospital Auth POS         '
pbp_b5_coins_cov                = 'Partial Hosp Coins Cov            '
pbp_b5_coins_cov_pos            = 'Partial Hosp Coins Cov POS        '
pbp_b5_coins_pct                = 'Partial Hosp MC Coin Pct          '
pbp_b5_coins_pct_pos            = 'Partial Hosp Coin Pct POS         '
pbp_b5_coins_yesno              = 'Partial Hosp Coins Yes No         '
pbp_b5_coins_yesno_pos          = 'Partial Hosp Coinsurance YN POS   '
pbp_b5_copay_amtd_pos           = 'Partial Hosp Copay Amt Dy POS     '
pbp_b5_copay_mciaamt            = 'Partial Hosp Copay Amt            '
pbp_b5_copay_yesno              = 'Partial Hosp Copay Yes No         '
pbp_b5_copay_yesno_pos          = 'Partial Hosp Copay Yes No POS     '
pbp_b5_ded_amt                  = 'Partial Hosp Deductible Amt       '
pbp_b5_ded_amt_pos              = 'Partial Hosp Deductible Amt POS   '
pbp_b5_ded_yesno                = 'Partial Hosp Deductible Yes No    '
pbp_b5_ded_yesno_pos            = 'Partial Hosp Deduct Yes No POS    '
pbp_b5_maxenr_amt               = 'Partial Hosp Max Enr Amt          '
pbp_b5_maxenr_amt_pos           = 'Partial Hosp Max Enr Amt POS      '
pbp_b5_maxenr_per               = 'Partial Hosp Max Enr Per          '
pbp_b5_maxenr_yesno             = 'Partial Hosp Max Enr Yes No       '
pbp_b5_maxenr_yn_pos            = 'Partial Hosp Max Enr Y/N POS      '
pbp_b5_maxplan_yesno_pos        = 'Partial Hosp Max Plan Y/N POS     '
pbp_b5_maxpln_amt_pos           = 'Partial Hosp Max Plan Amt POS     '
pbp_b5_maxpln_cov_pos           = 'Partial Hosp Max Plan Cov POS     '
pbp_b5_maxpln_per_pos           = 'Partial Hosp Max Pln Per POS      '
;
run;

proc sort data = pbp_b5 out = out.pbp_b5;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b5 (obs = 10);
  title 'pbp b5 data';
run;

proc means data =  out.pbp_b5;
  title 'pbp b5 file';
run;

proc freq data = out.pbp_b5;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b5_maxenr_yesno
  pbp_b5_maxenr_per
  pbp_b5_coins_yesno
  pbp_b5_coins_cov
  pbp_b5_ded_yesno
  pbp_b5_copay_yesno
  pbp_b5_auth
  pbp_b5_maxplan_yesno_pos
  pbp_b5_maxpln_per_pos
  pbp_b5_maxpln_cov_pos
  pbp_b5_maxenr_yn_pos
  pbp_b5_coins_yesno_pos
  pbp_b5_coins_cov_pos
  pbp_b5_ded_yesno_pos
  pbp_b5_copay_yesno_pos
  pbp_b5_auth_pos / missing;
run;

proc contents data = out.pbp_b5;
  title 'pbp b5 data';
run;
