*pbp_b6.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b6;

length
   pbp_a_hnumber                  $5
   pbp_a_plan_identifier          $3
   pbp_a_ben_cov                  $1
   pbp_a_plan_type                $2
   orgtype                        $2
   pbp_b6_bendec_yesno            $1
   pbp_b6_bendec_hh               $3
   pbp_b6_bendesc_amo             $1
   pbp_b6_bendesc_amorc           $1
   pbp_b6_bendesc_amohs           $1
   pbp_b6_maxenr_yesno            $1
   pbp_b6_maxenr_per              $1
   pbp_b6_coins_yesno             $1
   pbp_b6_coins_cov_mc            $1
   pbp_b6_coins_cov_cc            $1
   pbp_b6_coins_cov_rc            $1
   pbp_b6_coins_cov_hs            $1
   pbp_b_6_ded_yesno              $1
   pbp_b6_copay_yesno             $1
   pbp_b6_auth                    $5
   pbp_b6_maxplan_yesno_pos       $1
   pbp_b6_maxpln_per_pos          $1
   pbp_b6_maxpln_cov_pos          $1
   pbp_b6_maxenr_yn_pos           $1
   pbp_b6_coins_yesno_pos         $1
   pbp_b6_coins_cov_pos           $1
   pbp_b6_ded_yesno_pos           $1
   pbp_b6_copay_yesno_pos         $1
   pbp_b6_auth_pos                $5
;


infile '.\pbp\pbp_b6_home_health.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b6_bendec_yesno
   pbp_b6_bendec_hh
   pbp_b6_bendesc_amo
   pbp_b6_bendesc_amorc
   pbp_b6_bendesc_amohs
   pbp_b6_maxenr_yesno
   pbp_b6_maxenr_amt
   pbp_b6_maxenr_per
   pbp_b6_coins_yesno
   pbp_b6_coins_pct_mc
   pbp_b6_coins_pct_mcmax
   pbp_b6_coins_cov_mc
   pbp_b6_coins_pct_cc
   pbp_b6_coins_pct_ccmax
   pbp_b6_coins_cov_cc
   pbp_b6_coins_pct_rc
   pbp_b6_coins_pct_rcmax
   pbp_b6_coins_cov_rc
   pbp_b6_coins_pct_hs
   pbp_b6_coins_pct_hsmax
   pbp_b6_coins_cov_hs
   pbp_b_6_ded_yesno
   pbp_b_6_ded_amt
   pbp_b6_copay_yesno
   pbp_b6_copay_mcamt
   pbp_b6_copay_mcamtmax
   pbp_b6_copay_cc_amt
   pbp_b6_copay_cc_amtmax
   pbp_b6_copay_rc_amt
   pbp_b6_copay_rc_amtmax
   pbp_b6_copay_hs_amt
   pbp_b6_copay_hs_amtmax
   pbp_b6_auth
   pbp_b6_maxplan_yesno_pos
   pbp_b6_maxpln_amt_pos
   pbp_b6_maxpln_per_pos
   pbp_b6_maxpln_cov_pos
   pbp_b6_maxenr_yn_pos
   pbp_b6_maxenr_amt_pos
   pbp_b6_coins_yesno_pos
   pbp_b6_coins_pct_pos
   pbp_b6_coins_pct_max_pos
   pbp_b6_coins_cov_pos
   pbp_b6_ded_yesno_pos
   pbp_b6_ded_amt_pos
   pbp_b6_copay_yesno_pos
   pbp_b6_copay_amtv_pos
   pbp_b6_copay_max_amtv_pos
   pbp_b6_auth_pos
;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b6_auth                     = 'Home Health Auth                  '
pbp_b6_auth_pos                 = 'Home Health Auth POS              '
pbp_b6_bendec_hh                = 'Home Health Ben Dec               '
pbp_b6_bendec_yesno             = 'Home Health Ben Des Yes No        '
pbp_b6_bendesc_amo              = 'Home Health Ben Des AMO           '
pbp_b6_bendesc_amohs            = 'Home Health Ben Des HS AMO        '
pbp_b6_bendesc_amorc            = 'Home Health Ben Des RC AMO        '
pbp_b6_coins_cov_cc             = 'Home Health CC Coins Cov          '
pbp_b6_coins_cov_hs             = 'Home Health HS Coins Cov          '
pbp_b6_coins_cov_mc             = 'Home Health MC Coins Cov          '
pbp_b6_coins_cov_pos            = 'Home Health Coins Cov POS         '
pbp_b6_coins_cov_rc             = 'Home Health RC Coins Cov          '
pbp_b6_coins_pct_cc             = 'HH Cust Care Min Coin Pct         '
pbp_b6_coins_pct_ccmax          = 'HH Cust Care Max Coin Pct         '
pbp_b6_coins_pct_hs             = 'HH Home Svcs Min Coin Pct         '
pbp_b6_coins_pct_hsmax          = 'HH Home Svcs Max Coin Pct         '
pbp_b6_coins_pct_max_pos        = 'Home Health Max Coin Pct POS      '
pbp_b6_coins_pct_mc             = 'Home Health MC Min Coin Pct       '
pbp_b6_coins_pct_mcmax          = 'Home Health MC Max Coin Pct       '
pbp_b6_coins_pct_pos            = 'Home Health Min Coin Pct POS      '
pbp_b6_coins_pct_rc             = 'HH Resp Care Min Coin Pct         '
pbp_b6_coins_pct_rcmax          = 'HH Resp Care Max Coin Pct         '
pbp_b6_coins_yesno              = 'Home Health Coins Yes No          '
pbp_b6_coins_yesno_pos          = 'Home Health Coinsurance YN POS    '
pbp_b6_copay_amtv_pos           = 'Home Health Min Cpy Amt Visit POS '
pbp_b6_copay_cc_amt             = 'Home Health CC Min Copay Amt      '
pbp_b6_copay_cc_amtmax          = 'Home Health CC Max Copay Amt      '
pbp_b6_copay_hs_amt             = 'Home Health HS Min Copay Amt      '
pbp_b6_copay_hs_amtmax          = 'Home Health HS Max Copay Amt      '
pbp_b6_copay_max_amtv_pos       = 'Home Health Max Cpy Amt Visit POS '
pbp_b6_copay_mcamt              = 'Home Health MC Min Copay Amt      '
pbp_b6_copay_mcamtmax           = 'Home Health MC Max Copay Amt      '
pbp_b6_copay_rc_amt             = 'Home Health RC Min Copay Amt      '
pbp_b6_copay_rc_amtmax          = 'Home Health RC Max Copay Amt      '
pbp_b6_copay_yesno              = 'Home Health Copay Yes No          '
pbp_b6_copay_yesno_pos          = 'Home Health Copay Yes No POS      '
pbp_b6_ded_amt_pos              = 'Home Health Deductible Amt POS    '
pbp_b6_ded_yesno_pos            = 'Home Health Deduct Yes No POS     '
pbp_b6_maxenr_amt               = 'Home Health Max Enr Amt           '
pbp_b6_maxenr_amt_pos           = 'Home Health Max Enr Amt POS       '
pbp_b6_maxenr_per               = 'Home Health Max Enr Per           '
pbp_b6_maxenr_yesno             = 'Home Health Max Enr Yes No        '
pbp_b6_maxenr_yn_pos            = 'Home Health Max Enr Y/N POS       '
pbp_b6_maxplan_yesno_pos        = 'Home Health Max Plan Y/N POS      '
pbp_b6_maxpln_amt_pos           = 'Home Health Max Plan Amt POS      '
pbp_b6_maxpln_cov_pos           = 'Home Health Max Plan Cov POS      '
pbp_b6_maxpln_per_pos           = 'Home Health Max Pln Per POS       '
pbp_b_6_ded_amt                 = 'Home Health Deductible Amt        '
pbp_b_6_ded_yesno               = 'Home Health Deductible Yes No     '
;
run;

proc sort data = pbp_b6 out = out.pbp_b6;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b6 (obs = 10);
  title 'pbp b6 data';
run;

proc means data =  out.pbp_b6;
  title 'pbp b6 file';
run;

proc freq data = out.pbp_b6;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b6_bendec_yesno
  pbp_b6_bendec_hh
  pbp_b6_bendesc_amo
  pbp_b6_bendesc_amorc
  pbp_b6_bendesc_amohs
  pbp_b6_maxenr_yesno
  pbp_b6_maxenr_per
  pbp_b6_coins_yesno
  pbp_b6_coins_cov_mc
  pbp_b6_coins_cov_cc
  pbp_b6_coins_cov_rc
  pbp_b6_coins_cov_hs
  pbp_b_6_ded_yesno
  pbp_b6_copay_yesno
  pbp_b6_auth
  pbp_b6_maxplan_yesno_pos
  pbp_b6_maxpln_per_pos
  pbp_b6_maxpln_cov_pos
  pbp_b6_maxenr_yn_pos
  pbp_b6_coins_yesno_pos
  pbp_b6_coins_cov_pos
  pbp_b6_ded_yesno_pos
  pbp_b6_copay_yesno_pos
  pbp_b6_auth_pos / missing;
run;

proc contents data = out.pbp_b6;
  title 'pbp b6 data';
run;
