*pbp_b7ae.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b7ae;

length
   pbp_a_hnumber                    $5
   pbp_a_plan_identifier            $3
   pbp_a_ben_cov                    $1
   pbp_a_plan_type                  $2
   orgtype                          $2
   pbp_b7a_maxenr_yesno             $1
   pbp_b7a_maxenr_per               $1
   pbp_b7a_coins_yesno              $1
   pbp_b7a_coins_cov_mc             $1
   pbp_b_7a_ded_yesno               $1
   pbp_b7a_copay_yesno              $1
   pbp_b7a_maxplan_yesno_pos        $1
   pbp_b7a_maxpln_per_pos           $1
   pbp_b7a_maxpln_cov_pos           $1
   pbp_b7a_maxenr_yn_pos            $1
   pbp_b7a_coins_yesno_pos          $1
   pbp_b7a_coins_cov_pos            $1
   pbp_b7a_ded_yesno_pos            $1
   pbp_b7a_copay_yesno_pos          $1
   pbp_b7b_bendec_yesno             $1
   pbp_b7b_bendec_rc                $1
   pbp_b7b_bendesc_amo              $1
   pbp_b7b_bendesc_lim_rc           $1
   pbp_b7b_bendesc_per              $1
   pbp_b7b_maxenr_yesno             $1
   pbp_b7b_maxenr_per               $1
   pbp_b7b_coins_yesno              $1
   pbp_b7b_coins_cov_mc             $1
   pbp_b7b_coins_cov_cc             $1
   pbp_b_7b_ded_yesno               $1
   pbp_b7b_copay_yesno              $1
   pbp_b7b_auth                     $5
   pbp_b7b_maxplan_yesno_pos        $1
   pbp_b7b_maxpln_per_pos           $1
   pbp_b7b_maxpln_cov_pos           $1
   pbp_b7b_maxenr_yn_pos            $1
   pbp_b7b_coins_yesno_pos          $1
   pbp_b7b_coins_cov_pos            $1
   pbp_b7b_ded_yesno_pos            $1
   pbp_b7b_copay_yesno_pos          $1
   pbp_b7b_auth_pos                 $5
   pbp_b7c_maxenr_yesno             $1
   pbp_b7c_maxenr_per               $1
   pbp_b7c_coins_yesno              $1
   pbp_b7c_coins_cov_mc             $1
   pbp_b_7c_ded_yesno               $1
   pbp_b7c_copay_yesno              $1
   pbp_b_7c_auth                    $5
   pbp_b7c_maxplan_yesno_pos        $1
   pbp_b7c_maxpln_per_pos           $1
   pbp_b7c_maxpln_cov_pos           $1
   pbp_b7c_maxenr_yn_pos            $1
   pbp_b7c_coins_yesno_pos          $1
   pbp_b7c_coins_cov_pos            $1
   pbp_b7c_ded_yesno_pos            $1
   pbp_b7c_copay_yesno_pos          $1
   pbp_b7c_auth_pos                 $5
   pbp_b7d_maxenr_yesno             $1
   pbp_b7d_maxenr_per               $1
   pbp_b7d_coins_yesno              $1
   pbp_b7d_coins_cov_max_mc         $1
   pbp_b_7d_ded_yesno               $1
   pbp_b7d_copay_yesno              $1
   pbp_b7d_auth                     $5
   pbp_b7d_maxplan_yesno_pos        $1
   pbp_b7d_maxpln_per_pos           $1
   pbp_b7d_maxpln_cov_pos           $1
   pbp_b7d_maxenr_yn_pos            $1
   pbp_b7d_coins_yesno_pos          $1
   pbp_b7d_coins_cov_pos            $1
   pbp_b7d_ded_yesno_pos            $1
   pbp_b7d_copay_yesno_pos          $1
   pbp_b7d_auth_pos                 $5
   pbp_b7e_maxenr_yesno             $1
   pbp_b7e_maxenr_per               $1
   pbp_b7e_coins_yesno              $1
   pbp_b7e_coins_cov_ind_mc         $1
   pbp_b7e_coins_cov_grp_mc         $1
   pbp_b_7e_ded_yesno               $1
   pbp_b7e_copay_yesno              $1
   pbp_b7e_auth                     $5
   pbp_b7e_maxplan_yesno_pos        $1
   pbp_b7e_maxpln_per_pos           $1
   pbp_b7e_maxpln_cov_pos           $1
   pbp_b7e_maxenr_yn_pos            $1
   pbp_b7e_coins_yesno_pos          $1
   pbp_b7e_coins_cov_pos            $1
   pbp_b7e_coins_cov_grp_pos        $1
   pbp_b7e_ded_yesno_pos            $1
   pbp_b7e_copay_yesno_pos          $1
   pbp_b7e_auth_pos                 $5
;

infile '.\pbp\pbp_b7_health_prof_1.txt'
delimiter = '09'x dsd lrecl = 30000 firstobs = 2 missover;


   input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b7a_maxenr_yesno
   pbp_b7a_maxenr_amt
   pbp_b7a_maxenr_per
   pbp_b7a_coins_yesno
   pbp_b7a_coins_pct_mc
   pbp_b7a_coins_mcmax_pct
   pbp_b7a_coins_cov_mc
   pbp_b_7a_ded_yesno
   pbp_b_7a_ded_amt
   pbp_b7a_copay_yesno
   pbp_b7a_copay_mcamt
   pbp_b7a_copay_max_mcamt
   pbp_b7a_maxplan_yesno_pos
   pbp_b7a_maxpln_amt_pos
   pbp_b7a_maxpln_per_pos
   pbp_b7a_maxpln_cov_pos
   pbp_b7a_maxenr_yn_pos
   pbp_b7a_maxenr_amt_pos
   pbp_b7a_coins_yesno_pos
   pbp_b7a_coins_pct_pos
   pbp_b7a_coins_pctmax_pos
   pbp_b7a_coins_cov_pos
   pbp_b7a_ded_yesno_pos
   pbp_b7a_ded_amt_pos
   pbp_b7a_copay_yesno_pos
   pbp_b7a_copay_amtv_pos
   pbp_b7a_copay_amtmax_pos
   pbp_b7b_bendec_yesno
   pbp_b7b_bendec_rc
   pbp_b7b_bendesc_amo
   pbp_b7b_bendesc_lim_rc
   pbp_b7b_bendesc_amt_rc
   pbp_b7b_bendesc_per
   pbp_b7b_maxenr_yesno
   pbp_b7b_maxenr_amt
   pbp_b7b_maxenr_per
   pbp_b7b_coins_yesno
   pbp_b7b_coins_pct_mc
   pbp_b7b_coins_pct_maxmc
   pbp_b7b_coins_cov_mc
   pbp_b7b_coins_pct_cc
   pbp_b7b_coins_pct_maxcc
   pbp_b7b_coins_cov_cc
   pbp_b_7b_ded_yesno
   pbp_b_7b_ded_amt
   pbp_b7b_copay_yesno
   pbp_b7b_copay_mcamt
   pbp_b7b_copay_mcamt_max
   pbp_b7b_copay_rc_amt
   pbp_b7b_copay_rc_amt_max
   pbp_b7b_auth
   pbp_b7b_maxplan_yesno_pos
   pbp_b7b_maxpln_amt_pos
   pbp_b7b_maxpln_per_pos
   pbp_b7b_maxpln_cov_pos
   pbp_b7b_maxenr_yn_pos
   pbp_b7b_maxenr_amt_pos
   pbp_b7b_coins_yesno_pos
   pbp_b7b_coins_pct_pos
   pbp_b7b_coins_pctmax_pos
   pbp_b7b_coins_cov_pos
   pbp_b7b_ded_yesno_pos
   pbp_b7b_ded_amt_pos
   pbp_b7b_copay_yesno_pos
   pbp_b7b_copay_amtv_pos
   pbp_b7b_copay_amtvmax_pos
   pbp_b7b_auth_pos
   pbp_b7c_maxenr_yesno
   pbp_b7c_maxenr_amt
   pbp_b7c_maxenr_per
   pbp_b7c_coins_yesno
   pbp_b7c_coins_pct_mc
   pbp_b7c_coins_pct_mcmax
   pbp_b7c_coins_cov_mc
   pbp_b_7c_ded_yesno
   pbp_b_7c_ded_amt
   pbp_b7c_copay_yesno
   pbp_b7c_copay_mcamt
   pbp_b7c_copay_mcamtmax
   pbp_b_7c_auth
   pbp_b7c_maxplan_yesno_pos
   pbp_b7c_maxpln_amt_pos
   pbp_b7c_maxpln_per_pos
   pbp_b7c_maxpln_cov_pos
   pbp_b7c_maxenr_yn_pos
   pbp_b7c_maxenr_amt_pos
   pbp_b7c_coins_yesno_pos
   pbp_b7c_coins_pct_pos
   pbp_b7c_coins_pctmax_pos
   pbp_b7c_coins_cov_pos
   pbp_b7c_ded_yesno_pos
   pbp_b7c_ded_amt_pos
   pbp_b7c_copay_yesno_pos
   pbp_b7c_copay_amtv_pos
   pbp_b7c_copay_amtmax_pos
   pbp_b7c_auth_pos
   pbp_b7d_maxenr_yesno
   pbp_b7d_maxenr_amt
   pbp_b7d_maxenr_per
   pbp_b7d_coins_yesno
   pbp_b7d_coins_pct_min_mc
   pbp_b7d_coins_pct_max_mc
   pbp_b7d_coins_cov_max_mc
   pbp_b_7d_ded_yesno
   pbp_b_7d_ded_amt
   pbp_b7d_copay_yesno
   pbp_b7d_copay_min_mc_amt
   pbp_b7d_copay_max_mc_amt
   pbp_b7d_auth
   pbp_b7d_maxplan_yesno_pos
   pbp_b7d_maxpln_amt_pos
   pbp_b7d_maxpln_per_pos
   pbp_b7d_maxpln_cov_pos
   pbp_b7d_maxenr_yn_pos
   pbp_b7d_maxenr_amt_pos
   pbp_b7d_coins_yesno_pos
   pbp_b7d_coins_pct_pos
   pbp_b7d_coins_pctmax_pos
   pbp_b7d_coins_cov_pos
   pbp_b7d_ded_yesno_pos
   pbp_b7d_ded_amt_pos
   pbp_b7d_copay_yesno_pos
   pbp_b7d_copay_min_amtv_pos
   pbp_b7d_copay_max_amtv_pos
   pbp_b7d_auth_pos
   pbp_b7e_maxenr_yesno
   pbp_b7e_maxenr_amt
   pbp_b7e_maxenr_per
   pbp_b7e_coins_yesno
   pbp_b7e_coins_pct_ind_mc
   pbp_b7e_coins_pct_ind_maxmc
   pbp_b7e_coins_cov_ind_mc
   pbp_b7e_coins_pct_grp_mc
   pbp_b7e_coins_pct_grp_maxmc
   pbp_b7e_coins_cov_grp_mc
   pbp_b_7e_ded_yesno
   pbp_b_7e_ded_amt
   pbp_b7e_copay_yesno
   pbp_b7e_copay_ind_min_mc_amt
   pbp_b7e_copay_ind_max_mc_amt
   pbp_b7e_copay_grp_min_mc_amt
   pbp_b7e_copay_grp_max_mc_amt
   pbp_b7e_auth
   pbp_b7e_maxplan_yesno_pos
   pbp_b7e_maxpln_amt_pos
   pbp_b7e_maxpln_per_pos
   pbp_b7e_maxpln_cov_pos
   pbp_b7e_maxenr_yn_pos
   pbp_b7e_maxenr_amt_pos
   pbp_b7e_coins_yesno_pos
   pbp_b7e_coins_pct_pos
   pbp_b7e_coins_pct_max_pos
   pbp_b7e_coins_cov_pos
   pbp_b7e_coins_pct_grpmin_pos
   pbp_b7e_coins_pct_grpmax_pos
   pbp_b7e_coins_cov_grp_pos
   pbp_b7e_ded_yesno_pos
   pbp_b7e_ded_amt_pos
   pbp_b7e_copay_yesno_pos
   pbp_b7e_copay_min_ind_amt_pos
   pbp_b7e_copay_max_ind_amt_pos
   pbp_b7e_copay_min_grp_amt_pos
   pbp_b7e_copay_max_grp_amt_pos
   pbp_b7e_auth_pos
;

  label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b7a_coins_cov_mc            = 'Primary Care MC Coins Cov         '
pbp_b7a_coins_cov_pos           = 'Primary Care Coins Cov POS        '
pbp_b7a_coins_mcmax_pct         = 'Primary Care MC Max Coin Pct      '
pbp_b7a_coins_pct_mc            = 'Primary Care MC Min Coin Pct      '
pbp_b7a_coins_pct_pos           = 'Primary Care Min Coin Pct POS     '
pbp_b7a_coins_pctmax_pos        = 'Primary Care Max Coin Pct POS     '
pbp_b7a_coins_yesno             = 'Primary Care Coins Yes No         '
pbp_b7a_coins_yesno_pos         = 'Primary Care Coinsurance YN POS   '
pbp_b7a_copay_amtmax_pos        = 'Primary Care Copay Max Amt POS    '
pbp_b7a_copay_amtv_pos          = 'Primary Care Copay Min Amt POS    '
pbp_b7a_copay_max_mcamt         = 'Primary Care MC Max Copay Amt     '
pbp_b7a_copay_mcamt             = 'Primary Care MC Min Copay Amt     '
pbp_b7a_copay_yesno             = 'Primary Care Copay Yes No         '
pbp_b7a_copay_yesno_pos         = 'Primary Care Copay Yes No POS     '
pbp_b7a_ded_amt_pos             = 'Primary Care Deductible Amt POS   '
pbp_b7a_ded_yesno_pos           = 'Primary Care Deduct Yes No POS    '
pbp_b7a_maxenr_amt              = 'Primary Care Max Enr Amt          '
pbp_b7a_maxenr_amt_pos          = 'Primary Care Max Enr Amt POS      '
pbp_b7a_maxenr_per              = 'Primary Care Max Enr Per          '
pbp_b7a_maxenr_yesno            = 'Primary Care Max Enr Yes No       '
pbp_b7a_maxenr_yn_pos           = 'Primary Care Max Enr Y/N POS      '
pbp_b7a_maxplan_yesno_pos       = 'Primary Care Max Plan Y/N POS     '
pbp_b7a_maxpln_amt_pos          = 'Primary Care Max Plan Amt POS     '
pbp_b7a_maxpln_cov_pos          = 'Primary Care Max Plan Cov POS     '
pbp_b7a_maxpln_per_pos          = 'Primary Care Max Pln Per POS      '
pbp_b7b_auth                    = 'Chiropractic Auth                 '
pbp_b7b_auth_pos                = 'Chiropractic Services Auth POS    '
pbp_b7b_bendec_rc               = 'Chiropractic Ben Dec              '
pbp_b7b_bendec_yesno            = 'Chiropractic Ben Des Yes No       '
pbp_b7b_bendesc_amo             = 'Chiropractic Ben Des AMO          '
pbp_b7b_bendesc_amt_rc          = 'Chiropractic Ben Desc Amt         '
pbp_b7b_bendesc_lim_rc          = 'Chiropractic Ben Desc Lim         '
pbp_b7b_bendesc_per             = 'Chiropractic Ben Desc Per         '
pbp_b7b_coins_cov_cc            = 'Chiropractic RC Coins Cov         '
pbp_b7b_coins_cov_mc            = 'Chiropractic MC Coins Cov         '
pbp_b7b_coins_cov_pos           = 'Chiropractic Coins Cov POS        '
pbp_b7b_coins_pct_cc            = 'Chiro Rtn Care Min Coin Pct       '
pbp_b7b_coins_pct_maxcc         = 'Chiro Rtn Care Max Coin Pct       '
pbp_b7b_coins_pct_maxmc         = 'Chiropractic MC Max Coin Pct      '
pbp_b7b_coins_pct_mc            = 'Chiropractic MC Min Coin Pct      '
pbp_b7b_coins_pct_pos           = 'Chiropractic Min Coin Pct POS     '
pbp_b7b_coins_pctmax_pos        = 'Chiropractic Max Coin Pct POS     '
pbp_b7b_coins_yesno             = 'Chiropractic Coins Yes No         '
pbp_b7b_coins_yesno_pos         = 'Chiropractic Coinsurance YN POS   '
pbp_b7b_copay_amtv_pos          = 'Primary Care Min Cpy Amt Visit POS'
pbp_b7b_copay_amtvmax_pos       = 'Primary Care Max Cpy Amt Visit POS'
pbp_b7b_copay_mcamt             = 'Chiropractic MC Min Copay Amt     '
pbp_b7b_copay_mcamt_max         = 'Chiropractic MC Max Copay Amt     '
pbp_b7b_copay_rc_amt            = 'Chiropractic RC Min Copay Amt     '
pbp_b7b_copay_rc_amt_max        = 'Chiropractic RC Max Copay Amt     '
pbp_b7b_copay_yesno             = 'Chiropractic Copay Yes No         '
pbp_b7b_copay_yesno_pos         = 'Chiropractic Copay Yes No POS     '
pbp_b7b_ded_amt_pos             = 'Chiropractic Deductible Amt POS   '
pbp_b7b_ded_yesno_pos           = 'Chiropractic Deduct Yes No POS    '
pbp_b7b_maxenr_amt              = 'Chiropractic Max Enr Amt          '
pbp_b7b_maxenr_amt_pos          = 'Chiropractic Max Enr Amt POS      '
pbp_b7b_maxenr_per              = 'Chiropractic Max Enr Per          '
pbp_b7b_maxenr_yesno            = 'Chiropractic Max Enr Yes No       '
pbp_b7b_maxenr_yn_pos           = 'Chiropractic Max Enr Y/N POS      '
pbp_b7b_maxplan_yesno_pos       = 'Chiropractic Max Plan Y/N POS     '
pbp_b7b_maxpln_amt_pos          = 'Chiropractic Max Plan Amt POS     '
pbp_b7b_maxpln_cov_pos          = 'Chiropractic Max Plan Cov POS     '
pbp_b7b_maxpln_per_pos          = 'Chiropractic Max Pln Per POS      '
pbp_b7c_auth_pos                = 'Occ Therapy Services Auth POS     '
pbp_b7c_coins_cov_mc            = 'Occ Therapy MC Coins Cov          '
pbp_b7c_coins_cov_pos           = 'Occ Therapy Coins Cov POS         '
pbp_b7c_coins_pct_mc            = 'Occ Therapy MC Min Coin Pct       '
pbp_b7c_coins_pct_mcmax         = 'Occ Therapy MC Max Coin Pct       '
pbp_b7c_coins_pct_pos           = 'Occ Therapy Min Coin Pct POS      '
pbp_b7c_coins_pctmax_pos        = 'Occ Therapy Max Coin Pct POS      '
pbp_b7c_coins_yesno             = 'Occ Therapy Coins Yes No          '
pbp_b7c_coins_yesno_pos         = 'Occ Therapy Coinsurance YN POS    '
pbp_b7c_copay_amtmax_pos        = 'Occ Therapy Max Copay Amt POS     '
pbp_b7c_copay_amtv_pos          = 'Occ Therapy Min Copay Amt POS     '
pbp_b7c_copay_mcamt             = 'Occ Therapy MC Min Copay Amt      '
pbp_b7c_copay_mcamtmax          = 'Occ Therapy MC Max Copay Amt      '
pbp_b7c_copay_yesno             = 'Occ Therapy Copay Yes No          '
pbp_b7c_copay_yesno_pos         = 'Occ Therapy Copay Yes No POS      '
pbp_b7c_ded_amt_pos             = 'Occ Therapy Deductible Amt POS    '
pbp_b7c_ded_yesno_pos           = 'Occ Therapy Deduct Yes No POS     '
pbp_b7c_maxenr_amt              = 'Occ Therapy Max Enr Amt           '
pbp_b7c_maxenr_amt_pos          = 'Occ Therapy Max Enr Amt POS       '
pbp_b7c_maxenr_per              = 'Occ Therapy Max Enr Per           '
pbp_b7c_maxenr_yesno            = 'Occ Therapy Max Enr Yes No        '
pbp_b7c_maxenr_yn_pos           = 'Occ Therapy Max Enr Y/N POS       '
pbp_b7c_maxplan_yesno_pos       = 'Occ Therapy Max Plan Y/N POS      '
pbp_b7c_maxpln_amt_pos          = 'Occ Therapy Max Plan Amt POS      '
pbp_b7c_maxpln_cov_pos          = 'Occ Therapy Max Plan Cov POS      '
pbp_b7c_maxpln_per_pos          = 'Occ Therapy Max Pln Per POS       '
pbp_b7d_auth                    = 'Phys Specialist Auth              '
pbp_b7d_auth_pos                = 'Phys Specialist Auth POS          '
pbp_b7d_coins_cov_max_mc        = 'Phys Spclist Max MC Coins Cov     '
pbp_b7d_coins_cov_pos           = 'Phys Specialist Coins Cov POS     '
pbp_b7d_coins_pct_max_mc        = 'Phys Spclist Max MC Coin Pct      '
pbp_b7d_coins_pct_min_mc        = 'Phys Spclist Min MC Coin Pct      '
pbp_b7d_coins_pct_pos           = 'Phys Specialist Min Coin Pct POS  '
pbp_b7d_coins_pctmax_pos        = 'Phys Specialist Max Coin Pct POS  '
pbp_b7d_coins_yesno             = 'Phys Specialist Coins Yes No      '
pbp_b7d_coins_yesno_pos         = 'Phys Specialist Coinsurance YN POS'
pbp_b7d_copay_max_amtv_pos      = 'Phys Spclist Cpy Max Amt POS      '
pbp_b7d_copay_max_mc_amt        = 'Phys Spclist Max MC Copay Amt     '
pbp_b7d_copay_min_amtv_pos      = 'Phys Special Cpy Min Amt POS      '
pbp_b7d_copay_min_mc_amt        = 'Phys Spclist Min MC Copay Amt     '
pbp_b7d_copay_yesno             = 'Phys Specialist Copay Yes No      '
pbp_b7d_copay_yesno_pos         = 'Phys Specialist Copay Yes No POS  '
pbp_b7d_ded_amt_pos             = 'Phys Specialist Deductible Amt POS'
pbp_b7d_ded_yesno_pos           = 'Phys Specialist Deduct Yes No POS '
pbp_b7d_maxenr_amt              = 'Phys Specialist Max Enr Amt       '
pbp_b7d_maxenr_amt_pos          = 'Phys Specialist Max Enr Amt POS   '
pbp_b7d_maxenr_per              = 'Phys Specialist Max Enr Per       '
pbp_b7d_maxenr_yesno            = 'Phys Specialist Max Enr Yes No    '
pbp_b7d_maxenr_yn_pos           = 'Phys Specialist Max Enr Y/N POS   '
pbp_b7d_maxplan_yesno_pos       = 'Phys Specialist Max Plan Y/N POS  '
pbp_b7d_maxpln_amt_pos          = 'Phys Specialist Max Plan Amt POS  '
pbp_b7d_maxpln_cov_pos          = 'Phys Specialist Max Plan Cov POS  '
pbp_b7d_maxpln_per_pos          = 'Phys Specialist Max Pln Per POS   '
pbp_b7e_auth                    = 'Mental Health Auth                '
pbp_b7e_auth_pos                = 'Mental Health Services Auth POS   '
pbp_b7e_coins_cov_grp_mc        = 'Mental Health Grp MC Coins Cov    '
pbp_b7e_coins_cov_grp_pos       = 'Mental Health Group Coins Cov POS '
pbp_b7e_coins_cov_ind_mc        = 'Mental Health Ind MC Coins Cov    '
pbp_b7e_coins_cov_pos           = 'Mental Health Coins Cov POS       '
pbp_b7e_coins_pct_grp_maxmc     = 'Mntl Hlth Grp MC Max Coin Pct     '
pbp_b7e_coins_pct_grp_mc        = 'Mntl Hlth Grp MC Min Coin Pct     '
pbp_b7e_coins_pct_grpmax_pos    = 'Mental Health Max Grp Coin Pct POS'
pbp_b7e_coins_pct_grpmin_pos    = 'Mental Health Min Grp Coin Pct POS'
pbp_b7e_coins_pct_ind_maxmc     = 'Mntl Hlth Ind MC Max Coin Pct     '
pbp_b7e_coins_pct_ind_mc        = 'Mntl Hlth Ind MC Min Coin Pct     '
pbp_b7e_coins_pct_max_pos       = 'Mental Health Max Ind Coin Pct POS'
pbp_b7e_coins_pct_pos           = 'Mental Health Min Ind Coin Pct POS'
pbp_b7e_coins_yesno             = 'Mental Health Coins Yes No        '
pbp_b7e_coins_yesno_pos         = 'Mental Health Coinsurance YN POS  '
pbp_b7e_copay_grp_max_mc_amt    = 'Mental Hlth Grp Max MC Cpy Amt    '
pbp_b7e_copay_grp_min_mc_amt    = 'Mental Hlth Grp Min MC Cpy Amt    '
pbp_b7e_copay_ind_max_mc_amt    = 'Mental Hlth Ind Max MC Cpy Amt    '
pbp_b7e_copay_ind_min_mc_amt    = 'Mental Hlth Ind Min MC Cpy Amt    '
pbp_b7e_copay_max_grp_amt_pos   = 'Mental Hlth Cpy Max Grp Amt POS   '
pbp_b7e_copay_max_ind_amt_pos   = 'Mental Hlth Cpy Max Ind Amt POS   '
pbp_b7e_copay_min_grp_amt_pos   = 'Mental Hlth Copay Min Grp Amt POS '
pbp_b7e_copay_min_ind_amt_pos   = 'Mental Hlth Copay Min Ind Amt POS '
pbp_b7e_copay_yesno             = 'Mental Health Copay Yes No        '
pbp_b7e_copay_yesno_pos         = 'Mental Health Copay Yes No POS    '
pbp_b7e_ded_amt_pos             = 'Mental Health Deductible Amt POS  '
pbp_b7e_ded_yesno_pos           = 'Mental Health Deduct Yes No POS   '
pbp_b7e_maxenr_amt              = 'Mental Health Max Enr Amt         '
pbp_b7e_maxenr_amt_pos          = 'Mental Health Max Enr Amt POS     '
pbp_b7e_maxenr_per              = 'Mental Health Max Enr Per         '
pbp_b7e_maxenr_yesno            = 'Mental Health Max Enr Yes No      '
pbp_b7e_maxenr_yn_pos           = 'Mental Health Max Enr Y/N POS     '
pbp_b7e_maxplan_yesno_pos       = 'Mental Health Max Plan Y/N POS    '
pbp_b7e_maxpln_amt_pos          = 'Mental Health Max Plan Amt POS    '
pbp_b7e_maxpln_cov_pos          = 'Mental Health Max Plan Cov POS    '
pbp_b7e_maxpln_per_pos          = 'Mental Health Max Pln Per POS     '
pbp_b_7a_ded_amt                = 'Primary Care Deductible Amt       '
pbp_b_7a_ded_yesno              = 'Primary Care Deductible Yes No    '
pbp_b_7b_ded_amt                = 'Chiropractic Deductible Amt       '
pbp_b_7b_ded_yesno              = 'Chiropractic Deductible Yes No    '
pbp_b_7c_auth                   = 'Occu Therapy Auth                 '
pbp_b_7c_ded_amt                = 'Occu Therapy Deductible Amt       '
pbp_b_7c_ded_yesno              = 'Occu Therapy Deductible Yes No    '
pbp_b_7d_ded_amt                = 'Phys Specialist Deductible Amt    '
pbp_b_7d_ded_yesno              = 'Phys Specialist Deduc Yes No      '
pbp_b_7e_ded_amt                = 'Mental Health Deductible Amt      '
pbp_b_7e_ded_yesno              = 'Mental Health Deduc Yes No        '
;
run;

proc sort data = pbp_b7ae out = out.pbp_b7ae;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b7ae (obs = 10);
  title 'pbp 7ae data';
run;

proc means data =  out.pbp_b7ae;
  title 'pbp b 7ae file';
run;

proc freq data = out.pbp_b7ae;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b7a_maxenr_yesno
  pbp_b7a_maxenr_per
  pbp_b7a_coins_yesno
  pbp_b7a_coins_cov_mc
  pbp_b_7a_ded_yesno
  pbp_b7a_copay_yesno
  pbp_b7a_maxplan_yesno_pos
  pbp_b7a_maxpln_per_pos
  pbp_b7a_maxpln_cov_pos
  pbp_b7a_maxenr_yn_pos
  pbp_b7a_coins_yesno_pos
  pbp_b7a_coins_cov_pos
  pbp_b7a_ded_yesno_pos
  pbp_b7a_copay_yesno_pos
  pbp_b7b_bendec_yesno
  pbp_b7b_bendec_rc
  pbp_b7b_bendesc_amo
  pbp_b7b_bendesc_lim_rc
  pbp_b7b_bendesc_per
  pbp_b7b_maxenr_yesno
  pbp_b7b_maxenr_per
  pbp_b7b_coins_yesno
  pbp_b7b_coins_cov_mc
  pbp_b7b_coins_cov_cc
  pbp_b_7b_ded_yesno
  pbp_b7e_auth_pos / missing;
run;

proc contents data = out.pbp_b7ae;
  title 'pbp b7ae data';
run;
