*pbp_b7fi.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b7fi;

length
   pbp_a_hnumber                   $5
   pbp_a_plan_identifier           $3
   pbp_a_ben_cov                   $1
   pbp_a_plan_type                 $2
   orgtype                         $2
   pbp_b7f_bendecs_yesno           $1
   pbp_b7f_bendec_rf               $1
   pbp_b7f_bendesc_rf_amo          $1
   pbp_b7f_bendesc_lim_rf          $1
   pbp_b7f_bendes_per_rf           $1
   pbp_b_7f_maxplan_yesno          $1
   pbp_b_7f_maxplan_per            $1
   pbp_b_7f_maxplan_covb           $1
   pbp_b7f_maxenr_yesno            $1
   pbp_b7f_maxenr_per              $1
   pbp_b7f_coins_yesno             $1
   pbp_b7f_coins_cov_mc            $1
   pbp_b7f_coins_cov_rf            $1
   pbp_b_7f_ded_yesno              $1
   pbp_b7f_copay_yesno             $1
   pbp_b7f_auth                    $5
   pbp_b7f_maxplan_yesno_pos       $1
   pbp_b7f_maxpln_per_pos          $1
   pbp_b7f_maxpln_cov_pos          $1
   pbp_b7f_maxenr_yn_pos           $1
   pbp_b7f_coins_yesno_pos         $1
   pbp_b7f_coins_cov_pos           $1
   pbp_b7f_ded_yesno_pos           $1
   pbp_b7f_copay_yesno_pos         $1
   pbp_b7f_auth_pos                $5
   pbp_b7g_maxenr_yesno            $1
   pbp_b7g_maxenr_per              $1
   pbp_b7g_coins_yesno             $1
   pbp_b7g_coins_cov_mc            $1
   pbp_b_7g_ded_yesno              $1
   pbp_b7g_copay_yesno             $1
   pbp_b7g_auth                    $5
   pbp_b7g_maxplan_yesno_pos       $1
   pbp_b7g_maxpln_per_pos          $1
   pbp_b7g_maxpln_cov_pos          $1
   pbp_b7g_maxenr_yn_pos           $1
   pbp_b7g_coins_yesno_pos         $1
   pbp_b7g_coins_cov_pos           $1
   pbp_b7g_ded_yesno_pos           $1
   pbp_b7g_copay_yesno_pos         $1
   pbp_b7g_auth_pos                $5
   pbp_b7h_maxenr_yesno            $1
   pbp_b7h_maxenr_per              $1
   pbp_b7h_coins_yesno             $1
   pbp_b7h_coins_cov_ind_mc        $1
   pbp_b7h_coins_cov_grp_mc        $1
   pbp_b7h_ded_yesno               $1
   pbp_b7h_copay_yesno             $1
   pbp_b7h_auth                    $5
   pbp_b7h_maxplan_yesno_pos       $1
   pbp_b7h_maxpln_per_pos          $1
   pbp_b7h_maxpln_cov_pos          $1
   pbp_b7h_maxenr_yn_pos           $1
   pbp_b7h_coins_yesno_pos         $1
   pbp_b7h_coins_cov_pos           $1
   pbp_b7h_coins_cov_grp_pos       $1
   pbp_b7h_ded_yesno_pos           $1
   pbp_b7h_copay_yesno_pos         $1
   pbp_b7h_auth_pos                $5
   pbp_b7i_maxenr_yesno            $1
   pbp_b7i_maxenr_per              $1
   pbp_b7i_coins_yesno             $1
   pbp_b7i_coins_cov_mc            $1
   pbp_b7i_ded_yesno               $1
   pbp_b7i_copay_yesno             $1
   pbp_b7i_auth                    $5
   pbp_b7i_maxplan_yesno_pos       $1
   pbp_b7i_maxpln_per_pos          $1
   pbp_b7i_maxpln_cov_pos          $1
   pbp_b7i_maxenr_yn_pos           $1
   pbp_b7i_coins_yesno_pos         $1
   pbp_b7i_coins_cov_pos           $1
   pbp_b7i_ded_yesno_pos           $1
   pbp_b7i_copay_yesno_pos         $1
   pbp_b7i_auth_pos                $5
;


infile '.\pbp\pbp_b7_health_prof_2.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


   input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b7f_bendecs_yesno
   pbp_b7f_bendec_rf
   pbp_b7f_bendesc_rf_amo
   pbp_b7f_bendesc_lim_rf
   pbp_b7f_bendesc_amt_rf
   pbp_b7f_bendes_per_rf
   pbp_b_7f_maxplan_yesno
   pbp_b_7f_maxplan_amt
   pbp_b_7f_maxplan_per
   pbp_b_7f_maxplan_covb
   pbp_b7f_maxenr_yesno
   pbp_b7f_maxenr_amt
   pbp_b7f_maxenr_per
   pbp_b7f_coins_yesno
   pbp_b7f_coins_pct_mc
   pbp_b7f_coins_pct_mcmax
   pbp_b7f_coins_cov_mc
   pbp_b7f_coins_pct_rf
   pbp_b7f_coins_pct_rfmax
   pbp_b7f_coins_cov_rf
   pbp_b_7f_ded_yesno
   pbp_b_7f_ded_amt
   pbp_b7f_copay_yesno
   pbp_b7f_copay_mcamt
   pbp_b7f_copay_mcamtmax
   pbp_b7f_copay_rf_min_amt
   pbp_b7f_copay_rf_max_amt
   pbp_b7f_auth
   pbp_b7f_maxplan_yesno_pos
   pbp_b7f_maxpln_amt_pos
   pbp_b7f_maxpln_per_pos
   pbp_b7f_maxpln_cov_pos
   pbp_b7f_maxenr_yn_pos
   pbp_b7f_maxenr_amt_pos
   pbp_b7f_coins_yesno_pos
   pbp_b7f_coins_pct_pos
   pbp_b7f_coins_pctmax_pos
   pbp_b7f_coins_cov_pos
   pbp_b7f_ded_yesno_pos
   pbp_b7f_ded_amt_pos
   pbp_b7f_copay_yesno_pos
   pbp_b7f_copay_amtv_pos
   pbp_b7f_copay_amtmax_pos
   pbp_b7f_auth_pos
   pbp_b7g_maxenr_yesno
   pbp_b7g_maxenr_amt
   pbp_b7g_maxenr_per
   pbp_b7g_coins_yesno
   pbp_b7g_coins_pct_mc
   pbp_b7g_coins_max_pct_mc
   pbp_b7g_coins_cov_mc
   pbp_b_7g_ded_yesno
   pbp_b_7g_ded_amt
   pbp_b7g_copay_yesno
   pbp_b7g_copay_mcamt
   pbp_b7g_copay_mc_max_amt
   pbp_b7g_auth
   pbp_b7g_maxplan_yesno_pos
   pbp_b7g_maxpln_amt_pos
   pbp_b7g_maxpln_per_pos
   pbp_b7g_maxpln_cov_pos
   pbp_b7g_maxenr_yn_pos
   pbp_b7g_maxenr_amt_pos
   pbp_b7g_coins_yesno_pos
   pbp_b7g_coins_pct_pos
   pbp_b7g_coins_pctmax_pos
   pbp_b7g_coins_cov_pos
   pbp_b7g_ded_yesno_pos
   pbp_b7g_ded_amt_pos
   pbp_b7g_copay_yesno_pos
   pbp_b7g_copay_amtv_pos
   pbp_b7g_copay_amtmax_pos
   pbp_b7g_auth_pos
   pbp_b7h_maxenr_yesno
   pbp_b7h_maxenr_amt
   pbp_b7h_maxenr_per
   pbp_b7h_coins_yesno
   pbp_b7h_coins_pct_ind_mc
   pbp_b7h_coins_pct_ind_mcmax
   pbp_b7h_coins_cov_ind_mc
   pbp_b7h_coins_pct_grp_mc
   pbp_b7h_coins_pct_grp_mcmax
   pbp_b7h_coins_cov_grp_mc
   pbp_b7h_ded_yesno
   pbp_b7h_ded_amt
   pbp_b7h_copay_yesno
   pbp_b7h_copay_mcamt_inmin
   pbp_b7h_copay_mcamt_inmax
   pbp_b7h_copay_mcamt_grpmin
   pbp_b7h_copay_mcamt_grpmax
   pbp_b7h_auth
   pbp_b7h_maxplan_yesno_pos
   pbp_b7h_maxpln_amt_pos
   pbp_b7h_maxpln_per_pos
   pbp_b7h_maxpln_cov_pos
   pbp_b7h_maxenr_yn_pos
   pbp_b7h_maxenr_amt_pos
   pbp_b7h_coins_yesno_pos
   pbp_b7h_coins_pct_pos
   pbp_b7h_coins_pct_indmax_pos
   pbp_b7h_coins_cov_pos
   pbp_b7h_coins_pct_grpmin_pos
   pbp_b7h_coins_pct_grpmax_pos
   pbp_b7h_coins_cov_grp_pos
   pbp_b7h_ded_yesno_pos
   pbp_b7h_ded_amt_pos
   pbp_b7h_copay_yesno_pos
   pbp_b7h_copay_min_ind_amt_pos
   pbp_b7h_copay_max_ind_amt_pos
   pbp_b7h_copay_min_grp_amt_pos
   pbp_b7h_copay_max_grp_amt_pos
   pbp_b7h_auth_pos
   pbp_b7i_maxenr_yesno
   pbp_b7i_maxenr_amt
   pbp_b7i_maxenr_per
   pbp_b7i_coins_yesno
   pbp_b7i_coins_pct_mc
   pbp_b7i_coins_pct_mcmax
   pbp_b7i_coins_cov_mc
   pbp_b7i_ded_yesno
   pbp_b7i_ded_amt
   pbp_b7i_copay_yesno
   pbp_b7i_copay_mcamt
   pbp_b7i_copay_mcamtmax
   pbp_b7i_auth
   pbp_b7i_maxplan_yesno_pos
   pbp_b7i_maxpln_amt_pos
   pbp_b7i_maxpln_per_pos
   pbp_b7i_maxpln_cov_pos
   pbp_b7i_maxenr_yn_pos
   pbp_b7i_maxenr_amt_pos
   pbp_b7i_coins_yesno_pos
   pbp_b7i_coins_pct_pos
   pbp_b7i_coins_pctmax_pos
   pbp_b7i_coins_cov_pos
   pbp_b7i_ded_yesno_pos
   pbp_b7i_ded_amt_pos
   pbp_b7i_copay_yesno_pos
   pbp_b7i_copay_amtv_pos
   pbp_b7i_copay_amtmax_pos
   pbp_b7i_auth_pos
;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b7f_auth                    = 'Podiatrist Auth                   '
pbp_b7f_auth_pos                = 'Podiatrist Services Auth POS      '
pbp_b7f_bendec_rf               = 'Podiatrist Ben Dec RF             '
pbp_b7f_bendecs_yesno           = 'Podiatrist Ben Des Yes No         '
pbp_b7f_bendes_per_rf           = 'Podiatrist Ben Des Per RF         '
pbp_b7f_bendesc_amt_rf          = 'Podiatrist Ben Desc Amt RF        '
pbp_b7f_bendesc_lim_rf          = 'Podiatrist Ben Desc Lim RF        '
pbp_b7f_bendesc_rf_amo          = 'Podiatrist Ben Des AMO RF         '
pbp_b7f_coins_cov_mc            = 'Podiatrist MC Coins Cov           '
pbp_b7f_coins_cov_pos           = 'Podiatrist Coins Cov POS          '
pbp_b7f_coins_cov_rf            = 'Podiatrist RF Coins Cov           '
pbp_b7f_coins_pct_mc            = 'Podiatrist MC Min Coin Pct        '
pbp_b7f_coins_pct_mcmax         = 'Podiatrist MC Max Coin Pct        '
pbp_b7f_coins_pct_pos           = 'Podiatrist Min Coinsurance Pct POS'
pbp_b7f_coins_pct_rf            = 'Podiatry R Ftcare Min Coin Pct    '
pbp_b7f_coins_pct_rfmax         = 'Podiatry R Ftcare Max Coin Pct    '
pbp_b7f_coins_pctmax_pos        = 'Podiatrist Max Coinsurance Pct POS'
pbp_b7f_coins_yesno             = 'Podiatrist Coins Yes No           '
pbp_b7f_coins_yesno_pos         = 'Podiatrist Coinsurance YN POS     '
pbp_b7f_copay_amtmax_pos        = 'Podiatrist Max Copay Amt POS      '
pbp_b7f_copay_amtv_pos          = 'Podiatrist Min Copay Amt POS      '
pbp_b7f_copay_mcamt             = 'Podiatrist MC Min Copay Amt       '
pbp_b7f_copay_mcamtmax          = 'Podiatrist MC Max Copay Amt       '
pbp_b7f_copay_rf_max_amt        = 'Podiatrist RF Max Copay Amt       '
pbp_b7f_copay_rf_min_amt        = 'Podiatrist RF Min Copay Amt       '
pbp_b7f_copay_yesno             = 'Podiatrist Copay Yes No           '
pbp_b7f_copay_yesno_pos         = 'Podiatrist Copay Yes No POS       '
pbp_b7f_ded_amt_pos             = 'Podiatrist Deductible Amt POS     '
pbp_b7f_ded_yesno_pos           = 'Podiatrist Deduct Yes No POS      '
pbp_b7f_maxenr_amt              = 'Podiatrist Max Enr Amt            '
pbp_b7f_maxenr_amt_pos          = 'Podiatrist Max Enr Amt POS        '
pbp_b7f_maxenr_per              = 'Podiatrist Max Enr Per            '
pbp_b7f_maxenr_yesno            = 'Podiatrist Max Enr Yes No         '
pbp_b7f_maxenr_yn_pos           = 'Podiatrist Max Enr Y/N POS        '
pbp_b7f_maxplan_yesno_pos       = 'Podiatrist Max Plan Y/N POS       '
pbp_b7f_maxpln_amt_pos          = 'Podiatrist Max Plan Amt POS       '
pbp_b7f_maxpln_cov_pos          = 'Podiatrist Max Plan Cov POS       '
pbp_b7f_maxpln_per_pos          = 'Podiatrist Max Pln Per POS        '
pbp_b7g_auth                    = 'Oth Health Care Auth              '
pbp_b7g_auth_pos                = 'Oth Health Care Services Auth POS '
pbp_b7g_coins_cov_mc            = 'Oth Health Care MC Coins Cov      '
pbp_b7g_coins_cov_pos           = 'Oth Health Care Coins Cov POS     '
pbp_b7g_coins_max_pct_mc        = 'Oth Hlth Care MC Max Coin Pct     '
pbp_b7g_coins_pct_mc            = 'Oth Hlth Care MC Min Coin Pct     '
pbp_b7g_coins_pct_pos           = 'Oth Health Care Min Coin Pct POS  '
pbp_b7g_coins_pctmax_pos        = 'Oth Health Care Max Coin Pct POS  '
pbp_b7g_coins_yesno             = 'Oth Health Care Coins Yes No      '
pbp_b7g_coins_yesno_pos         = 'Oth Health Care Coinsurance YN POS'
pbp_b7g_copay_amtmax_pos        = 'Oth Health Care Max Cpy Amt POS   '
pbp_b7g_copay_amtv_pos          = 'Oth Health Care Min Cpy Amt POS   '
pbp_b7g_copay_mc_max_amt        = 'Oth Hlth Care MC Max Copay Amt    '
pbp_b7g_copay_mcamt             = 'Oth Hlth Care MC Min Copay Amt    '
pbp_b7g_copay_yesno             = 'Oth Health Care Copay Yes No      '
pbp_b7g_copay_yesno_pos         = 'Oth Health Care Copay Yes No POS  '
pbp_b7g_ded_amt_pos             = 'Oth Health Care Deductible Amt POS'
pbp_b7g_ded_yesno_pos           = 'Oth Health Care Deduct Yes No POS '
pbp_b7g_maxenr_amt              = 'Oth Health Care Max Enr Amt       '
pbp_b7g_maxenr_amt_pos          = 'Oth Health Care Max Enr Amt POS   '
pbp_b7g_maxenr_per              = 'Oth Health Care Max Enr Per       '
pbp_b7g_maxenr_yesno            = 'Oth Health Care Max Enr Yes No    '
pbp_b7g_maxenr_yn_pos           = 'Oth Health Care Max Enr Y/N POS   '
pbp_b7g_maxplan_yesno_pos       = 'Oth Health Care Max Plan Y/N POS  '
pbp_b7g_maxpln_amt_pos          = 'Oth Health Care Max Plan Amt POS  '
pbp_b7g_maxpln_cov_pos          = 'Oth Health Care Max Plan Cov POS  '
pbp_b7g_maxpln_per_pos          = 'Oth Health Care Max Pln Per POS   '
pbp_b7h_auth                    = 'Psychiatric Auth                  '
pbp_b7h_auth_pos                = 'Psychiatric Services Auth POS     '
pbp_b7h_coins_cov_grp_mc        = 'Pschiatric Grp MC Coins Cov       '
pbp_b7h_coins_cov_grp_pos       = 'Psychiatric Coins Grp Cov POS     '
pbp_b7h_coins_cov_ind_mc        = 'Psychiatric Ind MC Coins Cov      '
pbp_b7h_coins_cov_pos           = 'Psychiatric Coins Ind Cov POS     '
pbp_b7h_coins_pct_grp_mc        = 'Psych Grp MC Min Coin Pct         '
pbp_b7h_coins_pct_grp_mcmax     = 'Psych Grp MC Max Coin Pct         '
pbp_b7h_coins_pct_grpmax_pos    = 'Psychiatric Grp Max Coin Pct POS  '
pbp_b7h_coins_pct_grpmin_pos    = 'Psychiatric Grp Min Coin Pct POS  '
pbp_b7h_coins_pct_ind_mc        = 'Psych Ind MC Min Coin Pct         '
pbp_b7h_coins_pct_ind_mcmax     = 'Psych Ind MC Max Coin Pct         '
pbp_b7h_coins_pct_indmax_pos    = 'Psychiatric Ind Max Coin Pct POS  '
pbp_b7h_coins_pct_pos           = 'Psychiatric Ind Min Coin Pct POS  '
pbp_b7h_coins_yesno             = 'Psychiatric Coins Yes No          '
pbp_b7h_coins_yesno_pos         = 'Psychiatric Coinsurance YN POS    '
pbp_b7h_copay_max_grp_amt_pos   = 'Psychiatric Cpy Max Grp Amt POS   '
pbp_b7h_copay_max_ind_amt_pos   = 'Psychiatric Cpy Max Ind Amt POS   '
pbp_b7h_copay_mcamt_grpmax      = 'Psych Care MC Cpy GRP MAX Amt     '
pbp_b7h_copay_mcamt_grpmin      = 'Psych Care MC Cpy GRP MIN Amt     '
pbp_b7h_copay_mcamt_inmax       = 'Psych Care MC Cpy IN MAX Amt      '
pbp_b7h_copay_mcamt_inmin       = 'Psych Care MC Cpy IN MIN Amt      '
pbp_b7h_copay_min_grp_amt_pos   = 'Psychiatric Copay Min Grp Amt POS '
pbp_b7h_copay_min_ind_amt_pos   = 'Psychiatric Copay Min Ind Amt POS '
pbp_b7h_copay_yesno             = 'Psychiatric Care Copay Yes No     '
pbp_b7h_copay_yesno_pos         = 'Psychiatric Copay Yes No POS      '
pbp_b7h_ded_amt                 = 'Psychiatric Deductible Amt        '
pbp_b7h_ded_amt_pos             = 'Psychiatric Deductible Amt POS    '
pbp_b7h_ded_yesno               = 'Psychiatric Deductible Yes No     '
pbp_b7h_ded_yesno_pos           = 'Psychiatric Deduct Yes No POS     '
pbp_b7h_maxenr_amt              = 'Psychiatric Max Enr Amt           '
pbp_b7h_maxenr_amt_pos          = 'Psychiatric Max Enr Amt POS       '
pbp_b7h_maxenr_per              = 'Psychiatric Max Enr Per           '
pbp_b7h_maxenr_yesno            = 'Psychiatric Max Enr Yes No        '
pbp_b7h_maxenr_yn_pos           = 'Psychiatric Max Enr Y/N POS       '
pbp_b7h_maxplan_yesno_pos       = 'Psychiatric Max Plan Y/N POS      '
pbp_b7h_maxpln_amt_pos          = 'Psychiatric Max Plan Amt POS      '
pbp_b7h_maxpln_cov_pos          = 'Psychiatric Max Plan Cov POS      '
pbp_b7h_maxpln_per_pos          = 'Psychiatric Max Pln Per POS       '
pbp_b7i_auth                    = 'PT/SP Srvs Auth                   '
pbp_b7i_auth_pos                = 'PT/SP Srvs Services Auth POS      '
pbp_b7i_coins_cov_mc            = 'PT/SP Srvs MC Coins Cov           '
pbp_b7i_coins_cov_pos           = 'PT/SP Srvs Coins Cov POS          '
pbp_b7i_coins_pct_mc            = 'PT/SP Srvs MC Min Coin Pct        '
pbp_b7i_coins_pct_mcmax         = 'PT/SP Srvs MC Max Coin Pct        '
pbp_b7i_coins_pct_pos           = 'PT/SP Srvs Min Coin Pct POS       '
pbp_b7i_coins_pctmax_pos        = 'PT/SP Srvs Max Coin Pct POS       '
pbp_b7i_coins_yesno             = 'PT/SP Srvs Coins Yes No           '
pbp_b7i_coins_yesno_pos         = 'PT/SP Srvs Coinsurance YN POS     '
pbp_b7i_copay_amtmax_pos        = 'PT/SP Srvs Max Copay Amt POS      '
pbp_b7i_copay_amtv_pos          = 'PT/SP Srvs Min Copay Amt POS      '
pbp_b7i_copay_mcamt             = 'PT/SP Srvs MC Min Copay Amt       '
pbp_b7i_copay_mcamtmax          = 'PT/SP Srvs MC Max Copay Amt       '
pbp_b7i_copay_yesno             = 'PT/SP Srvs Copay Yes No           '
pbp_b7i_copay_yesno_pos         = 'PT/SP Srvs Copay Yes No POS       '
pbp_b7i_ded_amt                 = 'PT/SP Srvs Deductible Amt         '
pbp_b7i_ded_amt_pos             = 'PT/SP Srvs Deductible Amt POS     '
pbp_b7i_ded_yesno               = 'PT/SP Srvs Deductible Yes No      '
pbp_b7i_ded_yesno_pos           = 'PT/SP Srvs Deduct Yes No POS      '
pbp_b7i_maxenr_amt              = 'PT/SP Srvs Max Enr Amt            '
pbp_b7i_maxenr_amt_pos          = 'PT/SP Srvs Max Enr Amt POS        '
pbp_b7i_maxenr_per              = 'PT/SP Srvs Max Enr Per            '
pbp_b7i_maxenr_yesno            = 'PT/SP Srvs Max Enr Yes No         '
pbp_b7i_maxenr_yn_pos           = 'PT/SP Srvs Max Enr Y/N POS        '
pbp_b7i_maxplan_yesno_pos       = 'PT/SP Srvs Max Plan Y/N POS       '
pbp_b7i_maxpln_amt_pos          = 'PT/SP Srvs Max Plan Amt POS       '
pbp_b7i_maxpln_cov_pos          = 'PT/SP Srvs Max Plan Cov POS       '
pbp_b7i_maxpln_per_pos          = 'PT/SP Srvs Max Pln Per POS        '
pbp_b_7f_ded_amt                = 'Podiatrist Deductible Amt         '
pbp_b_7f_ded_yesno              = 'Podiatrist Deductible Yes No      '
pbp_b_7f_maxplan_amt            = 'Podiatrist Max Plan Amt           '
pbp_b_7f_maxplan_covb           = 'Podiatrist Max Plan Cov Bas       '
pbp_b_7f_maxplan_per            = 'Podiatrist Max Plan Per           '
pbp_b_7f_maxplan_yesno          = 'Podiatrist Max Plan Yes No        '
pbp_b_7g_ded_amt                = 'Oth Health Care Deductible Amt    '
pbp_b_7g_ded_yesno              = 'Oth Health Care Deduc Yes No      '
;
run;

proc sort data = pbp_b7fi out = out.pbp_b7fi;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b7fi (obs = 10);
  title 'pbp 7fi data';
run;

proc means data =  out.pbp_b7fi;
  title 'pbp b 7fi file';
run;

proc freq data = out.pbp_b7fi;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b7f_bendecs_yesno
  pbp_b7f_bendec_rf
  pbp_b7f_bendesc_rf_amo
  pbp_b7f_bendesc_lim_rf
  pbp_b7f_bendes_per_rf
  pbp_b_7f_maxplan_yesno
  pbp_b_7f_maxplan_per
  pbp_b_7f_maxplan_covb
  pbp_b7f_maxenr_yesno
  pbp_b7f_maxenr_per
  pbp_b7f_coins_yesno
  pbp_b7f_coins_cov_mc
  pbp_b7f_coins_cov_rf
  pbp_b_7f_ded_yesno
  pbp_b7f_copay_yesno
  pbp_b7f_auth
  pbp_b7f_maxplan_yesno_pos
  pbp_b7f_maxpln_per_pos
  pbp_b7f_maxpln_cov_pos
  pbp_b7f_maxenr_yn_pos
  pbp_b7f_coins_yesno_pos
  pbp_b7f_coins_cov_pos
  pbp_b7f_ded_yesno_pos
  pbp_b7f_copay_yesno_pos
  pbp_b7i_copay_yesno_pos
  pbp_b7i_auth_pos / missing;
run;

proc contents data = out.pbp_b7fi;
  title 'pbp b7fi data';
run;
