*pbp_b8.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b8;

length
    pbp_a_hnumber                    $5
    pbp_a_plan_identifier            $3
    pbp_a_ben_cov                    $1
    pbp_a_plan_type                  $2
    orgtype                          $2
    pbp_b8a_maxenr_yesno             $1
    pbp_b8a_maxenr_per               $1
    pbp_b8a_coins_yesno              $1
    pbp_b8a_coins_cov_cmc            $1
    pbp_b8a_coins_cov_dmc            $1
    pbp_b8a_coins_cov_tmc            $1
    pbp_b_8a_ded_yesno               $1
    pbp_b8a_copay_yesno              $1
    pbp_b8a_cost_share_yesno         $1
    pbp_b8a_auth                     $5
    pbp_b8a_maxplan_yesno_pos        $1
    pbp_b8a_maxpln_per_pos           $1
    pbp_b8a_maxpln_cov_pos           $1
    pbp_b8a_maxenr_yn_pos            $1
    pbp_b8a_coins_yesno_pos          $1
    pbp_b8a_coins_cov_pos            $1
    pbp_b8a_ded_yesno_pos            $1
    pbp_b8a_copay_yesno_pos          $1
    pbp_b8a_auth_pos                 $5
    pbp_b8b_maxenr_yesno             $1
    pbp_b8b_maxenr_per               $1
    pbp_b8b_coins_yesno              $1
    pbp_b8b_coins_cov_mc             $1
    pbp_b8b_ded_yesno                $1
    pbp_b8b_copay_yesno              $1
    pbp_b8b_cost_share               $1
    pbp_b8b_auth                     $5
    pbp_b8b_maxplan_yesno_pos        $1
    pbp_b8b_maxpln_per_pos           $1
    pbp_b8b_maxpln_cov_pos           $1
    pbp_b8b_maxenr_yn_pos            $1
    pbp_b8b_coins_yesno_pos          $1
    pbp_b8b_coins_cov_pos            $1
    pbp_b8b_ded_yesno_pos            $1
    pbp_b8b_copay_yesno_pos          $1
    pbp_b8b_auth_pos                 $5
;

   infile '.\pbp\pbp_b8_clin_diag_ther.txt' delimiter = '09'x
   dsd lrecl = 30000 firstobs=2 missover;


   input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b8a_maxenr_yesno
   pbp_b8a_maxenr_amt
   pbp_b8a_maxenr_per
   pbp_b8a_coins_yesno
   pbp_b8a_coins_pct_cmc
   pbp_b8a_coins_pct_cmc_max
   pbp_b8a_coins_cov_cmc
   pbp_b8a_coins_pct_dmc
   pbp_b8a_coins_pct_dmc_max
   pbp_b8a_coins_cov_dmc
   pbp_b8a_coins_pct_tmc
   pbp_b8a_coins_pct_tmc_max
   pbp_b8a_coins_cov_tmc
   pbp_b_8a_ded_yesno
   pbp_b_8a_ded_amt
   pbp_b8a_copay_yesno
   pbp_b8a_copay_min_cmc_amt
   pbp_b8a_copay_max_cmc_amt
   pbp_b8a_copay_min_dmc_amt
   pbp_b8a_copay_max_dmc_amt
   pbp_b8a_copay_min_tmc_amt
   pbp_b8a_copay_max_tmc_amt
   pbp_b8a_cost_share_yesno
   pbp_b8a_auth
   pbp_b8a_maxplan_yesno_pos
   pbp_b8a_maxpln_amt_pos
   pbp_b8a_maxpln_per_pos
   pbp_b8a_maxpln_cov_pos
   pbp_b8a_maxenr_yn_pos
   pbp_b8a_maxenr_amt_pos
   pbp_b8a_coins_yesno_pos
   pbp_b8a_coins_pct_pos
   pbp_b8a_coins_pctmax_pos
   pbp_b8a_coins_cov_pos
   pbp_b8a_ded_yesno_pos
   pbp_b8a_ded_amt_pos
   pbp_b8a_copay_yesno_pos
   pbp_b8a_copay_amt_pos
   pbp_b8a_copay_amtmax_pos
   pbp_b8a_auth_pos
   pbp_b8b_maxenr_yesno
   pbp_b8b_maxenr_amt
   pbp_b8b_maxenr_per
   pbp_b8b_coins_yesno
   pbp_b8b_coins_pct_cmc
   pbp_b8b_coins_pct_cmc_max
   pbp_b8b_coins_cov_mc
   pbp_b8b_ded_yesno
   pbp_b8b_ded_amt
   pbp_b8b_copay_yesno
   pbp_b8b_copay_mc_amt
   pbp_b8b_copay_mc_amt_max
   pbp_b8b_cost_share
   pbp_b8b_auth
   pbp_b8b_maxplan_yesno_pos
   pbp_b8b_maxpln_amt_pos
   pbp_b8b_maxpln_per_pos
   pbp_b8b_maxpln_cov_pos
   pbp_b8b_maxenr_yn_pos
   pbp_b8b_maxenr_amt_pos
   pbp_b8b_coins_yesno_pos
   pbp_b8b_coins_pct_pos
   pbp_b8b_coins_pctmax_pos
   pbp_b8b_coins_cov_pos
   pbp_b8b_ded_yesno_pos
   pbp_b8b_ded_amt_pos
   pbp_b8b_copay_yesno_pos
   pbp_b8b_copay_amt_pos
   pbp_b8b_copay_amtmax_pos
   pbp_b8b_auth_pos
;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b8a_auth                    = 'Outpatient Clinical Auth          '
pbp_b8a_auth_pos                = 'Outpnt C/D/T Services Auth POS    '
pbp_b8a_coins_cov_cmc           = 'Outpnt Clincal MC Coins Cov       '
pbp_b8a_coins_cov_dmc           = 'Outpnt Diagnostic MC Coins Cov    '
pbp_b8a_coins_cov_pos           = 'Outpnt C/D/T Coins Cov POS        '
pbp_b8a_coins_cov_tmc           = 'Outpnt Thera MC Coins Cov         '
pbp_b8a_coins_pct_cmc           = 'Outpnt Clinicl MC Min Coin Pct    '
pbp_b8a_coins_pct_cmc_max       = 'Outpnt Clinicl MC Max Coin Pct    '
pbp_b8a_coins_pct_dmc           = 'Outpnt Diag MC Min Coin Pct       '
pbp_b8a_coins_pct_dmc_max       = 'Outpnt Diag MC Max Coin Pct       '
pbp_b8a_coins_pct_pos           = 'Outpnt C/D/T Min Coin Pct POS     '
pbp_b8a_coins_pct_tmc           = 'Outpnt Therap MC Min Coin Pct     '
pbp_b8a_coins_pct_tmc_max       = 'Outpnt Therap MC Max Coin Pct     '
pbp_b8a_coins_pctmax_pos        = 'Outpnt C/D/T Max Coin Pct POS     '
pbp_b8a_coins_yesno             = 'Outpnt C/D/T Coins Yes No         '
pbp_b8a_coins_yesno_pos         = 'Outpnt C/D/T Min Coin Y/N POS     '
pbp_b8a_copay_amt_pos           = 'Outpnt C/D/T Min Copay Amt POS    '
pbp_b8a_copay_amtmax_pos        = 'Outpnt C/D/T Max Copay Amt POS    '
pbp_b8a_copay_max_cmc_amt       = 'Outpnt Clin Max MC Cpy Amt        '
pbp_b8a_copay_max_dmc_amt       = 'Outpnt Diag Max MC Cpy Amt        '
pbp_b8a_copay_max_tmc_amt       = 'Outpnt Thera Max MC Cpy Amt       '
pbp_b8a_copay_min_cmc_amt       = 'Outpnt Clin Min MC Cpy Amt        '
pbp_b8a_copay_min_dmc_amt       = 'Outpnt Diag Min MC Cpy Amt        '
pbp_b8a_copay_min_tmc_amt       = 'Outpnt Thera Min MC Cpy Amt       '
pbp_b8a_copay_yesno             = 'Outpnt C/D/T Copay Yes No         '
pbp_b8a_copay_yesno_pos         = 'Outpnt C/D/T Copay Yes No POS     '
pbp_b8a_cost_share_yesno        = 'Outpnt C/D/T Cost Share Y/N       '
pbp_b8a_ded_amt_pos             = 'Outpnt C/D/T Deductible Amt POS   '
pbp_b8a_ded_yesno_pos           = 'Outpnt C/D/T Deduct Yes No POS    '
pbp_b8a_maxenr_amt              = 'Outpnt C/D/T Max Enr Amt          '
pbp_b8a_maxenr_amt_pos          = 'Outpnt C/D/T Max Enr Amt POS      '
pbp_b8a_maxenr_per              = 'Outpnt C/D/T Max Enr Per          '
pbp_b8a_maxenr_yesno            = 'Outpnt C/D/T Max Enr Yes No       '
pbp_b8a_maxenr_yn_pos           = 'Outpnt C/D/T Max Enr Y/N POS      '
pbp_b8a_maxplan_yesno_pos       = 'Outpnt C/D/T Max Plan Y/N POS     '
pbp_b8a_maxpln_amt_pos          = 'Outpnt C/D/T Max Plan Amt POS     '
pbp_b8a_maxpln_cov_pos          = 'Outpnt C/D/T Max Plan Cov POS     '
pbp_b8a_maxpln_per_pos          = 'Outpnt C/D/T Max Pln Per POS      '
pbp_b8b_auth                    = 'Outpatient X-Rays Auth            '
pbp_b8b_auth_pos                = 'Outpnt X-Rays Auth POS            '
pbp_b8b_coins_cov_mc            = 'Outpnt X-Rays MC Coins Cov        '
pbp_b8b_coins_cov_pos           = 'Outpnt X-Rays Coins Cov POS       '
pbp_b8b_coins_pct_cmc           = 'Outpnt X-Rays MC Min Coin Pct     '
pbp_b8b_coins_pct_cmc_max       = 'Outpnt X-Rays MC Max Coin Pct     '
pbp_b8b_coins_pct_pos           = 'Outpnt X-Rays Min Coin Pct POS    '
pbp_b8b_coins_pctmax_pos        = 'Outpnt X-Rays Max Coin Pct POS    '
pbp_b8b_coins_yesno             = 'Outpnt X-Rays Coins Yes No        '
pbp_b8b_coins_yesno_pos         = 'Outpnt X-Rays Coinsurance YN POS  '
pbp_b8b_copay_amt_pos           = 'Outpnt X-Rays Min Copay Amt POS   '
pbp_b8b_copay_amtmax_pos        = 'Outpnt X-Rays Max Copay Amt POS   '
pbp_b8b_copay_mc_amt            = 'Outpnt X-Rays MC Min Cpy Amt      '
pbp_b8b_copay_mc_amt_max        = 'Outpnt X-Rays MC Max Cpy Amt      '
pbp_b8b_copay_yesno             = 'Outpnt X-Rays Copay Yes No        '
pbp_b8b_copay_yesno_pos         = 'Outpnt X-Rays Copay Yes No POS    '
pbp_b8b_cost_share              = 'Outpatient X-Rays Cost Share      '
pbp_b8b_ded_amt                 = 'Outpatient X-Rays Deduc Amt       '
pbp_b8b_ded_amt_pos             = 'Outpnt X-Rays Deductible Amt POS  '
pbp_b8b_ded_yesno               = 'Outpatient X-Rays Deduc Yes No    '
pbp_b8b_ded_yesno_pos           = 'Outpnt X-Rays Deduct Yes No POS   '
pbp_b8b_maxenr_amt              = 'Outpnt X-Rays Max Enr Amt         '
pbp_b8b_maxenr_amt_pos          = 'Outpnt X-Rays Max Enr Amt POS     '
pbp_b8b_maxenr_per              = 'Outpnt X-Rays Max Enr Per         '
pbp_b8b_maxenr_yesno            = 'Outpnt X-Rays Max Enr Yes No      '
pbp_b8b_maxenr_yn_pos           = 'Outpnt X-Rays Max Enr Y/N POS     '
pbp_b8b_maxplan_yesno_pos       = 'Outpnt X-Rays Max Plan Y/N POS    '
pbp_b8b_maxpln_amt_pos          = 'Outpnt X-Rays Max Plan Amt POS    '
pbp_b8b_maxpln_cov_pos          = 'Outpnt X-Rays Max Plan Cov POS    '
pbp_b8b_maxpln_per_pos          = 'Outpnt X-Rays Max Pln Per POS     '
pbp_b_8a_ded_amt                = 'Outpatient C/D/T Deduc Amt        '
pbp_b_8a_ded_yesno              = 'Outpatient C/D/T Deduc Yes No     '
;
run;

proc sort data = pbp_b8 out = out.pbp_b8;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b8 (obs = 10);
  title 'pbp b8 data';
run;

proc means data =  out.pbp_b8;
  title 'pbp b8 file';
run;

proc freq data = out.pbp_b8;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b8a_maxenr_yesno
  pbp_b8a_maxenr_per
  pbp_b8a_coins_yesno
  pbp_b8a_coins_cov_cmc
  pbp_b8a_coins_cov_dmc
  pbp_b8a_coins_cov_tmc
  pbp_b_8a_ded_yesno
  pbp_b8a_copay_yesno
  pbp_b8a_cost_share_yesno
  pbp_b8a_auth
  pbp_b8a_maxplan_yesno_pos
  pbp_b8a_maxpln_per_pos
  pbp_b8a_maxpln_cov_pos
  pbp_b8a_maxenr_yn_pos
  pbp_b8a_coins_yesno_pos
  pbp_b8a_coins_cov_pos
  pbp_b8a_ded_yesno_pos
  pbp_b8a_copay_yesno_pos
  pbp_b8b_maxenr_per
  pbp_b8b_coins_yesno
  pbp_b8b_coins_cov_mc
  pbp_b8b_ded_yesno
  pbp_b8b_copay_yesno
  pbp_b8b_cost_share
  pbp_b8b_copay_yesno_pos
  pbp_b8b_auth_pos / missing;
run;

proc contents data = out.pbp_b8;
  title 'pbp b8 data';
run;



