* pbp_b9.sas;

libname out '.\sas_data_sets\PBP';

options pageno=1 nocenter ls=200;

data pbp_b9;
    length
    pbp_a_hnumber                     $5
    pbp_a_plan_identifier             $3
    pbp_a_ben_cov                     $1
    pbp_a_plan_type                   $2
    orgtype                           $2
    pbp_b9_maxenr_yesno               $1
    pbp_b9_maxenr_per                 $1
    pbp_b9_coins_yesno                $1
    pbp_b9_coins_cov_mc               $1
    pbp_b9_ded_yesno                  $1
    pbp_b9_copay_yesno                $1
    pbp_b9_auth                       $5
    pbp_b9_maxplan_yesno_pos          $1
    pbp_b9_maxpln_per_pos             $1
    pbp_b9_maxpln_cov_pos             $1
    pbp_b9_maxenr_yn_pos              $1
    pbp_b9_coins_yesno_pos            $1
    pbp_b9_coins_cov_pos              $1
    pbp_b9_ded_yesno_pos              $1
    pbp_b9_copay_yesno_pos            $1
    pbp_b9_auth_pos                   $5
    pbp_b9b_maxenr_yesno              $1
    pbp_b9b_maxenr_type               $1
    pbp_b9b_maxenr_per                $1
    pbp_b9b_coins_yesno               $1
    pbp_b9b_coins_cov_mc              $1
    pbp_b9b_ded_yesno                 $1
    pbp_b9b_copay_yesno               $1
    pbp_b9b_auth                      $5
    pbp_b9b_maxplan_yesno_pos         $1
    pbp_b9b_maxpln_per_pos            $1
    pbp_b9b_maxpln_cov_pos            $1
    pbp_b9b_maxenr_yn_pos             $1
    pbp_b9b_maxenr_type_pos           $1
    pbp_b9b_coins_yesno_pos           $1
    pbp_b9b_coins_cov_pos             $1
    pbp_b9b_ded_yesno_pos             $1
    pbp_b9b_copay_yesno_pos           $1
    pbp_b9b_auth_pos                  $5
    pbp_b9c_maxenr_yesno              $1
    pbp_b9c_maxenr_type               $1
    pbp_b9c_maxenr_per                $1
    pbp_b9c_coins_yesno               $1
    pbp_b9c_coins_cov_mcind           $1
    pbp_b9c_coins_cov_mcgrp           $1
    pbp_b9c_ded_yesno                 $1
    pbp_b9c_copay_yesno               $1
    pbp_b9c_auth                      $5
    pbp_b9c_maxplan_yesno_pos         $1
    pbp_b9c_maxpln_per_pos            $1
    pbp_b9c_maxpln_cov_pos            $1
    pbp_b9c_maxenr_yn_pos             $1
    pbp_b9c_maxenr_type_pos           $1
    pbp_b9c_coins_yesno_pos           $1
    pbp_b9c_coins_cov_pos             $1
    pbp_b9c_coins_covgrp_pos          $1
    pbp_b9c_ded_yesno_pos             $1
    pbp_b9c_copay_yesno_pos           $1
    pbp_b9c_auth_pos                  $5
    pbp_b9d_maxenr_yesno              $1
    pbp_b9d_maxenr_type               $1
    pbp_b9d_maxenr_per                $1
    pbp_b9d_coins_yesno               $1
    pbp_b9d_coins_cov_mc              $1
    pbp_b9d_ded_yesno                 $1
    pbp_b9d_copay_yesno               $1
    pbp_b9d_auth                      $5
    pbp_b9d_maxplan_yesno_pos         $1
    pbp_b9d_maxpln_per_pos            $1
    pbp_b9d_maxpln_cov_pos            $1
    pbp_b9d_maxenr_yn_pos             $1
    pbp_b9d_maxenr_type_pos           $1
    pbp_b9d_coins_yesno_pos           $1
    pbp_b9d_coins_cov_pos             $1
    pbp_b9d_ded_yesno_pos             $1
    pbp_b9d_copay_yesno_pos           $1
    pbp_b9d_auth_pos                  $5
;

  infile '.\pbp\pbp_b9_outpt_hosp.txt'
         delimiter = '09'x dsd lrecl = 30000 firstobs = 2 missover;
input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_b9_maxenr_yesno
   pbp_b9_maxenr_amt
   pbp_b9_maxenr_per
   pbp_b9_coins_yesno
   pbp_b9_coins_pct_mc
   pbp_b9_coins_pct_mcmax
   pbp_b9_coins_cov_mc
   pbp_b9_ded_yesno
   pbp_b9_ded_amt
   pbp_b9_copay_yesno
   pbp_b9_copay_mc_amt
   pbp_b9_copay_mc_amtmax
   pbp_b9_auth
   pbp_b9_maxplan_yesno_pos
   pbp_b9_maxpln_amt_pos
   pbp_b9_maxpln_per_pos
   pbp_b9_maxpln_cov_pos
   pbp_b9_maxenr_yn_pos
   pbp_b9_maxenr_amt_pos
   pbp_b9_coins_yesno_pos
   pbp_b9_coins_pct_pos
   pbp_b9_coins_pctmax_pos
   pbp_b9_coins_cov_pos
   pbp_b9_ded_yesno_pos
   pbp_b9_ded_amt_pos
   pbp_b9_copay_yesno_pos
   pbp_b9_copay_amt_pos
   pbp_b9_copay_amtmax_pos
   pbp_b9_auth_pos
   pbp_b9b_maxenr_yesno
   pbp_b9b_maxenr_type
   pbp_b9b_maxenr_amt
   pbp_b9b_maxenr_per
   pbp_b9b_coins_yesno
   pbp_b9b_coins_pct_mc
   pbp_b9b_coins_pct_mcmax
   pbp_b9b_coins_cov_mc
   pbp_b9b_ded_yesno
   pbp_b9b_ded_amt
   pbp_b9b_copay_yesno
   pbp_b9b_copay_mc_amt
   pbp_b9b_copay_mc_amtmax
   pbp_b9b_auth
   pbp_b9b_maxplan_yesno_pos
   pbp_b9b_maxpln_amt_pos
   pbp_b9b_maxpln_per_pos
   pbp_b9b_maxpln_cov_pos
   pbp_b9b_maxenr_yn_pos
   pbp_b9b_maxenr_type_pos
   pbp_b9b_maxenr_amt_pos
   pbp_b9b_coins_yesno_pos
   pbp_b9b_coins_pct_pos
   pbp_b9b_coins_pctmax_pos
   pbp_b9b_coins_cov_pos
   pbp_b9b_ded_yesno_pos
   pbp_b9b_ded_amt_pos
   pbp_b9b_copay_yesno_pos
   pbp_b9b_copay_amt_pos
   pbp_b9b_copay_amtmax_pos
   pbp_b9b_auth_pos
   pbp_b9c_maxenr_yesno
   pbp_b9c_maxenr_type
   pbp_b9c_maxenr_amt
   pbp_b9c_maxenr_per
   pbp_b9c_coins_yesno
   pbp_b9c_coins_pct_mcind
   pbp_b9c_coins_pct_mcind_max
   pbp_b9c_coins_cov_mcind
   pbp_b9c_coins_pct_mcgrp
   pbp_b9c_coins_pct_mcgrp_max
   pbp_b9c_coins_cov_mcgrp
   pbp_b9c_ded_yesno
   pbp_b9c_ded_amt
   pbp_b9c_copay_yesno
   pbp_b9c_copay_mc_amtind
   pbp_b9c_copay_mc_amtind_max
   pbp_b9c_copay_mc_amtgrp
   pbp_b9c_copay_mc_amtgrp_max
   pbp_b9c_auth
   pbp_b9c_maxplan_yesno_pos
   pbp_b9c_maxpln_amt_pos
   pbp_b9c_maxpln_per_pos
   pbp_b9c_maxpln_cov_pos
   pbp_b9c_maxenr_yn_pos
   pbp_b9c_maxenr_type_pos
   pbp_b9c_maxenr_amt_pos
   pbp_b9c_coins_yesno_pos
   pbp_b9c_coins_pct_pos
   pbp_b9c_coins_pct_max_pos
   pbp_b9c_coins_cov_pos
   pbp_b9c_coins_pctgrp_pos
   pbp_b9c_coins_pctgrp_max_pos
   pbp_b9c_coins_covgrp_pos
   pbp_b9c_ded_yesno_pos
   pbp_b9c_ded_amt_pos
   pbp_b9c_copay_yesno_pos
   pbp_b9c_copay_amt_pos
   pbp_b9c_copay_amtmax_pos
   pbp_b9c_copay_amtgrp_pos
   pbp_b9c_copay_amt_maxgrp_pos
   pbp_b9c_auth_pos
   pbp_b9d_maxenr_yesno
   pbp_b9d_maxenr_type
   pbp_b9d_maxenr_amt
   pbp_b9d_maxenr_per
   pbp_b9d_coins_yesno
   pbp_b9d_coins_pct_mc
   pbp_b9d_coins_pct_mcmax
   pbp_b9d_coins_cov_mc
   pbp_b9d_ded_yesno
   pbp_b9d_ded_amt
   pbp_b9d_copay_yesno
   pbp_b9d_copay_mc_amt
   pbp_b9d_copay_mc_amtmax
   pbp_b9d_auth
   pbp_b9d_maxplan_yesno_pos
   pbp_b9d_maxpln_amt_pos
   pbp_b9d_maxpln_per_pos
   pbp_b9d_maxpln_cov_pos
   pbp_b9d_maxenr_yn_pos
   pbp_b9d_maxenr_type_pos
   pbp_b9d_maxenr_amt_pos
   pbp_b9d_coins_yesno_pos
   pbp_b9d_coins_pct_pos
   pbp_b9d_coins_pctmax_pos
   pbp_b9d_coins_cov_pos
   pbp_b9d_ded_yesno_pos
   pbp_b9d_ded_amt_pos
   pbp_b9d_copay_yesno_pos
   pbp_b9d_copay_amt_pos
   pbp_b9d_copay_amtmax_pos
   pbp_b9d_auth_pos
;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_b9_auth                     = 'Outpatient Hospital Auth          '
pbp_b9_auth_pos                 = 'Outpnt Hosp Services Auth POS     '
pbp_b9_coins_cov_mc             = 'Outpnt Hospital MC Coins Cov      '
pbp_b9_coins_cov_pos            = 'Outpnt Hosp Coins Cov POS         '
pbp_b9_coins_pct_mc             = 'Outpnt Hosp MC Min Coin Pct       '
pbp_b9_coins_pct_mcmax          = 'Outpnt Hosp MC Max Coin Pct       '
pbp_b9_coins_pct_pos            = 'Outpnt Hosp Min Coin Pct POS      '
pbp_b9_coins_pctmax_pos         = 'Outpnt Hosp Max Coin Pct POS      '
pbp_b9_coins_yesno              = 'Outpnt Hospital Coins Yes No      '
pbp_b9_coins_yesno_pos          = 'Outpnt Hosp Coinsurance YN POS    '
pbp_b9_copay_amt_pos            = 'Outpnt Hosp Min Copay Amt POS     '
pbp_b9_copay_amtmax_pos         = 'Outpnt Hosp Max Copay Amt POS     '
pbp_b9_copay_mc_amt             = 'Outpnt Hospital MC Min Cpy Amt    '
pbp_b9_copay_mc_amtmax          = 'Outpnt Hospital MC Max Cpy Amt    '
pbp_b9_copay_yesno              = 'Outpnt Hospital Copay Yes No      '
pbp_b9_copay_yesno_pos          = 'Outpnt Hosp Copay Yes No POS      '
pbp_b9_ded_amt                  = 'Outpatient Hospital Deduc Amt     '
pbp_b9_ded_amt_pos              = 'Outpnt Hosp Deductible Amt POS    '
pbp_b9_ded_yesno                = 'Outpatient Hosp Deduc Yes No      '
pbp_b9_ded_yesno_pos            = 'Outpnt Hosp Deduct Yes No POS     '
pbp_b9_maxenr_amt               = 'Outpnt Hospital Max Enr Amt       '
pbp_b9_maxenr_amt_pos           = 'Outpnt Hospital Max Enr Amt POS   '
pbp_b9_maxenr_per               = 'Outpnt Hospital Max Enr Per       '
pbp_b9_maxenr_yesno             = 'Outpnt Hospital Max Enr Yes No    '
pbp_b9_maxenr_yn_pos            = 'Outpnt Hospital Max Enr Y/N POS   '
pbp_b9_maxplan_yesno_pos        = 'Outpnt Hosp Max Plan Y/N POS      '
pbp_b9_maxpln_amt_pos           = 'Outpnt Hosp Max Plan Amt POS      '
pbp_b9_maxpln_cov_pos           = 'Outpnt Hosp Max Plan Cov POS      '
pbp_b9_maxpln_per_pos           = 'Outpnt Hosp Max Pln Per POS       '
pbp_b9b_auth                    = 'ASC Services Auth                 '
pbp_b9b_auth_pos                = 'ASC Services Auth POS             '
pbp_b9b_coins_cov_mc            = 'ASC Services MC Coins Cov         '
pbp_b9b_coins_cov_pos           = 'ASC Services Coins Cov POS        '
pbp_b9b_coins_pct_mc            = 'ASC Services MC Min Coin Pct      '
pbp_b9b_coins_pct_mcmax         = 'ASC Services MC Max Coin Pct      '
pbp_b9b_coins_pct_pos           = 'ASC Services Min Coin Pct POS     '
pbp_b9b_coins_pctmax_pos        = 'ASC Services Max Coin Pct POS     '
pbp_b9b_coins_yesno             = 'ASC Services Coins Yes No         '
pbp_b9b_coins_yesno_pos         = 'ASC Services Coinsurance YN POS   '
pbp_b9b_copay_amt_pos           = 'ASC Services Min Copay Amt POS    '
pbp_b9b_copay_amtmax_pos        = 'ASC Services Max Copay Amt POS    '
pbp_b9b_copay_mc_amt            = 'ASC Services MC Min Cpy Amt       '
pbp_b9b_copay_mc_amtmax         = 'ASC Services MC Max Cpy Amt       '
pbp_b9b_copay_yesno             = 'ASC Services Copay Yes No         '
pbp_b9b_copay_yesno_pos         = 'ASC Services Copay Yes No POS     '
pbp_b9b_ded_amt                 = 'ASC Services Deduc Amt            '
pbp_b9b_ded_amt_pos             = 'ASC Services Deductible Amt POS   '
pbp_b9b_ded_yesno               = 'ASC Services Deduc Yes No         '
pbp_b9b_ded_yesno_pos           = 'ASC Services Deduct Yes No POS    '
pbp_b9b_maxenr_amt              = 'ASC Services Max Enr Amt          '
pbp_b9b_maxenr_amt_pos          = 'ASC Services Max Enr Amt POS      '
pbp_b9b_maxenr_per              = 'ASC Services Max Enr Per          '
pbp_b9b_maxenr_type             = 'ASC Services Max Enr Type         '
pbp_b9b_maxenr_type_pos         = 'ASC Services Max Enr Type POS     '
pbp_b9b_maxenr_yesno            = 'ASC Services Max Enr Yes No       '
pbp_b9b_maxenr_yn_pos           = 'ASC Services Max Enr Y/N POS      '
pbp_b9b_maxplan_yesno_pos       = 'ASC Services Max Plan Y/N POS     '
pbp_b9b_maxpln_amt_pos          = 'ASC Services Max Plan Amt POS     '
pbp_b9b_maxpln_cov_pos          = 'ASC Services Max Plan Cov POS     '
pbp_b9b_maxpln_per_pos          = 'ASC Services Max Pln Per POS      '
pbp_b9c_auth                    = 'Outpnt SA Svcs Auth               '
pbp_b9c_auth_pos                = 'Outpnt SA Svcs Auth POS           '
pbp_b9c_coins_cov_mcgrp         = 'Outpnt SA Svc MC GRP Coins Cov    '
pbp_b9c_coins_cov_mcind         = 'Outpnt SA Svc MC IND Coins Cov    '
pbp_b9c_coins_cov_pos           = 'Outpnt SA Svcs Ind Coins Cov POS  '
pbp_b9c_coins_covgrp_pos        = 'Outpnt SA Svcs Grp Coins Cov POS  '
pbp_b9c_coins_pct_max_pos       = 'Outpnt SA Svc Ind Max Coin Pct POS'
pbp_b9c_coins_pct_mcgrp         = 'Outpnt SA Svcs MC Grp Min Coin    '
pbp_b9c_coins_pct_mcgrp_max     = 'Outpnt SA Svcs MC Grp Max Coin    '
pbp_b9c_coins_pct_mcind         = 'Outpnt SA Svcs MC Ind Min Coin    '
pbp_b9c_coins_pct_mcind_max     = 'Outpnt SA Svcs MC Ind Max Coin    '
pbp_b9c_coins_pct_pos           = 'Outpnt SA Svc Ind Min Coin Pct POS'
pbp_b9c_coins_pctgrp_max_pos    = 'Outpnt SA Svc Grp Max Coin Pct POS'
pbp_b9c_coins_pctgrp_pos        = 'Outpnt SA Svc Grp Min Coin Pct POS'
pbp_b9c_coins_yesno             = 'Outpnt SA Svcs Coins Yes No       '
pbp_b9c_coins_yesno_pos         = 'Outpnt SA Svcs Coinsurance YN POS '
pbp_b9c_copay_amt_maxgrp_pos    = 'Outpnt SA Svc Grp Max Cpy Amt POS '
pbp_b9c_copay_amt_pos           = 'Outpnt SA Svc Ind Min Cpy Amt POS '
pbp_b9c_copay_amtgrp_pos        = 'Outpnt SA Svc Grp Min Cpy Amt POS '
pbp_b9c_copay_amtmax_pos        = 'Outpnt SA Svc Ind Max Cpy Amt POS '
pbp_b9c_copay_mc_amtgrp         = 'Outpnt SA Svcs MC Grp Min Cpy     '
pbp_b9c_copay_mc_amtgrp_max     = 'Outpnt SA Svcs MC Grp Max Cpy     '
pbp_b9c_copay_mc_amtind         = 'Outpnt SA Svcs MC Ind Min Cpy     '
pbp_b9c_copay_mc_amtind_max     = 'Outpnt SA Svcs MC Ind Max Cpy     '
pbp_b9c_copay_yesno             = 'Outpnt SA Svcs Copay Yes No       '
pbp_b9c_copay_yesno_pos         = 'Outpnt SA Svcs Copay Yes No POS   '
pbp_b9c_ded_amt                 = 'Outpnt SA Svcs Deduc Amt          '
pbp_b9c_ded_amt_pos             = 'Outpnt SA Svcs Deductible Amt POS '
pbp_b9c_ded_yesno               = 'Outpnt SA Svcs Deduc Yes No       '
pbp_b9c_ded_yesno_pos           = 'Outpnt SA Svcs Deduct Yes No POS  '
pbp_b9c_maxenr_amt              = 'Outpnt SA Svcs Max Enr Amt        '
pbp_b9c_maxenr_amt_pos          = 'Outpnt SA Svcs Max Enr Amt POS    '
pbp_b9c_maxenr_per              = 'Outpnt SA Svcs Max Enr Per        '
pbp_b9c_maxenr_type             = 'Outpnt SA Svcs Max Enr Type       '
pbp_b9c_maxenr_type_pos         = 'Outpnt SA Svcs Max Enr Type POS   '
pbp_b9c_maxenr_yesno            = 'Outpnt SA Svcs Max Enr Yes No     '
pbp_b9c_maxenr_yn_pos           = 'Outpnt SA Svcs Max Enr Y/N POS    '
pbp_b9c_maxplan_yesno_pos       = 'Outpnt SA Svcs Max Plan Y/N POS   '
pbp_b9c_maxpln_amt_pos          = 'Outpnt SA Svcs Max Plan Amt POS   '
pbp_b9c_maxpln_cov_pos          = 'Outpnt SA Svcs Max Plan Cov POS   '
pbp_b9c_maxpln_per_pos          = 'Outpnt SA Svcs Max Pln Per POS    '
pbp_b9d_auth                    = 'Cardiac Rehab Svcs Auth           '
pbp_b9d_auth_pos                = 'Cardiac Rehab Svcs Auth POS       '
pbp_b9d_coins_cov_mc            = 'Cardiac Rehab Svc MC Coins Cov    '
pbp_b9d_coins_cov_pos           = 'Cardiac Rehab Svcs Coins Cov POS  '
pbp_b9d_coins_pct_mc            = 'Cardiac Rehab MC Min Coin Pct     '
pbp_b9d_coins_pct_mcmax         = 'Cardiac Rehab MC Max Coin Pct     '
pbp_b9d_coins_pct_pos           = 'Cardiac Rehab Svc Min Coin Pct POS'
pbp_b9d_coins_pctmax_pos        = 'Cardiac Rehab Svc Max Coin Pct POS'
pbp_b9d_coins_yesno             = 'Cardiac Rehab Svcs Coins YN       '
pbp_b9d_coins_yesno_pos         = 'Cardiac Rehab Svcs Coins YN POS   '
pbp_b9d_copay_amt_pos           = 'Cardiac Rehab Svc Min Cpy Amt POS '
pbp_b9d_copay_amtmax_pos        = 'Cardiac Rehab Svc Max Cpy Amt POS '
pbp_b9d_copay_mc_amt            = 'Cardiac Rehab MC Min Cpy Amt      '
pbp_b9d_copay_mc_amtmax         = 'Cardiac Rehab MC Max Cpy Amt      '
pbp_b9d_copay_yesno             = 'Cardiac Rehab Svc Copay Yes No    '
pbp_b9d_copay_yesno_pos         = 'Cardiac Rehab Svc Copay Yes No POS'
pbp_b9d_ded_amt                 = 'Cardiac Rehab Svcs Deduc Amt      '
pbp_b9d_ded_amt_pos             = 'Cardiac Rehab Svcs Deduct Amt POS '
pbp_b9d_ded_yesno               = 'Cardiac Rehab Svc Deduc Yes No    '
pbp_b9d_ded_yesno_pos           = 'Cardiac Rehab Svcs Deduct YN POS  '
pbp_b9d_maxenr_amt              = 'Cardiac Rehab Svcs Max Enr Amt    '
pbp_b9d_maxenr_amt_pos          = 'Cardiac Rehab Svcs Max Enr Amt POS'
pbp_b9d_maxenr_per              = 'Cardiac Rehab Svcs Max Enr Per    '
pbp_b9d_maxenr_type             = 'Card Rehab Svcs Max Enr Type      '
pbp_b9d_maxenr_type_pos         = 'Card Rehab Svcs Max Enr Type POS  '
pbp_b9d_maxenr_yesno            = 'Cardiac Rehab Svcs Max Enr YN     '
pbp_b9d_maxenr_yn_pos           = 'Cardiac Rehab Svcs Max Enr Y/N POS'
pbp_b9d_maxplan_yesno_pos       = 'Cardiac Rehab Svc Max Plan Y/N POS'
pbp_b9d_maxpln_amt_pos          = 'Cardiac Rehab Svc Max Plan Amt POS'
pbp_b9d_maxpln_cov_pos          = 'Cardiac Rehab Svc Max Plan Cov POS'
pbp_b9d_maxpln_per_pos          = 'Cardiac Rehab Svcs Max Pln Per POS'
;
run;

proc sort data = pbp_b9 out = out.pbp_b9;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b9 (obs = 10);
  title 'pbp b9 data';
run;

proc means data =  out.pbp_b9;
  title 'pbp b9 file';
run;

proc freq data = out.pbp_b9;
  table
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b9_maxenr_yesno
  pbp_b9_maxenr_per
  pbp_b9_coins_yesno
  pbp_b9_coins_cov_mc
  pbp_b9_ded_yesno
  pbp_b9_copay_yesno
  pbp_b9_auth
  pbp_b9_maxplan_yesno_pos
  pbp_b9_maxpln_per_pos
  pbp_b9_maxpln_cov_pos
  pbp_b9_maxenr_yn_pos
  pbp_b9_coins_yesno_pos
  pbp_b9_coins_cov_pos
  pbp_b9_ded_yesno_pos
  pbp_b9_copay_yesno_pos
  pbp_b9_auth_pos
  pbp_b9b_maxenr_yesno
  pbp_b9b_maxenr_type
  pbp_b9b_maxenr_per
  pbp_b9c_maxenr_type
  pbp_b9c_maxenr_per
  pbp_b9c_coins_yesno
  pbp_b9c_coins_cov_mcind
  pbp_b9d_maxenr_yesno
  pbp_b9d_maxenr_type
  pbp_b9d_maxenr_per
  pbp_b9d_coins_yesno
  pbp_b9d_coins_cov_mc
  pbp_b9d_ded_yesno
  pbp_b9d_copay_yesno
  pbp_b9d_auth
  pbp_b9d_maxplan_yesno_pos
  pbp_b9d_maxpln_per_pos
  pbp_b9d_maxpln_cov_pos
  pbp_b9d_maxenr_yn_pos
  pbp_b9d_maxenr_type_pos
  pbp_b9d_coins_yesno_pos
  pbp_b9d_coins_cov_pos
  pbp_b9d_ded_yesno_pos
  pbp_b9d_copay_yesno_pos
  pbp_b9d_auth_pos / missing;
run;

proc contents data = out.pbp_b9;
  title 'pbp b9 data';
run;
