* pbp_Section_A.sas;

libname out '.\sas_data_sets\PBP';

options pageno=1 nocenter ls=200;

data pbp_a;
  length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  orgtype                          $9
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  pbp_a_org_name                   $50
  pbp_a_contract_period            $4
  pbp_a_service_area               $7
  pbp_a_plan_name                  $50
  pbp_a_plan_geog_name             $50
  pbp_a_plan_phone                 $14
  pbp_a_ttytdd_phone               $14
  pbp_a_vp_name                    $50
  pbp_a_cfo_name                   $50
  pbp_a_ceo_title                  $50
  pbp_a_ceo_name                   $50
  pbp_a_org_marketing_name         $50
  pbp_a_continue_yn                $1
  pbp_a_continue_costshare_yn      $1
  pbp_a_vtprogram_yn               $1
  pbp_a_pbp_contact_name           $50
  pbp_a_pbp_contact_position       $30
  pbp_a_pbp_contact_phone          $14
  pbp_a_pbp_contact_phone_ext      $5
  pbp_a_pbp_contact_fax            $14
  pbp_a_pbp_email                  $50
  pbp_a_pbp_address1               $50
  pbp_a_pbp_address5               $30
  pbp_a_pbp_address2               $30
  pbp_a_pbp_address3               $2
  pbp_a_pbp_address4               $9
  ;

  infile '.\pbp\pbp_Section_A.txt'
         delimiter = '09'x dsd lrecl = 25000 firstobs = 2 missover;
input
  pbp_a_hnumber
  pbp_a_plan_identifier
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_a_org_name
  pbp_a_contract_period
  pbp_a_service_area
  pbp_a_plan_name
  pbp_a_plan_geog_name
  pbp_a_plan_phone
  pbp_a_ttytdd_phone
  pbp_a_vp_name
  pbp_a_cfo_name
  pbp_a_ceo_title
  pbp_a_ceo_name
  pbp_a_org_marketing_name
  pbp_a_continue_yn
  pbp_a_continue_costshare_yn
  pbp_a_vtprogram_yn
  pbp_a_pbp_contact_name
  pbp_a_pbp_contact_position
  pbp_a_pbp_contact_phone
  pbp_a_pbp_contact_phone_ext
  pbp_a_pbp_contact_fax
  pbp_a_pbp_email
  pbp_a_pbp_address1
  pbp_a_pbp_address5
  pbp_a_pbp_address2
  pbp_a_pbp_address3
  pbp_a_pbp_address4
;

  label
  orgtype                          = 'Organization Type              '
  pbp_a_org_name                   = 'MCO Legal Name                 '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_contract_period            = 'Contract Period                '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_service_area               = 'Service Area(s)                '
  pbp_a_plan_name                  = 'Plan Name                      '
  pbp_a_plan_geog_name             = 'Plan Geographic Name           '
  pbp_a_plan_phone                 = 'Plan Customer Srvc Phone Num   '
  pbp_a_ttytdd_phone               = 'Plan Customer Srvc TTYTDD Num  '
  pbp_a_vp_name                    = 'VP of Marketing Name           '
  pbp_a_cfo_name                   = 'CFO Name                       '
  pbp_a_ceo_title                  = 'CEO Title                      '
  pbp_a_ceo_name                   = 'CEO Name                       '
  pbp_a_org_marketing_name         = 'MCO Marketing Name             '
  pbp_a_continue_yn                = 'Continuation Area YN           '
  pbp_a_continue_costshare_yn      = 'Continuation Area Same Cost YN '
  pbp_a_vtprogram_yn               = 'Visitor/Travel Program YN      '
  pbp_a_pbp_contact_name           = 'M+C Org PBP Contact Name       '
  pbp_a_pbp_contact_position       = 'M+C Org PBP Contact Position   '
  pbp_a_pbp_contact_phone          = 'PBP Contact Phone              '
  pbp_a_pbp_contact_phone_ext      = 'PBP Contact Phone# Extension   '
  pbp_a_pbp_contact_fax            = 'M+C Org PBP Contact FAX        '
  pbp_a_pbp_email                  = 'PBP Contact E-mail Address     '
  pbp_a_pbp_address1               = 'PBP Contact Street Address     '
  pbp_a_pbp_address5               = 'PBP Suite/Dept/Mail Stop       '
  pbp_a_pbp_address2               = 'PBP Contact City               '
  pbp_a_pbp_address3               = 'PBP Contact State              '
  pbp_a_pbp_address4               = 'PBP Contact Zipcode            '
;
run;

proc sort data = pbp_a out = out.pbp_a;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_a(obs = 10);
  title 'pbp a data';
run;

proc means data =  out.pbp_a;
  title 'pbp a file';
run;

proc freq data = out.pbp_a;
  table
  pbp_a_ben_cov pbp_a_plan_type orgtype
  pbp_a_org_name
  pbp_a_hnumber
  pbp_a_contract_period
  pbp_a_plan_identifier
  pbp_a_plan_type
  pbp_a_ben_cov
  pbp_a_service_area
  pbp_a_plan_name
  pbp_a_plan_geog_name
  pbp_a_plan_phone
  pbp_a_ttytdd_phone
  pbp_a_vp_name
  pbp_a_cfo_name
  pbp_a_ceo_title
  pbp_a_ceo_name
  pbp_a_org_marketing_name
  pbp_a_continue_yn
  pbp_a_continue_costshare_yn
  pbp_a_vtprogram_yn
  pbp_a_pbp_contact_name
  pbp_a_pbp_contact_position
  pbp_a_pbp_contact_phone
  pbp_a_pbp_contact_phone_ext
  pbp_a_pbp_contact_fax
  pbp_a_pbp_email
  pbp_a_pbp_address1
  pbp_a_pbp_address5
  pbp_a_pbp_address2
  pbp_a_pbp_address3
  pbp_a_pbp_address4 / missing;
run;

proc contents data = out.pbp_a;
  title 'pbp a data';
run;

