* pbp_Section_C.sas;

libname out '.\sas_data_sets\PBP';

options pageno=1 nocenter ls=200;

data pbp_c;
  length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_c_csc_clause_und_bba         $1
  pbp_c_serv_prior_esd             $1
  pbp_c_other_exc                  $1
  pbp_c_gated_vs_open              $1
  pbp_c_prof_monitor_care          $3
  pbp_c_prof_part                  $9
  pbp_c_bene_contact               $5
  pbp_c_special_avail              $1
  pbp_c_dualelig_freq_a            $1
  pbp_c_dualelig_freq_b            $1
  pbp_c_dualelig_freq_c            $1
  pbp_c_dualelig_freq_d            $1
  pbp_c_dif_coor_care_outside      $1
  pbp_c_dif_coor_care_within       $1
;

  infile '.\pbp\pbp_Section_C.txt'
         delimiter = '09'x dsd lrecl = 30000 firstobs = 2 missover;
input
pbp_a_hnumber
pbp_a_plan_identifier
pbp_a_ben_cov
pbp_a_plan_type
orgtype
pbp_c_csc_clause_und_bba
pbp_c_serv_prior_esd
pbp_c_other_exc
pbp_c_gated_vs_open
pbp_c_prof_monitor_care
pbp_c_prof_part
pbp_c_accpt_new_bene_beg
pbp_c_accpt_new_bene_end
pbp_c_bene_contact
pbp_c_special_avail
pbp_c_dualelig_freq_a
pbp_c_dualelig_freq_b
pbp_c_dualelig_freq_c
pbp_c_dualelig_freq_d
pbp_c_dif_coor_care_outside
pbp_c_dif_coor_care_within
;

 label
  orgtype                          = 'Organization Type'
  pbp_a_ben_cov                    = 'Coverage Criteria'
  pbp_a_hnumber                    = 'H Number'
  pbp_a_plan_identifier            = 'Plan Identifier'
  pbp_a_plan_type                  = 'Select type of Plan'
  pbp_c_csc_clause_und_bba         = 'Conscience Clause Under BBA'
  pbp_c_serv_prior_esd             = 'Services Prior to Start Date'
  pbp_c_other_exc                  = 'Other Exclusions (C)'
  pbp_c_gated_vs_open              = 'Gated vs Open access'
  pbp_c_prof_monitor_care          = 'Professionals Monitor Care'
  pbp_c_prof_part                  = 'Type Professional Participants'
  pbp_c_accpt_new_bene_beg         = 'Number of Primary Care Providers expected at the beginning of the contract period'
  pbp_c_accpt_new_bene_end         = 'Number of Primary Care Providers expected at the end of the contract period'
  pbp_c_bene_contact               = 'Benefit Professional Contact'
  pbp_c_special_avail              = 'Specialists Available Enrollee'
  pbp_c_dualelig_freq_a            = 'FFS within orgs provider ntwk'
  pbp_c_dualelig_freq_b            = 'FFS outside orgs prvdr ntwk'
  pbp_c_dualelig_freq_c            = 'Capitation within organization'
  pbp_c_dualelig_freq_d            = 'Capitation outside organization'
  pbp_c_dif_coor_care_outside      = 'Diff coord care dual eligibles'
  pbp_c_dif_coor_care_within       = 'Diff coord care dual eligibles'

;
run;

proc sort data = pbp_c out = out.pbp_c;
  by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_c(obs = 10);
  title 'pbp c data';
run;

proc means data =  out.pbp_c;
  title 'pbp c file';
run;

proc freq data = out.pbp_c;
  table
  pbp_a_ben_cov pbp_a_plan_type orgtype
  pbp_c_csc_clause_und_bba
  pbp_c_serv_prior_esd
  pbp_c_other_exc
  pbp_c_gated_vs_open
  pbp_c_prof_monitor_care
  pbp_c_prof_part
  pbp_c_bene_contact
  pbp_c_special_avail
  pbp_c_dualelig_freq_a
  pbp_c_dualelig_freq_b
  pbp_c_dualelig_freq_c
  pbp_c_dualelig_freq_d
  pbp_c_dif_coor_care_outside
  pbp_c_dif_coor_care_within / missing;
run;

proc contents data = out.pbp_c;
  title 'pbp c data';
run;

