*pbp_b11.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b11;

length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_b11a_maxenr_yn               $1
  pbp_b11a_maxenr_per              $1
  pbp_b11a_coins_yn                $1
  pbp_b11a_coins_cov_mc            $2
  pbp_b11a_ded_yn                  $1
  pbp_b11a_copay_yn                $1
  pbp_b11a_auth                    $5
  pbp_b11b_maxenr_yn               $1
  pbp_b11b_maxenr_cost_type        $1
  pbp_b11b_maxenr_per              $1
  pbp_b11b_coins_yn                $1
  pbp_b11b_coins_cov_mc            $2
  pbp_b11b_ded_yn                  $1
  pbp_b11b_copay_yn                $1
  pbp_b11b_auth                    $5
  pbp_b11c_maxenr_yn               $1
  pbp_b11c_maxenr_cost_type        $1
  pbp_b11c_maxenr_per              $1
  pbp_b11c_coins_yn                $1
  pbp_b11c_coins_cov_mc            $2
  pbp_b11c_ded_yn                  $1
  pbp_b11c_copay_yn                $1
  pbp_b11c_auth                    $5
;

infile '.\pbp\pbp_b11_dme_prosth_orth_sup.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
  pbp_a_hnumber
  pbp_a_plan_identifier
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b11a_maxenr_yn
  pbp_b11a_maxenr_amt
  pbp_b11a_maxenr_per
  pbp_b11a_coins_yn
  pbp_b11a_coins_pct_mc
  pbp_b11a_coins_pct_mcmax
  pbp_b11a_coins_cov_mc
  pbp_b11a_coins_pct_disc
  pbp_b11a_ded_yn
  pbp_b11a_ded_amt
  pbp_b11a_copay_yn
  pbp_b11a_copay_mc_amt
  pbp_b11a_copay_mcmax_amt
  pbp_b11a_auth
  pbp_b11b_maxenr_yn
  pbp_b11b_maxenr_cost_type
  pbp_b11b_maxenr_amt
  pbp_b11b_maxenr_per
  pbp_b11b_coins_yn
  pbp_b11b_coins_pct_mc
  pbp_b11b_coins_pct_mcmax
  pbp_b11b_coins_cov_mc
  pbp_b11b_coins_pct_disc
  pbp_b11b_ded_yn
  pbp_b11b_ded_amt
  pbp_b11b_copay_yn
  pbp_b11b_copay_mcmin_amt
  pbp_b11b_copay_mcmax_amt
  pbp_b11b_auth
  pbp_b11c_maxenr_yn
  pbp_b11c_maxenr_cost_type
  pbp_b11c_maxenr_amt
  pbp_b11c_maxenr_per
  pbp_b11c_coins_yn
  pbp_b11c_coins_pct_mc
  pbp_b11c_coins_pct_mcmax
  pbp_b11c_coins_cov_mc
  pbp_b11c_coins_pct_disc
  pbp_b11c_ded_yn
  pbp_b11c_ded_amt
  pbp_b11c_copay_yn
  pbp_b11c_copay_mcmin_amt
  pbp_b11c_copay_mcmax_amt
  pbp_b11c_auth
;

  label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_b11a_maxenr_yn               = 'DME Max Enr YN                 '
  pbp_b11a_maxenr_amt              = 'DME Max Enr Amt                '
  pbp_b11a_maxenr_per              = 'DME Max Enr Per                '
  pbp_b11a_coins_yn                = 'DME Coinsurance YN             '
  pbp_b11a_coins_pct_mc            = 'DME MC Min Coins Pct           '
  pbp_b11a_coins_pct_mcmax         = 'DME MC Max Coins Pct           '
  pbp_b11a_coins_cov_mc            = 'DME MC Coins Cov               '
  pbp_b11a_coins_pct_disc          = 'DME MC Coins Discnt Pct        '
  pbp_b11a_ded_yn                  = 'DME Deductible YN              '
  pbp_b11a_ded_amt                 = 'DME Deductible Amt             '
  pbp_b11a_copay_yn                = 'DME Copayment YN               '
  pbp_b11a_copay_mc_amt            = 'DME MC Min Copay Amt           '
  pbp_b11a_copay_mcmax_amt         = 'DME MC Max Copay Amt           '
  pbp_b11a_auth                    = 'DME Auth                       '
  pbp_b11b_maxenr_yn               = 'Med Supplies Max Enr YN        '
  pbp_b11b_maxenr_cost_type        = 'Med Supplies Max Enr Type      '
  pbp_b11b_maxenr_amt              = 'Med Supplies Max Enr Amt       '
  pbp_b11b_maxenr_per              = 'Med Supplies Max Enr Per       '
  pbp_b11b_coins_yn                = 'Med Supplies Coinsurance YN    '
  pbp_b11b_coins_pct_mc            = 'Med Supplies MC Min Coins Pct  '
  pbp_b11b_coins_pct_mcmax         = 'Med Supplies MC Max Coins Pct  '
  pbp_b11b_coins_cov_mc            = 'Med Supplies MC Coins Cov      '
  pbp_b11b_coins_pct_disc          = 'Med Supplies MC Coin Dscnt Pct '
  pbp_b11b_ded_yn                  = 'Med Supplies Deductible YN     '
  pbp_b11b_ded_amt                 = 'Med Supplies Deductible Amt    '
  pbp_b11b_copay_yn                = 'Med Supplies Copayment YN      '
  pbp_b11b_copay_mcmin_amt         = 'Med Supplies MC Min Copay Amt  '
  pbp_b11b_copay_mcmax_amt         = 'Med Supplies MC Max Copay Amt  '
  pbp_b11b_auth                    = 'Med Supplies Auth              '
  pbp_b11c_maxenr_yn               = 'DMS Max Enr YN                 '
  pbp_b11c_maxenr_cost_type        = 'DMS Max Enr Type               '
  pbp_b11c_maxenr_amt              = 'DMS Max Enr Amt                '
  pbp_b11c_maxenr_per              = 'DMS Max Enr Per                '
  pbp_b11c_coins_yn                = 'DMS Coinsurance YN             '
  pbp_b11c_coins_pct_mc            = 'DMS MC Min Coins Pct           '
  pbp_b11c_coins_pct_mcmax         = 'DMS MC Max Coins Pct           '
  pbp_b11c_coins_cov_mc            = 'DMS MC Coins Cov               '
  pbp_b11c_coins_pct_disc          = 'DMS MC Coins Discnt Pct        '
  pbp_b11c_ded_yn                  = 'DMS Deductible YN              '
  pbp_b11c_ded_amt                 = 'DMS Deductible Amt             '
  pbp_b11c_copay_yn                = 'DMS Copayment YN               '
  pbp_b11c_copay_mcmin_amt         = 'DMS MC Min Copay Amt           '
  pbp_b11c_copay_mcmax_amt         = 'DMS MC Max Copay Amt           '
  pbp_b11c_auth                    = 'DMS Auth                       '
;
run;

proc sort data = pbp_b11 out = out.pbp_b11;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b11 (obs = 10);
  title 'pbp b11 data';
run;

proc means data =  out.pbp_b11;
  title 'pbp b11 file';
run;

proc freq data = out.pbp_b11;
  table
  orgtype
  pbp_b11a_maxenr_yn
  pbp_b11a_maxenr_per
  pbp_b11a_coins_yn
  pbp_b11a_coins_cov_mc
  pbp_b11a_ded_yn
  pbp_b11a_copay_yn
  pbp_b11a_auth
  pbp_b11b_maxenr_yn
  pbp_b11b_maxenr_cost_type
  pbp_b11b_maxenr_per
  pbp_b11b_coins_yn
  pbp_b11b_coins_cov_mc
  pbp_b11b_ded_yn
  pbp_b11b_copay_yn
  pbp_b11b_auth
  pbp_b11c_maxenr_yn
  pbp_b11c_maxenr_cost_type
  pbp_b11c_maxenr_per
  pbp_b11c_coins_yn
  pbp_b11c_coins_cov_mc
  pbp_b11c_ded_yn
  pbp_b11c_copay_yn
  pbp_b11c_auth / missing;
  run;

proc contents data = out.pbp_b11;
  title 'pbp b11 data';
run;
