*pbp_b13.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b13;

length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_b13a_bendec                  $1
  pbp_b13b_bendesc_enhan           $1
  pbp_b13a_bendesc_yn              $1
  pbp_b13a_bendesc_amo             $1
  pbp_b13a_maxenr_yn               $1
  pbp_b13a_maxenr_per              $1
  pbp_b13a_coins_yn                $1
  pbp_b13a_coins_cov_mc            $1
  pbp_b13a_ded_yn                  $1
  pbp_b13a_copay_yn                $1
  pbp_b13a_auth                    $5
  pbp_b13a_refer_yn                $1
  pbp_b13b_bendesc_yn              $1
  pbp_b13b_bendesc_amo             $1
  pbp_b13b_bendesc_lim             $1
  pbp_b13b_bendesc_per             $1
  pbp_b13b_maxplan_yn              $1
  pbp_b13b_maxplan_per             $1
  pbp_b13b_maxplan_cov             $1
  pbp_b13b_maxenr_yn               $1
  pbp_b13b_maxenr_per              $1
  pbp_b13b_coins_yn                $1
  pbp_b13b_coins_cov               $1
  pbp_b13b_ded_yn                  $1
  pbp_b13b_copay_yn                $1
  pbp_b13b_auth                    $5
  pbp_b13b_refer_yn                $1
  pbp_b13c_bendesc_service         $55
  pbp_b13c_bendesc_amo             $1
  pbp_b13c_maxplan_yn              $1
  pbp_b13c_maxplan_per             $1
  pbp_b13c_maxplan_cov             $1
  pbp_b13c_maxenr_yn               $1
  pbp_b13c_maxenr_per              $1
  pbp_b13c_coins_yn                $1
  pbp_b13c_coins_cov               $1
  pbp_b13c_ded_yn                  $1
  pbp_b13c_copay_yn                $1
  pbp_b13c_auth                    $5
  pbp_b13c_refer_yn                $1
  pbp_b13d_bendesc_service         $55
  pbp_b13d_bendesc_amo             $1
  pbp_b13d_maxplan_yn              $1
  pbp_b13d_maxplan_per             $1
  pbp_b13d_maxplan_cov             $1
  pbp_b13d_maxenr_yn               $1
  pbp_b13d_maxenr_per              $1
  pbp_b13d_coins_yn                $1
  pbp_b13d_coins_cov               $1
  pbp_b13d_ded_yn                  $1
  pbp_b13d_copay_yn                $1
  pbp_b13d_auth                    $5
  pbp_b13d_refer_yn                $1
  pbp_b13e_bendesc_service         $55
  pbp_b13e_bendesc_amo             $1
  pbp_b13e_maxplan_yn              $1
  pbp_b13e_maxplan_per             $1
  pbp_b13e_maxplan_cov             $1
  pbp_b13e_maxenr_yn               $1
  pbp_b13e_maxenr_per              $1
  pbp_b13e_coins_yn                $1
  pbp_b13e_coins_cov               $1
  pbp_b13e_ded_yn                  $1
  pbp_b13e_copay_yn                $1
  pbp_b13e_auth                    $5
  pbp_b13e_refer_yn                $1
;

infile '.\pbp\pbp_b13_other_services.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
  pbp_a_hnumber
  pbp_a_plan_identifier
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b13a_bendesc_yn
  pbp_b13a_bendec
  pbp_b13a_bendesc_amo
  pbp_b13a_maxenr_yn
  pbp_b13a_maxenr_amt
  pbp_b13a_maxenr_per
  pbp_b13a_coins_yn
  pbp_b13a_coins_pct_mc
  pbp_b13a_coins_cov_mc
  pbp_b13a_ded_yn
  pbp_b13a_ded_amt
  pbp_b13a_copay_yn
  pbp_b13a_copay_mc_amt
  pbp_b13a_auth
  pbp_b13a_refer_yn
  pbp_b13b_bendesc_yn
  pbp_b13b_bendesc_enhan
  pbp_b13b_bendesc_amo
  pbp_b13b_bendesc_lim
  pbp_b13b_bendesc_numv
  pbp_b13b_bendesc_per
  pbp_b13b_maxplan_yn
  pbp_b13b_maxplan_amt
  pbp_b13b_maxplan_per
  pbp_b13b_maxplan_cov
  pbp_b13b_maxenr_yn
  pbp_b13b_maxenr_amt
  pbp_b13b_maxenr_per
  pbp_b13b_coins_yn
  pbp_b13b_coins_pct
  pbp_b13b_coins_cov
  pbp_b13b_ded_yn
  pbp_b13b_ded_amt
  pbp_b13b_copay_yn
  pbp_b13b_copay_amt
  pbp_b13b_auth
  pbp_b13b_refer_yn
  pbp_b13c_bendesc_service
  pbp_b13c_bendesc_amo
  pbp_b13c_maxplan_yn
  pbp_b13c_maxplan_amt
  pbp_b13c_maxplan_per
  pbp_b13c_maxplan_cov
  pbp_b13c_maxenr_yn
  pbp_b13c_maxenr_amt
  pbp_b13c_maxenr_per
  pbp_b13c_coins_yn
  pbp_b13c_coins_pct
  pbp_b13c_coins_cov
  pbp_b13c_ded_yn
  pbp_b13c_ded_amt
  pbp_b13c_copay_yn
  pbp_b13c_copay_amt
  pbp_b13c_auth
  pbp_b13c_refer_yn
  pbp_b13d_bendesc_service
  pbp_b13d_bendesc_amo
  pbp_b13d_maxplan_yn
  pbp_b13d_maxplan_amt
  pbp_b13d_maxplan_per
  pbp_b13d_maxplan_cov
  pbp_b13d_maxenr_yn
  pbp_b13d_maxenr_amt
  pbp_b13d_maxenr_per
  pbp_b13d_coins_yn
  pbp_b13d_coins_pct
  pbp_b13d_coins_cov
  pbp_b13d_ded_yn
  pbp_b13d_ded_amt
  pbp_b13d_copay_yn
  pbp_b13d_copay_amt
  pbp_b13d_auth
  pbp_b13d_refer_yn
  pbp_b13e_bendesc_service
  pbp_b13e_bendesc_amo
  pbp_b13e_maxplan_yn
  pbp_b13e_maxplan_amt
  pbp_b13e_maxplan_per
  pbp_b13e_maxplan_cov
  pbp_b13e_maxenr_yn
  pbp_b13e_maxenr_amt
  pbp_b13e_maxenr_per
  pbp_b13e_coins_yn
  pbp_b13e_coins_pct
  pbp_b13e_coins_cov
  pbp_b13e_ded_yn
  pbp_b13e_ded_amt
  pbp_b13e_copay_yn
  pbp_b13e_copay_amt
  pbp_b13e_auth
  pbp_b13e_refer_yn
;

  label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_b13a_bendesc_yn              = 'Outpnt Blood Ben Desc YN       '
  pbp_b13a_bendec                  = 'Outpnt Blood Ben Desc Enhance  '
  pbp_b13a_bendesc_amo             = 'Outpnt Blood Ben Desc AMO      '
  pbp_b13a_maxenr_yn               = 'Outpnt Blood Max Enr YN        '
  pbp_b13a_maxenr_amt              = 'Outpnt Blood Max Enr Amt       '
  pbp_b13a_maxenr_per              = 'Outpnt Blood Max Enr Per       '
  pbp_b13a_coins_yn                = 'Outpnt Blood Coinsurance YN    '
  pbp_b13a_coins_pct_mc            = 'Outpnt Blood MC Coins Pct      '
  pbp_b13a_coins_cov_mc            = 'Outpnt Blood MC Coins Cov      '
  pbp_b13a_ded_yn                  = 'Outpnt Blood Deductible YN     '
  pbp_b13a_ded_amt                 = 'Outpnt Blood Deductible Amt    '
  pbp_b13a_copay_yn                = 'Outpnt Blood Copayment YN      '
  pbp_b13a_copay_mc_amt            = 'Outpnt Blood MC Copay Amt      '
  pbp_b13a_auth                    = 'Outpnt Blood Auth              '
  pbp_b13a_refer_yn                = 'Outpnt Blood Referral YN       '
  pbp_b13b_bendesc_yn              = 'Acupuncture Ben Desc YN        '
  pbp_b13b_bendesc_enhan           = 'Acupuncture Ben Desc Enhance   '
  pbp_b13b_bendesc_amo             = 'Acupuncture Ben Desc AMO       '
  pbp_b13b_bendesc_lim             = 'Acupuncture Ben Desc Lim YN    '
  pbp_b13b_bendesc_numv            = 'Acupuncture Ben Desc Num       '
  pbp_b13b_bendesc_per             = 'Acupuncture Ben Desc Per       '
  pbp_b13b_maxplan_yn              = 'Acupuncture Max Plan YN        '
  pbp_b13b_maxplan_amt             = 'Acupuncture Max Plan Amt       '
  pbp_b13b_maxplan_per             = 'Acupuncture Max Plan Per       '
  pbp_b13b_maxplan_cov             = 'Acupuncture Max Plan Cov       '
  pbp_b13b_maxenr_yn               = 'Acupuncture Max Enr YN         '
  pbp_b13b_maxenr_amt              = 'Acupuncture Max Enr Amt        '
  pbp_b13b_maxenr_per              = 'Acupuncture Max Enr Per        '
  pbp_b13b_coins_yn                = 'Acupuncture Coinsurance YN     '
  pbp_b13b_coins_pct               = 'Acupuncture Coins Pct          '
  pbp_b13b_coins_cov               = 'Acupuncture Coins Cov          '
  pbp_b13b_ded_yn                  = 'Acupuncture Deductible YN      '
  pbp_b13b_ded_amt                 = 'Acupuncture Deductible Amt     '
  pbp_b13b_copay_yn                = 'Acupuncture Copayment YN       '
  pbp_b13b_copay_amt               = 'Acupuncture Copay Amt          '
  pbp_b13b_auth                    = 'Acupuncture Auth               '
  pbp_b13b_refer_yn                = 'Acupuncture Referral YN        '
  pbp_b13c_bendesc_service         = 'Other 1 Name of Service        '
  pbp_b13c_bendesc_amo             = 'Other 1 Ben Desc AMO           '
  pbp_b13c_maxplan_yn              = 'Other 1 Max Plan YN            '
  pbp_b13c_maxplan_amt             = 'Other 1 Max Plan Amt           '
  pbp_b13c_maxplan_per             = 'Other 1 Max Plan Per           '
  pbp_b13c_maxplan_cov             = 'Other 1 Max Plan Cov           '
  pbp_b13c_maxenr_yn               = 'Other 1 Max Enr YN             '
  pbp_b13c_maxenr_amt              = 'Other 1 Max Enr Amt            '
  pbp_b13c_maxenr_per              = 'Other 1 Max Enr Per            '
  pbp_b13c_coins_yn                = 'Other 1 Coinsurance YN         '
  pbp_b13c_coins_pct               = 'Other 1 Coins Pct              '
  pbp_b13c_coins_cov               = 'Other 1 Coins Cov              '
  pbp_b13c_ded_yn                  = 'Other 1 Deductible YN          '
  pbp_b13c_ded_amt                 = 'Other 1 Deductible Amt         '
  pbp_b13c_copay_yn                = 'Other 1 Copayment YN           '
  pbp_b13c_copay_amt               = 'Other 1 Copay Amt              '
  pbp_b13c_auth                    = 'Other 1 Auth                   '
  pbp_b13c_refer_yn                = 'Other 1 Referral YN            '
  pbp_b13d_bendesc_service         = 'Other 2 Name of Service        '
  pbp_b13d_bendesc_amo             = 'Other 2 Ben Desc AMO           '
  pbp_b13d_maxplan_yn              = 'Other 2 Max Plan YN            '
  pbp_b13d_maxplan_amt             = 'Other 2 Max Plan Amt           '
  pbp_b13d_maxplan_per             = 'Other 2 Max Plan Per           '
  pbp_b13d_maxplan_cov             = 'Other 2 Max Plan Cov           '
  pbp_b13d_maxenr_yn               = 'Other 2 Max Enr YN             '
  pbp_b13d_maxenr_amt              = 'Other 2 Max Enr Amt            '
  pbp_b13d_maxenr_per              = 'Other 2 Max Enr Per            '
  pbp_b13d_coins_yn                = 'Other 2 Coinsurance YN         '
  pbp_b13d_coins_pct               = 'Other 2 Coins Pct              '
  pbp_b13d_coins_cov               = 'Other 2 Coins Cov              '
  pbp_b13d_ded_yn                  = 'Other 2 Deductible YN          '
  pbp_b13d_ded_amt                 = 'Other 2 Deductible Amt         '
  pbp_b13d_copay_yn                = 'Other 2 Copayment YN           '
  pbp_b13d_copay_amt               = 'Other 2 Copay Amt              '
  pbp_b13d_auth                    = 'Other 2 Auth                   '
  pbp_b13d_refer_yn                = 'Other 2 Referral YN            '
  pbp_b13e_bendesc_service         = 'Other 3 Name of Service        '
  pbp_b13e_bendesc_amo             = 'Other 3 Ben Desc AMO           '
  pbp_b13e_maxplan_yn              = 'Other 3 Max Plan YN            '
  pbp_b13e_maxplan_amt             = 'Other 3 Max Plan Amt           '
  pbp_b13e_maxplan_per             = 'Other 3 Max Plan Per           '
  pbp_b13e_maxplan_cov             = 'Other 3 Max Plan Cov           '
  pbp_b13e_maxenr_yn               = 'Other 3 Max Enr YN             '
  pbp_b13e_maxenr_amt              = 'Other 3 Max Enr Amt            '
  pbp_b13e_maxenr_per              = 'Other 3 Max Enr Per            '
  pbp_b13e_coins_yn                = 'Other 3 Coinsurance YN         '
  pbp_b13e_coins_pct               = 'Other 3 Coins Pct              '
  pbp_b13e_coins_cov               = 'Other 3 Coins Cov              '
  pbp_b13e_ded_yn                  = 'Other 3 Deductible YN          '
  pbp_b13e_ded_amt                 = 'Other 3 Deductible Amt         '
  pbp_b13e_copay_yn                = 'Other 3 Copayment YN           '
  pbp_b13e_copay_amt               = 'Other 3 Copay Amt              '
  pbp_b13e_auth                    = 'Other 3 Auth                   '
  pbp_b13e_refer_yn                = 'Other 3 Referral YN            '
;
run;

proc sort data = pbp_b13 out = out.pbp_b13;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b13 (obs = 10);
  title 'pbp b13 data';
run;

proc means data =  out.pbp_b13;
  title 'pbp b13 file';
run;

proc freq data = out.pbp_b13;
  table
  orgtype
  pbp_b13a_bendesc_yn
  pbp_b13a_bendesc_amo
  pbp_b13a_maxenr_yn
  pbp_b13a_maxenr_per
  pbp_b13a_coins_yn
  pbp_b13a_coins_cov_mc
  pbp_b13a_ded_yn
  pbp_b13a_copay_yn
  pbp_b13a_auth
  pbp_b13a_refer_yn
  pbp_b13b_bendesc_yn
  pbp_b13b_bendesc_amo
  pbp_b13b_bendesc_lim
  pbp_b13b_bendesc_per
  pbp_b13b_maxplan_yn
  pbp_b13b_maxplan_per
  pbp_b13a_bendec
  pbp_b13b_bendesc_enhan
  pbp_b13b_maxplan_cov
  pbp_b13b_maxenr_yn
  pbp_b13b_maxenr_per
  pbp_b13b_coins_yn
  pbp_b13b_coins_cov
  pbp_b13b_ded_yn
  pbp_b13b_copay_yn
  pbp_b13b_auth
  pbp_b13b_refer_yn
  pbp_b13c_bendesc_service
  pbp_b13c_bendesc_amo
  pbp_b13c_maxplan_yn
  pbp_b13c_maxplan_per
  pbp_b13c_maxplan_cov
  pbp_b13c_maxenr_yn
  pbp_b13c_maxenr_per
  pbp_b13c_coins_yn
  pbp_b13c_coins_cov
  pbp_b13c_ded_yn
  pbp_b13c_copay_yn
  pbp_b13c_auth
  pbp_b13c_refer_yn
  pbp_b13d_bendesc_service
  pbp_b13d_bendesc_amo
  pbp_b13d_maxplan_yn
  pbp_b13d_maxplan_per
  pbp_b13d_maxplan_cov
  pbp_b13d_maxenr_yn
  pbp_b13d_maxenr_per
  pbp_b13d_coins_yn
  pbp_b13d_coins_cov
  pbp_b13d_ded_yn
  pbp_b13d_copay_yn
  pbp_b13d_auth
  pbp_b13d_refer_yn
  pbp_b13e_bendesc_service
  pbp_b13e_bendesc_amo
  pbp_b13e_maxplan_yn
  pbp_b13e_maxplan_per
  pbp_b13e_maxplan_cov
  pbp_b13e_maxenr_yn
  pbp_b13e_maxenr_per
  pbp_b13e_coins_yn
  pbp_b13e_coins_cov
  pbp_b13e_ded_yn
  pbp_b13e_copay_yn
  pbp_b13e_auth
  pbp_b13e_refer_yn / missing;
run;

proc contents data = out.pbp_b13;
  title 'pbp b13 data';
run;
