*pbp_b17.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b17;

length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_b17a_bendesc_yn              $1
  pbp_b17a_bendesc_amo_rex         $1
  pbp_b17a_bendesc_lim             $1
  pbp_b17a_bendesc_per             $1
  pbp_b17a_maxplan_yn              $1
  pbp_b17a_maxplan_per             $1
  pbp_b17a_maxplan_cov             $1
  pbp_b17a_bendesc_enh             $1
  pbp_b17a_maxenr_yn               $1
  pbp_b17a_maxenr_per              $1
  pbp_b17a_coins_yn                $1
  pbp_b17a_coins_cov_mc            $1
  pbp_b17a_coins_rexcov            $1
  pbp_b17a_ded_yn                  $1
  pbp_b17a_copay_yn                $1
  pbp_b17a_auth                    $5
  pbp_b17a_refer_yn                $1
  pbp_b17b_bendesc_yn              $1
  pbp_b17b_bendesc_amo_cl          $1
  pbp_b17b_bendesc_lim_cl          $1
  pbp_b17b_bendesc_per_cl          $1
  pbp_b17b_bendesc_enh             $5
  pbp_b17b_bendesc_amo_egs         $1
  pbp_b17b_bendesc_lim_egs         $1
  pbp_b17b_bendesc_per_egs         $1
  pbp_b17b_bendesc_amo_egi         $1
  pbp_b17b_bendesc_lim_egl         $1
  pbp_b17b_bendesc_per_egl         $1
  pbp_b17b_bendesc_amo_egf         $1
  pbp_b17b_bendesc_lim_egf         $1
  pbp_b17b_bendesc_per_egf         $1
  pbp_b17b_bendesc_amo_upg         $1
  pbp_b17b_maxplan_yn              $1
  pbp_b17b_maxplan_type            $1
  pbp_b17b_maxplan_per             $1
  pbp_b17b_maxplan_cov             $1
  pbp_b17b_maxenr_yn               $1
  pbp_b17b_maxenr_type             $1
  pbp_b17b_maxenr_per              $1
  pbp_b17b_coins_yn                $1
  pbp_b17b_coins_cov_mc            $1
  pbp_b17b_coins_cov_cl            $1
  pbp_b17b_coins_cov_egs           $1
  pbp_b17b_coins_cov_egl           $1
  pbp_b17b_coins_cov_egf           $1
  pbp_b17b_coins_cov_upg           $1
  pbp_b17b_ded_yn                  $1
  pbp_b17b_copay_yn                $1
  pbp_b17b_auth                    $5
  pbp_b17b_refer_yn                $1
;

  infile '.\pbp\pbp_b17_eye_exams_wear.txt'
         delimiter = '09'x dsd lrecl = 20000 firstobs = 2 missover;
input
  pbp_a_hnumber
  pbp_a_plan_identifier
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b17a_bendesc_yn
  pbp_b17a_bendesc_enh
  pbp_b17a_bendesc_amo_rex
  pbp_b17a_bendesc_lim
  pbp_b17a_bendesc_numv
  pbp_b17a_bendesc_per
  pbp_b17a_maxplan_yn
  pbp_b17a_maxplan_amt
  pbp_b17a_maxplan_per
  pbp_b17a_maxplan_cov
  pbp_b17a_maxenr_yn
  pbp_b17a_maxenr_amt
  pbp_b17a_maxenr_per
  pbp_b17a_coins_yn
  pbp_b17a_coins_mcmin_pct
  pbp_b17a_coins_mcmax_pct
  pbp_b17a_coins_cov_mc
  pbp_b17a_coins_rexmin_pct
  pbp_b17a_coins_rexmax_pct
  pbp_b17a_coins_rexcov
  pbp_b17a_ded_yn
  pbp_b17a_ded_amt
  pbp_b17a_copay_yn
  pbp_b17a_copay_mcmin_amt
  pbp_b17a_copay_mcmax_amt
  pbp_b17a_copay_rexmin_amt
  pbp_b17a_copay_rexmax_amt
  pbp_b17a_auth
  pbp_b17a_refer_yn
  pbp_b17b_bendesc_yn
  pbp_b17b_bendesc_enh
  pbp_b17b_bendesc_amo_cl
  pbp_b17b_bendesc_lim_cl
  pbp_b17b_bendesc_numv_cl
  pbp_b17b_bendesc_per_cl
  pbp_b17b_bendesc_amo_egs
  pbp_b17b_bendesc_lim_egs
  pbp_b17b_bendesc_numv_egs
  pbp_b17b_bendesc_per_egs
  pbp_b17b_bendesc_amo_egi
  pbp_b17b_bendesc_lim_egl
  pbp_b17b_bendesc_numv_egl
  pbp_b17b_bendesc_per_egl
  pbp_b17b_bendesc_amo_egf
  pbp_b17b_bendesc_lim_egf
  pbp_b17b_bendesc_numv_egf
  pbp_b17b_bendesc_per_egf
  pbp_b17b_bendesc_amo_upg
  pbp_b17b_maxplan_yn
  pbp_b17b_maxplan_type
  pbp_b17b_maxplan_amt
  pbp_b17b_maxplan_per
  pbp_b17b_maxplan_cov
  pbp_b17b_maxplan_pct
  pbp_b17b_maxenr_yn
  pbp_b17b_maxenr_type
  pbp_b17b_maxenr_amt
  pbp_b17b_maxenr_per
  pbp_b17b_coins_yn
  pbp_b17b_coins_pct_mc
  pbp_b17b_coins_cov_mc
  pbp_b17b_coins_pct_cl
  pbp_b17b_coins_cov_cl
  pbp_b17b_coins_pct_egs
  pbp_b17b_coins_cov_egs
  pbp_b17b_coins_pct_egl
  pbp_b17b_coins_cov_egl
  pbp_b17b_coins_pct_egf
  pbp_b17b_coins_cov_egf
  pbp_b17b_coins_pct_upg
  pbp_b17b_coins_cov_upg
  pbp_b17b_ded_yn
  pbp_b17b_ded_amt
  pbp_b17b_copay_yn
  pbp_b17b_copay_amt_mc
  pbp_b17b_copay_amt_cl
  pbp_b17b_copay_amt_egs
  pbp_b17b_copay_amt_egl
  pbp_b17b_copay_amt_egf
  pbp_b17b_copay_amt_upg
  pbp_b17b_auth
  pbp_b17b_refer_yn
;

label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_b17a_bendesc_yn              = 'Eye Exams Ben Desc YN          '
  pbp_b17a_bendesc_enh             = 'Eye Exams Ben Desc Enhance     '
  pbp_b17a_bendesc_amo_rex         = 'Eye Exams REX Ben Desc AMO     '
  pbp_b17a_bendesc_lim             = 'Eye Exams REX Ben Desc Lim YN  '
  pbp_b17a_bendesc_numv            = 'Eye Exams REX Ben Desc Num     '
  pbp_b17a_bendesc_per             = 'Eye Exams REX Ben Desc Per     '
  pbp_b17a_maxplan_yn              = 'Eye Exams Max Plan YN          '
  pbp_b17a_maxplan_amt             = 'Eye Exams Max Plan Amt         '
  pbp_b17a_maxplan_per             = 'Eye Exams Max Plan Per         '
  pbp_b17a_maxplan_cov             = 'Eye Exams Max Plan Cov         '
  pbp_b17a_maxenr_yn               = 'Eye Exams Max Enr YN           '
  pbp_b17a_maxenr_amt              = 'Eye Exams Max Enr Amt          '
  pbp_b17a_maxenr_per              = 'Eye Exams Max Enr Per          '
  pbp_b17a_coins_yn                = 'Eye Exams Coinsurance YN       '
  pbp_b17a_coins_mcmin_pct         = 'Eye Exams MC Min Coins Pct     '
  pbp_b17a_coins_mcmax_pct         = 'Eye Exams MC Max Coins Pct     '
  pbp_b17a_coins_cov_mc            = 'Eye Exams MC Coins Cov         '
  pbp_b17a_coins_rexmin_pct        = 'Eye Exams REX Min Coins Pct    '
  pbp_b17a_coins_rexmax_pct        = 'Eye Exams REX Max Coins Pct    '
  pbp_b17a_coins_rexcov            = 'Eye Exams REX Coins Cov        '
  pbp_b17a_ded_yn                  = 'Eye Exams Deductible YN        '
  pbp_b17a_ded_amt                 = 'Eye Exams Deductible Amt       '
  pbp_b17a_copay_yn                = 'Eye Exams Copayment YN         '
  pbp_b17a_copay_mcmin_amt         = 'Eye Exams MC Min Copay Amt     '
  pbp_b17a_copay_mcmax_amt         = 'Eye Exams MC Max Copay Amt     '
  pbp_b17a_copay_rexmin_amt        = 'Eye Exams REX Min Copay Amt    '
  pbp_b17a_copay_rexmax_amt        = 'Eye Exams REX Max Copay Amt    '
  pbp_b17a_auth                    = 'Eye Exams Auth                 '
  pbp_b17a_refer_yn                = 'Eye Exams Referral YN          '
  pbp_b17b_bendesc_yn              = 'Eye Wear Ben Desc YN           '
  pbp_b17b_bendesc_enh             = 'Eye Wear Ben Desc Enhance      '
  pbp_b17b_bendesc_amo_cl          = 'Eye Wear CL Ben Desc AMO       '
  pbp_b17b_bendesc_lim_cl          = 'Eye Wear CL Ben Desc Lim YN    '
  pbp_b17b_bendesc_numv_cl         = 'Eye Wear CL Ben Desc Num       '
  pbp_b17b_bendesc_per_cl          = 'Eye Wear CL Ben Desc Per       '
  pbp_b17b_bendesc_amo_egs         = 'Eye Wear EGS Ben Desc AMO      '
  pbp_b17b_bendesc_lim_egs         = 'Eye Wear EGS Ben Desc Lim YN   '
  pbp_b17b_bendesc_numv_egs        = 'Eye Wear EGS Ben Desc Num      '
  pbp_b17b_bendesc_per_egs         = 'Eye Wear EGS Ben Desc Per      '
  pbp_b17b_bendesc_amo_egi         = 'Eye Wear EGL Ben Desc AMO      '
  pbp_b17b_bendesc_lim_egl         = 'Eye Wear EGL Ben Desc Lim YN   '
  pbp_b17b_bendesc_numv_egl        = 'Eye Wear EGL Ben Desc Num      '
  pbp_b17b_bendesc_per_egl         = 'Eye Wear EGL Ben Desc Per      '
  pbp_b17b_bendesc_amo_egf         = 'Eye Wear EGF Ben Desc AMO      '
  pbp_b17b_bendesc_lim_egf         = 'Eye Wear EGF Ben Desc Lim YN   '
  pbp_b17b_bendesc_numv_egf        = 'Eye Wear EGF Ben Desc Num      '
  pbp_b17b_bendesc_per_egf         = 'Eye Wear EGF Ben Desc Per      '
  pbp_b17b_bendesc_amo_upg         = 'Eye Wear UPG Ben Desc AMO      '
  pbp_b17b_maxplan_yn              = 'Eye Wear Max Plan YN           '
  pbp_b17b_maxplan_type            = 'Eye Wear Max Plan Type         '
  pbp_b17b_maxplan_amt             = 'Eye Wear Max Plan Amt          '
  pbp_b17b_maxplan_per             = 'Eye Wear Max Plan Per          '
  pbp_b17b_maxplan_cov             = 'Eye Wear Max Plan Cov          '
  pbp_b17b_maxplan_pct             = 'Eye Wear Max Plan Discnt Pct   '
  pbp_b17b_maxenr_yn               = 'Eye Wear Max Enr YN            '
  pbp_b17b_maxenr_type             = 'Eye Wear Max Enr Type          '
  pbp_b17b_maxenr_amt              = 'Eye Wear Max Enr Amt           '
  pbp_b17b_maxenr_per              = 'Eye Wear Max Enr Per           '
  pbp_b17b_coins_yn                = 'Eye Wear Coinsurance YN        '
  pbp_b17b_coins_pct_mc            = 'Eye Wear MC Coins Pct          '
  pbp_b17b_coins_cov_mc            = 'Eye Wear MC Coins Cov          '
  pbp_b17b_coins_pct_cl            = 'Eye Wear CL Coins Pct          '
  pbp_b17b_coins_cov_cl            = 'Eye Wear CL Coins Cov          '
  pbp_b17b_coins_pct_egs           = 'Eye Wear EGS Coins Pct         '
  pbp_b17b_coins_cov_egs           = 'Eye Wear EGS Coins Cov         '
  pbp_b17b_coins_pct_egl           = 'Eye Wear EGL Coins Pct         '
  pbp_b17b_coins_cov_egl           = 'Eye Wear EGL Coins Cov         '
  pbp_b17b_coins_pct_egf           = 'Eye Wear EGF Coins Pct         '
  pbp_b17b_coins_cov_egf           = 'Eye Wear EGF Coins Cov         '
  pbp_b17b_coins_pct_upg           = 'Eye Wear UPG Coins Pct         '
  pbp_b17b_coins_cov_upg           = 'Eye Wear UPG Coins Cov         '
  pbp_b17b_ded_yn                  = 'Eye Wear Deductible YN         '
  pbp_b17b_ded_amt                 = 'Eye Wear Deductible Amt        '
  pbp_b17b_copay_yn                = 'Eye Wear Copayment YN          '
  pbp_b17b_copay_amt_mc            = 'Eye Wear MC Copay Amt          '
  pbp_b17b_copay_amt_cl            = 'Eye Wear CL Copay Amt          '
  pbp_b17b_copay_amt_egs           = 'Eye Wear EGS Copay Amt         '
  pbp_b17b_copay_amt_egl           = 'Eye Wear EGL Copay Amt         '
  pbp_b17b_copay_amt_egf           = 'Eye Wear EGF Copay Amt         '
  pbp_b17b_copay_amt_upg           = 'Eye Wear UPG Copay Amt         '
  pbp_b17b_auth                    = 'Eye Wear Auth                  '
  pbp_b17b_refer_yn                = 'Eye Wear Referral YN           '
;

run;

proc sort data = pbp_b17 out = out.pbp_b17;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b17(obs = 10);
  title 'pbp b17 data';
run;

proc means data =  out.pbp_b17;
  title 'pbp b17 file';
run;

proc freq data = out.pbp_b17;
  table
  orgtype
  pbp_b17a_bendesc_yn
  pbp_b17a_bendesc_enh
  pbp_b17a_bendesc_amo_rex
  pbp_b17a_bendesc_lim
  pbp_b17a_bendesc_per
  pbp_b17a_maxplan_yn
  pbp_b17a_maxplan_per
  pbp_b17a_maxplan_cov
  pbp_b17a_maxenr_yn
  pbp_b17a_maxenr_per
  pbp_b17a_coins_yn
  pbp_b17a_coins_cov_mc
  pbp_b17a_coins_rexcov
  pbp_b17a_ded_yn
  pbp_b17a_copay_yn
  pbp_b17a_auth
  pbp_b17a_refer_yn
  pbp_b17b_bendesc_yn
  pbp_b17b_bendesc_amo_cl
  pbp_b17b_bendesc_lim_cl
  pbp_b17b_bendesc_per_cl
  pbp_b17b_bendesc_amo_egs
  pbp_b17b_bendesc_lim_egs
  pbp_b17b_bendesc_per_egs
  pbp_b17b_bendesc_amo_egi
  pbp_b17b_bendesc_lim_egl
  pbp_b17b_bendesc_per_egl
  pbp_b17b_bendesc_amo_egf
  pbp_b17b_bendesc_lim_egf
  pbp_b17b_bendesc_per_egf
  pbp_b17b_bendesc_amo_upg
  pbp_b17b_maxplan_yn
  pbp_b17b_maxplan_type
  pbp_b17b_maxplan_per
  pbp_b17b_maxplan_cov
  pbp_b17b_maxenr_yn
  pbp_b17b_maxenr_type
  pbp_b17b_maxenr_per
  pbp_b17b_coins_yn
  pbp_b17b_coins_cov_mc
  pbp_b17b_coins_cov_cl
  pbp_b17b_coins_cov_egs
  pbp_b17b_coins_cov_egl
  pbp_b17b_coins_cov_egf
  pbp_b17b_coins_cov_upg
  pbp_b17b_ded_yn
  pbp_b17b_copay_yn
  pbp_b17b_auth
  pbp_b17b_refer_yn / missing;
run;

proc contents data = out.pbp_b17;
  title 'pbp b17 data';
run;
