*pbp_b4.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b4;

length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_b4a_bendesc_emg              $1
  pbp_b4b_bendesc_urg              $1
  pbp_b4b_coins_wavd_mcdh          $1
  pbp_b4a_bendesc_yn               $1
  pbp_b4a_bendesc_amo              $1
  pbp_b4a_maxenr_yn                $1
  pbp_b4a_maxenr_per               $1
  pbp_b4a_coins_yn                 $1
  pbp_b4a_coins_wavdia_yn          $1
  pbp_b4a_coins_wavdia_dh          $1
  pbp_b4a_coins_cov_mc             $1
  pbp_b4a_coins_cov_ww             $1
  pbp_b4a_coins_wavdww_yn          $1
  pbp_b4a_ded_yn                   $1
  pbp_b4a_copay_yn                 $1
  pbp_b4a_copay_wavdia_yn          $1
  pbp_b4a_copay_wavdia_mi_dh       $1
  pbp_b4a_copay_wavdww_yn          $1
  pbp_b4a_refer_yn                 $1
  pbp_b4b_bendesc_yn               $1
  pbp_b4b_bendesc_amo              $1
  pbp_b4b_maxenr_yn                $1
  pbp_b4b_maxenr_type              $1
  pbp_b4b_maxenr_per               $1
  pbp_b4b_coins_yn                 $1
  pbp_b4b_coins_wavdmc_yn          $1
  pbp_b4b_coins_cov_mc_min         $1
  pbp_b4b_coins_cov_mc_ww          $1
  pbp_b4b_coins_wavdww_yn          $1
  pbp_b4b_ded_yn                   $1
  pbp_b4b_copay_yn                 $1
  pbp_b4b_copay_wavdia_yn          $1
  pbp_b4b_copay_wavd_mcdh          $1
  pbp_b4b_copay_wavdww_yn          $1
  pbp_b4b_refer_yn                 $1
;

infile '.\pbp\pbp_b4_emerg_urgent.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;

input
  pbp_a_hnumber
  pbp_a_plan_identifier
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b4a_bendesc_yn
  pbp_b4a_bendesc_emg
  pbp_b4a_bendesc_amo
  pbp_b4a_maxenr_yn
  pbp_b4a_maxenr_amt
  pbp_b4a_maxenr_per
  pbp_b4a_coins_yn
  pbp_b4a_coins_pct_mc_min
  pbp_b4a_coins_pct_mc_max
  pbp_b4a_coins_wavdia_yn
  pbp_b4a_coins_wavdia_dh
  pbp_b4a_coins_wavd_dh
  pbp_b4a_coins_cov_mc
  pbp_b4a_coins_pct_ww
  pbp_b4a_coins_cov_ww
  pbp_b4a_coins_wavdww_yn
  pbp_b4a_ded_yn
  pbp_b4a_ded_amt
  pbp_b4a_copay_yn
  pbp_b4a_copay_amt_mc_min
  pbp_b4a_copay_amt_mc_max
  pbp_b4a_copay_wavdia_yn
  pbp_b4a_copay_wavdia_mi_dh
  pbp_b4a_copay_wavd_dh
  pbp_b4a_copay_amt_ww
  pbp_b4a_copay_wavdww_yn
  pbp_b4a_refer_yn
  pbp_b4b_bendesc_yn
  pbp_b4b_bendesc_urg
  pbp_b4b_bendesc_amo
  pbp_b4b_maxenr_yn
  pbp_b4b_maxenr_type
  pbp_b4b_maxenr_amt
  pbp_b4b_maxenr_per
  pbp_b4b_coins_yn
  pbp_b4b_coins_pct_mc_min
  pbp_b4b_coins_pct_mc_max
  pbp_b4b_coins_wavdmc_yn
  pbp_b4b_coins_wavd_mcdh
  pbp_b4b_coins_wavdmc_dh
  pbp_b4b_coins_cov_mc_min
  pbp_b4b_coins_pct_ww
  pbp_b4b_coins_cov_mc_ww
  pbp_b4b_coins_wavdww_yn
  pbp_b4b_ded_yn
  pbp_b4b_ded_amt
  pbp_b4b_copay_yn
  pbp_b4b_copay_amt_mc_min
  pbp_b4b_copay_amt_mc_max
  pbp_b4b_copay_wavdia_yn
  pbp_b4b_copay_wavd_mcdh
  pbp_b4b_copay_wavdmc_dh
  pbp_b4b_copay_amt_ww
  pbp_b4b_copay_wavdww_yn
  pbp_b4b_refer_yn
;

  label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_b4a_bendesc_yn               = 'Emerg Care Ben Desc YN         '
  pbp_b4a_bendesc_emg              = 'Emerg Care Ben Desc            '
  pbp_b4a_bendesc_amo              = 'Emerg Care Ben Desc AMO        '
  pbp_b4a_maxenr_yn                = 'Emerg Care Max Enr YN          '
  pbp_b4a_maxenr_amt               = 'Emerg Care Max Enr Amt         '
  pbp_b4a_maxenr_per               = 'Emerg Care Max Enr Per         '
  pbp_b4a_coins_yn                 = 'Emerg Care Coinsurance YN      '
  pbp_b4a_coins_pct_mc_min         = 'Emerg Care MC Min Coins Pct    '
  pbp_b4a_coins_pct_mc_max         = 'Emerg Care MC Max Coins Pct    '
  pbp_b4a_coins_wavdia_yn          = 'Emerg Care MC Coins Waived YN  '
  pbp_b4a_coins_wavdia_dh          = 'Emerg Care Coins Waived D/H    '
  pbp_b4a_coins_wavd_dh            = 'Emerg Care Coins Waived D/H    '
  pbp_b4a_coins_cov_mc             = 'Emerg Care MC Coins Cov        '
  pbp_b4a_coins_pct_ww             = 'Emerg Care WW Coins Pct        '
  pbp_b4a_coins_cov_ww             = 'Emerg Care MC WW Coins Cov     '
  pbp_b4a_coins_wavdww_yn          = 'Emerg Care WW Coins Waived YN  '
  pbp_b4a_ded_yn                   = 'Emerg Care Deductible YN       '
  pbp_b4a_ded_amt                  = 'Emerg Care Deductible Amt      '
  pbp_b4a_copay_yn                 = 'Emerg Care Copayment YN        '
  pbp_b4a_copay_amt_mc_min         = 'Emerg Care MC Min Copay Amt    '
  pbp_b4a_copay_amt_mc_max         = 'Emerg Care MC Max Copay Amt    '
  pbp_b4a_copay_wavdia_yn          = 'Emerg Care MC Copay Waived YN  '
  pbp_b4a_copay_wavdia_mi_dh       = 'Emerg Care Copay Waived D/H    '
  pbp_b4a_copay_wavd_dh            = 'Emerg Care Copay Waived D/H    '
  pbp_b4a_copay_amt_ww             = 'Emerg Care WW Copay Amt        '
  pbp_b4a_copay_wavdww_yn          = 'Emerg Care WW Copay Waived YN  '
  pbp_b4a_refer_yn                 = 'Emerg Care Referral YN         '
  pbp_b4b_bendesc_yn               = 'Urg Care Ben Desc YN           '
  pbp_b4b_bendesc_urg              = 'Urg Care Ben Desc              '
  pbp_b4b_bendesc_amo              = 'Urg Care Ben Desc AMO          '
  pbp_b4b_maxenr_yn                = 'Urg Care Max Enr YN            '
  pbp_b4b_maxenr_type              = 'Urg Care Max Enr Type          '
  pbp_b4b_maxenr_amt               = 'Urg Care Max Enr Amt           '
  pbp_b4b_maxenr_per               = 'Urg Care Max Enr Per           '
  pbp_b4b_coins_yn                 = 'Urg Care Coinsurance YN        '
  pbp_b4b_coins_pct_mc_min         = 'Urg Care MC Min Coins Pct      '
  pbp_b4b_coins_pct_mc_max         = 'Urg Care MC Max Coins Pct      '
  pbp_b4b_coins_wavdmc_yn          = 'Urg Care MC Coins Waived YN    '
  pbp_b4b_coins_wavd_mcdh          = 'Urg Care MC Coins Waived D/H   '
  pbp_b4b_coins_wavdmc_dh          = 'Urg Care MC Coins Waived D/H   '
  pbp_b4b_coins_cov_mc_min         = 'Urg Care MC Coins Cov          '
  pbp_b4b_coins_pct_ww             = 'Urg Care WW Coins Pct          '
  pbp_b4b_coins_cov_mc_ww          = 'Urg Care WW Coins Cov          '
  pbp_b4b_coins_wavdww_yn          = 'Urg Care Coins Waived (WW) YN  '
  pbp_b4b_ded_yn                   = 'Urg Care Deductible YN         '
  pbp_b4b_ded_amt                  = 'Urg Care Deductible Amt        '
  pbp_b4b_copay_yn                 = 'Urg Care Copayment YN          '
  pbp_b4b_copay_amt_mc_min         = 'Urg Care MC Min Copay Amt      '
  pbp_b4b_copay_amt_mc_max         = 'Urg Care MC Max Copay Amt      '
  pbp_b4b_copay_wavdia_yn          = 'Urg Care Copay Waived (IA) YN  '
  pbp_b4b_copay_wavd_mcdh          = 'Urg Care MC Copay Waived D/H   '
  pbp_b4b_copay_wavdmc_dh          = 'Urg Care MC Copay Waived D/H   '
  pbp_b4b_copay_amt_ww             = 'Urg Care WW Copay Amt          '
  pbp_b4b_copay_wavdww_yn          = 'Urg Care Copay Waived (WW) YN  '
  pbp_b4b_refer_yn                 = 'Urg Care Referral YN           '
;
run;

proc sort data = pbp_b4 out = out.pbp_b4;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b4 (obs = 10);
  title 'pbp b4 data';
run;

proc means data =  out.pbp_b4;
  title 'pbp b4 file';
run;

proc freq data = out.pbp_b4;
  table
  pbp_a_ben_cov pbp_a_plan_type orgtype
  pbp_b4a_bendesc_yn
  pbp_b4a_bendesc_amo
  pbp_b4a_bendesc_emg
  pbp_b4b_bendesc_urg
  pbp_b4b_coins_wavd_mcdh
  pbp_b4a_maxenr_yn
  pbp_b4a_maxenr_per
  pbp_b4a_coins_yn
  pbp_b4a_coins_wavdia_yn
  pbp_b4a_coins_wavdia_dh
  pbp_b4a_coins_cov_mc
  pbp_b4a_coins_cov_ww
  pbp_b4a_coins_wavdww_yn
  pbp_b4a_ded_yn
  pbp_b4a_copay_yn
  pbp_b4a_copay_wavdia_yn
  pbp_b4a_copay_wavdia_mi_dh
  pbp_b4a_copay_wavdww_yn
  pbp_b4a_refer_yn
  pbp_b4b_bendesc_yn
  pbp_b4b_bendesc_amo
  pbp_b4b_maxenr_yn
  pbp_b4b_maxenr_type
  pbp_b4b_maxenr_per
  pbp_b4b_coins_yn
  pbp_b4b_coins_wavdmc_yn
  pbp_b4b_coins_cov_mc_min
  pbp_b4b_coins_cov_mc_ww
  pbp_b4b_coins_wavdww_yn
  pbp_b4b_ded_yn
  pbp_b4b_copay_yn
  pbp_b4b_copay_wavdia_yn
  pbp_b4b_copay_wavd_mcdh
  pbp_b4b_copay_wavdww_yn
  pbp_b4b_refer_yn / missing;
run;

proc contents data = out.pbp_b4;
  title 'pbp b4 data';
run;
