*pbp_b6.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b6;

length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_b6_bendesc_hh                $3
  pbp_b6_bendesc_yn                $1
  pbp_b6_bendesc_amo               $1
  pbp_b6_bendesc_amo_rc            $1
  pbp_b6_bendesc_amo_hs            $1
  pbp_b6_maxenr_yn                 $1
  pbp_b6_maxenr_per                $1
  pbp_b6_coins_yn                  $1
  pbp_b6_coins_cov_mc              $1
  pbp_b6_coins_cov_cc              $1
  pbp_b6_coins_cov_rc              $1
  pbp_b6_coins_cov_hs              $1
  pbp_b6_ded_yn                    $1
  pbp_b6_copay_yn                  $1
  pbp_b6_auth                      $5
  pbp_b6_refer_yn                  $1
;

infile '.\pbp\pbp_b6_home_health.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
  pbp_a_hnumber
  pbp_a_plan_identifier
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b6_bendesc_yn
  pbp_b6_bendesc_hh
  pbp_b6_bendesc_amo
  pbp_b6_bendesc_amo_rc
  pbp_b6_bendesc_amo_hs
  pbp_b6_maxenr_yn
  pbp_b6_maxenr_amt
  pbp_b6_maxenr_per
  pbp_b6_coins_yn
  pbp_b6_coins_pct_mc_min
  pbp_b6_coins_pct_mc_max
  pbp_b6_coins_cov_mc
  pbp_b6_coins_pct_cc_min
  pbp_b6_coins_pct_cc_max
  pbp_b6_coins_cov_cc
  pbp_b6_coins_pct_rc_min
  pbp_b6_coins_pct_rc_max
  pbp_b6_coins_cov_rc
  pbp_b6_coins_pct_hs_min
  pbp_b6_coins_pct_hs_max
  pbp_b6_coins_cov_hs
  pbp_b6_ded_yn
  pbp_b6_ded_amt
  pbp_b6_copay_yn
  pbp_b6_copay_mc_amt_min
  pbp_b6_copay_mc_amt_max
  pbp_b6_copay_cc_amt_min
  pbp_b6_copay_cc_amt_max
  pbp_b6_copay_rc_amt_min
  pbp_b6_copay_rc_amt_max
  pbp_b6_copay_hs_amt_min
  pbp_b6_copay_hs_amt_max
  pbp_b6_auth
  pbp_b6_refer_yn
;

  label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_b6_bendesc_yn                = 'Home Health Ben Desc YN        '
  pbp_b6_bendesc_hh                = 'Home Health Ben Desc Enhance   '
  pbp_b6_bendesc_amo               = 'Home Health Ben Desc AMO       '
  pbp_b6_bendesc_amo_rc            = 'Home Health RC Ben Desc AMO    '
  pbp_b6_bendesc_amo_hs            = 'Home Health HS Ben Desc AMO    '
  pbp_b6_maxenr_yn                 = 'Home Health Max Enr YN         '
  pbp_b6_maxenr_amt                = 'Home Health Max Enr Amt        '
  pbp_b6_maxenr_per                = 'Home Health Max Enr Per        '
  pbp_b6_coins_yn                  = 'Home Health Coinsurance YN     '
  pbp_b6_coins_pct_mc_min          = 'Home Health MC Min Coins Pct   '
  pbp_b6_coins_pct_mc_max          = 'Home Health MC Max Coins Pct   '
  pbp_b6_coins_cov_mc              = 'Home Health MC Coins Cov       '
  pbp_b6_coins_pct_cc_min          = 'Home Health CC Min Coins Pct   '
  pbp_b6_coins_pct_cc_max          = 'Home Health CC Max Coins Pct   '
  pbp_b6_coins_cov_cc              = 'Home Health CC Coins Cov       '
  pbp_b6_coins_pct_rc_min          = 'Home Health RC Min Coins Pct   '
  pbp_b6_coins_pct_rc_max          = 'Home Health RC Max Coins Pct   '
  pbp_b6_coins_cov_rc              = 'Home Health RC Coins Cov       '
  pbp_b6_coins_pct_hs_min          = 'Home Health HS Min Coins Pct   '
  pbp_b6_coins_pct_hs_max          = 'Home Health HS Max Coins Pct   '
  pbp_b6_coins_cov_hs              = 'Home Health HS Coins Cov       '
  pbp_b6_ded_yn                    = 'Home Health Deductible YN      '
  pbp_b6_ded_amt                   = 'Home Health Deductible Amt     '
  pbp_b6_copay_yn                  = 'Home Health Copayment YN       '
  pbp_b6_copay_mc_amt_min          = 'Home Health MC Min Copay Amt   '
  pbp_b6_copay_mc_amt_max          = 'Home Health MC Max Copay Amt   '
  pbp_b6_copay_cc_amt_min          = 'Home Health CC Min Copay Amt   '
  pbp_b6_copay_cc_amt_max          = 'Home Health CC Max Copay Amt   '
  pbp_b6_copay_rc_amt_min          = 'Home Health RC Min Copay Amt   '
  pbp_b6_copay_rc_amt_max          = 'Home Health RC Max Copay Amt   '
  pbp_b6_copay_hs_amt_min          = 'Home Health HS Min Copay Amt   '
  pbp_b6_copay_hs_amt_max          = 'Home Health HS Max Copay Amt   '
  pbp_b6_auth                      = 'Home Health Auth               '
  pbp_b6_refer_yn                  = 'Home Health Referral YN        '
;

run;

proc sort data = pbp_b6 out = out.pbp_b6;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b6 (obs = 10);
  title 'pbp b6 data';
run;

proc means data =  out.pbp_b6;
  title 'pbp b6 file';
run;

proc freq data = out.pbp_b6;
  table
  pbp_a_ben_cov pbp_a_plan_type orgtype
  pbp_b6_bendesc_yn
  pbp_b6_bendesc_amo
  pbp_b6_bendesc_amo_rc
  pbp_b6_bendesc_amo_hs
  pbp_b6_maxenr_yn
  pbp_b6_bendesc_hh
  pbp_b6_maxenr_per
  pbp_b6_coins_yn
  pbp_b6_coins_cov_mc
  pbp_b6_coins_cov_cc
  pbp_b6_coins_cov_rc
  pbp_b6_coins_cov_hs
  pbp_b6_ded_yn
  pbp_b6_copay_yn
  pbp_b6_auth
  pbp_b6_refer_yn / missing;
run;

proc contents data = out.pbp_b6;
  title 'pbp b6 data';
run;
