* pbp_b9.sas;

libname out '.\sas_data_sets\PBP';

options pageno=1 nocenter ls=200;

data pbp_b9;
  length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_b9c_coins_mcgs_intrvl_num    $1
  pbp_b9c_coins_mcis_intrvl_num    $1
  pbp_b9c_copay_mcgs_intrvl_num    $1
  pbp_b9c_copay_mcis_intrvl_num    $1
  pbp_b9a_maxenr_yn                $1
  pbp_b9a_maxenr_per               $1
  pbp_b9a_coins_yn                 $1
  pbp_b9a_coins_cov_mc             $1
  pbp_b9a_ded_yn                   $1
  pbp_b9a_copay_yn                 $1
  pbp_b9a_auth                     $5
  pbp_b9a_refer_yn                 $1
  pbp_b9b_maxenr_yn                $1
  pbp_b9b_maxenr_type              $1
  pbp_b9b_maxenr_per               $1
  pbp_b9b_coins_yn                 $1
  pbp_b9b_coins_cov_mc             $1
  pbp_b9b_ded_yn                   $1
  pbp_b9b_copay_yn                 $1
  pbp_b9b_auth                     $5
  pbp_b9b_refer_yn                 $1
  pbp_b9c_maxenr_yn                $1
  pbp_b9c_maxenr_type              $1
  pbp_b9c_maxenr_per               $1
  pbp_b9c_coins_yn                 $1
  pbp_b9c_coins_mcis_cov           $1
  pbp_b9c_coins_mcgs_cov           $1
  pbp_b9c_ded_yn                   $1
  pbp_b9c_copay_yn                 $1
  pbp_b9c_auth                     $5
  pbp_b9c_refer_yn                 $1
  pbp_b9d_maxenr_yn                $1
  pbp_b9d_maxenr_type              $1
  pbp_b9d_maxenr_per               $1
  pbp_b9d_coins_yn                 $1
  pbp_b9d_coins_cov_mc             $1
  pbp_b9d_ded_yn                   $1
  pbp_b9d_copay_yn                 $1
  pbp_b9d_auth                     $5
  pbp_b9d_refer_yn                 $1
;

  infile '.\pbp\pbp_b9_outpt_hosp.txt'
         delimiter = '09'x dsd lrecl = 30000 firstobs = 2 missover;
input
  pbp_a_hnumber
  pbp_a_plan_identifier
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b9a_maxenr_yn
  pbp_b9a_maxenr_amt
  pbp_b9a_maxenr_per
  pbp_b9a_coins_yn
  pbp_b9a_coins_pct_mc
  pbp_b9a_coins_pct_mcmax
  pbp_b9a_coins_cov_mc
  pbp_b9a_ded_yn
  pbp_b9a_ded_amt
  pbp_b9a_copay_yn
  pbp_b9a_copay_mc_amt
  pbp_b9a_copay_mc_amt_max
  pbp_b9a_auth
  pbp_b9a_refer_yn
  pbp_b9b_maxenr_yn
  pbp_b9b_maxenr_type
  pbp_b9b_maxenr_amt
  pbp_b9b_maxenr_per
  pbp_b9b_coins_yn
  pbp_b9b_coins_pct_mc
  pbp_b9b_coins_pct_mcmax
  pbp_b9b_coins_cov_mc
  pbp_b9b_ded_yn
  pbp_b9b_ded_amt
  pbp_b9b_copay_yn
  pbp_b9b_copay_mc_amt
  pbp_b9b_copay_mc_amt_max
  pbp_b9b_auth
  pbp_b9b_refer_yn
  pbp_b9c_maxenr_yn
  pbp_b9c_maxenr_type
  pbp_b9c_maxenr_amt
  pbp_b9c_maxenr_per
  pbp_b9c_coins_yn
  pbp_b9c_coins_mcis_intrvl_num
  pbp_b9c_coins_mcis_pct_intrvl1
  pbp_b9c_coins_mcis_bgns_ntrvl1
  pbp_b9c_coins_mcis_ends_ntrvl1
  pbp_b9c_coins_mcis_pct_intrvl2
  pbp_b9c_coins_mcis_bgns_ntrvl2
  pbp_b9c_coins_mcis_ends_ntrvl2
  pbp_b9c_coins_mcis_pct_intrvl3
  pbp_b9c_coins_mcis_bgns_ntrvl3
  pbp_b9c_coins_mcis_ends_ntrvl3
  pbp_b9c_coins_mcis_cov
  pbp_b9c_coins_mcgs_intrvl_num
  pbp_b9c_coins_mcgs_pct_intrvl1
  pbp_b9c_coins_mcgs_bgns_ntrvl1
  pbp_b9c_coins_mcgs_ends_ntrvl1
  pbp_b9c_coins_mcgs_pct_intrvl2
  pbp_b9c_coins_mcgs_bgns_ntrvl2
  pbp_b9c_coins_mcgs_ends_ntrvl2
  pbp_b9c_coins_mcgs_pct_intrvl3
  pbp_b9c_coins_mcgs_bgns_ntrvl3
  pbp_b9c_coins_mcgs_ends_ntrvl3
  pbp_b9c_coins_mcgs_cov
  pbp_b9c_ded_yn
  pbp_b9c_ded_amt
  pbp_b9c_copay_yn
  pbp_b9c_copay_mcis_intrvl_num
  pbp_b9c_copay_mcis_amt_intrvl1
  pbp_b9c_copay_mcis_bgns_ntrvl1
  pbp_b9c_copay_mcis_ends_ntrvl1
  pbp_b9c_copay_mcis_amt_intrvl2
  pbp_b9c_copay_mcis_bgns_ntrvl2
  pbp_b9c_copay_mcis_ends_ntrvl2
  pbp_b9c_copay_mcis_amt_intrvl3
  pbp_b9c_copay_mcis_bgns_ntrvl3
  pbp_b9c_copay_mcis_ends_ntrvl3
  pbp_b9c_copay_mcgs_intrvl_num
  pbp_b9c_copay_mcgs_amt_intrvl1
  pbp_b9c_copay_mcgs_bgns_ntrvl1
  pbp_b9c_copay_mcgs_ends_ntrvl1
  pbp_b9c_copay_mcgs_amt_intrvl2
  pbp_b9c_copay_mcgs_bgns_ntrvl2
  pbp_b9c_copay_mcgs_ends_ntrvl2
  pbp_b9c_copay_mcgs_amt_intrvl3
  pbp_b9c_copay_mcgs_bgns_ntrvl3
  pbp_b9c_copay_mcgs_ends_ntrvl3
  pbp_b9c_auth
  pbp_b9c_refer_yn
  pbp_b9d_maxenr_yn
  pbp_b9d_maxenr_type
  pbp_b9d_maxenr_amt
  pbp_b9d_maxenr_per
  pbp_b9d_coins_yn
  pbp_b9d_coins_pct_mc
  pbp_b9d_coins_pct_mcmax
  pbp_b9d_coins_cov_mc
  pbp_b9d_ded_yn
  pbp_b9d_ded_amt
  pbp_b9d_copay_yn
  pbp_b9d_copay_mc_amt
  pbp_b9d_copay_mc_amt_max
  pbp_b9d_auth
  pbp_b9d_refer_yn
;

  label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_b9a_maxenr_yn                = 'Outpnt Hosp Max Enr YN         '
  pbp_b9a_maxenr_amt               = 'Outpnt Hosp Max Enr Amt        '
  pbp_b9a_maxenr_per               = 'Outpnt Hosp Max Enr Per        '
  pbp_b9a_coins_yn                 = 'Outpnt Hosp Coinsurance YN     '
  pbp_b9a_coins_pct_mc             = 'Outpnt Hosp MC Min Coins Pct   '
  pbp_b9a_coins_pct_mcmax          = 'Outpnt Hosp MC Max Coins Pct   '
  pbp_b9a_coins_cov_mc             = 'Outpnt Hosp MC Coins Cov       '
  pbp_b9a_ded_yn                   = 'Outpnt Hosp Deductible YN      '
  pbp_b9a_ded_amt                  = 'Outpnt Hosp Deductible Amt     '
  pbp_b9a_copay_yn                 = 'Outpnt Hosp Copayment YN       '
  pbp_b9a_copay_mc_amt             = 'Outpnt Hosp MC Min Copay Amt   '
  pbp_b9a_copay_mc_amt_max         = 'Outpnt Hosp MC Max Copay Amt   '
  pbp_b9a_auth                     = 'Outpnt Hosp Auth               '
  pbp_b9a_refer_yn                 = 'Outpnt Hosp Referral YN        '
  pbp_b9b_maxenr_yn                = 'ASC Services Max Enr YN        '
  pbp_b9b_maxenr_type              = 'ASC Services Max Enr Type      '
  pbp_b9b_maxenr_amt               = 'ASC Services Max Enr Amt       '
  pbp_b9b_maxenr_per               = 'ASC Services Max Enr Per       '
  pbp_b9b_coins_yn                 = 'ASC Services Coinsurance YN    '
  pbp_b9b_coins_pct_mc             = 'ASC Services MC Min Coins Pct  '
  pbp_b9b_coins_pct_mcmax          = 'ASC Services MC Max Coins Pct  '
  pbp_b9b_coins_cov_mc             = 'ASC Services MC Coins Cov      '
  pbp_b9b_ded_yn                   = 'ASC Services Deductible YN     '
  pbp_b9b_ded_amt                  = 'ASC Services Deductible Amt    '
  pbp_b9b_copay_yn                 = 'ASC Services Copayment YN      '
  pbp_b9b_copay_mc_amt             = 'ASC Services MC Min Copay Amt  '
  pbp_b9b_copay_mc_amt_max         = 'ASC Services MC Max Copay Amt  '
  pbp_b9b_auth                     = 'ASC Services Auth              '
  pbp_b9b_refer_yn                 = 'ASC Services Referral YN       '
  pbp_b9c_maxenr_yn                = 'Outpnt SA Svcs Max Enr YN      '
  pbp_b9c_maxenr_type              = 'Outpnt SA Svcs Max Enr Type    '
  pbp_b9c_maxenr_amt               = 'Outpnt SA Svcs Max Enr Amt     '
  pbp_b9c_maxenr_per               = 'Outpnt SA Svcs Max Enr Per     '
  pbp_b9c_coins_yn                 = 'Outpnt SA Svcs Coinsurance YN  '
  pbp_b9c_coins_mcis_intrvl_num    = 'OSA MCIS Coins Interval Num    '
  pbp_b9c_coins_mcis_pct_intrvl1   = 'OSA MCIS Coins Pct Intrvl 1    '
  pbp_b9c_coins_mcis_bgns_ntrvl1   = 'OSA MCIS Coins BgnS Intrvl 1   '
  pbp_b9c_coins_mcis_ends_ntrvl1   = 'OSA MCIS Coins EndS Intrvl 1   '
  pbp_b9c_coins_mcis_pct_intrvl2   = 'OSA MCIS Coins Pct Intrvl 2    '
  pbp_b9c_coins_mcis_bgns_ntrvl2   = 'OSA MCIS Coins BgnS Intrvl 2   '
  pbp_b9c_coins_mcis_ends_ntrvl2   = 'OSA MCIS Coins EndS Intrvl 2   '
  pbp_b9c_coins_mcis_pct_intrvl3   = 'OSA MCIS Coins Pct Intrvl 3    '
  pbp_b9c_coins_mcis_bgns_ntrvl3   = 'OSA MCIS Coins BgnS Intrvl 3   '
  pbp_b9c_coins_mcis_ends_ntrvl3   = 'OSA MCIS Coins EndS Intrvl 3   '
  pbp_b9c_coins_mcis_cov           = 'OSA MCIS Coins Cov             '
  pbp_b9c_coins_mcgs_intrvl_num    = 'OSA MCGS Coins Interval Num    '
  pbp_b9c_coins_mcgs_pct_intrvl1   = 'OSA MCGS Coins Pct Intrvl 1    '
  pbp_b9c_coins_mcgs_bgns_ntrvl1   = 'OSA MCGS Coins BgnS Intrvl 1   '
  pbp_b9c_coins_mcgs_ends_ntrvl1   = 'OSA MCGS Coins EndS Intrvl 1   '
  pbp_b9c_coins_mcgs_pct_intrvl2   = 'OSA MCGS Coins Pct Intrvl 2    '
  pbp_b9c_coins_mcgs_bgns_ntrvl2   = 'OSA MCGS Coins BgnS Intrvl 2   '
  pbp_b9c_coins_mcgs_ends_ntrvl2   = 'OSA MCGS Coins EndS Intrvl 2   '
  pbp_b9c_coins_mcgs_pct_intrvl3   = 'OSA MCGS Coins Pct Intrvl 3    '
  pbp_b9c_coins_mcgs_bgns_ntrvl3   = 'OSA MCGS Coins BgnS Intrvl 3   '
  pbp_b9c_coins_mcgs_ends_ntrvl3   = 'OSA MCGS Coins EndS Intrvl 3   '
  pbp_b9c_coins_mcgs_cov           = 'OSA MCGS Coins Cov             '
  pbp_b9c_ded_yn                   = 'OSA Svcs Deductible YN         '
  pbp_b9c_ded_amt                  = 'OSA Svcs Deductible Amt        '
  pbp_b9c_copay_yn                 = 'OSA Svcs Copayment YN          '
  pbp_b9c_copay_mcis_intrvl_num    = 'OSA MCIS Copay Interval Num    '
  pbp_b9c_copay_mcis_amt_intrvl1   = 'OSA MCIS Copay Amt Intrvl 1    '
  pbp_b9c_copay_mcis_bgns_ntrvl1   = 'OSA MCIS Copay BgnS Intrvl 1   '
  pbp_b9c_copay_mcis_ends_ntrvl1   = 'OSA MCIS Copay EndS Intrvl 1   '
  pbp_b9c_copay_mcis_amt_intrvl2   = 'OSA MCIS Copay Amt Intrvl 2    '
  pbp_b9c_copay_mcis_bgns_ntrvl2   = 'OSA MCIS Copay BgnS Intrvl 2   '
  pbp_b9c_copay_mcis_ends_ntrvl2   = 'OSA MCIS Copay EndS Intrvl 2   '
  pbp_b9c_copay_mcis_amt_intrvl3   = 'OSA MCIS Copay Amt Intrvl 3    '
  pbp_b9c_copay_mcis_bgns_ntrvl3   = 'OSA MCIS Copay BgnS Intrvl 3   '
  pbp_b9c_copay_mcis_ends_ntrvl3   = 'OSA MCIS Copay EndS Intrvl 3   '
  pbp_b9c_copay_mcgs_intrvl_num    = 'OSA MCGS Copay Interval Num    '
  pbp_b9c_copay_mcgs_amt_intrvl1   = 'OSA MCGS Copay Amt Intrvl 1    '
  pbp_b9c_copay_mcgs_bgns_ntrvl1   = 'OSA MCGS Copay BgnS Intrvl 1   '
  pbp_b9c_copay_mcgs_ends_ntrvl1   = 'OSA MCGS Copay EndS Intrvl 1   '
  pbp_b9c_copay_mcgs_amt_intrvl2   = 'OSA MCGS Copay Amt Intrvl 2    '
  pbp_b9c_copay_mcgs_bgns_ntrvl2   = 'OSA MCGS Copay BgnS Intrvl 2   '
  pbp_b9c_copay_mcgs_ends_ntrvl2   = 'OSA MCGS Copay EndS Intrvl 2   '
  pbp_b9c_copay_mcgs_amt_intrvl3   = 'OSA MCGS Copay Amt Intrvl 3    '
  pbp_b9c_copay_mcgs_bgns_ntrvl3   = 'OSA MCGS Copay BgnS Intrvl 3   '
  pbp_b9c_copay_mcgs_ends_ntrvl3   = 'OSA MCGS Copay EndS Intrvl 3   '
  pbp_b9c_auth                     = 'Outpnt SA Svcs Auth            '
  pbp_b9c_refer_yn                 = 'Outpnt SA Svcs Referral YN     '
  pbp_b9d_maxenr_yn                = 'Cardiac Rehab Max Enr YN       '
  pbp_b9d_maxenr_type              = 'Cardiac Rehab Max Enr Type     '
  pbp_b9d_maxenr_amt               = 'Cardiac Rehab Max Enr Amt      '
  pbp_b9d_maxenr_per               = 'Cardiac Rehab Max Enr Per      '
  pbp_b9d_coins_yn                 = 'Cardiac Rehab Coinsurance YN   '
  pbp_b9d_coins_pct_mc             = 'Cardiac Rehab MC Min Coins Pct '
  pbp_b9d_coins_pct_mcmax          = 'Cardiac Rehab MC Max Coins Pct '
  pbp_b9d_coins_cov_mc             = 'Cardiac Rehab MC Coins Cov     '
  pbp_b9d_ded_yn                   = 'Cardiac Rehab Deductible YN    '
  pbp_b9d_ded_amt                  = 'Cardiac Rehab Deductible Amt   '
  pbp_b9d_copay_yn                 = 'Cardiac Rehab Copayment YN     '
  pbp_b9d_copay_mc_amt             = 'Cardiac Rehab MC Min Copay Amt '
  pbp_b9d_copay_mc_amt_max         = 'Cardiac Rehab MC Max Copay Amt '
  pbp_b9d_auth                     = 'Cardiac Rehab Auth             '
  pbp_b9d_refer_yn                 = 'Cardiac Rehab Referral YN      '

run;

proc sort data = pbp_b9 out = out.pbp_b9;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b9 (obs = 10);
  title 'pbp b9 data';
run;

proc means data =  out.pbp_b9;
  title 'pbp b9 file';
run;

proc freq data = out.pbp_b9;
  table
  pbp_a_ben_cov pbp_a_plan_type orgtype
  pbp_b9a_maxenr_yn
  pbp_b9a_maxenr_per
  pbp_b9a_coins_yn
  pbp_b9a_coins_cov_mc
  pbp_b9a_ded_yn
  pbp_b9c_coins_mcgs_intrvl_num
  pbp_b9c_coins_mcis_intrvl_num
  pbp_b9c_copay_mcgs_intrvl_num
  pbp_b9c_copay_mcis_intrvl_num
  pbp_b9a_copay_yn
  pbp_b9a_auth
  pbp_b9a_refer_yn
  pbp_b9b_maxenr_yn
  pbp_b9b_maxenr_type
  pbp_b9b_maxenr_per
  pbp_b9b_coins_yn
  pbp_b9b_coins_cov_mc
  pbp_b9b_ded_yn
  pbp_b9b_copay_yn
  pbp_b9b_auth
  pbp_b9b_refer_yn
  pbp_b9c_maxenr_yn
  pbp_b9c_maxenr_type
  pbp_b9c_maxenr_per
  pbp_b9c_coins_yn
  pbp_b9c_coins_mcis_cov
  pbp_b9c_coins_mcgs_cov
  pbp_b9c_ded_yn
  pbp_b9c_copay_yn
  pbp_b9c_auth
  pbp_b9c_refer_yn
  pbp_b9d_maxenr_yn
  pbp_b9d_maxenr_type
  pbp_b9d_maxenr_per
  pbp_b9d_coins_yn
  pbp_b9d_coins_cov_mc
  pbp_b9d_ded_yn
  pbp_b9d_copay_yn
  pbp_b9d_auth
  pbp_b9d_refer_yn / missing;
run;

proc contents data = out.pbp_b9;
  title 'pbp b9 data';
run;
