* pbp_Section_D.sas;

libname out '.\sas_data_sets\PBP';

options pageno=1 nocenter ls=200;

data pbp_d;
  length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_d_deduct_yn                  $1
  pbp_d_deduct_all_services_yn     $1
  pbp_d_partb_prem_reduct_yn       $1
  pbp_d_out_pocket_amt_yn          $1
  pbp_d_out_pocket_period          $1
  pbp_d_max_plan_ben_cov_yn        $1
  pbp_d_max_plan_period            $1
  pbp_d_in_coins_yn                $1
  pbp_d_in_coins_period            $1
  pbp_d_out_coins_yn               $1
  pbp_d_out_coins_period           $1
  pbp_d_opt_identifier             $3
;

  infile '.\pbp\pbp_Section_D.txt'
         delimiter = '09'x dsd lrecl = 15000 firstobs = 2 missover;
input
  pbp_a_hnumber
  pbp_a_plan_identifier
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_d_mplusc_premium
  pbp_d_mplusc_bonly_premium
  pbp_d_partb_prem_reduct_yn
  pbp_d_partb_prem_reduct_amt
  pbp_d_msa_annual_amt
  pbp_d_deduct_yn
  pbp_d_deduct
  pbp_d_deduct_all_services_yn
  pbp_d_out_pocket_amt_yn
  pbp_d_out_pocket_amt
  pbp_d_out_pocket_period
  pbp_d_max_plan_ben_cov_yn
  pbp_d_max_plan_ben_cov
  pbp_d_max_plan_period
  pbp_d_in_coins_yn
  pbp_d_in_coins_amt
  pbp_d_in_coins_period
  pbp_d_out_coins_yn
  pbp_d_out_coins_amt
  pbp_d_out_coins_period
  pbp_d_opt_identifier
  pbp_d_amt_opt_premium
  pbp_d_partb_reduct_amt_calc
;

  label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_d_mplusc_premium             = 'Indicate Plan Premium Amt (AB) '
  pbp_d_mplusc_bonly_premium       = 'Indicate Plan Premium Amt (B)  '
  pbp_d_deduct_yn                  = 'Plan Deductible YN             '
  pbp_d_deduct                     = 'Plan Deductible Amt            '
  pbp_d_deduct_all_services_yn     = 'Plan Dedct Apply All Servs YN  '
  pbp_d_partb_prem_reduct_yn       = 'MCO Reduce Part B Premium YN   '
  pbp_d_partb_prem_reduct_amt      = 'Part B Premium Reduction Amt   '
  pbp_d_msa_annual_amt             = 'Annual MSA Deposit Amt         '
  pbp_d_out_pocket_amt_yn          = 'Max Enr Amt YN (non-POS)       '
  pbp_d_out_pocket_amt             = 'Max Enr Amt (non-POS)          '
  pbp_d_out_pocket_period          = 'Max Enr Per (non-POS)          '
  pbp_d_max_plan_ben_cov_yn        = 'Max Plan YN (non-POS)          '
  pbp_d_max_plan_ben_cov           = 'Max Plan Amt (non-POS)         '
  pbp_d_max_plan_period            = 'Max Plan Per (non-POS)         '
  pbp_d_in_coins_yn                = 'Coins PPO In Area YN           '
  pbp_d_in_coins_amt               = 'Coins PPO In Area Pct          '
  pbp_d_in_coins_period            = 'Coins PPO In Area Cov          '
  pbp_d_out_coins_yn               = 'Coins PPO Out of Area YN       '
  pbp_d_out_coins_amt              = 'Coins PPO Out of Area Pct      '
  pbp_d_out_coins_period           = 'Coins PPO Out of Area Cov      '
  pbp_d_opt_identifier             = 'Option D Identifier            '
  pbp_d_amt_opt_premium            = 'Optional Premium Amt (D)       '
  pbp_d_partb_reduct_amt_calc      = 'Calc Part B Prem Reduct Amt    '
;
run;

proc sort data = pbp_d out = out.pbp_d;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_d(obs = 10);
  title 'pbp d data';
run;

proc means data =  out.pbp_d;
  title 'pbp d file';
run;

proc freq data = out.pbp_d;
  table
  pbp_a_ben_cov pbp_a_plan_type orgtype
  pbp_d_deduct_yn
  pbp_d_out_pocket_amt_yn
  pbp_d_out_pocket_period
  pbp_d_max_plan_ben_cov_yn
  pbp_d_max_plan_period
  pbp_d_deduct_all_services_yn
  pbp_d_partb_prem_reduct_yn
  pbp_d_in_coins_yn
  pbp_d_in_coins_period
  pbp_d_out_coins_yn
  pbp_d_out_coins_period
  pbp_d_opt_identifier / missing;
run;

proc contents data = out.pbp_d;
  title 'pbp d data';
run;
