* pbp_Section_D_opt.sas;

libname out '.\sas_data_sets\PBP';

options pageno=1 nocenter ls=200;

data pbp_dopt;
   length
   pbp_a_hnumber            $5
   pbp_a_plan_identifier    $3
   pbp_a_ben_cov            $1
   pbp_a_plan_type          $2
   orgtype                  $2
   pbp_d_opt_identifier     $3
   pbp_d_opt_other_benefits $54
   pbp_d_pick_benefits      $54
 ;

   infile '.\pbp\pbp_Section_D_opts.txt'
          delimiter = '09'x dsd lrecl = 4500 firstobs = 2 missover;
input
   pbp_a_hnumber
   pbp_a_plan_identifier
   pbp_a_ben_cov
   pbp_a_plan_type
   orgtype
   pbp_d_opt_identifier
   pbp_d_amt_opt_premium
   pbp_d_opt_other_benefits
   pbp_d_pick_benefits
 ;

label
orgtype                         = 'Organization Type                 '
pbp_a_ben_cov                   = 'Coverage Criteria                 '
pbp_a_hnumber                   = 'H Number                          '
pbp_a_plan_identifier           = 'Plan Identifier                   '
pbp_a_plan_type                 = 'Select type of Plan               '
pbp_d_amt_opt_premium           = 'Optional Premium Amount (D)       '
pbp_d_opt_identifier            = 'Option D Identifier               '
pbp_d_opt_other_benefits        = 'Select Other Benefits (D)         '
pbp_d_pick_benefits             = 'Select Benefits (D)               '
;
run;

proc sort data = pbp_dopt out = out.pbp_dopt;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_dopt(obs = 10);
  title 'pbp dopt data';
run;

proc means data =  out.pbp_dopt;
  title 'pbp dopt file';
run;

proc freq data = out.pbp_dopt;
  table
  pbp_a_ben_cov pbp_a_plan_type orgtype
  pbp_d_opt_identifier
  pbp_d_opt_other_benefits
  pbp_d_pick_benefits / missing;
  run;

proc contents data = out.pbp_d;
  title 'pbp dopt data';
run;
