*pbp_b14ad.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b14ad;

length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_b14a_bendesc_ehc             $10
  pbp_b14b_bendesc                 $1
  pbp_b14b_cost_share              $1
  pbp_b14c_bendesc_enhan           $1
  pbp_b14c_cost_share              $1
  pbp_b14d_bendesc_enhan           $2
  pbp_b14d_cost_share              $1
  pbp_b14a_bendesc_yn              $1
  pbp_b14a_bendesc_amo_hec         $1
  pbp_b14a_bendesc_amo_nl          $1
  pbp_b14a_bendesc_amo_ntv         $1
  pbp_b14a_bendesc_amo_sc          $1
  pbp_b14a_bendesc_amo_chp         $1
  pbp_b14a_bendesc_amo_amp         $1
  pbp_b14a_bendesc_amo_mhc         $1
  pbp_b14a_bendesc_amo_nhl         $1
  pbp_b14a_bendesc_amo_dsm         $1
  pbp_b14a_bendesc_amo_oth         $1
  pbp_b14a_maxplan_yn              $1
  pbp_b14a_maxplan_per             $1
  pbp_b14a_maxplan_covb            $1
  pbp_b14a_maxenr_yn               $1
  pbp_b14a_maxenr_per              $1
  pbp_b14a_coins_yn                $1
  pbp_b14a_coins_cov_hec           $1
  pbp_b14a_coins_cov_nl            $1
  pbp_b14a_coins_cov_ntv           $1
  pbp_b14a_coins_cov_sc            $1
  pbp_b14a_coins_cov_chp           $1
  pbp_b14a_coins_cov_amp           $1
  pbp_b14a_coins_cov_mhc           $1
  pbp_b14a_coins_cov_nhl           $1
  pbp_b14a_coins_cov_dsm           $1
  pbp_b14a_coins_cov_oth           $1
  pbp_b14a_ded_yn                  $1
  pbp_b14a_copay_yn                $1
  pbp_b14a_auth                    $5
  pbp_b14a_refer_yn                $1
  pbp_b14b_bendesc_yn              $1
  pbp_b14b_bendesc_amo             $1
  pbp_b14b_maxenr_yn               $1
  pbp_b14b_maxenr_type             $1
  pbp_b14b_maxenr_per              $1
  pbp_b14b_coins_yn                $1
  pbp_b14b_coins_cov_mc            $1
  pbp_b14b_coins_cov_oi            $1
  pbp_b14b_ded_yn                  $1
  pbp_b14b_copay_yn                $1
  pbp_b14b_auth                    $5
  pbp_b14b_refer_yn                $1
  pbp_b14c_bendesc_yn              $1
  pbp_b14c_bendesc_amo             $1
  pbp_b14c_bendesc_lim             $1
  pbp_b14c_bendesc_per             $1
  pbp_b14c_maxplan_yn              $1
  pbp_b14c_maxplan_type            $1
  pbp_b14c_maxplan_per             $1
  pbp_b14c_maxplan_cov             $1
  pbp_b14c_maxenr_yn               $1
  pbp_b14c_maxenr_type             $1
  pbp_b14c_maxenr_per              $1
  pbp_b14c_coins_yn                $1
  pbp_b14c_coins_cov               $1
  pbp_b14c_ded_yn                  $1
  pbp_b14c_copay_yn                $1
  pbp_b14c_auth                    $5
  pbp_b14c_refer_yn                $1
  pbp_b14d_bendesc_yn              $1
  pbp_b14d_bendesc_amo_ps          $1
  pbp_b14d_bendesc_lim_aps_yn      $1
  pbp_b14d_bendesc_ps_per          $1
  pbp_b14d_bendesc_amo_pe          $1
  pbp_b14d_bendesc_lim_ape_yn      $1
  pbp_b14d_bendesc_pe_per          $1
  pbp_b14d_maxplan_yn              $1
  pbp_b14d_maxplan_type            $1
  pbp_b14d_maxplan_per             $1
  pbp_b14d_maxplan_cov             $1
  pbp_b14d_maxenr_yn               $1
  pbp_b14d_maxenr_type             $1
  pbp_b14d_maxenr_per              $1
  pbp_b14d_coins_yn                $1
  pbp_b14d_coins_cov_mcpap         $1
  pbp_b14d_coins_cov_pap           $1
  pbp_b14d_coins_cov_mcpe          $1
  pbp_b14d_coins_cov_pe            $1
  pbp_b14d_ded_yn                  $1
  pbp_b14d_copay_yn                $1
  pbp_b14d_auth                    $5
  pbp_b14d_refer_yn                $1
;

infile '.\pbp\pbp_b14_preventive_1.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


  input
  pbp_a_hnumber
  pbp_a_plan_identifier
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b14a_bendesc_yn
  pbp_b14a_bendesc_ehc
  pbp_b14a_bendesc_amo_hec
  pbp_b14a_bendesc_amo_nl
  pbp_b14a_bendesc_amo_ntv
  pbp_b14a_bendesc_amo_sc
  pbp_b14a_bendesc_amo_chp
  pbp_b14a_bendesc_amo_amp
  pbp_b14a_bendesc_amo_mhc
  pbp_b14a_bendesc_amo_nhl
  pbp_b14a_bendesc_amo_dsm
  pbp_b14a_bendesc_amo_oth
  pbp_b14a_maxplan_yn
  pbp_b14a_maxplan_amt
  pbp_b14a_maxplan_per
  pbp_b14a_maxplan_covb
  pbp_b14a_maxplan_pct
  pbp_b14a_maxenr_yn
  pbp_b14a_maxenr_amt
  pbp_b14a_maxenr_per
  pbp_b14a_coins_yn
  pbp_b14a_coins_pct_hec
  pbp_b14a_coins_pct_max_hec
  pbp_b14a_coins_cov_hec
  pbp_b14a_coins_hec_pct
  pbp_b14a_coins_pct_nl
  pbp_b14a_coins_cov_nl
  pbp_b14a_coins_nl_pct
  pbp_b14a_coins_pct_ntv
  pbp_b14a_coins_cov_ntv
  pbp_b14a_coins_ntv_pct
  pbp_b14a_coins_pct_sc
  pbp_b14a_coins_cov_sc
  pbp_b14a_coins_sc_pct
  pbp_b14a_coins_pct_chp
  pbp_b14a_coins_cov_chp
  pbp_b14a_coins_chp_pct
  pbp_b14a_coins_pct_amp
  pbp_b14a_coins_pct_max_amp
  pbp_b14a_coins_cov_amp
  pbp_b14a_coins_amp_pct
  pbp_b14a_coins_pct_mhc
  pbp_b14a_coins_pct_max_mhc
  pbp_b14a_coins_cov_mhc
  pbp_b14a_coins_mhc_pct
  pbp_b14a_coins_pct_nhl
  pbp_b14a_coins_cov_nhl
  pbp_b14a_coins_nhl_pct
  pbp_b14a_coins_pct_dsm
  pbp_b14a_coins_pct_max_dsm
  pbp_b14a_coins_cov_dsm
  pbp_b14a_coins_dsm_pct
  pbp_b14a_coins_pct_oth
  pbp_b14a_coins_pct_max_oth
  pbp_b14a_coins_cov_oth
  pbp_b14a_coins_oth_pct
  pbp_b14a_ded_yn
  pbp_b14a_ded_amt
  pbp_b14a_copay_yn
  pbp_b14a_copay_hec_amt
  pbp_b14a_copay_hec_max_amt
  pbp_b14a_copay_nl_amt
  pbp_b14a_copay_ntv_amt
  pbp_b14a_copay_sc_amt
  pbp_b14a_copay_chp_amt
  pbp_b14a_copay_amp_amt
  pbp_b14a_copay_amp_max_amt
  pbp_b14a_copay_mhc_amt
  pbp_b14a_copay_mhc_max_amt
  pbp_b14a_copay_nhl_amt
  pbp_b14a_copay_dsm_amt
  pbp_b14a_copay_dsm_max_amt
  pbp_b14a_copay_oth_amt
  pbp_b14a_copay_oth_max_amt
  pbp_b14a_auth
  pbp_b14a_refer_yn
  pbp_b14b_bendesc_yn
  pbp_b14b_bendesc
  pbp_b14b_bendesc_amo
  pbp_b14b_maxenr_yn
  pbp_b14b_maxenr_type
  pbp_b14b_maxenr_amt
  pbp_b14b_maxenr_per
  pbp_b14b_coins_yn
  pbp_b14b_coins_pct_mc
  pbp_b14b_coins_cov_mc
  pbp_b14b_coins_pct_oi
  pbp_b14b_coins_pct_maxoi
  pbp_b14b_coins_cov_oi
  pbp_b14b_ded_yn
  pbp_b14b_ded_amt
  pbp_b14b_copay_yn
  pbp_b14b_copay_mc_amt
  pbp_b14b_copay_oi_amt
  pbp_b14b_copay_oi_max_amt
  pbp_b14b_cost_share
  pbp_b14b_auth
  pbp_b14b_refer_yn
  pbp_b14c_bendesc_yn
  pbp_b14c_bendesc_enhan
  pbp_b14c_bendesc_amo
  pbp_b14c_bendesc_lim
  pbp_b14c_bendesc_numv
  pbp_b14c_bendesc_per
  pbp_b14c_maxplan_yn
  pbp_b14c_maxplan_type
  pbp_b14c_maxplan_amt
  pbp_b14c_maxplan_per
  pbp_b14c_maxplan_cov
  pbp_b14c_maxenr_yn
  pbp_b14c_maxenr_type
  pbp_b14c_maxenr_amt
  pbp_b14c_maxenr_per
  pbp_b14c_coins_yn
  pbp_b14c_coins_pct
  pbp_b14c_coins_cov
  pbp_b14c_ded_yn
  pbp_b14c_ded_amt
  pbp_b14c_copay_yn
  pbp_b14c_copay_amt
  pbp_b14c_cost_share
  pbp_b14c_auth
  pbp_b14c_refer_yn
  pbp_b14d_bendesc_yn
  pbp_b14d_bendesc_enhan
  pbp_b14d_bendesc_amo_ps
  pbp_b14d_bendesc_lim_aps_yn
  pbp_b14d_bendesc_numps
  pbp_b14d_bendesc_ps_per
  pbp_b14d_bendesc_amo_pe
  pbp_b14d_bendesc_lim_ape_yn
  pbp_b14d_bendesc_numpe
  pbp_b14d_bendesc_pe_per
  pbp_b14d_maxplan_yn
  pbp_b14d_maxplan_type
  pbp_b14d_maxplan_amt
  pbp_b14d_maxplan_per
  pbp_b14d_maxplan_cov
  pbp_b14d_maxenr_yn
  pbp_b14d_maxenr_type
  pbp_b14d_maxenr_amt
  pbp_b14d_maxenr_per
  pbp_b14d_coins_yn
  pbp_b14d_coins_pct_mcpap
  pbp_b14d_coins_cov_mcpap
  pbp_b14d_coins_pct_pap
  pbp_b14d_coins_cov_pap
  pbp_b14d_coins_pct_mcpe
  pbp_b14d_coins_cov_mcpe
  pbp_b14d_coins_pct_pe
  pbp_b14d_coins_cov_pe
  pbp_b14d_ded_yn
  pbp_b14d_ded_amt
  pbp_b14d_copay_yn
  pbp_b14d_copay_amt_mcpap
  pbp_b14d_copay_amt_mcpe
  pbp_b14d_copay_amt_pap
  pbp_b14d_copay_amt_pe
  pbp_b14d_cost_share
  pbp_b14d_auth
  pbp_b14d_refer_yn
;

  label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_b14a_bendesc_yn              = 'Health Ed Ben Desc YN          '
  pbp_b14a_bendesc_ehc             = 'Health Ed Ben Desc Enhance     '
  pbp_b14a_bendesc_amo_hec         = 'Health Ed HEC Ben Desc AMO     '
  pbp_b14a_bendesc_amo_nl          = 'Health Ed NL Ben Desc AMO      '
  pbp_b14a_bendesc_amo_ntv         = 'Health Ed NTV Ben Desc AMO     '
  pbp_b14a_bendesc_amo_sc          = 'Health Ed SC Ben Desc AMO      '
  pbp_b14a_bendesc_amo_chp         = 'Health Ed CHP Ben Desc AMO     '
  pbp_b14a_bendesc_amo_amp         = 'Health Ed AMP Ben Desc AMO     '
  pbp_b14a_bendesc_amo_mhc         = 'Health Ed MHC Ben Desc AMO     '
  pbp_b14a_bendesc_amo_nhl         = 'Health Ed NHL Ben Desc AMO     '
  pbp_b14a_bendesc_amo_dsm         = 'Health Ed DSM Ben Desc AMO     '
  pbp_b14a_bendesc_amo_oth         = 'Health Ed OTH Ben Desc AMO     '
  pbp_b14a_maxplan_yn              = 'Health Ed Max Plan YN          '
  pbp_b14a_maxplan_amt             = 'Health Ed Max Plan Amt         '
  pbp_b14a_maxplan_per             = 'Health Ed Max Plan Per         '
  pbp_b14a_maxplan_covb            = 'Health Ed Max Plan Cov         '
  pbp_b14a_maxplan_pct             = 'Health Ed Max Plan Pct         '
  pbp_b14a_maxenr_yn               = 'Health Ed Max Enr YN           '
  pbp_b14a_maxenr_amt              = 'Health Ed Max Enr Amt          '
  pbp_b14a_maxenr_per              = 'Health Ed Max Enr Per          '
  pbp_b14a_coins_yn                = 'Health Ed Coinsurance YN       '
  pbp_b14a_coins_pct_hec           = 'Health Ed HEC Min Coins Pct    '
  pbp_b14a_coins_pct_max_hec       = 'Health Ed HEC Max Coins Pct    '
  pbp_b14a_coins_cov_hec           = 'Health Ed HEC Coins Cov        '
  pbp_b14a_coins_hec_pct           = 'Health Ed HEC Coins Pct        '
  pbp_b14a_coins_pct_nl            = 'Health Ed NL Coins Pct         '
  pbp_b14a_coins_cov_nl            = 'Health Ed NL Coins Cov         '
  pbp_b14a_coins_nl_pct            = 'Health Ed NL Coins Dscnt Pct   '
  pbp_b14a_coins_pct_ntv           = 'Health Ed NTV Coins Pct        '
  pbp_b14a_coins_cov_ntv           = 'Health Ed NTV Coins Cov        '
  pbp_b14a_coins_ntv_pct           = 'Health Ed NTV Coins Dscnt Pct  '
  pbp_b14a_coins_pct_sc            = 'Health Ed SC Coins Pct         '
  pbp_b14a_coins_cov_sc            = 'Health Ed SC Coins Cov         '
  pbp_b14a_coins_sc_pct            = 'Health Ed SC Coins Dscnt Pct   '
  pbp_b14a_coins_pct_chp           = 'Health Ed CHP Coins Pct        '
  pbp_b14a_coins_cov_chp           = 'Health Ed CHP Coins Cov        '
  pbp_b14a_coins_chp_pct           = 'Health Ed CHP Coins Dscnt Pct  '
  pbp_b14a_coins_pct_amp           = 'Health Ed AMP Min Coins Pct    '
  pbp_b14a_coins_pct_max_amp       = 'Health Ed AMP Max Coins Pct    '
  pbp_b14a_coins_cov_amp           = 'Health Ed AMP Coins Cov        '
  pbp_b14a_coins_amp_pct           = 'Health Ed AMP Coins Dscnt Pct  '
  pbp_b14a_coins_pct_mhc           = 'Health Ed MHC Min Coins Pct    '
  pbp_b14a_coins_pct_max_mhc       = 'Health Ed MHC Max Coins Pct    '
  pbp_b14a_coins_cov_mhc           = 'Health Ed MHC Coins Cov        '
  pbp_b14a_coins_mhc_pct           = 'Health Ed MHC Coins Dscnt Pct  '
  pbp_b14a_coins_pct_nhl           = 'Health Ed NHL Coins Pct        '
  pbp_b14a_coins_cov_nhl           = 'Health Ed NHL Coins Cov        '
  pbp_b14a_coins_nhl_pct           = 'Health Ed NHL Coins Dscnt Pct  '
  pbp_b14a_coins_pct_dsm           = 'Health Ed DSM Min Coins Pct    '
  pbp_b14a_coins_pct_max_dsm       = 'Health Ed DSM Max Coins Pct    '
  pbp_b14a_coins_cov_dsm           = 'Health Ed DSM Coins Cov        '
  pbp_b14a_coins_dsm_pct           = 'Health Ed DSM Coins Dscnt Pct  '
  pbp_b14a_coins_pct_oth           = 'Health Ed OTH Min Coins Pct    '
  pbp_b14a_coins_pct_max_oth       = 'Health Ed OTH Max Coins Pct    '
  pbp_b14a_coins_cov_oth           = 'Health Ed OTH Coins Cov        '
  pbp_b14a_coins_oth_pct           = 'Health Ed OTH Coins Dscnt Pct  '
  pbp_b14a_ded_yn                  = 'Health Ed Deductible YN        '
  pbp_b14a_ded_amt                 = 'Health Ed Deductible Amt       '
  pbp_b14a_copay_yn                = 'Health Ed Copayment YN         '
  pbp_b14a_copay_hec_amt           = 'Health Ed HEC Copay Min Amt    '
  pbp_b14a_copay_hec_max_amt       = 'Health Ed HEC Copay Max Amt    '
  pbp_b14a_copay_nl_amt            = 'Health Ed NL Copay Amt         '
  pbp_b14a_copay_ntv_amt           = 'Health Ed NTV Copay Amt        '
  pbp_b14a_copay_sc_amt            = 'Health Ed SC Copay Amt         '
  pbp_b14a_copay_chp_amt           = 'Health Ed CHP Copay Amt        '
  pbp_b14a_copay_amp_amt           = 'Health Ed AMP Min Copay Amt    '
  pbp_b14a_copay_amp_max_amt       = 'Health Ed AMP Max Copay Amt    '
  pbp_b14a_copay_mhc_amt           = 'Health Ed MHC Min Copay Amt    '
  pbp_b14a_copay_mhc_max_amt       = 'Health Ed MHC Max Copay Amt    '
  pbp_b14a_copay_nhl_amt           = 'Health Ed NHL Copay Amt        '
  pbp_b14a_copay_dsm_amt           = 'Health Ed DSM Min Copay Amt    '
  pbp_b14a_copay_dsm_max_amt       = 'Health Ed DSM Max Copay Amt    '
  pbp_b14a_copay_oth_amt           = 'Health Ed OTH Min Copay Amt    '
  pbp_b14a_copay_oth_max_amt       = 'Health Ed OTH Max Copay Amt    '
  pbp_b14a_auth                    = 'Health Ed Auth                 '
  pbp_b14a_refer_yn                = 'Health Ed Referral YN          '
  pbp_b14b_bendesc_yn              = 'Immunizations Ben Desc YN      '
  pbp_b14b_bendesc                 = 'Immunizations Ben Desc Enhance '
  pbp_b14b_bendesc_amo             = 'Immunizations Ben Desc AMO     '
  pbp_b14b_maxenr_yn               = 'Immunizations Max Enr YN       '
  pbp_b14b_maxenr_type             = 'Immunizations Max Enr Type     '
  pbp_b14b_maxenr_amt              = 'Immunizations Max Enr Amt      '
  pbp_b14b_maxenr_per              = 'Immunizations Max Enr Per      '
  pbp_b14b_coins_yn                = 'Immunizations Coinsurance YN   '
  pbp_b14b_coins_pct_mc            = 'Immunizations MC Coins Pct     '
  pbp_b14b_coins_cov_mc            = 'Immunizations MC Coins Cov     '
  pbp_b14b_coins_pct_oi            = 'Immunizations OI Min Coins Pct '
  pbp_b14b_coins_pct_maxoi         = 'Immunizations OI Max Coins Pct '
  pbp_b14b_coins_cov_oi            = 'Immunizations OI Coins Cov     '
  pbp_b14b_ded_yn                  = 'Immunizations Deductible YN    '
  pbp_b14b_ded_amt                 = 'Immunizations Deductible Amt   '
  pbp_b14b_copay_yn                = 'Immunizations Copayment YN     '
  pbp_b14b_copay_mc_amt            = 'Immunizations MC Copay Amt     '
  pbp_b14b_copay_oi_amt            = 'Immunizations OI Min Copay Amt '
  pbp_b14b_copay_oi_max_amt        = 'Immunizations OI Max Copay Amt '
  pbp_b14b_cost_share              = 'Immunizations Cost Share       '
  pbp_b14b_auth                    = 'Immunizations Auth             '
  pbp_b14b_refer_yn                = 'Immunizations Referral YN      '
  pbp_b14c_bendesc_yn              = 'Routine Phys Ben Desc YN       '
  pbp_b14c_bendesc_enhan           = 'Routine Phys Ben Desc Enhance  '
  pbp_b14c_bendesc_amo             = 'Routine Phys Ben Desc AMO      '
  pbp_b14c_bendesc_lim             = 'Routine Phys Ben Desc Lim YN   '
  pbp_b14c_bendesc_numv            = 'Routine Phys Ben Desc Num      '
  pbp_b14c_bendesc_per             = 'Routine Phys Ben Desc Per      '
  pbp_b14c_maxplan_yn              = 'Routine Phys Max Plan YN       '
  pbp_b14c_maxplan_type            = 'Routine Phys Max Plan Type     '
  pbp_b14c_maxplan_amt             = 'Routine Phys Max Plan Amt      '
  pbp_b14c_maxplan_per             = 'Routine Phys Max Plan Per      '
  pbp_b14c_maxplan_cov             = 'Routine Phys Max Plan Cov      '
  pbp_b14c_maxenr_yn               = 'Routine Phys Max Enr YN        '
  pbp_b14c_maxenr_type             = 'Routine Phys Max Enr Type      '
  pbp_b14c_maxenr_amt              = 'Routine Phys Max Enr Amt       '
  pbp_b14c_maxenr_per              = 'Routine Phys Max Enr Per       '
  pbp_b14c_coins_yn                = 'Routine Phys Coinsurance YN    '
  pbp_b14c_coins_pct               = 'Routine Phys Coins Pct         '
  pbp_b14c_coins_cov               = 'Routine Phys Coins Cov         '
  pbp_b14c_ded_yn                  = 'Routine Phys Deductible YN     '
  pbp_b14c_ded_amt                 = 'Routine Phys Deductible Amt    '
  pbp_b14c_copay_yn                = 'Routine Phys Copayment YN      '
  pbp_b14c_copay_amt               = 'Routine Phys Copay Amt         '
  pbp_b14c_cost_share              = 'Routine Phys Cost Share        '
  pbp_b14c_auth                    = 'Routine Phys Auth              '
  pbp_b14c_refer_yn                = 'Routine Phys Referral YN       '
  pbp_b14d_bendesc_yn              = 'Pap/Pelvic Ben Desc YN         '
  pbp_b14d_bendesc_enhan           = 'Pap/Pelvic Ben Desc Enhance    '
  pbp_b14d_bendesc_amo_ps          = 'Add Pap Smears Ben Desc AMO    '
  pbp_b14d_bendesc_lim_aps_yn      = 'Add Pap Smears Ben Desc Lim YN '
  pbp_b14d_bendesc_numps           = 'Pap Smears Ben Desc Num        '
  pbp_b14d_bendesc_ps_per          = 'Pap Smears Ben Desc Per        '
  pbp_b14d_bendesc_amo_pe          = 'Add Pelvic Exams Ben Desc AMO  '
  pbp_b14d_bendesc_lim_ape_yn      = 'Add Pelvic Exm Ben Desc Lim YN '
  pbp_b14d_bendesc_numpe           = 'Pelvic Exams Ben Desc Num      '
  pbp_b14d_bendesc_pe_per          = 'Pelvic Exams Ben Desc Per      '
  pbp_b14d_maxplan_yn              = 'Pap/Pelvic Max Plan YN         '
  pbp_b14d_maxplan_type            = 'Pap/Pelvic Max Plan Type       '
  pbp_b14d_maxplan_amt             = 'Pap/Pelvic Max Plan Amt        '
  pbp_b14d_maxplan_per             = 'Pap/Pelvic Max Plan Per        '
  pbp_b14d_maxplan_cov             = 'Pap/Pelvic Max Plan Cov        '
  pbp_b14d_maxenr_yn               = 'Pap/Pelvic Max Enr YN          '
  pbp_b14d_maxenr_type             = 'Pap/Pelvic Max Enr Type        '
  pbp_b14d_maxenr_amt              = 'Pap/Pelvic Max Enr Amt         '
  pbp_b14d_maxenr_per              = 'Pap/Pelvic Max Enr Per         '
  pbp_b14d_coins_yn                = 'Pap/Pelvic Coinsurance YN      '
  pbp_b14d_coins_pct_mcpap         = 'Pap Smears MC Coins Pct        '
  pbp_b14d_coins_cov_mcpap         = 'Pap Smears MC Coins Cov        '
  pbp_b14d_coins_pct_pap           = 'Add Pap Smears Coins Pct       '
  pbp_b14d_coins_cov_pap           = 'Add Pap Smears Coins Cov       '
  pbp_b14d_coins_pct_mcpe          = 'Pelvic Exams MC Coins Pct      '
  pbp_b14d_coins_cov_mcpe          = 'Pelvic Exams MC Coins Cov      '
  pbp_b14d_coins_pct_pe            = 'Add Pelvic Exams Coins Pct     '
  pbp_b14d_coins_cov_pe            = 'Add Pelvic Exams Coins Cov     '
  pbp_b14d_ded_yn                  = 'Pap/Pelvic Deductible YN       '
  pbp_b14d_ded_amt                 = 'Pap/Pelvic Deductible Amt      '
  pbp_b14d_copay_yn                = 'Pap/Pelvic Copayment YN        '
  pbp_b14d_copay_amt_mcpap         = 'Pap Smears MC Copay Amt        '
  pbp_b14d_copay_amt_mcpe          = 'Pelvic Exams MC Copay Amt      '
  pbp_b14d_copay_amt_pap           = 'Add Pap Smears Copay Amt       '
  pbp_b14d_copay_amt_pe            = 'Add Pelvic Exams Copay Amt     '
  pbp_b14d_cost_share              = 'Pap/Pelvic Cost Share          '
  pbp_b14d_auth                    = 'Pap/Pelvic Auth                '
  pbp_b14d_refer_yn                = 'Pap/Pelvic Referral YN         '
;
run;

proc sort data = pbp_b14ad out = out.pbp_b14ad;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b14ad(obs = 20);
  title 'pbp b14ad data';
run;

proc means data =  out.pbp_b14ad;
  title 'pbp b14ad file';
run;

proc freq data = out.pbp_b14ad;
  table
  orgtype
  pbp_b14a_bendesc_yn
  pbp_b14a_bendesc_amo_hec
  pbp_b14a_bendesc_amo_nl
  pbp_b14a_bendesc_amo_ntv
  pbp_b14a_bendesc_amo_sc
  pbp_b14a_bendesc_amo_chp
  pbp_b14a_bendesc_amo_amp
  pbp_b14a_bendesc_amo_mhc
  pbp_b14a_bendesc_amo_nhl
  pbp_b14a_bendesc_amo_dsm
  pbp_b14a_bendesc_amo_oth
  pbp_b14a_maxplan_yn
  pbp_b14a_maxplan_per
  pbp_b14a_maxplan_covb
  pbp_b14a_maxenr_yn
  pbp_b14a_bendesc_ehc
  pbp_b14b_bendesc
  pbp_b14b_cost_share
  pbp_b14c_bendesc_enhan
  pbp_b14c_cost_share
  pbp_b14d_bendesc_enhan
  pbp_b14d_cost_share
  pbp_b14a_maxenr_per
  pbp_b14a_coins_yn
  pbp_b14a_coins_cov_hec
  pbp_b14a_coins_cov_nl
  pbp_b14a_coins_cov_ntv
  pbp_b14a_coins_cov_sc
  pbp_b14a_coins_cov_chp
  pbp_b14a_coins_cov_amp
  pbp_b14a_coins_cov_mhc
  pbp_b14a_coins_cov_nhl
  pbp_b14a_coins_cov_dsm
  pbp_b14a_coins_cov_oth
  pbp_b14a_ded_yn
  pbp_b14a_copay_yn
  pbp_b14a_auth
  pbp_b14a_refer_yn
  pbp_b14b_bendesc_yn
  pbp_b14b_bendesc_amo
  pbp_b14b_maxenr_yn
  pbp_b14b_maxenr_type
  pbp_b14b_maxenr_per
  pbp_b14b_coins_yn
  pbp_b14b_coins_cov_mc
  pbp_b14b_coins_cov_oi
  pbp_b14b_ded_yn
  pbp_b14b_copay_yn
  pbp_b14b_auth
  pbp_b14b_refer_yn
  pbp_b14c_bendesc_yn
  pbp_b14c_bendesc_amo
  pbp_b14c_bendesc_lim
  pbp_b14c_bendesc_per
  pbp_b14c_maxplan_yn
  pbp_b14c_maxplan_type
  pbp_b14c_maxplan_per
  pbp_b14c_maxplan_cov
  pbp_b14c_maxenr_yn
  pbp_b14c_maxenr_type
  pbp_b14c_maxenr_per
  pbp_b14c_coins_yn
  pbp_b14c_coins_cov
  pbp_b14c_ded_yn
  pbp_b14c_copay_yn
  pbp_b14c_auth
  pbp_b14c_refer_yn
  pbp_b14d_bendesc_yn
  pbp_b14d_bendesc_amo_ps
  pbp_b14d_bendesc_lim_aps_yn
  pbp_b14d_bendesc_ps_per
  pbp_b14d_bendesc_amo_pe
  pbp_b14d_bendesc_lim_ape_yn
  pbp_b14d_bendesc_pe_per
  pbp_b14d_maxplan_yn
  pbp_b14d_maxplan_type
  pbp_b14d_maxplan_per
  pbp_b14d_maxplan_cov
  pbp_b14d_maxenr_yn
  pbp_b14d_maxenr_type
  pbp_b14d_maxenr_per
  pbp_b14d_coins_yn
  pbp_b14d_coins_cov_mcpap
  pbp_b14d_coins_cov_pap
  pbp_b14d_coins_cov_mcpe
  pbp_b14d_coins_cov_pe
  pbp_b14d_ded_yn
  pbp_b14d_copay_yn
  pbp_b14d_auth
  pbp_b14d_refer_yn / missing;
run;

proc contents data = out.pbp_b14ad;
  title 'pbp b14ad data';
run;
