* pbp_b15.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b15;
  length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_b15_ded_cdt                  $5
  pbp_b15_fb_place                 $4
  pbp_b15_fg_place                 $4
  pbp_b15_fpb_place                $4
  pbp_b15_maxenr_cdt               $5
  pbp_b15_maxplan_fb_less_copay    $1
  pbp_b15_maxplan_fg_less_copay    $1
  pbp_b15_maxplan_fpb_less_copay   $1
  pbp_b15_maxplan_less_copay       $1
  pbp_b15_maxplan_nfb_less_copay   $1
  pbp_b15_maxplan_nfg_less_copay   $1
  pbp_b15_nfb_place                $4
  pbp_b15_nfg_place                $4
  pbp_b15_bendesc_yn               $1
  pbp_b15_bendesc_amo              $1
  pbp_b15_bendesc_ehc_yn           $1
  pbp_b15_bendesc_for              $3
  pbp_b15_bendesc_nfor             $2
  pbp_b15_bendesc_nfor_yn          $1
  pbp_b15_bendesc_nfor_med_yn      $1
  pbp_b15_maxplan_cdt              $5
  pbp_b15_maxplan_yn               $1
  pbp_b15_maxplan_types            $3
  pbp_b15_maxplan_per_cdt1         $5
  pbp_b15_maxplan_unused_yn        $1
  pbp_b15_maxplan_per_cdt          $5
  pbp_b15_maxplan_cov_cdt          $2
  pbp_b15_maxplan_fg_unlm          $1
  pbp_b15_maxenr_yn                $1
  pbp_b15_coins_yn                 $1
  pbp_b15_coins_cov_mc             $2
  pbp_b15_ded_yn                   $1
  pbp_b15_copay_mc_yn              $1
  pbp_b15_auth                     $5
  pbp_b15_auth_nonform             $5
  pbp_b15_maxplan_fg_yn            $1
  pbp_b15_maxplan_per_fg           $5
  pbp_b15_maxplan_cov_fg           $2
  pbp_b15_coins_fg_yn              $1
  pbp_b15_coins_cov_fg             $2
  pbp_b15_copay_fg_yn              $1
  pbp_b15_maxplan_fpb_yn           $1
  pbp_b15_maxplan_per_pb           $5
  pbp_b15_maxplan_cov_fpb          $2
  pbp_b15_coins_fpb_yn             $1
  pbp_b15_coins_cov_fpb            $2
  pbp_b15_copay_fpb_yn             $1
  pbp_b15_maxplan_fb_yn            $1
  pbp_b15_maxplan_per_fb           $5
  pbp_b15_maxplan_cov_fb           $2
  pbp_b15_coins_fb_yn              $1
  pbp_b15_coins_cov_fb             $2
  pbp_b15_copay_fb_yn              $1
  pbp_b15_copay_add_fb_yn          $1
  pbp_b15_maxplan_nfg_yn           $1
  pbp_b15_maxplan_per_nfg          $5
  pbp_b15_maxplan_cov_nfg          $2
  pbp_b15_coins_yn_nfg             $1
  pbp_b15_coins_cov_nfg            $2
  pbp_b15_copay_nfg_yn             $1
  pbp_b15_maxplan_nfb_yn           $1
  pbp_b15_maxplan_per_nfb          $5
  pbp_b15_maxplan_cov_nfb          $2
  pbp_b15_coins_yn_nfb             $1
  pbp_b15_coins_cov_nfb            $2
  pbp_b15_copay_nfb_yn             $1
  pbp_b15_copay_add_nfb_yn         $1
;

  infile '.\pbp\pbp_b15_drugs.txt'
         delimiter = '09'x dsd lrecl = 10000 firstobs = 2 missover;
input
  pbp_a_hnumber
  pbp_a_plan_identifier
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b15_bendesc_yn
  pbp_b15_bendesc_amo
  pbp_b15_bendesc_ehc_yn
  pbp_b15_bendesc_for
  pbp_b15_bendesc_nfor_yn
  pbp_b15_bendesc_nfor
  pbp_b15_bendesc_nfor_med_yn
  pbp_b15_maxplan_yn
  pbp_b15_maxplan_types
  pbp_b15_maxplan_per_cdt1
  pbp_b15_maxplan_amt_cdt_1yr1
  pbp_b15_maxplan_amt_cdt_6mth1
  pbp_b15_maxplan_amt_cdt_3mth1
  pbp_b15_maxplan_amt_cdt_1mth1
  pbp_b15_maxplan_amt_cdt_oth1
  pbp_b15_maxplan_unused_yn
  pbp_b15_maxplan_cdt
  pbp_b15_maxplan_per_cdt
  pbp_b15_maxplan_amt_cdt_1yr
  pbp_b15_maxplan_amt_cdt_6mth
  pbp_b15_maxplan_amt_cdt_3mth
  pbp_b15_maxplan_amt_cdt_1mth
  pbp_b15_maxplan_amt_cdt_oth
  pbp_b15_maxplan_less_copay
  pbp_b15_maxplan_cov_cdt
  pbp_b15_maxplan_prp_cdt_pct
  pbp_b15_maxplan_awpf_cdt_amt
  pbp_b15_maxpln_awpf_cdt_amt_mx
  pbp_b15_maxplan_awpd_cdt_pct
  pbp_b15_maxplan_mcoacp_cdt_amt
  pbp_b15_maxplan_fg_unlm
  pbp_b15_maxenr_yn
  pbp_b15_maxenr_cdt
  pbp_b15_maxenr_amt
  pbp_b15_coins_yn
  pbp_b15_coins_pct_mc
  pbp_b15_coins_cov_mc
  pbp_b15_coins_prp_mc_pct
  pbp_b15_coins_awpf_mc_amt
  pbp_b15_coins_awpf_mc_amt_max
  pbp_b15_coins_awpd_mc_pct
  pbp_b15_coins_mcoacp_mc_amt
  pbp_b15_ded_yn
  pbp_b15_ded_cdt
  pbp_b15_ded_amt
  pbp_b15_copay_mc_yn
  pbp_b15_copay_min_mcb_amt
  pbp_b15_copay_max_mcb_amt
  pbp_b15_auth
  pbp_b15_auth_nonform
  pbp_b15_maxplan_fg_yn
  pbp_b15_maxplan_per_fg
  pbp_b15_maxplan_amt_fg_1yr
  pbp_b15_maxplan_amt_fg_6mth
  pbp_b15_maxplan_amt_fg_3mth
  pbp_b15_maxplan_amt_fg_1mth
  pbp_b15_maxplan_amt_fg_oth
  pbp_b15_maxplan_fg_less_copay
  pbp_b15_maxplan_cov_fg
  pbp_b15_maxplan_prp_fg_pct
  pbp_b15_maxplan_awpf_fg_amt
  pbp_b15_maxpln_awpf_fg_amt_mx
  pbp_b15_maxplan_awpd_fg_pct
  pbp_b15_maxplan_mcoacp_fg_amt
  pbp_b15_fg_place
  pbp_b15_coins_fg_yn
  pbp_b15_coins_pct_fg_drp
  pbp_b15_coins_pct_fg_hmo
  pbp_b15_coins_pct_fg_mo
  pbp_b15_coins_pct_fg_oth
  pbp_b15_coins_cov_fg
  pbp_b15_coins_prp_fg_pct
  pbp_b15_coins_awpf_fg_amt
  pbp_b15_coins_awpf_fg_amt_max
  pbp_b15_coins_awpd_fg_pct
  pbp_b15_coins_mcoacp_fg_amt
  pbp_b15_copay_fg_yn
  pbp_b15_copay_fg_drp_amt
  pbp_b15_copay_fg_hmo_amt
  pbp_b15_copay_fg_mo_amt
  pbp_b15_copay_fg_oth_amt
  pbp_b15_fg_drp_days
  pbp_b15_fg_hmo_days
  pbp_b15_fg_mo_days
  pbp_b15_fg_oth_days
  pbp_b15_maxplan_fpb_yn
  pbp_b15_maxplan_per_pb
  pbp_b15_maxplan_amt_fpb_1yr
  pbp_b15_maxplan_amt_fpb_6mth
  pbp_b15_maxplan_amt_fpb_3mth
  pbp_b15_maxplan_amt_fpb_1mth
  pbp_b15_maxplan_amt_fpb_oth
  pbp_b15_maxplan_fpb_less_copay
  pbp_b15_maxplan_cov_fpb
  pbp_b15_maxplan_prp_fpb_pct
  pbp_b15_maxplan_awpf_fpb_amt
  pbp_b15_maxpln_awpf_fpb_amt_mx
  pbp_b15_maxplan_awpd_fpb_pct
  pbp_b15_maxplan_mcoacp_fpb_amt
  pbp_b15_fpb_place
  pbp_b15_coins_fpb_yn
  pbp_b15_coins_pct_fpb_drp
  pbp_b15_coins_pct_fpb_hmo
  pbp_b15_coins_pct_fpb_mo
  pbp_b15_coins_pct_fpb_oth
  pbp_b15_coins_cov_fpb
  pbp_b15_coins_prp_fpb_pct
  pbp_b15_coins_awpf_fpb_amt
  pbp_b15_coins_awpf_fpb_amt_max
  pbp_b15_coins_awpd_fpb_pct
  pbp_b15_coins_mcoacp_fpb_amt
  pbp_b15_copay_fpb_yn
  pbp_b15_copay_fpb_drp_amt
  pbp_b15_copay_fpb_hmo_amt
  pbp_b15_copay_fpb_mo_amt
  pbp_b15_copay_fpb_oth_amt
  pbp_b15_fpb_drp_days
  pbp_b15_fpb_hmo_days
  pbp_b15_fpb_mo_days
  pbp_b15_fpb_oth_days
  pbp_b15_maxplan_fb_yn
  pbp_b15_maxplan_per_fb
  pbp_b15_maxplan_amt_fb_1yr
  pbp_b15_maxplan_amt_fb_6mth
  pbp_b15_maxplan_amt_fb_3mth
  pbp_b15_maxplan_amt_fb_1mth
  pbp_b15_maxplan_amt_fb_oth
  pbp_b15_maxplan_fb_less_copay
  pbp_b15_maxplan_cov_fb
  pbp_b15_maxplan_prp_fb_pct
  pbp_b15_maxplan_awpf_fb_amt
  pbp_b15_maxpln_awpf_fb_amt_mx
  pbp_b15_maxplan_awpd_fb_pct
  pbp_b15_maxplan_mcoacp_fb_amt
  pbp_b15_fb_place
  pbp_b15_coins_fb_yn
  pbp_b15_coins_pct_fb_drp
  pbp_b15_coins_pct_fb_hmo
  pbp_b15_coins_pct_fb_mo
  pbp_b15_coins_pct_fb_oth
  pbp_b15_coins_cov_fb
  pbp_b15_coins_prp_fb_pct
  pbp_b15_coins_awpf_fb_amt
  pbp_b15_coins_awpf_fb_amt_max
  pbp_b15_coins_awpd_fb_pct
  pbp_b15_coins_mcoacp_fb_amt
  pbp_b15_copay_fb_yn
  pbp_b15_copay_fb_drp_amt
  pbp_b15_copay_fb_hmo_amt
  pbp_b15_copay_fb_mo_amt
  pbp_b15_copay_fb_oth_amt
  pbp_b15_fb_drp_days
  pbp_b15_fb_hmo_days
  pbp_b15_fb_mo_days
  pbp_b15_fb_oth_days
  pbp_b15_copay_add_fb_yn
  pbp_b15_maxplan_nfg_yn
  pbp_b15_maxplan_per_nfg
  pbp_b15_maxplan_amt_nfg_1yr
  pbp_b15_maxplan_amt_nfg_6mth
  pbp_b15_maxplan_amt_nfg_3mth
  pbp_b15_maxplan_amt_nfg_1mth
  pbp_b15_maxplan_amt_nfg_oth
  pbp_b15_maxplan_nfg_less_copay
  pbp_b15_maxplan_cov_nfg
  pbp_b15_maxplan_prp_nfg_pct
  pbp_b15_maxplan_awpf_nfg_amt
  pbp_b15_maxpln_awpf_nfg_amt_mx
  pbp_b15_maxplan_awpd_nfg_pct
  pbp_b15_maxplan_mcoacp_nfg_amt
  pbp_b15_nfg_place
  pbp_b15_coins_yn_nfg
  pbp_b15_coins_pct_nfg_drp
  pbp_b15_coins_pct_nfg_hmo
  pbp_b15_coins_pct_nfg_mo
  pbp_b15_coins_pct_nfg_oth
  pbp_b15_coins_cov_nfg
  pbp_b15_coins_prp_nfg_pct
  pbp_b15_coins_awpf_nfg_amt
  pbp_b15_coins_awpf_nfg_amt_max
  pbp_b15_coins_awpd_nfg_pct
  pbp_b15_coins_mcoacp_nfg_amt
  pbp_b15_copay_nfg_yn
  pbp_b15_copay_nfg_drp_amt
  pbp_b15_copay_nfg_hmo_amt
  pbp_b15_copay_nfg_mo_amt
  pbp_b15_copay_nfg_oth_amt
  pbp_b15_nfg_drp_days
  pbp_b15_nfg_hmo_days
  pbp_b15_nfg_mo_days
  pbp_b15_nfg_oth_days
  pbp_b15_maxplan_nfb_yn
  pbp_b15_maxplan_per_nfb
  pbp_b15_maxplan_amt_nfb_1yr
  pbp_b15_maxplan_amt_nfb_6mth
  pbp_b15_maxplan_amt_nfb_3mth
  pbp_b15_maxplan_amt_nfb_1mth
  pbp_b15_maxplan_amt_nfb_oth
  pbp_b15_maxplan_nfb_less_copay
  pbp_b15_maxplan_cov_nfb
  pbp_b15_maxplan_prp_nfb_pct
  pbp_b15_maxplan_awpf_nfb_amt
  pbp_b15_maxpln_awpf_nfb_amt_mx
  pbp_b15_maxplan_awpd_nfb_pct
  pbp_b15_maxplan_mcoacp_nfb_amt
  pbp_b15_nfb_place
  pbp_b15_coins_yn_nfb
  pbp_b15_coins_pct_nfb_drp
  pbp_b15_coins_pct_nfb_hmo
  pbp_b15_coins_pct_nfb_mo
  pbp_b15_coins_pct_nfb_oth
  pbp_b15_coins_cov_nfb
  pbp_b15_coins_prp_nfb_pct
  pbp_b15_coins_awpf_nfb_amt
  pbp_b15_coins_awpf_nfb_amt_max
  pbp_b15_coins_awpd_nfb_pct
  pbp_b15_coins_mcoacp_nfb_amt
  pbp_b15_copay_nfb_yn
  pbp_b15_copay_nfb_drp_amt
  pbp_b15_copay_nfb_hmo_amt
  pbp_b15_copay_nfb_mo_amt
  pbp_b15_copay_nfb_oth_amt
  pbp_b15_nfb_drp_days
  pbp_b15_nfb_hmo_days
  pbp_b15_nfb_mo_days
  pbp_b15_nfb_oth_days
  pbp_b15_copay_add_nfb_yn
;

  label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_b15_bendesc_yn               = 'Outpt Drg Ben Desc YN          '
  pbp_b15_bendesc_amo              = 'Outpt Drg Ben Desc AMO         '
  pbp_b15_bendesc_ehc_yn           = 'Outpt Drg Ben Desc F YN        '
  pbp_b15_bendesc_for              = 'Outpt Drg Ben Desc F Enhance   '
  pbp_b15_bendesc_nfor_yn          = 'Outpt Drg Ben Desc NF YN       '
  pbp_b15_bendesc_nfor             = 'Outpt Drg Ben Desc NF Enhance  '
  pbp_b15_bendesc_nfor_med_yn      = 'Outpt Drg Ben Desc NF Med YN   '
  pbp_b15_maxplan_yn               = 'Outpt Drg Max Plan 1 YN        '
  pbp_b15_maxplan_types            = 'B15 Max Plan Types             '
  pbp_b15_maxplan_per_cdt1         = 'Outpt Drg CDT Max Plan Per     '
  pbp_b15_maxplan_amt_cdt_1yr1     = 'Outpt Drg A CDT Max Plan Amt   '
  pbp_b15_maxplan_amt_cdt_6mth1    = 'Outpt Drg S CDT Max Plan Amt   '
  pbp_b15_maxplan_amt_cdt_3mth1    = 'Outpt Drg Q CDT Max Plan Amt   '
  pbp_b15_maxplan_amt_cdt_1mth1    = 'Outpt Drg M CDT Max Plan Amt   '
  pbp_b15_maxplan_amt_cdt_oth1     = 'Outpt Drg O CDT Max Plan Amt   '
  pbp_b15_maxplan_unused_yn        = 'Outpt Drg Max Plan Unused YN   '
  pbp_b15_maxplan_cdt              = 'Outpt Drg CDT Max Plan         '
  pbp_b15_maxplan_per_cdt          = 'Outpt Drg CDT Max Plan Per     '
  pbp_b15_maxplan_amt_cdt_1yr      = 'Outpt Drg A CDT Max Plan Amt   '
  pbp_b15_maxplan_amt_cdt_6mth     = 'Outpt Drg S CDT Max Plan Amt   '
  pbp_b15_maxplan_amt_cdt_3mth     = 'Outpt Drg Q CDT Max Plan Amt   '
  pbp_b15_maxplan_amt_cdt_1mth     = 'Outpt Drg M CDT Max Plan Amt   '
  pbp_b15_maxplan_amt_cdt_oth      = 'Outpt Drg O CDT Max Plan Amt   '
  pbp_b15_maxplan_less_copay       = 'Outpt Drg Max Plan Less Copay  '
  pbp_b15_maxplan_cov_cdt          = 'Outpt Drg CDT Max Plan Cov     '
  pbp_b15_maxplan_prp_cdt_pct      = 'Outpt Drg PRP Max Plan CDT Pct '
  pbp_b15_maxplan_awpf_cdt_amt     = 'Outpt Drg AWPF Max Plan CDTMIN '
  pbp_b15_maxpln_awpf_cdt_amt_mx   = 'Outpt Drg AWPF Max Plan CDTMAX '
  pbp_b15_maxplan_awpd_cdt_pct     = 'Outpt Drg AWPD Max Pln CDT Pct '
  pbp_b15_maxplan_mcoacp_cdt_amt   = 'Outpt Drg OACP Max Pln CDT Amt '
  pbp_b15_maxplan_fg_unlm          = 'Outpt Drg Max Plan Gen Lim YN  '
  pbp_b15_maxenr_yn                = 'Outpt Drg Max Enr YN           '
  pbp_b15_maxenr_cdt               = 'Outpt Drg Max Enr CDT          '
  pbp_b15_maxenr_amt               = 'Outpt Drg Max Enr Amt          '
  pbp_b15_coins_yn                 = 'Outpt Drg Coinsurance YN       '
  pbp_b15_coins_pct_mc             = 'Outpt Drg MC Coins Pct         '
  pbp_b15_coins_cov_mc             = 'Outpt Drg MC Coins Cov         '
  pbp_b15_coins_prp_mc_pct         = 'Outpt Drg PRP Coins MC Pct     '
  pbp_b15_coins_awpf_mc_amt        = 'Outpt Drg AWPF Min Coins MC    '
  pbp_b15_coins_awpf_mc_amt_max    = 'Outpt Drg AWPF Max Coins MC    '
  pbp_b15_coins_awpd_mc_pct        = 'Outpt Drg AWPD Coins MC Pct    '
  pbp_b15_coins_mcoacp_mc_amt      = 'Outpt Drg OACP Coins MC Amt    '
  pbp_b15_ded_yn                   = 'Outpt Drg Deductible YN        '
  pbp_b15_ded_cdt                  = 'Outpt Drg Deductible CDT       '
  pbp_b15_ded_amt                  = 'Outpt Drg Deductible Amt       '
  pbp_b15_copay_mc_yn              = 'Outpt Drg Copayment MC YN      '
  pbp_b15_copay_min_mcb_amt        = 'Outpt Drg Copay Min MCB Amt    '
  pbp_b15_copay_max_mcb_amt        = 'Outpt Drg Copay Max MCB Amt    '
  pbp_b15_auth                     = 'Outpt Drg F Auth               '
  pbp_b15_auth_nonform             = 'Outpt Drg NF Auth              '
  pbp_b15_maxplan_fg_yn            = 'Outpt Drg FG Max Plan YN       '
  pbp_b15_maxplan_per_fg           = 'Outpt Drg FG Max Plan Per      '
  pbp_b15_maxplan_amt_fg_1yr       = 'Outpt Drg FG A Max Plan Amt    '
  pbp_b15_maxplan_amt_fg_6mth      = 'Outpt Drg FG S Max Plan Amt    '
  pbp_b15_maxplan_amt_fg_3mth      = 'Outpt Drg FG Q Max Plan Amt    '
  pbp_b15_maxplan_amt_fg_1mth      = 'Outpt Drg FG M Max Plan Amt    '
  pbp_b15_maxplan_amt_fg_oth       = 'Outpt Drg FG O Max Plan Amt    '
  pbp_b15_maxplan_fg_less_copay    = 'Outpt Drg FG Max Plan L-Copay  '
  pbp_b15_maxplan_cov_fg           = 'Outpt Drg FG Max Plan Cov      '
  pbp_b15_maxplan_prp_fg_pct       = 'Outpt Drg FG PRP Max Plan Pct  '
  pbp_b15_maxplan_awpf_fg_amt      = 'Outpt Drg FG AWPF Max Plan Min '
  pbp_b15_maxpln_awpf_fg_amt_mx    = 'Outpt Drg FG AWPF Max Plan Max '
  pbp_b15_maxplan_awpd_fg_pct      = 'Outpt Drg FG AWPD Max Plan Pct '
  pbp_b15_maxplan_mcoacp_fg_amt    = 'Outpt Drg FG OACP Max Plan Amt '
  pbp_b15_fg_place                 = 'Outpt Drg FG Place             '
  pbp_b15_coins_fg_yn              = 'Outpt Drg FG Coinsurance YN    '
  pbp_b15_coins_pct_fg_drp         = 'Outpt Drg FG DRP Coins Pct     '
  pbp_b15_coins_pct_fg_hmo         = 'Outpt Drg FG HMO Coins Pct     '
  pbp_b15_coins_pct_fg_mo          = 'Outpt Drg FG MO Coins Pct      '
  pbp_b15_coins_pct_fg_oth         = 'Outpt Drg FG Other Coins Pct   '
  pbp_b15_coins_cov_fg             = 'Outpt Drg FG Coins Cov         '
  pbp_b15_coins_prp_fg_pct         = 'Outpt Drg FG PRP Coins DPct    '
  pbp_b15_coins_awpf_fg_amt        = 'Outpt Drg FG AWPF Min Coin Amt '
  pbp_b15_coins_awpf_fg_amt_max    = 'Outpt Drg FG AWPF Max Coin Amt '
  pbp_b15_coins_awpd_fg_pct        = 'Outpt Drg FG AWPD Coins DPct   '
  pbp_b15_coins_mcoacp_fg_amt      = 'Outpt Drg FG OACP Coins Amt    '
  pbp_b15_copay_fg_yn              = 'Outpt Drg FG Copayment YN      '
  pbp_b15_copay_fg_drp_amt         = 'Outpt Drg FG DRP Copay Amt     '
  pbp_b15_copay_fg_hmo_amt         = 'Outpt Drg FG HMOCopay Amt      '
  pbp_b15_copay_fg_mo_amt          = 'Outpt Drg FG MO Copay Amt      '
  pbp_b15_copay_fg_oth_amt         = 'Outpt Drg FG Other Copay Amt   '
  pbp_b15_fg_drp_days              = 'Outpt Drg FG DRP # Days        '
  pbp_b15_fg_hmo_days              = 'Outpt Drg FG HMO # Days        '
  pbp_b15_fg_mo_days               = 'Outpt Drg FG MO # Days         '
  pbp_b15_fg_oth_days              = 'Outpt Drg FG Other # Days      '
  pbp_b15_maxplan_fpb_yn           = 'Outpt Drg FPB Max Plan YN      '
  pbp_b15_maxplan_per_pb           = 'Outpt Drg FPB Max Plan Per     '
  pbp_b15_maxplan_amt_fpb_1yr      = 'Outpt Drg FPB A Max Plan Amt   '
  pbp_b15_maxplan_amt_fpb_6mth     = 'Outpt Drg FPB S Max Plan Amt   '
  pbp_b15_maxplan_amt_fpb_3mth     = 'Outpt Drg FPB Q Max Plan Amt   '
  pbp_b15_maxplan_amt_fpb_1mth     = 'Outpt Drg FPB M Max Plan Amt   '
  pbp_b15_maxplan_amt_fpb_oth      = 'Outpt Drg FPB O Max Plan Amt   '
  pbp_b15_maxplan_fpb_less_copay   = 'Outpt Drg FPB Max Plan L-Copay '
  pbp_b15_maxplan_cov_fpb          = 'Outpt Drg FPB Max Plan Cov     '
  pbp_b15_maxplan_prp_fpb_pct      = 'Outpt Drg FPB PRP Max Plan Pct '
  pbp_b15_maxplan_awpf_fpb_amt     = 'Outpt Drg FPB AWPF Max Pln Min '
  pbp_b15_maxpln_awpf_fpb_amt_mx   = 'Outpt Drg FPB AWPF Max Pln Max '
  pbp_b15_maxplan_awpd_fpb_pct     = 'Outpt Drg FPB AWPD Max Pln Pct '
  pbp_b15_maxplan_mcoacp_fpb_amt   = 'Outpt Drg FPB OACP Max Pln Amt '
  pbp_b15_fpb_place                = 'Outpt Drg FPB Place            '
  pbp_b15_coins_fpb_yn             = 'Outpt Drg FPB Coinsurance YN   '
  pbp_b15_coins_pct_fpb_drp        = 'Outpt Drg FPB DRP Coins Pct    '
  pbp_b15_coins_pct_fpb_hmo        = 'Outpt Drg FPB HMO Coins Pct    '
  pbp_b15_coins_pct_fpb_mo         = 'Outpt Drg FPB MO Coins Pct     '
  pbp_b15_coins_pct_fpb_oth        = 'Outpt Drg FPB Other Coins Pct  '
  pbp_b15_coins_cov_fpb            = 'Outpt Drg FPB Coins Cov        '
  pbp_b15_coins_prp_fpb_pct        = 'Outpt Drg FPB PRP Coins Pct    '
  pbp_b15_coins_awpf_fpb_amt       = 'Outpt Drg FPB AWPF Min Coins   '
  pbp_b15_coins_awpf_fpb_amt_max   = 'Outpt Drg FPB AWPF Max Coins   '
  pbp_b15_coins_awpd_fpb_pct       = 'Outpt Drg FPB AWPD Coins Pct   '
  pbp_b15_coins_mcoacp_fpb_amt     = 'Outpt Drg FPB OACP Coins Amt   '
  pbp_b15_copay_fpb_yn             = 'Outpt Drg FPB Copayment YN     '
  pbp_b15_copay_fpb_drp_amt        = 'Outpt Drg FPB DRP Copay Amt    '
  pbp_b15_copay_fpb_hmo_amt        = 'Outpt Drg FPB HMO Copay Amt    '
  pbp_b15_copay_fpb_mo_amt         = 'Outpt Drg FPB MO Copay Amt     '
  pbp_b15_copay_fpb_oth_amt        = 'Outpt Drg FPB Other Copay Amt  '
  pbp_b15_fpb_drp_days             = 'Outpt Drg FPB DRP # Days       '
  pbp_b15_fpb_hmo_days             = 'Outpt Drg FPB HMO # Days       '
  pbp_b15_fpb_mo_days              = 'Outpt Drg FPB MO # Days        '
  pbp_b15_fpb_oth_days             = 'Outpt Drg FPB Other # Days     '
  pbp_b15_maxplan_fb_yn            = 'Outpt Drg FB Max Plan YN       '
  pbp_b15_maxplan_per_fb           = 'Outpt Drg FB Max Plan Per      '
  pbp_b15_maxplan_amt_fb_1yr       = 'Outpt Drg FB A Max Plan Amt    '
  pbp_b15_maxplan_amt_fb_6mth      = 'Outpt Drg FB S Max Plan Amt    '
  pbp_b15_maxplan_amt_fb_3mth      = 'Outpt Drg FB Q Max Plan Amt    '
  pbp_b15_maxplan_amt_fb_1mth      = 'Outpt Drg FB M Max Plan Amt    '
  pbp_b15_maxplan_amt_fb_oth       = 'Outpt Drg FB O Max Plan Amt    '
  pbp_b15_maxplan_fb_less_copay    = 'Outpt Drg FB Max Plan L-Copay  '
  pbp_b15_maxplan_cov_fb           = 'Outpt Drg FB Max Plan Cov      '
  pbp_b15_maxplan_prp_fb_pct       = 'Outpt Drg FB PRP Max Plan Pct  '
  pbp_b15_maxplan_awpf_fb_amt      = 'Outpt Drg FB AWPF Max Plan Min '
  pbp_b15_maxpln_awpf_fb_amt_mx    = 'Outpt Drg FB AWPF Max Plan Max '
  pbp_b15_maxplan_awpd_fb_pct      = 'Outpt Drg FB AWPD Max Plan Pct '
  pbp_b15_maxplan_mcoacp_fb_amt    = 'Outpt Drg FB OACP Max Plan Amt '
  pbp_b15_fb_place                 = 'Outpt Drg FB Place             '
  pbp_b15_coins_fb_yn              = 'Outpt Drg FB Coinsurance YN    '
  pbp_b15_coins_pct_fb_drp         = 'Outpt Drg FB DRP Coins Pct     '
  pbp_b15_coins_pct_fb_hmo         = 'Outpt Drg FB HMO Coins Pct     '
  pbp_b15_coins_pct_fb_mo          = 'Outpt Drg FB MO Coins Pct      '
  pbp_b15_coins_pct_fb_oth         = 'Outpt Drg FB Other Coins Pct   '
  pbp_b15_coins_cov_fb             = 'Outpt Drg FB Coins Cov         '
  pbp_b15_coins_prp_fb_pct         = 'Outpt Drg FB PRP Coins Pct     '
  pbp_b15_coins_awpf_fb_amt        = 'Outpt Drg FB AWPF Min Coin Amt '
  pbp_b15_coins_awpf_fb_amt_max    = 'Outpt Drg FB AWPF Max Coin Amt '
  pbp_b15_coins_awpd_fb_pct        = 'Outpt Drg FB AWPD Coins Pct    '
  pbp_b15_coins_mcoacp_fb_amt      = 'Outpt Drg FB OACP Coins Amt    '
  pbp_b15_copay_fb_yn              = 'Outpt Drg FB Copayment YN      '
  pbp_b15_copay_fb_drp_amt         = 'Outpt Drg FB DRP Copay Amt     '
  pbp_b15_copay_fb_hmo_amt         = 'Outpt Drg FB HMO Copay Amt     '
  pbp_b15_copay_fb_mo_amt          = 'Outpt Drg FB MO Copay Amt      '
  pbp_b15_copay_fb_oth_amt         = 'Outpt Drg FB Other Copay Amt   '
  pbp_b15_fb_drp_days              = 'Outpt Drg FB DRP # Days        '
  pbp_b15_fb_hmo_days              = 'Outpt Drg FB HMO # Days        '
  pbp_b15_fb_mo_days               = 'Outpt Drg FB MO # Days         '
  pbp_b15_fb_oth_days              = 'Outpt Drg FB Other # Days      '
  pbp_b15_copay_add_fb_yn          = 'Outpt Drg FB Add Copay YN      '
  pbp_b15_maxplan_nfg_yn           = 'Outpt Drg NFG Max Plan YN      '
  pbp_b15_maxplan_per_nfg          = 'Outpt Drg NFG Max Plan Per     '
  pbp_b15_maxplan_amt_nfg_1yr      = 'Outpt Drg NFG A Max Plan Amt   '
  pbp_b15_maxplan_amt_nfg_6mth     = 'Outpt Drg NFG S Max Plan Amt   '
  pbp_b15_maxplan_amt_nfg_3mth     = 'Outpt Drg NFG Q Max Plan Amt   '
  pbp_b15_maxplan_amt_nfg_1mth     = 'Outpt Drg NFG M Max Plan Amt   '
  pbp_b15_maxplan_amt_nfg_oth      = 'Outpt Drg NFG O Max Plan Amt   '
  pbp_b15_maxplan_nfg_less_copay   = 'Outpt Drg NFG Max Plan L-Copay '
  pbp_b15_maxplan_cov_nfg          = 'Outpt Drg NFG Max Plan Cov     '
  pbp_b15_maxplan_prp_nfg_pct      = 'Outpt Drg NFG PRP Max Plan Pct '
  pbp_b15_maxplan_awpf_nfg_amt     = 'Outpt Drg NFG AWPF Max Pln Min '
  pbp_b15_maxpln_awpf_nfg_amt_mx   = 'Outpt Drg NFG AWPF Max Pln Max '
  pbp_b15_maxplan_awpd_nfg_pct     = 'Outpt Drg NFG AWPD Max Pln Pct '
  pbp_b15_maxplan_mcoacp_nfg_amt   = 'Outpt Drg NFG OACP Max Pln Amt '
  pbp_b15_nfg_place                = 'Outpt Drg NFG Place            '
  pbp_b15_coins_yn_nfg             = 'Outpt Drg NFG Coins YN         '
  pbp_b15_coins_pct_nfg_drp        = 'Outpt Drg NFG DRP Coins Pct    '
  pbp_b15_coins_pct_nfg_hmo        = 'Outpt Drg NFG HMO Coins Pct    '
  pbp_b15_coins_pct_nfg_mo         = 'Outpt Drg NFG MO Coins Pct     '
  pbp_b15_coins_pct_nfg_oth        = 'Outpt Drg NFG Other Coins Pct  '
  pbp_b15_coins_cov_nfg            = 'Outpt Drg NFG Coins Cov        '
  pbp_b15_coins_prp_nfg_pct        = 'Outpt Drg NFG PRP Coins Pct    '
  pbp_b15_coins_awpf_nfg_amt       = 'Outpt Drg NFG AWPF Min Coins   '
  pbp_b15_coins_awpf_nfg_amt_max   = 'Outpt Drg NFG AWPF Max Coins   '
  pbp_b15_coins_awpd_nfg_pct       = 'Outpt Drg NFG AWPD Coins Pct   '
  pbp_b15_coins_mcoacp_nfg_amt     = 'Outpt Drg NFG OACP Coins Amt   '
  pbp_b15_copay_nfg_yn             = 'Outpt Drg NFG Copayment YN     '
  pbp_b15_copay_nfg_drp_amt        = 'Outpt Drg NFG DRP Copay Amt    '
  pbp_b15_copay_nfg_hmo_amt        = 'Outpt Drg NFG HMO Copay Amt    '
  pbp_b15_copay_nfg_mo_amt         = 'Outpt Drg NFG MO Copay Amt     '
  pbp_b15_copay_nfg_oth_amt        = 'Outpt Drg NFG Other Copay Amt  '
  pbp_b15_nfg_drp_days             = 'Outpt Drg NFG DRP # Days       '
  pbp_b15_nfg_hmo_days             = 'Outpt Drg NFG HMO # Days       '
  pbp_b15_nfg_mo_days              = 'Outpt Drg NFG MO # Days        '
  pbp_b15_nfg_oth_days             = 'Outpt Drg NFG Other # Days     '
  pbp_b15_maxplan_nfb_yn           = 'Outpt Drg NFB Max Plan YN      '
  pbp_b15_maxplan_per_nfb          = 'Outpt Drg NFB Max Plan Per     '
  pbp_b15_maxplan_amt_nfb_1yr      = 'Outpt Drg NFB A Max Plan Amt   '
  pbp_b15_maxplan_amt_nfb_6mth     = 'Outpt Drg NFB S Max Plan Amt   '
  pbp_b15_maxplan_amt_nfb_3mth     = 'Outpt Drg NFB Q Max Plan Amt   '
  pbp_b15_maxplan_amt_nfb_1mth     = 'Outpt Drg NFB M Max Plan Amt   '
  pbp_b15_maxplan_amt_nfb_oth      = 'Outpt Drg NFB O Max Plan Amt   '
  pbp_b15_maxplan_nfb_less_copay   = 'Outpt Drg NFB Max Plan L-Copay '
  pbp_b15_maxplan_cov_nfb          = 'Outpt Drg NFB Max Plan Cov     '
  pbp_b15_maxplan_prp_nfb_pct      = 'Outpt Drg NFB PRP Max Plan Pct '
  pbp_b15_maxplan_awpf_nfb_amt     = 'Outpt Drg NFB AWPF Max Pln Min '
  pbp_b15_maxpln_awpf_nfb_amt_mx   = 'Outpt Drg NFB AWPF Max Pln Max '
  pbp_b15_maxplan_awpd_nfb_pct     = 'Outpt Drg NFB AWPD Max Pln Pct '
  pbp_b15_maxplan_mcoacp_nfb_amt   = 'Outpt Drg NFB OACP Max Pln Amt '
  pbp_b15_nfb_place                = 'Outpt Drg NFB Place            '
  pbp_b15_coins_yn_nfb             = 'Outpt Drg NFB Coins YN         '
  pbp_b15_coins_pct_nfb_drp        = 'Outpt Drg NFB DRP Coins Pct    '
  pbp_b15_coins_pct_nfb_hmo        = 'Outpt Drg NFB HMO Coins Pct    '
  pbp_b15_coins_pct_nfb_mo         = 'Outpt Drg NFB MO Coins Pct     '
  pbp_b15_coins_pct_nfb_oth        = 'Outpt Drg NFB Other Coins Pct  '
  pbp_b15_coins_cov_nfb            = 'Outpt Drg NFB Coins Cov        '
  pbp_b15_coins_prp_nfb_pct        = 'Outpt Drg NFB PRP Coins Pct    '
  pbp_b15_coins_awpf_nfb_amt       = 'Outpt Drg NFB AWPF Min Coins   '
  pbp_b15_coins_awpf_nfb_amt_max   = 'Outpt Drg NFB AWPF Max Coins   '
  pbp_b15_coins_awpd_nfb_pct       = 'Outpt Drg NFB AWPD Coins Pct   '
  pbp_b15_coins_mcoacp_nfb_amt     = 'Outpt Drg NFB OACP Coins Amt   '
  pbp_b15_copay_nfb_yn             = 'Outpt Drg NFB Copayment YN     '
  pbp_b15_copay_nfb_drp_amt        = 'Outpt Drg NFB DRP Copay Amt    '
  pbp_b15_copay_nfb_hmo_amt        = 'Outpt Drg NFB HMO Copay Amt    '
  pbp_b15_copay_nfb_mo_amt         = 'Outpt Drg NFB MO Copay Amt     '
  pbp_b15_copay_nfb_oth_amt        = 'Outpt Drg NFB Other Copay Amt  '
  pbp_b15_nfb_drp_days             = 'Outpt Drg NFB DRP # Days       '
  pbp_b15_nfb_hmo_days             = 'Outpt Drg NFB HMO # Days       '
  pbp_b15_nfb_mo_days              = 'Outpt Drg NFB MO # Days        '
  pbp_b15_nfb_oth_days             = 'Outpt Drg NFB Other # Days     '
  pbp_b15_copay_add_nfb_yn         = 'Outpt Drg NFB Add Copay YN     '
;
run;

proc sort data = pbp_b15 out = out.pbp_b15;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b15 (obs = 10);
  title 'pbp b15 data';
run;

proc means data =  out.pbp_b15;
  title 'pbp b15 file';
run;

proc freq data = out.pbp_b15;
  table
  orgtype
  pbp_b15_bendesc_yn
  pbp_b15_bendesc_amo
  pbp_b15_bendesc_ehc_yn
  pbp_b15_bendesc_nfor_yn
  pbp_b15_bendesc_nfor_med_yn
  pbp_b15_maxplan_yn
  pbp_b15_maxplan_types
  pbp_b15_maxplan_per_cdt1
  pbp_b15_maxplan_unused_yn
  pbp_b15_maxplan_per_cdt
  pbp_b15_maxplan_cov_cdt
  pbp_b15_maxplan_fg_unlm
  pbp_b15_maxenr_yn
  pbp_b15_coins_yn
  pbp_b15_coins_cov_mc
  pbp_b15_ded_cdt
  pbp_b15_fb_place
  pbp_b15_fg_place
  pbp_b15_fpb_place
  pbp_b15_maxenr_cdt
  pbp_b15_maxplan_fb_less_copay
  pbp_b15_maxplan_fg_less_copay
  pbp_b15_maxplan_fpb_less_copay
  pbp_b15_maxplan_less_copay
  pbp_b15_maxplan_nfb_less_copay
  pbp_b15_maxplan_nfg_less_copay
  pbp_b15_nfb_place
  pbp_b15_nfg_place
  pbp_b15_ded_yn
  pbp_b15_copay_mc_yn
  pbp_b15_auth
  pbp_b15_auth_nonform
  pbp_b15_maxplan_fg_yn
  pbp_b15_maxplan_per_fg
  pbp_b15_maxplan_cov_fg
  pbp_b15_coins_fg_yn
  pbp_b15_coins_cov_fg
  pbp_b15_copay_fg_yn
  pbp_b15_maxplan_fpb_yn
  pbp_b15_maxplan_per_pb
  pbp_b15_maxplan_cov_fpb
  pbp_b15_coins_fpb_yn
  pbp_b15_coins_cov_fpb
  pbp_b15_copay_fpb_yn
  pbp_b15_maxplan_fb_yn
  pbp_b15_maxplan_per_fb
  pbp_b15_maxplan_cov_fb
  pbp_b15_coins_fb_yn
  pbp_b15_coins_cov_fb
  pbp_b15_copay_fb_yn
  pbp_b15_copay_add_fb_yn
  pbp_b15_maxplan_nfg_yn
  pbp_b15_maxplan_per_nfg
  pbp_b15_maxplan_cov_nfg
  pbp_b15_coins_yn_nfg
  pbp_b15_coins_cov_nfg
  pbp_b15_copay_nfg_yn
  pbp_b15_maxplan_nfb_yn
  pbp_b15_maxplan_per_nfb
  pbp_b15_maxplan_cov_nfb
  pbp_b15_coins_yn_nfb
  pbp_b15_coins_cov_nfb
  pbp_b15_copay_nfb_yn
  pbp_b15_copay_add_nfb_yn / missing;
  run;

proc contents data = out.pbp_b15;
  title 'pbp b15 data';
run;
