* pbp_b19.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b19;
  length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_b19_bendesc_subcats          $44
  pbp_b19_coins_costs_apply        $1
  pbp_b19_coins_iha_intrvl_num     $1
  pbp_b19_coins_iph_intrvl_num     $1
  pbp_b19_copay_costs_apply        $1
  pbp_b19_copay_iha_intrvl_num     $1
  pbp_b19_copay_iph_intrvl_num     $1
  pbp_b19_bendesc_yn               $1
  pbp_b19_bendesc_amo              $1
  pbp_b19_maxplan_yn               $1
  pbp_b19_maxplan_per              $1
  pbp_b19_maxplan_cov              $1
  pbp_b19_maxenr_yn                $1
  pbp_b19_maxenr_per               $1
  pbp_b19_coins_yn                 $1
  pbp_b19_coins_cov                $1
  pbp_b19_coins_ihs_yn             $1
  pbp_b19_coins_ihs_ben_type       $2
  pbp_b19_coins_iha_cov            $1
  pbp_b19_coins_iph_cov            $1
  pbp_b19_ded_yn                   $1
  pbp_b19_copay_yn                 $1
  pbp_b19_copay_ihs_yn             $1
  pbp_b19_copay_ihs_ben_type       $2
  pbp_b19_auth_yn                  $1
  pbp_b19_auth_subcats             $44
  pbp_b19_auth                     $5
  pbp_b19_referral_yn              $1
  pbp_b19_referral_subcats         $44
  ;

infile '.\pbp\pbp_b19_pos.txt'
delimiter = '09'x dsd lrecl = 20000 firstobs = 2 missover;

input
  pbp_a_hnumber
  pbp_a_plan_identifier
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b19_bendesc_yn
  pbp_b19_bendesc_amo
  pbp_b19_bendesc_subcats
  pbp_b19_maxplan_yn
  pbp_b19_maxplan_amt
  pbp_b19_maxplan_per
  pbp_b19_maxplan_cov
  pbp_b19_maxenr_yn
  pbp_b19_maxenr_amt
  pbp_b19_maxenr_per
  pbp_b19_coins_yn
  pbp_b19_coins_costs_apply
  pbp_b19_coins_min_pct
  pbp_b19_coins_max_pct
  pbp_b19_coins_cov
  pbp_b19_coins_ihs_yn
  pbp_b19_coins_ihs_ben_type
  pbp_b19_coins_iha_pct
  pbp_b19_coins_iha_intrvl_num
  pbp_b19_coins_iha_pct_intrvl1
  pbp_b19_coins_iha_bgnd_intrvl1
  pbp_b19_coins_iha_endd_intrvl1
  pbp_b19_coins_iha_pct_intrvl2
  pbp_b19_coins_iha_bgnd_intrvl2
  pbp_b19_coins_iha_endd_intrvl2
  pbp_b19_coins_iha_pct_intrvl3
  pbp_b19_coins_iha_bgnd_intrvl3
  pbp_b19_coins_iha_endd_intrvl3
  pbp_b19_coins_iha_cov
  pbp_b19_coins_iph_pct
  pbp_b19_coins_iph_intrvl_num
  pbp_b19_coins_iph_pct_intrvl1
  pbp_b19_coins_iph_bgnd_intrvl1
  pbp_b19_coins_iph_endd_intrvl1
  pbp_b19_coins_iph_pct_intrvl2
  pbp_b19_coins_iph_bgnd_intrvl2
  pbp_b19_coins_iph_endd_intrvl2
  pbp_b19_coins_iph_pct_intrvl3
  pbp_b19_coins_iph_bgnd_intrvl3
  pbp_b19_coins_iph_endd_intrvl3
  pbp_b19_coins_iph_cov
  pbp_b19_ded_yn
  pbp_b19_ded_amt
  pbp_b19_copay_yn
  pbp_b19_copay_costs_apply
  pbp_b19_copay_min_amt
  pbp_b19_copay_max_amt
  pbp_b19_copay_ihs_yn
  pbp_b19_copay_ihs_ben_type
  pbp_b19_copay_iha_ps_amt
  pbp_b19_copay_iha_intrvl_num
  pbp_b19_copay_iha_amt_intrvl1
  pbp_b19_copay_iha_bgnd_intrvl1
  pbp_b19_copay_iha_endd_intrvl1
  pbp_b19_copay_iha_amt_intrvl2
  pbp_b19_copay_iha_bgnd_intrvl2
  pbp_b19_copay_iha_endd_intrvl2
  pbp_b19_copay_iha_amt_intrvl3
  pbp_b19_copay_iha_bgnd_intrvl3
  pbp_b19_copay_iha_endd_intrvl3
  pbp_b19_copay_iph_ps_amt
  pbp_b19_copay_iph_intrvl_num
  pbp_b19_copay_iph_amt_intrvl1
  pbp_b19_copay_iph_bgnd_intrvl1
  pbp_b19_copay_iph_endd_intrvl1
  pbp_b19_copay_iph_amt_intrvl2
  pbp_b19_copay_iph_bgnd_intrvl2
  pbp_b19_copay_iph_endd_intrvl2
  pbp_b19_copay_iph_amt_intrvl3
  pbp_b19_copay_iph_bgnd_intrvl3
  pbp_b19_copay_iph_endd_intrvl3
  pbp_b19_auth_yn
  pbp_b19_auth_subcats
  pbp_b19_auth
  pbp_b19_referral_yn
  pbp_b19_referral_subcats
;

  label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_b19_bendesc_yn               = 'POS Benefit YN                 '
  pbp_b19_bendesc_amo              = 'POS Benefit AMO                '
  pbp_b19_bendesc_subcats          = 'POS Benefit Subsrvc Categories '
  pbp_b19_maxplan_yn               = 'POS Benefit Max Plan YN        '
  pbp_b19_maxplan_amt              = 'POS Benefit Max Plan Amt       '
  pbp_b19_maxplan_per              = 'POS Benefit Max Plan Per       '
  pbp_b19_maxplan_cov              = 'POS Benefit Max Plan Cov       '
  pbp_b19_maxenr_yn                = 'POS Benefit Max Enr YN         '
  pbp_b19_maxenr_amt               = 'POS Benefit Max Enr Amt        '
  pbp_b19_maxenr_per               = 'POS Benefit Max Enr Per        '
  pbp_b19_coins_yn                 = 'POS Benefit Coinsurance YN     '
  pbp_b19_coins_costs_apply        = 'POS Benefit Coins CA           '
  pbp_b19_coins_min_pct            = 'POS Benefit Coins Min Pct      '
  pbp_b19_coins_max_pct            = 'POS Benefit Coins Max Pct      '
  pbp_b19_coins_cov                = 'POS Benefit Coins Cov          '
  pbp_b19_coins_ihs_yn             = 'POS Benefit IHS Coinsurance YN '
  pbp_b19_coins_ihs_ben_type       = 'POS Benefit IHS Coins Type     '
  pbp_b19_coins_iha_pct            = 'POS Benefit IHA Coins Pct      '
  pbp_b19_coins_iha_intrvl_num     = 'POS IHA Coins Interval Num     '
  pbp_b19_coins_iha_pct_intrvl1    = 'POS IHA Coins Pct Intrvl 1     '
  pbp_b19_coins_iha_bgnd_intrvl1   = 'POS IHA Coins BgnD Intrvl 1    '
  pbp_b19_coins_iha_endd_intrvl1   = 'POS IHA Coins EndD Intrvl 1    '
  pbp_b19_coins_iha_pct_intrvl2    = 'POS IHA Coins Pct Intrvl 2     '
  pbp_b19_coins_iha_bgnd_intrvl2   = 'POS IHA Coins BgnD Intrvl 2    '
  pbp_b19_coins_iha_endd_intrvl2   = 'POS IHA Coins EndD Intrvl 2    '
  pbp_b19_coins_iha_pct_intrvl3    = 'POS IHA Coins Pct Intrvl 3     '
  pbp_b19_coins_iha_bgnd_intrvl3   = 'POS IHA Coins BgnD Intrvl 3    '
  pbp_b19_coins_iha_endd_intrvl3   = 'POS IHA Coins EndD Intrvl 3    '
  pbp_b19_coins_iha_cov            = 'POS IHA Coins Cov              '
  pbp_b19_coins_iph_pct            = 'POS Benefit IPH Coins Pct      '
  pbp_b19_coins_iph_intrvl_num     = 'POS IPH Coins Interval Num     '
  pbp_b19_coins_iph_pct_intrvl1    = 'POS IPH Coins Pct Intrvl 1     '
  pbp_b19_coins_iph_bgnd_intrvl1   = 'POS IPH Coins BgnD Intrvl 1    '
  pbp_b19_coins_iph_endd_intrvl1   = 'POS IPH Coins EndD Intrvl 1    '
  pbp_b19_coins_iph_pct_intrvl2    = 'POS IPH Coins Pct Intrvl 2     '
  pbp_b19_coins_iph_bgnd_intrvl2   = 'POS IPH Coins BgnD Intrvl 2    '
  pbp_b19_coins_iph_endd_intrvl2   = 'POS IPH Coins EndD Intrvl 2    '
  pbp_b19_coins_iph_pct_intrvl3    = 'POS IPH Coins Pct Intrvl 3     '
  pbp_b19_coins_iph_bgnd_intrvl3   = 'POS IPH Coins BgnD Intrvl 3    '
  pbp_b19_coins_iph_endd_intrvl3   = 'POS IPH Coins EndD Intrvl 3    '
  pbp_b19_coins_iph_cov            = 'POS IPH Coins Cov              '
  pbp_b19_ded_yn                   = 'POS Benefit Deductible YN      '
  pbp_b19_ded_amt                  = 'POS Benefit Deductible Amt     '
  pbp_b19_copay_yn                 = 'POS Benefit Copayment YN       '
  pbp_b19_copay_costs_apply        = 'POS Benefit Copay CA           '
  pbp_b19_copay_min_amt            = 'POS Benefit Copay Min Amt      '
  pbp_b19_copay_max_amt            = 'POS Benefit Copay Max Amt      '
  pbp_b19_copay_ihs_yn             = 'POS Benefit IHS Copayment YN   '
  pbp_b19_copay_ihs_ben_type       = 'POS Benefit IHS Copay Type     '
  pbp_b19_copay_iha_ps_amt         = 'POS Benefit IHA Copay PS Amt   '
  pbp_b19_copay_iha_intrvl_num     = 'POS IHA Copay Interval Num     '
  pbp_b19_copay_iha_amt_intrvl1    = 'POS IHA Copay Amt Intrvl 1     '
  pbp_b19_copay_iha_bgnd_intrvl1   = 'POS IHA Copay BgnD Intrvl 1    '
  pbp_b19_copay_iha_endd_intrvl1   = 'POS IHA Copay EndD Intrvl 1    '
  pbp_b19_copay_iha_amt_intrvl2    = 'POS IHA Copay Amt Intrvl 2     '
  pbp_b19_copay_iha_bgnd_intrvl2   = 'POS IHA Copay BgnD Intrvl 2    '
  pbp_b19_copay_iha_endd_intrvl2   = 'POS IHA Copay EndD Intrvl 2    '
  pbp_b19_copay_iha_amt_intrvl3    = 'POS IHA Copay Amt Intrvl 3     '
  pbp_b19_copay_iha_bgnd_intrvl3   = 'POS IHA Copay BgnD Intrvl 3    '
  pbp_b19_copay_iha_endd_intrvl3   = 'POS IHA Copay EndD Intrvl 3    '
  pbp_b19_copay_iph_ps_amt         = 'POS Benefit IPH Copay PS Amt   '
  pbp_b19_copay_iph_intrvl_num     = 'POS IPH Copay Interval Num     '
  pbp_b19_copay_iph_amt_intrvl1    = 'POS IPH Copay Amt Intrvl 1     '
  pbp_b19_copay_iph_bgnd_intrvl1   = 'POS IPH Copay BgnD Intrvl 1    '
  pbp_b19_copay_iph_endd_intrvl1   = 'POS IPH Copay EndD Intrvl 1    '
  pbp_b19_copay_iph_amt_intrvl2    = 'POS IPH Copay Amt Intrvl 2     '
  pbp_b19_copay_iph_bgnd_intrvl2   = 'POS IPH Copay BgnD Intrvl 2    '
  pbp_b19_copay_iph_endd_intrvl2   = 'POS IPH Copay EndD Intrvl 2    '
  pbp_b19_copay_iph_amt_intrvl3    = 'POS IPH Copay Amt Intrvl 3     '
  pbp_b19_copay_iph_bgnd_intrvl3   = 'POS IPH Copay BgnD Intrvl 3    '
  pbp_b19_copay_iph_endd_intrvl3   = 'POS IPH Copay EndD Intrvl 3    '
  pbp_b19_auth_yn                  = 'POS Benefit Auth Required YN   '
  pbp_b19_auth_subcats             = 'POS Auth Subsrvc Categories    '
  pbp_b19_auth                     = 'POS Benefit Auth               '
  pbp_b19_referral_yn              = 'POS Referral Required YN       '
  pbp_b19_referral_subcats         = 'POS Referral Subsvc Categories '
  ;
run;

proc sort data = pbp_b19 out = out.pbp_b19;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b19(obs = 10);
  title 'pbp b19 data';
run;

proc means data =  out.pbp_b19;
  title 'pbp b19 file';
run;

proc freq data = out.pbp_b19;
  table
  pbp_a_ben_cov pbp_a_plan_type orgtype
  pbp_b19_bendesc_yn
  pbp_b19_bendesc_amo
  pbp_b19_maxplan_yn
  pbp_b19_maxplan_per
  pbp_b19_maxplan_cov
  pbp_b19_maxenr_yn
  pbp_b19_maxenr_per
  pbp_b19_bendesc_subcats
  pbp_b19_coins_costs_apply
  pbp_b19_coins_iha_intrvl_num
  pbp_b19_coins_iph_intrvl_num
  pbp_b19_copay_costs_apply
  pbp_b19_copay_iha_intrvl_num
  pbp_b19_copay_iph_intrvl_num
  pbp_b19_coins_yn
  pbp_b19_coins_cov
  pbp_b19_coins_ihs_yn
  pbp_b19_coins_ihs_ben_type
  pbp_b19_coins_iha_cov
  pbp_b19_coins_iph_cov
  pbp_b19_ded_yn
  pbp_b19_copay_yn
  pbp_b19_copay_ihs_yn
  pbp_b19_copay_ihs_ben_type
  pbp_b19_auth_yn
  pbp_b19_auth_subcats
  pbp_b19_auth
  pbp_b19_referral_yn
  pbp_b19_referral_subcats / missing;
run;

proc contents data = out.pbp_b19;
  title 'pbp b19 data';
run;
