*pbp_step17b.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_step17b;

length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_d_opt_identifier             $3
  pbp_b17b_bendesc_yn              $1
  pbp_b17b_bendesc_amo_cl          $1
  pbp_b17b_bendesc_lim_cl          $1
  pbp_b17b_bendesc_per_cl          $1
  pbp_b17b_bendesc_enh             $5
  pbp_b17b_bendesc_amo_egs         $1
  pbp_b17b_bendesc_lim_egs         $1
  pbp_b17b_bendesc_per_egs         $1
  pbp_b17b_bendesc_amo_egi         $1
  pbp_b17b_bendesc_lim_egl         $1
  pbp_b17b_bendesc_per_egl         $1
  pbp_b17b_bendesc_amo_egf         $1
  pbp_b17b_bendesc_lim_egf         $1
  pbp_b17b_bendesc_per_egf         $1
  pbp_b17b_bendesc_amo_upg         $1
  pbp_b17b_maxplan_yn              $1
  pbp_b17b_maxplan_type            $1
  pbp_b17b_maxplan_per             $1
  pbp_b17b_maxplan_cov             $1
  pbp_b17b_maxenr_yn               $1
  pbp_b17b_maxenr_type             $1
  pbp_b17b_maxenr_per              $1
  pbp_b17b_coins_yn                $1
  pbp_b17b_coins_cov_mc            $1
  pbp_b17b_coins_cov_cl            $1
  pbp_b17b_coins_cov_egs           $1
  pbp_b17b_coins_cov_egl           $1
  pbp_b17b_coins_cov_egf           $1
  pbp_b17b_coins_cov_upg           $1
  pbp_b17b_ded_yn                  $1
  pbp_b17b_copay_yn                $1
  pbp_b17b_auth                    $5
  pbp_b17b_refer_yn                $1
;

infile '.\pbp\pbp_step17b.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
  pbp_a_hnumber
  pbp_a_plan_identifier
  pbp_a_ben_cov
  pbp_a_plan_type
  orgtype
  pbp_b17b_bendesc_yn
  pbp_b17b_bendesc_enh
  pbp_b17b_bendesc_amo_cl
  pbp_b17b_bendesc_lim_cl
  pbp_b17b_bendesc_numv_cl
  pbp_b17b_bendesc_per_cl
  pbp_b17b_bendesc_amo_egs
  pbp_b17b_bendesc_lim_egs
  pbp_b17b_bendesc_numv_egs
  pbp_b17b_bendesc_per_egs
  pbp_b17b_bendesc_amo_egi
  pbp_b17b_bendesc_lim_egl
  pbp_b17b_bendesc_numv_egl
  pbp_b17b_bendesc_per_egl
  pbp_b17b_bendesc_amo_egf
  pbp_b17b_bendesc_lim_egf
  pbp_b17b_bendesc_numv_egf
  pbp_b17b_bendesc_per_egf
  pbp_b17b_bendesc_amo_upg
  pbp_b17b_maxplan_yn
  pbp_b17b_maxplan_type
  pbp_b17b_maxplan_amt
  pbp_b17b_maxplan_per
  pbp_b17b_maxplan_cov
  pbp_b17b_maxplan_pct
  pbp_b17b_maxenr_yn
  pbp_b17b_maxenr_type
  pbp_b17b_maxenr_amt
  pbp_b17b_maxenr_per
  pbp_b17b_coins_yn
  pbp_b17b_coins_pct_mc
  pbp_b17b_coins_cov_mc
  pbp_b17b_coins_pct_cl
  pbp_b17b_coins_cov_cl
  pbp_b17b_coins_pct_egs
  pbp_b17b_coins_cov_egs
  pbp_b17b_coins_pct_egl
  pbp_b17b_coins_cov_egl
  pbp_b17b_coins_pct_egf
  pbp_b17b_coins_cov_egf
  pbp_b17b_coins_pct_upg
  pbp_b17b_coins_cov_upg
  pbp_b17b_ded_yn
  pbp_b17b_ded_amt
  pbp_b17b_copay_yn
  pbp_b17b_copay_amt_mc
  pbp_b17b_copay_amt_cl
  pbp_b17b_copay_amt_egs
  pbp_b17b_copay_amt_egl
  pbp_b17b_copay_amt_egf
  pbp_b17b_copay_amt_upg
  pbp_b17b_auth
  pbp_b17b_refer_yn
  pbp_d_opt_identifier
;

label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_d_opt_identifier             = 'Option D Identifier            '
  pbp_b17b_bendesc_yn              = 'Eye Wear Ben Desc YN           '
  pbp_b17b_bendesc_enh             = 'Eye Wear Ben Desc Enhance      '
  pbp_b17b_bendesc_amo_cl          = 'Eye Wear CL Ben Desc AMO       '
  pbp_b17b_bendesc_lim_cl          = 'Eye Wear CL Ben Desc Lim YN    '
  pbp_b17b_bendesc_numv_cl         = 'Eye Wear CL Ben Desc Num       '
  pbp_b17b_bendesc_per_cl          = 'Eye Wear CL Ben Desc Per       '
  pbp_b17b_bendesc_amo_egs         = 'Eye Wear EGS Ben Desc AMO      '
  pbp_b17b_bendesc_lim_egs         = 'Eye Wear EGS Ben Desc Lim YN   '
  pbp_b17b_bendesc_numv_egs        = 'Eye Wear EGS Ben Desc Num      '
  pbp_b17b_bendesc_per_egs         = 'Eye Wear EGS Ben Desc Per      '
  pbp_b17b_bendesc_amo_egi         = 'Eye Wear EGL Ben Desc AMO      '
  pbp_b17b_bendesc_lim_egl         = 'Eye Wear EGL Ben Desc Lim YN   '
  pbp_b17b_bendesc_numv_egl        = 'Eye Wear EGL Ben Desc Num      '
  pbp_b17b_bendesc_per_egl         = 'Eye Wear EGL Ben Desc Per      '
  pbp_b17b_bendesc_amo_egf         = 'Eye Wear EGF Ben Desc AMO      '
  pbp_b17b_bendesc_lim_egf         = 'Eye Wear EGF Ben Desc Lim YN   '
  pbp_b17b_bendesc_numv_egf        = 'Eye Wear EGF Ben Desc Num      '
  pbp_b17b_bendesc_per_egf         = 'Eye Wear EGF Ben Desc Per      '
  pbp_b17b_bendesc_amo_upg         = 'Eye Wear UPG Ben Desc AMO      '
  pbp_b17b_maxplan_yn              = 'Eye Wear Max Plan YN           '
  pbp_b17b_maxplan_type            = 'Eye Wear Max Plan Type         '
  pbp_b17b_maxplan_amt             = 'Eye Wear Max Plan Amt          '
  pbp_b17b_maxplan_per             = 'Eye Wear Max Plan Per          '
  pbp_b17b_maxplan_cov             = 'Eye Wear Max Plan Cov          '
  pbp_b17b_maxplan_pct             = 'Eye Wear Max Plan Discnt Pct   '
  pbp_b17b_maxenr_yn               = 'Eye Wear Max Enr YN            '
  pbp_b17b_maxenr_type             = 'Eye Wear Max Enr Type          '
  pbp_b17b_maxenr_amt              = 'Eye Wear Max Enr Amt           '
  pbp_b17b_maxenr_per              = 'Eye Wear Max Enr Per           '
  pbp_b17b_coins_yn                = 'Eye Wear Coinsurance YN        '
  pbp_b17b_coins_pct_mc            = 'Eye Wear MC Coins Pct          '
  pbp_b17b_coins_cov_mc            = 'Eye Wear MC Coins Cov          '
  pbp_b17b_coins_pct_cl            = 'Eye Wear CL Coins Pct          '
  pbp_b17b_coins_cov_cl            = 'Eye Wear CL Coins Cov          '
  pbp_b17b_coins_pct_egs           = 'Eye Wear EGS Coins Pct         '
  pbp_b17b_coins_cov_egs           = 'Eye Wear EGS Coins Cov         '
  pbp_b17b_coins_pct_egl           = 'Eye Wear EGL Coins Pct         '
  pbp_b17b_coins_cov_egl           = 'Eye Wear EGL Coins Cov         '
  pbp_b17b_coins_pct_egf           = 'Eye Wear EGF Coins Pct         '
  pbp_b17b_coins_cov_egf           = 'Eye Wear EGF Coins Cov         '
  pbp_b17b_coins_pct_upg           = 'Eye Wear UPG Coins Pct         '
  pbp_b17b_coins_cov_upg           = 'Eye Wear UPG Coins Cov         '
  pbp_b17b_ded_yn                  = 'Eye Wear Deductible YN         '
  pbp_b17b_ded_amt                 = 'Eye Wear Deductible Amt        '
  pbp_b17b_copay_yn                = 'Eye Wear Copayment YN          '
  pbp_b17b_copay_amt_mc            = 'Eye Wear MC Copay Amt          '
  pbp_b17b_copay_amt_cl            = 'Eye Wear CL Copay Amt          '
  pbp_b17b_copay_amt_egs           = 'Eye Wear EGS Copay Amt         '
  pbp_b17b_copay_amt_egl           = 'Eye Wear EGL Copay Amt         '
  pbp_b17b_copay_amt_egf           = 'Eye Wear EGF Copay Amt         '
  pbp_b17b_copay_amt_upg           = 'Eye Wear UPG Copay Amt         '
  pbp_b17b_auth                    = 'Eye Wear Auth                  '
  pbp_b17b_refer_yn                = 'Eye Wear Referral YN           '
;
run;

proc sort data = pbp_step17b out = out.pbp_step17b;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_step17b(obs = 10);
  title 'pbp step17b data';
run;

proc means data = out.pbp_step17b;
  title 'pbp step17b file';
run;

proc freq data = out.pbp_step17b;
  table
  pbp_a_ben_cov pbp_a_plan_type orgtype pbp_d_opt_identifier
  pbp_b17b_bendesc_yn
  pbp_b17b_bendesc_amo_cl
  pbp_b17b_bendesc_lim_cl
  pbp_b17b_bendesc_per_cl
  pbp_b17b_bendesc_amo_egs
  pbp_b17b_bendesc_lim_egs
  pbp_b17b_bendesc_per_egs
  pbp_b17b_bendesc_amo_egi
  pbp_b17b_bendesc_lim_egl
  pbp_b17b_bendesc_per_egl
  pbp_b17b_bendesc_amo_egf
  pbp_b17b_bendesc_lim_egf
  pbp_b17b_bendesc_per_egf
  pbp_b17b_bendesc_amo_upg
  pbp_b17b_maxplan_yn
  pbp_b17b_maxplan_type
  pbp_b17b_maxplan_per
  pbp_b17b_maxplan_cov
  pbp_b17b_maxenr_yn
  pbp_b17b_maxenr_type
  pbp_b17b_maxenr_per
  pbp_b17b_coins_yn
  pbp_b17b_coins_cov_mc
  pbp_b17b_coins_cov_cl
  pbp_b17b_coins_cov_egs
  pbp_b17b_coins_cov_egl
  pbp_b17b_coins_cov_egf
  pbp_b17b_coins_cov_upg
  pbp_b17b_ded_yn
  pbp_b17b_copay_yn
  pbp_b17b_auth
  pbp_b17b_refer_yn / missing;
run;

proc contents data = out.pbp_step17b;
  title 'pbp step17b data';
run;
