* pbp_Section_A.sas;

libname out '.\sas_data_sets\PBP';

options pageno=1 nocenter ls=200;

data pbp_a;
  length
  orgtype                           $2
  pbp_a_ben_cov                     $1
  pbp_a_continue_costshare_yn       $1
  pbp_a_continue_yn                 $1
  pbp_a_contract_period             $4
  pbp_a_curmbr_phone                $14
  pbp_a_eghp_yn                     $1
  pbp_a_hnumber                     $5
  pbp_a_org_marketing_name          $50
  pbp_a_org_name                    $50
  pbp_a_plan_geog_name              $50
  pbp_a_plan_identifier             $3
  pbp_a_plan_name                   $50
  pbp_a_plan_type                   $2
  pbp_a_prombr_phone                $14
  pbp_a_service_area                $7
  pbp_a_ttytdd_curmbr_phone         $14
  pbp_a_ttytdd_prombr_phone         $14
  pbp_a_vtprogram_yn                $1
  ;

  infile '.\pbp\pbp_Section_A.txt'
         delimiter = '09'x dsd lrecl = 25000 firstobs = 2 missover;
input
pbp_a_hnumber
pbp_a_plan_identifier
pbp_a_ben_cov
pbp_a_plan_type
orgtype
pbp_a_ben_cov
pbp_a_continue_costshare_yn
pbp_a_continue_yn
pbp_a_contract_period
pbp_a_curmbr_phone
pbp_a_eghp_yn
pbp_a_hnumber
pbp_a_org_marketing_name
pbp_a_org_name
pbp_a_plan_geog_name
pbp_a_plan_identifier
pbp_a_plan_name
pbp_a_plan_type
pbp_a_prombr_phone
pbp_a_service_area
pbp_a_ttytdd_curmbr_phone
pbp_a_ttytdd_prombr_phone
pbp_a_vtprogram_yn;

  label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_continue_costshare_yn      = 'Continuation Area Same Cost YN '
  pbp_a_continue_yn                = 'Continuation Area YN           '
  pbp_a_contract_period            = 'Contract Period                '
  pbp_a_curmbr_phone               = 'Cur Mbr Phone Num              '
  pbp_a_eghp_yn                    = 'EGHP Plan YN                   '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_org_marketing_name         = 'MCO Marketing Name             '
  pbp_a_org_name                   = 'MCO Legal Name                 '
  pbp_a_plan_geog_name             = 'Plan Geographic Name           '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_name                  = 'Plan Name                      '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_a_prombr_phone               = 'Pro Mbr Phone Num              '
  pbp_a_service_area               = 'Service Area(s)                '
  pbp_a_ttytdd_curmbr_phone        = 'Cur Mbr TTYTDD Num             '
  pbp_a_ttytdd_prombr_phone        = 'Pro Mbr TTYTDD Num             '
  pbp_a_vtprogram_yn               = 'Visitor/Travel Program YN      ';
run;

proc sort data = pbp_a out = out.pbp_a;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_a(obs = 10);
  title 'pbp a data';
run;

proc means data =  out.pbp_a;
  title 'pbp a file';
run;

proc freq data = out.pbp_a;
  table
  pbp_a_ben_cov pbp_a_plan_type orgtype
  pbp_a_org_name
  pbp_a_hnumber
  pbp_a_contract_period
  pbp_a_plan_identifier
  pbp_a_plan_type
  pbp_a_ben_cov
  pbp_a_service_area
  pbp_a_plan_name
  pbp_a_plan_geog_name
  pbp_a_eghp_yn
  pbp_a_org_marketing_name
  pbp_a_continue_yn
  pbp_a_continue_costshare_yn
  pbp_a_vtprogram_yn / missing;
run;

proc contents data = out.pbp_a;
  title 'pbp a data';
run;
