* pbp_Section_C.sas;

libname out '.\sas_data_sets\PBP';

options pageno=1 nocenter ls=200;

data pbp_c;
  length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_c_coins_iha_cov              $1
  pbp_c_coins_iha_intrvl_num       $1
  pbp_c_coins_ihs_ben_type         $2
  pbp_c_coins_ihs_yn               $1
  pbp_c_coins_iph_cov              $1
  pbp_c_coins_iph_intrvl_num       $1
  pbp_c_copay_iha_intrvl_num       $1
  pbp_c_copay_ihs_ben_type         $2
  pbp_c_copay_ihs_yn               $1
  pbp_c_copay_iph_intrvl_num       $1
  pbp_c_gen_auth                   $5
  pbp_c_gen_auth_subcats           $51
  pbp_c_gen_auth_viol              $1
  pbp_c_gen_auth_yn                $1
  pbp_c_gen_bendesc_subcats        $51
  pbp_c_gen_ded_yn                 $1
  pbp_c_gen_maxenr_per             $1
  pbp_c_gen_maxenr_yn              $1
  pbp_c_gen_maxplan_cov            $1
  pbp_c_gen_maxplan_per            $1
  pbp_c_gen_maxplan_yn             $1
  pbp_c_gen_referral_subcats       $51
  pbp_c_gen_referral_yn            $1
  pbp_c_ihs_auth                   $5
  pbp_c_ihs_auth_yn                $1
  pbp_c_outpt1_auth                $5
  pbp_c_outpt1_bendesc_cats        $49
  pbp_c_outpt1_coins_cov           $1
  pbp_c_outpt1_coins_yn            $1
  pbp_c_outpt1_copay_yn            $1
  pbp_c_outpt1_ded_yn              $1
  pbp_c_outpt1_group_num           $1
  pbp_c_outpt1_maxenr_per          $1
  pbp_c_outpt1_maxenr_yn           $1
  pbp_c_outpt1_maxplan_cov         $1
  pbp_c_outpt1_maxplan_per         $1
  pbp_c_outpt1_maxplan_yn          $1
  pbp_c_outpt2_auth                $5
  pbp_c_outpt2_bendesc_cats        $49
  pbp_c_outpt2_coins_cov           $1
  pbp_c_outpt2_coins_yn            $1
  pbp_c_outpt2_copay_yn            $1
  pbp_c_outpt2_ded_yn              $1
  pbp_c_outpt2_maxenr_per          $1
  pbp_c_outpt2_maxenr_yn           $1
  pbp_c_outpt2_maxplan_cov         $1
  pbp_c_outpt2_maxplan_per         $1
  pbp_c_outpt2_maxplan_yn          $1
  pbp_c_outpt3_auth                $5
  pbp_c_outpt3_bendesc_cats        $49
  pbp_c_outpt3_coins_cov           $1
  pbp_c_outpt3_coins_yn            $1
  pbp_c_outpt3_copay_yn            $1
  pbp_c_outpt3_ded_yn              $1
  pbp_c_outpt3_maxenr_per          $1
  pbp_c_outpt3_maxenr_yn           $1
  pbp_c_outpt3_maxplan_cov         $1
  pbp_c_outpt3_maxplan_per         $1
  pbp_c_outpt3_maxplan_yn          $1
  pbp_c_outpt4_auth                $5
  pbp_c_outpt4_bendesc_cats        $49
  pbp_c_outpt4_coins_cov           $1
  pbp_c_outpt4_coins_yn            $1
  pbp_c_outpt4_copay_yn            $1
  pbp_c_outpt4_ded_yn              $1
  pbp_c_outpt4_maxenr_per          $1
  pbp_c_outpt4_maxenr_yn           $1
  pbp_c_outpt4_maxplan_cov         $1
  pbp_c_outpt4_maxplan_per         $1
  pbp_c_outpt4_maxplan_yn          $1
  pbp_c_outpt5_auth                $5
  pbp_c_outpt5_bendesc_cats        $49
  pbp_c_outpt5_coins_cov           $1
  pbp_c_outpt5_coins_yn            $1
  pbp_c_outpt5_copay_yn            $1
  pbp_c_outpt5_ded_yn              $1
  pbp_c_outpt5_maxenr_per          $1
  pbp_c_outpt5_maxenr_yn           $1
  pbp_c_outpt5_maxplan_cov         $1
  pbp_c_outpt5_maxplan_per         $1
  pbp_c_outpt5_maxplan_yn          $1
;

  infile '.\pbp\pbp_Section_C.txt'
         delimiter = '09'x dsd lrecl = 30000 firstobs = 2 missover;
input
pbp_a_hnumber
pbp_a_plan_identifier
pbp_a_ben_cov
pbp_a_plan_type
orgtype
pbp_c_coins_iha_bgnd_intrvl1
pbp_c_coins_iha_bgnd_intrvl2
pbp_c_coins_iha_bgnd_intrvl3
pbp_c_coins_iha_cov
pbp_c_coins_iha_endd_intrvl1
pbp_c_coins_iha_endd_intrvl2
pbp_c_coins_iha_endd_intrvl3
pbp_c_coins_iha_intrvl_num
pbp_c_coins_iha_pct
pbp_c_coins_iha_pct_intrvl1
pbp_c_coins_iha_pct_intrvl2
pbp_c_coins_iha_pct_intrvl3
pbp_c_coins_ihs_ben_type
pbp_c_coins_ihs_yn
pbp_c_coins_iph_bgnd_intrvl1
pbp_c_coins_iph_bgnd_intrvl2
pbp_c_coins_iph_bgnd_intrvl3
pbp_c_coins_iph_cov
pbp_c_coins_iph_endd_intrvl1
pbp_c_coins_iph_endd_intrvl2
pbp_c_coins_iph_endd_intrvl3
pbp_c_coins_iph_intrvl_num
pbp_c_coins_iph_pct
pbp_c_coins_iph_pct_intrvl1
pbp_c_coins_iph_pct_intrvl2
pbp_c_coins_iph_pct_intrvl3
pbp_c_copay_iha_amt_intrvl1
pbp_c_copay_iha_amt_intrvl2
pbp_c_copay_iha_amt_intrvl3
pbp_c_copay_iha_bgnd_intrvl1
pbp_c_copay_iha_bgnd_intrvl2
pbp_c_copay_iha_bgnd_intrvl3
pbp_c_copay_iha_endd_intrvl1
pbp_c_copay_iha_endd_intrvl2
pbp_c_copay_iha_endd_intrvl3
pbp_c_copay_iha_intrvl_num
pbp_c_copay_iha_ps_amt
pbp_c_copay_ihs_ben_type
pbp_c_copay_ihs_yn
pbp_c_copay_iph_amt_intrvl1
pbp_c_copay_iph_amt_intrvl2
pbp_c_copay_iph_amt_intrvl3
pbp_c_copay_iph_bgnd_intrvl1
pbp_c_copay_iph_bgnd_intrvl2
pbp_c_copay_iph_bgnd_intrvl3
pbp_c_copay_iph_endd_intrvl1
pbp_c_copay_iph_endd_intrvl2
pbp_c_copay_iph_endd_intrvl3
pbp_c_copay_iph_intrvl_num
pbp_c_copay_iph_ps_amt
pbp_c_gen_auth
pbp_c_gen_auth_subcats
pbp_c_gen_auth_viol
pbp_c_gen_auth_yn
pbp_c_gen_bendesc_subcats
pbp_c_gen_ded_amt
pbp_c_gen_ded_yn
pbp_c_gen_maxenr_amt
pbp_c_gen_maxenr_per
pbp_c_gen_maxenr_yn
pbp_c_gen_maxplan_amt
pbp_c_gen_maxplan_cov
pbp_c_gen_maxplan_per
pbp_c_gen_maxplan_yn
pbp_c_gen_referral_subcats
pbp_c_gen_referral_yn
pbp_c_ihs_auth
pbp_c_ihs_auth_yn
pbp_c_outpt1_auth
pbp_c_outpt1_bendesc_cats
pbp_c_outpt1_coins_cov
pbp_c_outpt1_coins_max_pct
pbp_c_outpt1_coins_min_pct
pbp_c_outpt1_coins_yn
pbp_c_outpt1_copay_max_amt
pbp_c_outpt1_copay_min_amt
pbp_c_outpt1_copay_yn
pbp_c_outpt1_ded_amt
pbp_c_outpt1_ded_yn
pbp_c_outpt1_group_num
pbp_c_outpt1_maxenr_amt
pbp_c_outpt1_maxenr_per
pbp_c_outpt1_maxenr_yn
pbp_c_outpt1_maxplan_amt
pbp_c_outpt1_maxplan_cov
pbp_c_outpt1_maxplan_per
pbp_c_outpt1_maxplan_yn
pbp_c_outpt2_auth
pbp_c_outpt2_bendesc_cats
pbp_c_outpt2_coins_cov
pbp_c_outpt2_coins_max_pct
pbp_c_outpt2_coins_min_pct
pbp_c_outpt2_coins_yn
pbp_c_outpt2_copay_max_amt
pbp_c_outpt2_copay_min_amt
pbp_c_outpt2_copay_yn
pbp_c_outpt2_ded_amt
pbp_c_outpt2_ded_yn
pbp_c_outpt2_maxenr_amt
pbp_c_outpt2_maxenr_per
pbp_c_outpt2_maxenr_yn
pbp_c_outpt2_maxplan_amt
pbp_c_outpt2_maxplan_cov
pbp_c_outpt2_maxplan_per
pbp_c_outpt2_maxplan_yn
pbp_c_outpt3_auth
pbp_c_outpt3_bendesc_cats
pbp_c_outpt3_coins_cov
pbp_c_outpt3_coins_max_pct
pbp_c_outpt3_coins_min_pct
pbp_c_outpt3_coins_yn
pbp_c_outpt3_copay_max_amt
pbp_c_outpt3_copay_min_amt
pbp_c_outpt3_copay_yn
pbp_c_outpt3_ded_amt
pbp_c_outpt3_ded_yn
pbp_c_outpt3_maxenr_amt
pbp_c_outpt3_maxenr_per
pbp_c_outpt3_maxenr_yn
pbp_c_outpt3_maxplan_amt
pbp_c_outpt3_maxplan_cov
pbp_c_outpt3_maxplan_per
pbp_c_outpt3_maxplan_yn
pbp_c_outpt4_auth
pbp_c_outpt4_bendesc_cats
pbp_c_outpt4_coins_cov
pbp_c_outpt4_coins_max_pct
pbp_c_outpt4_coins_min_pct
pbp_c_outpt4_coins_yn
pbp_c_outpt4_copay_max_amt
pbp_c_outpt4_copay_min_amt
pbp_c_outpt4_copay_yn
pbp_c_outpt4_ded_amt
pbp_c_outpt4_ded_yn
pbp_c_outpt4_maxenr_amt
pbp_c_outpt4_maxenr_per
pbp_c_outpt4_maxenr_yn
pbp_c_outpt4_maxplan_amt
pbp_c_outpt4_maxplan_cov
pbp_c_outpt4_maxplan_per
pbp_c_outpt4_maxplan_yn
pbp_c_outpt5_bendesc_cats
pbp_c_outpt5_coins_cov
pbp_c_outpt5_coins_max_pct
pbp_c_outpt5_coins_min_pct
pbp_c_outpt5_coins_yn
pbp_c_outpt5_copay_max_amt
pbp_c_outpt5_copay_min_amt
pbp_c_outpt5_copay_yn
pbp_c_outpt5_ded_amt
pbp_c_outpt5_ded_yn
pbp_c_outpt5_maxenr_amt
pbp_c_outpt5_maxenr_yn
pbp_c_outpt5_maxplan_amt
pbp_c_outpt5_maxplan_cov
pbp_c_outpt5_maxplan_per
pbp_c_outpt5_maxplan_yn
pbp_c_outpt5_auth
pbp_c_outpt5_maxenr_per
;

  label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_c_coins_iha_bgnd_intrvl1     = 'OON IHA Coins BgnD Intrvl 1    '
  pbp_c_coins_iha_bgnd_intrvl2     = 'OON IHA Coins BgnD Intrvl 2    '
  pbp_c_coins_iha_bgnd_intrvl3     = 'OON IHA Coins BgnD Intrvl 3    '
  pbp_c_coins_iha_cov              = 'OON IHA Coins Cov              '
  pbp_c_coins_iha_endd_intrvl1     = 'OON IHA Coins EndD Intrvl 1    '
  pbp_c_coins_iha_endd_intrvl2     = 'OON IHA Coins EndD Intrvl 2    '
  pbp_c_coins_iha_endd_intrvl3     = 'OON IHA Coins EndD Intrvl 3    '
  pbp_c_coins_iha_intrvl_num       = 'OON IHA Coins Interval Num     '
  pbp_c_coins_iha_pct              = 'OON Benefit IHA Coins Pct      '
  pbp_c_coins_iha_pct_intrvl1      = 'OON IHA Coins Pct Intrvl 1     '
  pbp_c_coins_iha_pct_intrvl2      = 'OON IHA Coins Pct Intrvl 2     '
  pbp_c_coins_iha_pct_intrvl3      = 'OON IHA Coins Pct Intrvl 3     '
  pbp_c_coins_ihs_ben_type         = 'OON Benefit IHS Coins Type     '
  pbp_c_coins_ihs_yn               = 'OON Benefit IHS Coinsurance YN '
  pbp_c_coins_iph_bgnd_intrvl1     = 'OON IPH Coins BgnD Intrvl 1    '
  pbp_c_coins_iph_bgnd_intrvl2     = 'OON IPH Coins BgnD Intrvl 2    '
  pbp_c_coins_iph_bgnd_intrvl3     = 'OON IPH Coins BgnD Intrvl 3    '
  pbp_c_coins_iph_cov              = 'OON IPH Coins Cov              '
  pbp_c_coins_iph_endd_intrvl1     = 'OON IPH Coins EndD Intrvl 1    '
  pbp_c_coins_iph_endd_intrvl2     = 'OON IPH Coins EndD Intrvl 2    '
  pbp_c_coins_iph_endd_intrvl3     = 'OON IPH Coins EndD Intrvl 3    '
  pbp_c_coins_iph_intrvl_num       = 'OON IPH Coins Interval Num     '
  pbp_c_coins_iph_pct              = 'OON Benefit IPH Coins Pct      '
  pbp_c_coins_iph_pct_intrvl1      = 'OON IPH Coins Pct Intrvl 1     '
  pbp_c_coins_iph_pct_intrvl2      = 'OON IPH Coins Pct Intrvl 2     '
  pbp_c_coins_iph_pct_intrvl3      = 'OON IPH Coins Pct Intrvl 3     '
  pbp_c_copay_iha_amt_intrvl1      = 'OON IHA Copay Amt Intrvl 1     '
  pbp_c_copay_iha_amt_intrvl2      = 'OON IHA Copay Amt Intrvl 2     '
  pbp_c_copay_iha_amt_intrvl3      = 'OON IHA Copay Amt Intrvl 3     '
  pbp_c_copay_iha_bgnd_intrvl1     = 'OON IHA Copay BgnD Intrvl 1    '
  pbp_c_copay_iha_bgnd_intrvl2     = 'OON IHA Copay BgnD Intrvl 2    '
  pbp_c_copay_iha_bgnd_intrvl3     = 'OON IHA Copay BgnD Intrvl 3    '
  pbp_c_copay_iha_endd_intrvl1     = 'OON IHA Copay EndD Intrvl 1    '
  pbp_c_copay_iha_endd_intrvl2     = 'OON IHA Copay EndD Intrvl 2    '
  pbp_c_copay_iha_endd_intrvl3     = 'OON IHA Copay EndD Intrvl 3    '
  pbp_c_copay_iha_intrvl_num       = 'OON IHA Copay Interval Num     '
  pbp_c_copay_iha_ps_amt           = 'OON Benefit IHA Copay PS Amt   '
  pbp_c_copay_ihs_ben_type         = 'OON Benefit IHS Copay Type     '
  pbp_c_copay_ihs_yn               = 'OON Benefit IHS Copayment YN   '
  pbp_c_copay_iph_amt_intrvl1      = 'OON IPH Copay Amt Intrvl 1     '
  pbp_c_copay_iph_amt_intrvl2      = 'OON IPH Copay Amt Intrvl 2     '
  pbp_c_copay_iph_amt_intrvl3      = 'OON IPH Copay Amt Intrvl 3     '
  pbp_c_copay_iph_bgnd_intrvl1     = 'OON IPH Copay BgnD Intrvl 1    '
  pbp_c_copay_iph_bgnd_intrvl2     = 'OON IPH Copay BgnD Intrvl 2    '
  pbp_c_copay_iph_bgnd_intrvl3     = 'OON IPH Copay BgnD Intrvl 3    '
  pbp_c_copay_iph_endd_intrvl1     = 'OON IPH Copay EndD Intrvl 1    '
  pbp_c_copay_iph_endd_intrvl2     = 'OON IPH Copay EndD Intrvl 2    '
  pbp_c_copay_iph_endd_intrvl3     = 'OON IPH Copay EndD Intrvl 3    '
  pbp_c_copay_iph_intrvl_num       = 'OON IPH Copay Interval Num     '
  pbp_c_copay_iph_ps_amt           = 'OON Benefit IPH Copay PS Amt   '
  pbp_c_gen_auth                   = 'OON Benefit Auth               '
  pbp_c_gen_auth_subcats           = 'OON Auth Subsrvc Categories    '
  pbp_c_gen_auth_viol              = 'OON Auth Violation             '
  pbp_c_gen_auth_yn                = 'OON Benefit Auth Required YN   '
  pbp_c_gen_bendesc_subcats        = 'OON Benefit Subsrvc Categories '
  pbp_c_gen_ded_amt                = 'OON Benefit Deductible Amt     '
  pbp_c_gen_ded_yn                 = 'OON Benefit Deductible YN      '
  pbp_c_gen_maxenr_amt             = 'OON Benefit Max Enr Amt        '
  pbp_c_gen_maxenr_per             = 'OON Benefit Max Enr Per        '
  pbp_c_gen_maxenr_yn              = 'OON Benefit Max Enr YN         '
  pbp_c_gen_maxplan_amt            = 'OON Benefit Max Plan Amt       '
  pbp_c_gen_maxplan_cov            = 'OON Benefit Max Plan Cov       '
  pbp_c_gen_maxplan_per            = 'OON Benefit Max Plan Per       '
  pbp_c_gen_maxplan_yn             = 'OON Benefit Max Plan YN        '
  pbp_c_gen_referral_subcats       = 'OON Referral Subsvc Categories '
  pbp_c_gen_referral_yn            = 'OON Referral Required YN       '
  pbp_c_ihs_auth                   = 'OON Benefit Auth               '
  pbp_c_ihs_auth_yn                = 'OON Benefit Auth Required YN   '
  pbp_c_outpt1_auth                = 'OON Out Pt 1 Auth              '
  pbp_c_outpt1_bendesc_cats        = 'OON Out Pt 1 Benefit Cats      '
  pbp_c_outpt1_coins_cov           = 'OON Out PT 1 Coins Cov         '
  pbp_c_outpt1_coins_max_pct       = 'OON Out Pt 1 Max Coins Pct     '
  pbp_c_outpt1_coins_min_pct       = 'OON Out Pt 1 Min Coins Pct     '
  pbp_c_outpt1_coins_yn            = 'OON Out Pt 1 Coinsurance YN    '
  pbp_c_outpt1_copay_max_amt       = 'OON Out Pt 1 Copayment Max Amt '
  pbp_c_outpt1_copay_min_amt       = 'OON Out Pt 1 Copayment Min Amt '
  pbp_c_outpt1_copay_yn            = 'OON Out Pt 1 Copay YN          '
  pbp_c_outpt1_ded_amt             = 'OON Out Pt 1 Deductible Amt    '
  pbp_c_outpt1_ded_yn              = 'OON Out Pt 1 Deductible YN     '
  pbp_c_outpt1_group_num           = 'OON Out Pt 1 Group Num         '
  pbp_c_outpt1_maxenr_amt          = 'OON Out Pt 1 Max Enr Amt       '
  pbp_c_outpt1_maxenr_per          = 'OON Out Pt 1 Max Enr Per       '
  pbp_c_outpt1_maxenr_yn           = 'OON Out Pt 1 Max Enr YN        '
  pbp_c_outpt1_maxplan_amt         = 'OON Out Pt 1 Max Plan Amt      '
  pbp_c_outpt1_maxplan_cov         = 'OON Out PT 1 Max Plan Cov      '
  pbp_c_outpt1_maxplan_per         = 'OON Out Pt 1 Max Plan Per      '
  pbp_c_outpt1_maxplan_yn          = 'OON Out Pt 1 Max Plan YN       '
  pbp_c_outpt2_auth                = 'OON Out Pt 2 Auth              '
  pbp_c_outpt2_bendesc_cats        = 'OON Out Pt 2 Benefit Cats      '
  pbp_c_outpt2_coins_cov           = 'OON Out PT 2 Coins Cov         '
  pbp_c_outpt2_coins_max_pct       = 'OON Out Pt 2 Max Coins Pct     '
  pbp_c_outpt2_coins_min_pct       = 'OON Out Pt 2 Min Coins Pct     '
  pbp_c_outpt2_coins_yn            = 'OON Out Pt 2 Coinsurance YN    '
  pbp_c_outpt2_copay_max_amt       = 'OON Out Pt 2 Copayment Max Amt '
  pbp_c_outpt2_copay_min_amt       = 'OON Out Pt 2 Copayment Min Amt '
  pbp_c_outpt2_copay_yn            = 'OON Out Pt 2 Copay YN          '
  pbp_c_outpt2_ded_amt             = 'OON Out Pt 2 Deductible Amt    '
  pbp_c_outpt2_ded_yn              = 'OON Out Pt 2 Deductible YN     '
  pbp_c_outpt2_maxenr_amt          = 'OON Out Pt 2 Max Enr Amt       '
  pbp_c_outpt2_maxenr_per          = 'OON Out Pt 2 Max Enr Per       '
  pbp_c_outpt2_maxenr_yn           = 'OON Out Pt 2 Max Enr YN        '
  pbp_c_outpt2_maxplan_amt         = 'OON Out Pt 2 Max Plan Amt      '
  pbp_c_outpt2_maxplan_cov         = 'OON Out PT 2 Max Plan Cov      '
  pbp_c_outpt2_maxplan_per         = 'OON Out Pt 2 Max Plan Per      '
  pbp_c_outpt2_maxplan_yn          = 'OON Out Pt 2 Max Plan YN       '
  pbp_c_outpt3_auth                = 'OON Out Pt 3 Auth              '
  pbp_c_outpt3_bendesc_cats        = 'OON Out Pt 3 Benefit Cats      '
  pbp_c_outpt3_coins_cov           = 'OON Out PT 3 Coins Cov         '
  pbp_c_outpt3_coins_max_pct       = 'OON Out Pt 3 Max Coins Pct     '
  pbp_c_outpt3_coins_min_pct       = 'OON Out Pt 3 Min Coins Pct     '
  pbp_c_outpt3_coins_yn            = 'OON Out Pt 3 Coinsurance YN    '
  pbp_c_outpt3_copay_max_amt       = 'OON Out Pt 3 Copayment Max Amt '
  pbp_c_outpt3_copay_min_amt       = 'OON Out Pt 3 Copayment Min Amt '
  pbp_c_outpt3_copay_yn            = 'OON Out Pt 3 Copay YN          '
  pbp_c_outpt3_ded_amt             = 'OON Out Pt 3 Deductible Amt    '
  pbp_c_outpt3_ded_yn              = 'OON Out Pt 3 Deductible YN     '
  pbp_c_outpt3_maxenr_amt          = 'OON Out Pt 3 Max Enr Amt       '
  pbp_c_outpt3_maxenr_per          = 'OON Out Pt 3 Max Enr Per       '
  pbp_c_outpt3_maxenr_yn           = 'OON Out Pt 3 Max Enr YN        '
  pbp_c_outpt3_maxplan_amt         = 'OON Out Pt 3 Max Plan Amt      '
  pbp_c_outpt3_maxplan_cov         = 'OON Out PT 3 Max Plan Cov      '
  pbp_c_outpt3_maxplan_per         = 'OON Out Pt 3 Max Plan Per      '
  pbp_c_outpt3_maxplan_yn          = 'OON Out Pt 3 Max Plan YN       '
  pbp_c_outpt4_auth                = 'OON Out Pt 4 Auth              '
  pbp_c_outpt4_bendesc_cats        = 'OON Out Pt 4 Benefit Cats      '
  pbp_c_outpt4_coins_cov           = 'OON Out PT 4 Coins Cov         '
  pbp_c_outpt4_coins_max_pct       = 'OON Out Pt 4 Max Coins Pct     '
  pbp_c_outpt4_coins_min_pct       = 'OON Out Pt 4 Min Coins Pct     '
  pbp_c_outpt4_coins_yn            = 'OON Out Pt 4 Coinsurance YN    '
  pbp_c_outpt4_copay_max_amt       = 'OON Out Pt 4 Copayment Max Amt '
  pbp_c_outpt4_copay_min_amt       = 'OON Out Pt 4 Copayment Min Amt '
  pbp_c_outpt4_copay_yn            = 'OON Out Pt 4 Copay YN          '
  pbp_c_outpt4_ded_amt             = 'OON Out Pt 4 Deductible Amt    '
  pbp_c_outpt4_ded_yn              = 'OON Out Pt 4 Deductible YN     '
  pbp_c_outpt4_maxenr_amt          = 'OON Out Pt 4 Max Enr Amt       '
  pbp_c_outpt4_maxenr_per          = 'OON Out Pt 4 Max Enr Per       '
  pbp_c_outpt4_maxenr_yn           = 'OON Out Pt 4 Max Enr YN        '
  pbp_c_outpt4_maxplan_amt         = 'OON Out Pt 4 Max Plan Amt      '
  pbp_c_outpt4_maxplan_cov         = 'OON Out PT 4 Max Plan Cov      '
  pbp_c_outpt4_maxplan_per         = 'OON Out Pt 4 Max Plan Per      '
  pbp_c_outpt4_maxplan_yn          = 'OON Out Pt 4 Max Plan YN       '
  pbp_c_outpt5_auth                = 'OON Out Pt 5 Auth              '
  pbp_c_outpt5_bendesc_cats        = 'OON Out Pt 5 Benefit Cats      '
  pbp_c_outpt5_coins_cov           = 'OON Out PT 5 Coins Cov         '
  pbp_c_outpt5_coins_max_pct       = 'OON Out Pt 5 Max Coins Pct     '
  pbp_c_outpt5_coins_min_pct       = 'OON Out Pt 5 Min Coins Pct     '
  pbp_c_outpt5_coins_yn            = 'OON Out Pt 5 Coinsurance YN    '
  pbp_c_outpt5_copay_max_amt       = 'OON Out Pt 5 Copayment Max Amt '
  pbp_c_outpt5_copay_min_amt       = 'OON Out Pt 5 Copayment Min Amt '
  pbp_c_outpt5_copay_yn            = 'OON Out Pt 5 Copay YN          '
  pbp_c_outpt5_ded_amt             = 'OON Out Pt 5 Deductible Amt    '
  pbp_c_outpt5_ded_yn              = 'OON Out Pt 5 Deductible YN     '
  pbp_c_outpt5_maxenr_amt          = 'OON Out Pt 5 Max Enr Amt       '
  pbp_c_outpt5_maxenr_per          = 'OON Out Pt 5 Max Enr Per       '
  pbp_c_outpt5_maxenr_yn           = 'OON Out Pt 5 Max Enr YN        '
  pbp_c_outpt5_maxplan_amt         = 'OON Out Pt 5 Max Plan Amt      '
  pbp_c_outpt5_maxplan_cov         = 'OON Out PT 5 Max Plan Cov      '
  pbp_c_outpt5_maxplan_per         = 'OON Out Pt 5 Max Plan Per      '
  pbp_c_outpt5_maxplan_yn          = 'OON Out Pt 5 Max Plan YN       '
;
  run;

proc sort data = pbp_c out = out.pbp_c;
  by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_c(obs = 10);
  title 'pbp c data';
run;

proc means data =  out.pbp_c;
  title 'pbp c file';
run;

proc freq data = out.pbp_c;
  table
  pbp_a_ben_cov pbp_a_plan_type orgtype
  pbp_c_coins_iha_cov
  pbp_c_coins_iha_intrvl_num
  pbp_c_coins_ihs_ben_type
  pbp_c_coins_ihs_yn
  pbp_c_coins_iph_cov
  pbp_c_coins_iph_intrvl_num
  pbp_c_copay_iha_intrvl_num
  pbp_c_copay_ihs_ben_type
  pbp_c_copay_ihs_yn
  pbp_c_copay_iph_intrvl_num
  pbp_c_gen_auth
  pbp_c_gen_auth_subcats
  pbp_c_gen_auth_viol
  pbp_c_gen_auth_yn
  pbp_c_gen_bendesc_subcats
  pbp_c_gen_ded_yn
  pbp_c_gen_maxenr_per
  pbp_c_gen_maxenr_yn
  pbp_c_gen_maxplan_cov
  pbp_c_gen_maxplan_per
  pbp_c_gen_maxplan_yn
  pbp_c_gen_referral_subcats
  pbp_c_gen_referral_yn
  pbp_c_ihs_auth
  pbp_c_ihs_auth_yn
  pbp_c_outpt1_auth
  pbp_c_outpt1_bendesc_cats
  pbp_c_outpt1_coins_cov
  pbp_c_outpt1_coins_yn
  pbp_c_outpt1_copay_yn
  pbp_c_outpt1_ded_yn
  pbp_c_outpt1_group_num
  pbp_c_outpt1_maxenr_per
  pbp_c_outpt1_maxenr_yn
  pbp_c_outpt1_maxplan_cov
  pbp_c_outpt1_maxplan_per
  pbp_c_outpt1_maxplan_yn
  pbp_c_outpt2_auth
  pbp_c_outpt2_bendesc_cats
  pbp_c_outpt2_coins_cov
  pbp_c_outpt2_coins_yn
  pbp_c_outpt2_copay_yn
  pbp_c_outpt2_ded_yn
  pbp_c_outpt2_maxenr_per
  pbp_c_outpt2_maxenr_yn
  pbp_c_outpt2_maxplan_cov
  pbp_c_outpt2_maxplan_per
  pbp_c_outpt2_maxplan_yn
  pbp_c_outpt3_auth
  pbp_c_outpt3_bendesc_cats
  pbp_c_outpt3_coins_cov
  pbp_c_outpt3_coins_yn
  pbp_c_outpt3_copay_yn
  pbp_c_outpt3_ded_yn
  pbp_c_outpt3_maxenr_per
  pbp_c_outpt3_maxenr_yn
  pbp_c_outpt3_maxplan_cov
  pbp_c_outpt3_maxplan_per
  pbp_c_outpt3_maxplan_yn
  pbp_c_outpt4_auth
  pbp_c_outpt4_bendesc_cats
  pbp_c_outpt4_coins_cov
  pbp_c_outpt4_coins_yn
  pbp_c_outpt4_copay_yn
  pbp_c_outpt4_ded_yn
  pbp_c_outpt4_maxenr_per
  pbp_c_outpt4_maxenr_yn
  pbp_c_outpt4_maxplan_cov
  pbp_c_outpt4_maxplan_per
  pbp_c_outpt4_maxplan_yn
  pbp_c_outpt5_auth
  pbp_c_outpt5_bendesc_cats
  pbp_c_outpt5_coins_cov
  pbp_c_outpt5_coins_yn
  pbp_c_outpt5_copay_yn
  pbp_c_outpt5_ded_yn
  pbp_c_outpt5_maxenr_per
  pbp_c_outpt5_maxenr_yn
  pbp_c_outpt5_maxplan_cov
  pbp_c_outpt5_maxplan_per
  pbp_c_outpt5_maxplan_yn / missing;
run;

proc contents data = out.pbp_c;
  title 'pbp c data';
run;

