* pbp_Section_D.sas;

libname out '.\sas_data_sets\PBP';

options pageno=1 nocenter ls=200;

data pbp_d;
  length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_d_deduct_yn                  $1
  pbp_d_deduct_all_services_yn     $1
  pbp_d_mco_pay_reduct_yn          $1
  pbp_d_out_pocket_amt_yn          $1
  pbp_d_out_pocket_period          $1
  pbp_d_max_plan_ben_cov_yn        $1
  pbp_d_max_plan_period            $1
  pbp_d_deduct_services            $51
  pbp_d_deduct_type                $1
  pbp_d_out_pocket_all_svcs_yn     $1
  pbp_d_out_pocket_mc_only_flag    $1
  pbp_d_out_pocket_services        $51
  pbp_d_out_pocket_type            $1;

  infile '.\pbp\pbp_Section_D.txt'
         delimiter = '09'x dsd lrecl = 15000 firstobs = 2 missover;
input
pbp_a_hnumber
pbp_a_plan_identifier
pbp_a_ben_cov
pbp_a_plan_type
orgtype
pbp_d_deduct
pbp_d_deduct_all_services_yn
pbp_d_deduct_services
pbp_d_deduct_type
pbp_d_deduct_yn
pbp_d_max_plan_ben_cov
pbp_d_max_plan_ben_cov_yn
pbp_d_max_plan_period
pbp_d_mco_pay_reduct_amt
pbp_d_mco_pay_reduct_yn
pbp_d_mplusc_bonly_premium
pbp_d_mplusc_premium
pbp_d_msa_annual_amt
pbp_d_out_pocket_all_svcs_yn
pbp_d_out_pocket_amt
pbp_d_out_pocket_amt_yn
pbp_d_out_pocket_mc_only_amt
pbp_d_out_pocket_mc_only_flag
pbp_d_out_pocket_period
pbp_d_out_pocket_services
pbp_d_out_pocket_type
pbp_d_partb_premium_reduce_amt;

  label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_d_mplusc_premium             = 'Indicate Plan Premium Amt (AB) '
  pbp_d_mplusc_bonly_premium       = 'Indicate Plan Premium Amt (B)  '
  pbp_d_deduct_yn                  = 'Plan Deductible YN             '
  pbp_d_deduct                     = 'Plan Deductible Amt            '
  pbp_d_deduct_all_services_yn     = 'Plan Dedct Apply All Servs YN  '
  pbp_d_mco_pay_reduct_yn          = 'MCO Reduce Part B Premium YN   '
  pbp_d_mco_pay_reduct_amt         = 'Part B Premium Reduction Amt   '
  pbp_d_msa_annual_amt             = 'Annual MSA Deposit Amt         '
  pbp_d_out_pocket_amt_yn          = 'Max Enr Amt YN (non-POS)       '
  pbp_d_out_pocket_amt             = 'Max Enr Amt (non-POS)          '
  pbp_d_out_pocket_period          = 'Max Enr Per (non-POS)          '
  pbp_d_max_plan_ben_cov_yn        = 'Max Plan YN (non-POS)          '
  pbp_d_max_plan_ben_cov           = 'Max Plan Amt (non-POS)         '
  pbp_d_max_plan_period            = 'Max Plan Per (non-POS)         '
  pbp_d_deduct_services            = 'Serv Cats Plan Deduct          '
  pbp_d_deduct_type                = 'Deduct Type for Serv Cats      '
  pbp_d_out_pocket_all_svcs_yn     = 'Max Enr Cost Apply All Svcs    '
  pbp_d_out_pocket_mc_only_amt     = 'Max Enr Out Pocket Amt Med Ben '
  pbp_d_out_pocket_mc_only_flag    = 'Max Enr MC Amt Edit Flag       '
  pbp_d_out_pocket_services        = 'Max Enr Cost Serv Cats         '
  pbp_d_out_pocket_type            = 'Max Enr Type for Serv Cats     '
  pbp_d_partb_premium_reduce_amt   = 'Reduced Part B Premium         ';
run;

proc sort data = pbp_d out = out.pbp_d;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_d(obs = 10);
  title 'pbp d data';
run;

proc means data =  out.pbp_d;
  title 'pbp d file';
run;

proc freq data = out.pbp_d;
  table
  pbp_a_ben_cov pbp_a_plan_type orgtype
  pbp_d_deduct_yn
  pbp_d_out_pocket_amt_yn
  pbp_d_out_pocket_period
  pbp_d_max_plan_ben_cov_yn
  pbp_d_max_plan_period
  pbp_d_deduct_all_services_yn
  pbp_d_mco_pay_reduct_yn
  pbp_d_deduct_services
  pbp_d_deduct_type
  pbp_d_out_pocket_all_svcs_yn
  pbp_d_out_pocket_mc_only_flag
  pbp_d_out_pocket_services
  pbp_d_out_pocket_type / missing;
run;

proc contents data = out.pbp_d;
  title 'pbp d data';
run;
