*pbp_b12.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b12;

length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_b12_maxenr_yn                $1
  pbp_b12_maxenr_per               $1
  pbp_b12_coins_yn                 $1
  pbp_b12_coins_cov_mc_ia          $1
  pbp_b12_coins_cov_mc_oa          $1
  pbp_b12_ded_yn                   $1
  pbp_b12_copay_yn                 $1
  pbp_b12_auth                     $5
  pbp_b12_refer_yn                 $1
  pbp_b12_sep_cost_yn              $1;

infile '.\pbp\pbp_b12_renal_dialysis.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;

input
pbp_a_hnumber
pbp_a_plan_identifier
pbp_a_ben_cov
pbp_a_plan_type
orgtype
pbp_b12_auth
pbp_b12_coins_cov_mc_ia
pbp_b12_coins_cov_mc_oa
pbp_b12_coins_pct_mc_ia
pbp_b12_coins_pct_mc_oa
pbp_b12_coins_yn
pbp_b12_copay_mc_amt_ia
pbp_b12_copay_mc_amt_oa
pbp_b12_copay_yn
pbp_b12_ded_amt
pbp_b12_ded_yn
pbp_b12_maxenr_amt
pbp_b12_maxenr_per
pbp_b12_maxenr_yn
pbp_b12_refer_yn
pbp_b12_sep_cost_yn;

  label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_b12_maxenr_yn                = 'Renal Dialysis Max Enr YN      '
  pbp_b12_maxenr_amt               = 'Renal Dialysis Max Enr Amt     '
  pbp_b12_maxenr_per               = 'Renal Dialysis Max Enr Per     '
  pbp_b12_coins_yn                 = 'Renal Dialysis Coinsurance YN  '
  pbp_b12_coins_pct_mc_ia          = 'Renal Dialysis IA MC Coins Pct '
  pbp_b12_coins_cov_mc_ia          = 'Renal Dialysis IA MC Coins Cov '
  pbp_b12_coins_pct_mc_oa          = 'Renal Dialysis OA MC Coins Pct '
  pbp_b12_coins_cov_mc_oa          = 'Renal Dialysis OA MC Coins Cov '
  pbp_b12_ded_yn                   = 'Renal Dialysis Deductible YN   '
  pbp_b12_ded_amt                  = 'Renal Dialysis Deductible Amt  '
  pbp_b12_copay_yn                 = 'Renal Dialysis Copayment YN    '
  pbp_b12_copay_mc_amt_ia          = 'Renal Dialysis IA MC Copay Amt '
  pbp_b12_copay_mc_amt_oa          = 'Renal Dialysis OA MC Copay Amt '
  pbp_b12_auth                     = 'Renal Dialysis Auth            '
  pbp_b12_refer_yn                 = 'Renal Dialysis Referral YN     '
  pbp_b12_sep_cost_yn              = 'Separate Cost Share YN         ';
run;

proc sort data = pbp_b12 out= out.pbp_b12;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b12 (obs = 10);
  title 'pbp b12 data';
run;

proc means data =  out.pbp_b12;
  title 'pbp b12 file';
run;

proc freq data = out.pbp_b12;
  table
  orgtype
  pbp_b12_maxenr_yn
  pbp_b12_maxenr_per
  pbp_b12_coins_yn
  pbp_b12_coins_cov_mc_ia
  pbp_b12_coins_cov_mc_oa
  pbp_b12_ded_yn
  pbp_b12_copay_yn
  pbp_b12_auth
  pbp_b12_refer_yn
  pbp_b12_sep_cost_yn / missing;
run;

proc contents data = out.pbp_b12;
  title 'pbp b12 data';
run;
