*pbp_b14ei.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b14ei;

length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_b14e_bendesc                 $1
  pbp_b14e_cost_share              $1
  pbp_b14f_bendesc                 $1
  pbp_b14f_cost_share              $1
  pbp_b14g_cost_share              $1
  pbp_b14h_bendesc                 $1
  pbp_b14h_cost_share              $1
  pbp_b14i_cost_share              $1
  pbp_b14e_bendesc_yn              $1
  pbp_b14e_bendesc_amo             $1
  pbp_b14e_bendesc_lim_ps_yn       $1
  pbp_b14e_bendesc_as_per          $1
  pbp_b14e_maxplan_yn              $1
  pbp_b14e_maxplan_type            $1
  pbp_b14e_maxplan_per             $1
  pbp_b14e_maxplan_cov             $1
  pbp_b14e_maxenr_yn               $1
  pbp_b14e_maxenr_type             $1
  pbp_b14e_maxenr_per              $1
  pbp_b14e_coins_yn                $1
  pbp_b14e_coins_cov               $1
  pbp_b14e_as_coins_cov            $1
  pbp_b14e_ded_yn                  $1
  pbp_b14e_copay_yn                $1
  pbp_b14e_auth                    $5
  pbp_b14e_refer_yn                $1
  pbp_b14f_bendesc_yn              $1
  pbp_b14f_bendesc_amo             $1
  pbp_b14f_bendesc_lim_cs_yn       $1
  pbp_b14f_bendesc_as_per          $1
  pbp_b14f_maxplan_yn              $1
  pbp_b14f_maxplan_type            $1
  pbp_b14f_maxplan_per             $1
  pbp_b14f_maxplan_cov             $1
  pbp_b14f_maxenr_yn               $1
  pbp_b14f_maxenr_type             $1
  pbp_b14f_maxenr_per              $1
  pbp_b14f_coins_yn                $1
  pbp_b14f_coins_cov               $1
  pbp_b14f_as_coins_cov            $1
  pbp_b14f_ded_yn                  $1
  pbp_b14f_copay_yn                $1
  pbp_b14f_auth                    $5
  pbp_b14f_refer_yn                $1
  pbp_b14g_maxenr_yn               $1
  pbp_b14g_maxenr_type             $1
  pbp_b14g_coins_yn                $1
  pbp_b14g_coins_cov               $1
  pbp_b14g_ded_yn                  $1
  pbp_b14g_copay_yn                $1
  pbp_b14g_auth                    $5
  pbp_b14g_refer_yn                $1
  pbp_b14h_bendesc_yn              $1
  pbp_b14h_bendesc_amo             $1
  pbp_b14h_bendesc_lim_ms_yn       $1
  pbp_b14h_bendesc_as_per          $1
  pbp_b14h_maxplan_yn              $1
  pbp_b14h_maxplan_type            $1
  pbp_b14h_maxplan_per             $1
  pbp_b14h_maxplan_cov             $1
  pbp_b14h_maxenr_yn               $1
  pbp_b14h_maxenr_type             $1
  pbp_b14h_maxenr_per              $1
  pbp_b14h_coins_yn                $1
  pbp_b14h_coins_cov               $1
  pbp_b14h_as_coins_cov            $1
  pbp_b14h_ded_yn                  $1
  pbp_b14h_copay_yn                $1
  pbp_b14h_auth                    $5
  pbp_b14h_refer_yn                $1
  pbp_b14i_maxenr_yn               $1
  pbp_b14i_maxenr_type             $1
  pbp_b14i_maxenr_per              $1
  pbp_b14i_coins_yn                $1
  pbp_b14i_coins_cov               $1
  pbp_b14i_ded_yn                  $1
  pbp_b14i_copay_yn                $1
  pbp_b14i_auth                    $5
  pbp_b14i_refer_yn                $1
  pbp_b14e_sep_cost_yn             $1
  pbp_b14f_sep_cost_yn             $1
  pbp_b14g_sep_cost_yn             $1
  pbp_b14h_sep_cost_yn             $1
  pbp_b14g_maxenr_per              $1;

infile '.\pbp\pbp_b14_preventive_2.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;

input
pbp_a_hnumber
pbp_a_plan_identifier
pbp_a_ben_cov
pbp_a_plan_type
orgtype
pbp_b14e_ad_coins_pct
pbp_b14e_as_coins_cov
pbp_b14e_as_copay_amt
pbp_b14e_auth
pbp_b14e_bendesc
pbp_b14e_bendesc_amo
pbp_b14e_bendesc_as_per
pbp_b14e_bendesc_lim_ps_yn
pbp_b14e_bendesc_numps
pbp_b14e_bendesc_yn
pbp_b14e_coins_cov
pbp_b14e_coins_pct
pbp_b14e_coins_yn
pbp_b14e_copay_amt
pbp_b14e_copay_yn
pbp_b14e_cost_share
pbp_b14e_ded_amt
pbp_b14e_ded_yn
pbp_b14e_maxenr_amt
pbp_b14e_maxenr_per
pbp_b14e_maxenr_type
pbp_b14e_maxenr_yn
pbp_b14e_maxplan_amt
pbp_b14e_maxplan_cov
pbp_b14e_maxplan_per
pbp_b14e_maxplan_type
pbp_b14e_maxplan_yn
pbp_b14e_refer_yn
pbp_b14e_sep_cost_yn
pbp_b14f_as_coins_cov
pbp_b14f_as_coins_max_pct
pbp_b14f_as_coins_pct
pbp_b14f_auth
pbp_b14f_bendesc
pbp_b14f_bendesc_amo
pbp_b14f_bendesc_as_per
pbp_b14f_bendesc_lim_cs_yn
pbp_b14f_bendesc_numps
pbp_b14f_bendesc_yn
pbp_b14f_coins_cov
pbp_b14f_coins_max_pct
pbp_b14f_coins_pct
pbp_b14f_coins_yn
pbp_b14f_copay_as_max_amt
pbp_b14f_copay_as_min_amt
pbp_b14f_copay_mc_max_amt
pbp_b14f_copay_mc_min_amt
pbp_b14f_copay_yn
pbp_b14f_cost_share
pbp_b14f_ded_amt
pbp_b14f_ded_yn
pbp_b14f_maxenr_amt
pbp_b14f_maxenr_per
pbp_b14f_maxenr_type
pbp_b14f_maxenr_yn
pbp_b14f_maxplan_amt
pbp_b14f_maxplan_cov
pbp_b14f_maxplan_per
pbp_b14f_maxplan_type
pbp_b14f_maxplan_yn
pbp_b14f_refer_yn
pbp_b14f_sep_cost_yn
pbp_b14g_auth
pbp_b14g_coins_cov
pbp_b14g_coins_pct
pbp_b14g_coins_yn
pbp_b14g_copay_amt
pbp_b14g_copay_yn
pbp_b14g_cost_share
pbp_b14g_ded_amt
pbp_b14g_ded_yn
pbp_b14g_maxenr_amt
pbp_b14g_maxenr_per
pbp_b14g_maxenr_type
pbp_b14g_maxenr_yn
pbp_b14g_refer_yn
pbp_b14g_sep_cost_yn
pbp_b14h_ad_coins_pct
pbp_b14h_as_coins_cov
pbp_b14h_as_copay_amt
pbp_b14h_auth
pbp_b14h_bendesc
pbp_b14h_bendesc_amo
pbp_b14h_bendesc_as_per
pbp_b14h_bendesc_lim_ms_yn
pbp_b14h_bendesc_numps
pbp_b14h_bendesc_yn
pbp_b14h_coins_cov
pbp_b14h_coins_pct
pbp_b14h_coins_yn
pbp_b14h_copay_max_amt
pbp_b14h_copay_min_amt
pbp_b14h_copay_yn
pbp_b14h_cost_share
pbp_b14h_ded_amt
pbp_b14h_ded_yn
pbp_b14h_maxenr_amt
pbp_b14h_maxenr_per
pbp_b14h_maxenr_type
pbp_b14h_maxenr_yn
pbp_b14h_maxplan_amt
pbp_b14h_maxplan_cov
pbp_b14h_maxplan_per
pbp_b14h_maxplan_type
pbp_b14h_maxplan_yn
pbp_b14h_refer_yn
pbp_b14h_sep_cost_yn
pbp_b14i_auth
pbp_b14i_coins_cov
pbp_b14i_coins_max_pct
pbp_b14i_coins_pct
pbp_b14i_coins_yn
pbp_b14i_copay_mc_max_amt
pbp_b14i_copay_mc_min_amt
pbp_b14i_copay_yn
pbp_b14i_cost_share
pbp_b14i_ded_amt
pbp_b14i_ded_yn
pbp_b14i_maxenr_amt
pbp_b14i_maxenr_per
pbp_b14i_maxenr_type
pbp_b14i_maxenr_yn
pbp_b14i_refer_yn;

  label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_b14e_bendesc_yn              = 'Prostate Scrn Ben Desc YN      '
  pbp_b14e_bendesc                 = 'Prostate Scrn Ben Desc Enhance '
  pbp_b14e_bendesc_amo             = 'Prostate Scrn Ben Desc AMO     '
  pbp_b14e_bendesc_lim_ps_yn       = 'Prostate Scrn Ben Desc Lim YN  '
  pbp_b14e_bendesc_numps           = 'Prostate Scrn Ben Desc Num     '
  pbp_b14e_bendesc_as_per          = 'Prostate Scrn Ben Desc Per     '
  pbp_b14e_maxplan_yn              = 'Prostate Scrn Max Plan YN      '
  pbp_b14e_maxplan_type            = 'Prostate Scrn Max Plan Type    '
  pbp_b14e_maxplan_amt             = 'Prostate Scrn Max Plan Amt     '
  pbp_b14e_maxplan_per             = 'Prostate Scrn Max Plan Per     '
  pbp_b14e_maxplan_cov             = 'Prostate Scrn Max Plan Cov     '
  pbp_b14e_maxenr_yn               = 'Prostate Scrn Max Enr YN       '
  pbp_b14e_maxenr_type             = 'Prostate Scrn Max Enr Type     '
  pbp_b14e_maxenr_amt              = 'Prostate Scrn Max Enr Amt      '
  pbp_b14e_maxenr_per              = 'Prostate Scrn Max Enr Per      '
  pbp_b14e_coins_yn                = 'Prostate Scrn Coinsurance YN   '
  pbp_b14e_coins_pct               = 'Prostate Scrn MC Coins Pct     '
  pbp_b14e_coins_cov               = 'Prostate Scrn MC Coins Cov     '
  pbp_b14e_ad_coins_pct            = 'Prostate Scrn AS Coins Pct     '
  pbp_b14e_as_coins_cov            = 'Prostate Scrn AS Coins Cov     '
  pbp_b14e_ded_yn                  = 'Prostate Scrn Deductible YN    '
  pbp_b14e_ded_amt                 = 'Prostate Scrn Deductible Amt   '
  pbp_b14e_copay_yn                = 'Prostate Scrn Copayment YN     '
  pbp_b14e_copay_amt               = 'Prostate Scrn MC Copay Amt     '
  pbp_b14e_as_copay_amt            = 'Prostate Scrn AS Copay Amt     '
  pbp_b14e_cost_share              = 'Prostate Scrn Cost Share       '
  pbp_b14e_auth                    = 'Prostate Scrn Auth             '
  pbp_b14e_refer_yn                = 'Prostate Scrn Referral YN      '
  pbp_b14f_bendesc_yn              = 'Colorctl Scrn Ben Desc YN      '
  pbp_b14f_bendesc                 = 'Colorctl Scrn Ben Desc Enhance '
  pbp_b14f_bendesc_amo             = 'Colorctl Scrn Ben Desc AMO     '
  pbp_b14f_bendesc_lim_cs_yn       = 'Colorctl Scrn Ben Desc Lim YN  '
  pbp_b14f_bendesc_numps           = 'Colorctl Scrn Ben Desc Num     '
  pbp_b14f_bendesc_as_per          = 'Colorctl Scrn Ben Desc Per     '
  pbp_b14f_maxplan_yn              = 'Colorctl Scrn Max Plan YN      '
  pbp_b14f_maxplan_type            = 'Colorctl Scrn Max Plan Type    '
  pbp_b14f_maxplan_amt             = 'Colorctl Scrn Max Plan Amt     '
  pbp_b14f_maxplan_per             = 'Colorctl Scrn Max Plan Per     '
  pbp_b14f_maxplan_cov             = 'Colorctl Scrn Max Plan Cov     '
  pbp_b14f_maxenr_yn               = 'Colorctl Scrn Max Enr YN       '
  pbp_b14f_maxenr_type             = 'Colorctl Scrn Max Enr Type     '
  pbp_b14f_maxenr_amt              = 'Colorctl Scrn Max Enr Amt      '
  pbp_b14f_maxenr_per              = 'Colorctl Scrn Max Enr Per      '
  pbp_b14f_coins_yn                = 'Colorctl Scrn Coinsurance YN   '
  pbp_b14f_coins_pct               = 'Colorctl Scrn MC Min Coins Pct '
  pbp_b14f_coins_max_pct           = 'Colorctl Scrn MC Max Coins Pct '
  pbp_b14f_coins_cov               = 'Colorctl Scrn MC Coins Cov     '
  pbp_b14f_as_coins_pct            = 'Colorctl Scrn AS Min Coins Pct '
  pbp_b14f_as_coins_max_pct        = 'Colorctl Scrn AS Max Coins Pct '
  pbp_b14f_as_coins_cov            = 'Colorctl Scrn AS Coins Cov     '
  pbp_b14f_ded_yn                  = 'Colorctl Scrn Deductible YN    '
  pbp_b14f_ded_amt                 = 'Colorctl Scrn Deductible Amt   '
  pbp_b14f_copay_yn                = 'Colorctl Scrn Copayment YN     '
  pbp_b14f_copay_mc_min_amt        = 'Colorctl Scrn MC Min Copay Amt '
  pbp_b14f_copay_mc_max_amt        = 'Colorctl Scrn MC Max Copay Amt '
  pbp_b14f_copay_as_min_amt        = 'Colorctl Scrn AS Min Copay Amt '
  pbp_b14f_copay_as_max_amt        = 'Colorctl Scrn AS Max Copay Amt '
  pbp_b14f_cost_share              = 'Colorctl Scrn Cost Share       '
  pbp_b14f_auth                    = 'Colorctl Scrn Auth             '
  pbp_b14f_refer_yn                = 'Colorctl Scrn Referral YN      '
  pbp_b14g_maxenr_yn               = 'Bone Mass Meas Max Enr YN      '
  pbp_b14g_maxenr_type             = 'Bone Mass Meas Max Enr Type    '
  pbp_b14g_maxenr_amt              = 'Bone Mass Meas Max Enr Amt     '
  pbp_b14g_coins_yn                = 'Bone Mass Meas Coinsurance YN  '
  pbp_b14g_coins_pct               = 'Bone Mass Meas Coins Pct       '
  pbp_b14g_coins_cov               = 'Bone Mass Meas Coins Cov       '
  pbp_b14g_ded_yn                  = 'Bone Mass Meas Deductible YN   '
  pbp_b14g_ded_amt                 = 'Bone Mass Meas Deductible Amt  '
  pbp_b14g_copay_yn                = 'Bone Mass Meas Copayment YN    '
  pbp_b14g_copay_amt               = 'Bone Mass Meas Copay Amt       '
  pbp_b14g_cost_share              = 'Bone Mass Meas Cost Share      '
  pbp_b14g_auth                    = 'Bone Mass Meas Auth            '
  pbp_b14g_refer_yn                = 'Bone Mass Meas Referral YN     '
  pbp_b14h_bendesc_yn              = 'Mammography Ben Desc YN        '
  pbp_b14h_bendesc                 = 'Mammography Ben Desc Enhance   '
  pbp_b14h_bendesc_amo             = 'Mammography Ben Desc AMO       '
  pbp_b14h_bendesc_lim_ms_yn       = 'Mammography Ben Desc Lim YN    '
  pbp_b14h_bendesc_numps           = 'Mammography Ben Desc Num       '
  pbp_b14h_bendesc_as_per          = 'Mammography Ben Desc Per       '
  pbp_b14h_maxplan_yn              = 'Mammography Max Plan YN        '
  pbp_b14h_maxplan_type            = 'Mammography Max Plan Type      '
  pbp_b14h_maxplan_amt             = 'Mammography Max Plan Amt       '
  pbp_b14h_maxplan_per             = 'Mammography Max Plan Per       '
  pbp_b14h_maxplan_cov             = 'Mammography Max Plan Cov       '
  pbp_b14h_maxenr_yn               = 'Mammography Max Enr YN         '
  pbp_b14h_maxenr_type             = 'Mammography Max Enr Type       '
  pbp_b14h_maxenr_amt              = 'Mammography Max Enr Amt        '
  pbp_b14h_maxenr_per              = 'Mammography Max Enr Per        '
  pbp_b14h_coins_yn                = 'Mammography Coinsurance YN     '
  pbp_b14h_coins_pct               = 'Mammography MC Coins Pct       '
  pbp_b14h_coins_cov               = 'Mammography MC Coins Cov       '
  pbp_b14h_ad_coins_pct            = 'Mammography AS Coins Pct       '
  pbp_b14h_as_coins_cov            = 'Mammography AS Coins Cov       '
  pbp_b14h_ded_yn                  = 'Mammography Deductible YN      '
  pbp_b14h_ded_amt                 = 'Mammography Deductible Amt     '
  pbp_b14h_copay_yn                = 'Mammography Copayment YN       '
  pbp_b14h_as_copay_amt            = 'Mammography AS Copay Amt       '
  pbp_b14h_cost_share              = 'Mammography Cost Share         '
  pbp_b14h_auth                    = 'Mammography Auth               '
  pbp_b14h_refer_yn                = 'Mammography Referral YN        '
  pbp_b14i_maxenr_yn               = 'Diabetes Mon Max Enr YN        '
  pbp_b14i_maxenr_type             = 'Diabetes Mon Max Enr Type      '
  pbp_b14i_maxenr_amt              = 'Diabetes Mon Max Enr Amt       '
  pbp_b14i_maxenr_per              = 'Diabetes Mon Max Enr Per       '
  pbp_b14i_coins_yn                = 'Diabetes Mon Coinsurance YN    '
  pbp_b14i_coins_pct               = 'Diabetes Mon MC Min Coins Pct  '
  pbp_b14i_coins_max_pct           = 'Diabetes Mon MC Max Coins Pct  '
  pbp_b14i_coins_cov               = 'Diabetes Mon MC Coins Cov      '
  pbp_b14i_ded_yn                  = 'Diabetes Mon Deductible YN     '
  pbp_b14i_ded_amt                 = 'Diabetes Mon Deductible Amt    '
  pbp_b14i_copay_yn                = 'Diabetes Mon Copayment YN      '
  pbp_b14i_copay_mc_min_amt        = 'Diabetes Mon MC Min Copay Amt  '
  pbp_b14i_copay_mc_max_amt        = 'Diabetes Mon MC Max Copay Amt  '
  pbp_b14i_cost_share              = 'Diabetes Mon Cost Share        '
  pbp_b14i_auth                    = 'Diabetes Mon Auth              '
  pbp_b14i_refer_yn                = 'Diabetes Mon Referral YN       '
  pbp_b14e_sep_cost_yn             = 'Separate Cost Share YN         '
  pbp_b14f_sep_cost_yn             = 'Separate Cost Share YN         '
  pbp_b14g_sep_cost_yn             = 'Separate Cost Share YN         '
  pbp_b14h_sep_cost_yn             = 'Separate Cost Share YN         '
  pbp_b14g_maxenr_per              = 'Bone Mass Meas. Max Enr Per    '
  pbp_b14h_copay_min_amt           = 'Mammography MC Min Copay Amt   '
  pbp_b14h_copay_max_amt           = 'Mammography MC Max Copay Amt   ';

run;

proc sort data = pbp_b14ei out = out.pbp_b14ei;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b14ei(obs = 10);
  title 'pbp b14ei data';
run;

proc means data =  out.pbp_b14ei;
  title 'pbp b14ei file';
run;

proc freq data = out.pbp_b14ei;
  table
  orgtype
  pbp_b14e_bendesc_yn
  pbp_b14e_bendesc_amo
  pbp_b14e_bendesc_lim_ps_yn
  pbp_b14e_bendesc_as_per
  pbp_b14e_maxplan_yn
  pbp_b14e_maxplan_type
  pbp_b14e_maxplan_per
  pbp_b14e_maxplan_cov
  pbp_b14e_maxenr_yn
  pbp_b14e_maxenr_type
  pbp_b14e_maxenr_per
  pbp_b14e_coins_yn
  pbp_b14e_coins_cov
  pbp_b14e_as_coins_cov
  pbp_b14e_ded_yn
  pbp_b14e_copay_yn
  pbp_b14e_auth
  pbp_b14e_refer_yn
  pbp_b14f_bendesc_yn
  pbp_b14f_bendesc_amo
  pbp_b14f_bendesc_lim_cs_yn
  pbp_b14f_bendesc_as_per
  pbp_b14f_maxplan_yn
  pbp_b14f_maxplan_type
  pbp_b14f_maxplan_per
  pbp_b14f_maxplan_cov
  pbp_b14f_maxenr_yn
  pbp_b14f_maxenr_type
  pbp_b14f_maxenr_per
  pbp_b14f_coins_yn
  pbp_b14f_coins_cov
  pbp_b14f_as_coins_cov
  pbp_b14f_ded_yn
  pbp_b14f_copay_yn
  pbp_b14f_auth
  pbp_b14f_refer_yn
  pbp_b14g_maxenr_yn
  pbp_b14g_maxenr_type
  pbp_b14g_coins_yn
  pbp_b14g_coins_cov
  pbp_b14g_ded_yn
  pbp_b14g_copay_yn
  pbp_b14g_auth
  pbp_b14g_refer_yn
  pbp_b14h_bendesc_yn
  pbp_b14h_bendesc_amo
  pbp_b14h_bendesc_lim_ms_yn
  pbp_b14h_bendesc_as_per
  pbp_b14h_maxplan_yn
  pbp_b14e_bendesc
  pbp_b14e_cost_share
  pbp_b14f_bendesc
  pbp_b14f_cost_share
  pbp_b14g_cost_share
  pbp_b14h_bendesc
  pbp_b14h_cost_share
  pbp_b14i_cost_share
  pbp_b14h_maxplan_type
  pbp_b14h_maxplan_per
  pbp_b14h_maxplan_cov
  pbp_b14h_maxenr_yn
  pbp_b14h_maxenr_type
  pbp_b14h_maxenr_per
  pbp_b14h_coins_yn
  pbp_b14h_coins_cov
  pbp_b14h_as_coins_cov
  pbp_b14h_ded_yn
  pbp_b14h_copay_yn
  pbp_b14h_auth
  pbp_b14h_refer_yn
  pbp_b14i_maxenr_yn
  pbp_b14i_maxenr_type
  pbp_b14i_maxenr_per
  pbp_b14i_coins_yn
  pbp_b14i_coins_cov
  pbp_b14i_ded_yn
  pbp_b14i_copay_yn
  pbp_b14i_auth
  pbp_b14i_refer_yn
  pbp_b14e_sep_cost_yn
  pbp_b14f_sep_cost_yn
  pbp_b14g_sep_cost_yn
  pbp_b14h_sep_cost_yn
  pbp_b14g_maxenr_per / missing;
run;

proc contents data = out.pbp_b14ei;
  title 'pbp b14ei data';
run;
