* pbp_b15.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b15;
  length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_b15_addl_cost                $1
  pbp_b15_auth                     $5
  pbp_b15_bendesc_amo              $1
  pbp_b15_bendesc_yn               $1
  pbp_b15_coins_mc_cov             $2
  pbp_b15_coins_mc_yn              $1
  pbp_b15_copay_mc_yn              $1
  pbp_b15_ded_cdt                  $6
  pbp_b15_ded_yn                   $1
  pbp_b15_grp1_coins_cov           $2
  pbp_b15_grp1_coins_yn            $1
  pbp_b15_grp1_copay_yn            $1
  pbp_b15_grp1_drug_types          $3
  pbp_b15_grp1_label               $2
  pbp_b15_grp1_maxplan_cov         $2
  pbp_b15_grp1_maxplan_per         $6
  pbp_b15_grp1_maxplan_yn          $1
  pbp_b15_grp1_place               $4
  pbp_b15_grp2_coins_cov           $2
  pbp_b15_grp2_coins_yn            $1
  pbp_b15_grp2_copay_yn            $1
  pbp_b15_grp2_drug_types          $3
  pbp_b15_grp2_label               $2
  pbp_b15_grp2_maxplan_cov         $2
  pbp_b15_grp2_maxplan_per         $6
  pbp_b15_grp2_maxplan_yn          $1
  pbp_b15_grp2_place               $4
  pbp_b15_grp3_coins_cov           $2
  pbp_b15_grp3_coins_yn            $1
  pbp_b15_grp3_copay_yn            $1
  pbp_b15_grp3_drug_types          $3
  pbp_b15_grp3_label               $2
  pbp_b15_grp3_maxplan_cov         $2
  pbp_b15_grp3_maxplan_per         $6
  pbp_b15_grp3_maxplan_yn          $1
  pbp_b15_grp3_place               $4
  pbp_b15_grp4_coins_cov           $2
  pbp_b15_grp4_coins_yn            $1
  pbp_b15_grp4_copay_yn            $1
  pbp_b15_grp4_drug_types          $3
  pbp_b15_grp4_label               $2
  pbp_b15_grp4_maxplan_cov         $2
  pbp_b15_grp4_maxplan_per         $6
  pbp_b15_grp4_maxplan_yn          $1
  pbp_b15_grp4_place               $4
  pbp_b15_grp5_coins_cov           $2
  pbp_b15_grp5_coins_yn            $1
  pbp_b15_grp5_copay_yn            $1
  pbp_b15_grp5_drug_types          $3
  pbp_b15_grp5_label               $2
  pbp_b15_grp5_maxplan_cov         $2
  pbp_b15_grp5_maxplan_per         $6
  pbp_b15_grp5_maxplan_yn          $1
  pbp_b15_grp5_place               $4
  pbp_b15_maxenr_cdt               $6
  pbp_b15_maxenr_per               $1
  pbp_b15_maxenr_yn                $1
  pbp_b15_maxplan_cdt              $5
  pbp_b15_maxplan_cov_cdt          $2
  pbp_b15_maxplan_grp_unlm_yn      $1
  pbp_b15_maxplan_grp_waived       $1
  pbp_b15_maxplan_net_copay_yn     $1
  pbp_b15_maxplan_per              $5
  pbp_b15_maxplan_per_cdt          $5
  pbp_b15_maxplan_types            $3
  pbp_b15_maxplan_unused_yn        $1
  pbp_b15_maxplan_yn               $1
  ;

  infile '.\pbp\pbp_b15_drugs.txt'
         delimiter = '09'x dsd lrecl = 10000 firstobs = 2 missover;
input
pbp_a_hnumber
pbp_a_plan_identifier
pbp_a_ben_cov
pbp_a_plan_type
orgtype
pbp_b15_addl_cost
pbp_b15_bendesc_amo
pbp_b15_bendesc_grp_num
pbp_b15_bendesc_yn
pbp_b15_maxplan_amt_1mth
pbp_b15_maxplan_amt_1yr
pbp_b15_maxplan_amt_3mth
pbp_b15_maxplan_amt_6mth
pbp_b15_maxplan_amt_cdt_1mth
pbp_b15_maxplan_amt_cdt_1yr
pbp_b15_maxplan_amt_cdt_3mth
pbp_b15_maxplan_amt_cdt_6mth
pbp_b15_maxplan_amt_cdt_oth
pbp_b15_maxplan_amt_oth
pbp_b15_maxplan_awpd_cdt_pct
pbp_b15_maxplan_awpf_cdt_amt
pbp_b15_maxplan_cdt
pbp_b15_maxplan_cov_cdt
pbp_b15_maxplan_grp_unlm_yn
pbp_b15_maxplan_grp_waived
pbp_b15_maxplan_mcoacp_cdt_amt
pbp_b15_maxplan_net_copay_yn
pbp_b15_maxplan_per
pbp_b15_maxplan_per_cdt
pbp_b15_maxplan_prp_cdt_pct
pbp_b15_maxplan_types
pbp_b15_maxplan_unused_yn
pbp_b15_maxplan_yn
pbp_b15_maxpln_awpf_cdt_amt_mx
pbp_b15_auth
pbp_b15_coins_awpd_mc_pct
pbp_b15_coins_awpf_mc_amt
pbp_b15_coins_awpf_mc_amt_max
pbp_b15_coins_mcoacp_mc_amt
pbp_b15_coins_mc_cov
pbp_b15_coins_mc_pct
pbp_b15_coins_mc_yn
pbp_b15_coins_prp_mc_pct
pbp_b15_copay_max_mc_amt
pbp_b15_copay_mc_yn
pbp_b15_copay_min_mc_amt
pbp_b15_ded_amt
pbp_b15_ded_cdt
pbp_b15_ded_yn
pbp_b15_grp1_coins_awpd_pct
pbp_b15_grp1_coins_awpf_amt
pbp_b15_grp1_coins_awp_amt_max
pbp_b15_grp1_coins_cov
pbp_b15_grp1_coins_mcoacp_amt
pbp_b15_grp1_coins_pct_drp
pbp_b15_grp1_coins_pct_hmo
pbp_b15_grp1_coins_pct_mo
pbp_b15_grp1_coins_pct_oth
pbp_b15_grp1_coins_prp_pct
pbp_b15_grp1_coins_yn
pbp_b15_grp1_copay_drp_amt
pbp_b15_grp1_copay_hmo_amt
pbp_b15_grp1_copay_mo_amt
pbp_b15_grp1_copay_oth_amt
pbp_b15_grp1_copay_yn
pbp_b15_grp1_drp_days
pbp_b15_grp1_drug_types
pbp_b15_grp1_hmo_days
pbp_b15_grp1_label
pbp_b15_grp1_maxplan_amt_1mth
pbp_b15_grp1_maxplan_amt_1yr
pbp_b15_grp1_maxplan_amt_3mth
pbp_b15_grp1_maxplan_amt_6mth
pbp_b15_grp1_maxplan_amt_oth
pbp_b15_grp1_maxplan_amt_pres
pbp_b15_grp1_maxplan_awpd_pct
pbp_b15_grp1_maxplan_awpf_amt
pbp_b15_grp1_maxplan_cov
pbp_b15_grp1_maxplan_mcoac_amt
pbp_b15_grp1_maxplan_per
pbp_b15_grp1_maxplan_prp_pct
pbp_b15_grp1_maxplan_yn
pbp_b15_grp1_maxpln_awp_amt_mx
pbp_b15_grp1_mo_days
pbp_b15_grp1_oth_days
pbp_b15_grp1_place
pbp_b15_grp2_coins_awpd_pct
pbp_b15_grp2_coins_awpf_amt
pbp_b15_grp2_coins_awp_amt_max
pbp_b15_grp2_coins_cov
pbp_b15_grp2_coins_mcoacp_amt
pbp_b15_grp2_coins_pct_drp
pbp_b15_grp2_coins_pct_hmo
pbp_b15_grp2_coins_pct_mo
pbp_b15_grp2_coins_pct_oth
pbp_b15_grp2_coins_prp_pct
pbp_b15_grp2_coins_yn
pbp_b15_grp2_copay_drp_amt
pbp_b15_grp2_copay_hmo_amt
pbp_b15_grp2_copay_mo_amt
pbp_b15_grp2_copay_oth_amt
pbp_b15_grp2_copay_yn
pbp_b15_grp2_drp_days
pbp_b15_grp2_drug_types
pbp_b15_grp2_hmo_days
pbp_b15_grp2_label
pbp_b15_grp2_maxplan_amt_1mth
pbp_b15_grp2_maxplan_amt_1yr
pbp_b15_grp2_maxplan_amt_3mth
pbp_b15_grp2_maxplan_amt_6mth
pbp_b15_grp2_maxplan_amt_oth
pbp_b15_grp2_maxplan_amt_pres
pbp_b15_grp2_maxplan_awpd_pct
pbp_b15_grp2_maxplan_awpf_amt
pbp_b15_grp2_maxplan_cov
pbp_b15_grp2_maxplan_mcoac_amt
pbp_b15_grp2_maxplan_per
pbp_b15_grp2_maxplan_prp_pct
pbp_b15_grp2_maxplan_yn
pbp_b15_grp2_maxpln_awp_amt_mx
pbp_b15_grp2_mo_days
pbp_b15_grp2_oth_days
pbp_b15_grp2_place
pbp_b15_grp3_coins_awpd_pct
pbp_b15_grp3_coins_awpf_amt
pbp_b15_grp3_coins_awp_amt_max
pbp_b15_grp3_coins_cov
pbp_b15_grp3_coins_mcoacp_amt
pbp_b15_grp3_coins_pct_drp
pbp_b15_grp3_coins_pct_hmo
pbp_b15_grp3_coins_pct_mo
pbp_b15_grp3_coins_pct_oth
pbp_b15_grp3_coins_prp_pct
pbp_b15_grp3_coins_yn
pbp_b15_grp3_copay_drp_amt
pbp_b15_grp3_copay_hmo_amt
pbp_b15_grp3_copay_mo_amt
pbp_b15_grp3_copay_oth_amt
pbp_b15_grp3_copay_yn
pbp_b15_grp3_drp_days
pbp_b15_grp3_drug_types
pbp_b15_grp3_hmo_days
pbp_b15_grp3_label
pbp_b15_grp3_maxplan_amt_1mth
pbp_b15_grp3_maxplan_amt_1yr
pbp_b15_grp3_maxplan_amt_3mth
pbp_b15_grp3_maxplan_amt_6mth
pbp_b15_grp3_maxplan_amt_oth
pbp_b15_grp3_maxplan_amt_pres
pbp_b15_grp3_maxplan_awpd_pct
pbp_b15_grp3_maxplan_awpf_amt
pbp_b15_grp3_maxplan_cov
pbp_b15_grp3_maxplan_mcoac_amt
pbp_b15_grp3_maxplan_per
pbp_b15_grp3_maxplan_prp_pct
pbp_b15_grp3_maxplan_yn
pbp_b15_grp3_maxpln_awp_amt_mx
pbp_b15_grp3_mo_days
pbp_b15_grp3_oth_days
pbp_b15_grp3_place
pbp_b15_grp4_coins_awpd_pct
pbp_b15_grp4_coins_awpf_amt
pbp_b15_grp4_coins_awp_amt_max
pbp_b15_grp4_coins_cov
pbp_b15_grp4_coins_mcoacp_amt
pbp_b15_grp4_coins_pct_drp
pbp_b15_grp4_coins_pct_hmo
pbp_b15_grp4_coins_pct_mo
pbp_b15_grp4_coins_pct_oth
pbp_b15_grp4_coins_prp_pct
pbp_b15_grp4_coins_yn
pbp_b15_grp4_copay_drp_amt
pbp_b15_grp4_copay_hmo_amt
pbp_b15_grp4_copay_mo_amt
pbp_b15_grp4_copay_oth_amt
pbp_b15_grp4_copay_yn
pbp_b15_grp4_drp_days
pbp_b15_grp4_drug_types
pbp_b15_grp4_hmo_days
pbp_b15_grp4_label
pbp_b15_grp4_maxplan_amt_1mth
pbp_b15_grp4_maxplan_amt_1yr
pbp_b15_grp4_maxplan_amt_3mth
pbp_b15_grp4_maxplan_amt_6mth
pbp_b15_grp4_maxplan_amt_oth
pbp_b15_grp4_maxplan_amt_pres
pbp_b15_grp4_maxplan_awpd_pct
pbp_b15_grp4_maxplan_awpf_amt
pbp_b15_grp4_maxplan_cov
pbp_b15_grp4_maxplan_mcoac_amt
pbp_b15_grp4_maxplan_per
pbp_b15_grp4_maxplan_prp_pct
pbp_b15_grp4_maxplan_yn
pbp_b15_grp4_maxpln_awp_amt_mx
pbp_b15_grp4_mo_days
pbp_b15_grp4_oth_days
pbp_b15_grp4_place
pbp_b15_grp5_coins_awpd_pct
pbp_b15_grp5_coins_awpf_amt
pbp_b15_grp5_coins_awp_amt_max
pbp_b15_grp5_coins_cov
pbp_b15_grp5_coins_mcoacp_amt
pbp_b15_grp5_coins_pct_drp
pbp_b15_grp5_coins_pct_hmo
pbp_b15_grp5_coins_pct_mo
pbp_b15_grp5_coins_pct_oth
pbp_b15_grp5_coins_prp_pct
pbp_b15_grp5_coins_yn
pbp_b15_grp5_copay_drp_amt
pbp_b15_grp5_copay_hmo_amt
pbp_b15_grp5_copay_mo_amt
pbp_b15_grp5_copay_oth_amt
pbp_b15_grp5_copay_yn
pbp_b15_grp5_drp_days
pbp_b15_grp5_drug_types
pbp_b15_grp5_hmo_days
pbp_b15_grp5_label
pbp_b15_grp5_maxplan_amt_1mth
pbp_b15_grp5_maxplan_amt_1yr
pbp_b15_grp5_maxplan_amt_3mth
pbp_b15_grp5_maxplan_amt_6mth
pbp_b15_grp5_maxplan_amt_oth
pbp_b15_grp5_maxplan_amt_pres
pbp_b15_grp5_maxplan_awpd_pct
pbp_b15_grp5_maxplan_awpf_amt
pbp_b15_grp5_maxplan_cov
pbp_b15_grp5_maxplan_mcoac_amt
pbp_b15_grp5_maxplan_per
pbp_b15_grp5_maxplan_prp_pct
pbp_b15_grp5_maxplan_yn
pbp_b15_grp5_maxpln_awp_amt_mx
pbp_b15_grp5_mo_days
pbp_b15_grp5_oth_days
pbp_b15_grp5_place
pbp_b15_maxenr_amt
pbp_b15_maxenr_cdt
pbp_b15_maxenr_per
pbp_b15_maxenr_yn
;

 label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_b15_addl_cost                = 'Addl Cost Higher Cost Drug     '
  pbp_b15_auth                     = 'Outpt Drg F Auth               '
  pbp_b15_bendesc_amo              = 'Outpt Drg Ben Desc AMO         '
  pbp_b15_bendesc_grp_num          = 'Number of Drug Groups Offered  '
  pbp_b15_bendesc_yn               = 'Outpt Drg Ben Desc YN          '
  pbp_b15_coins_awpd_mc_pct        = 'Outpt Drg AWPD Coins MC Pct    '
  pbp_b15_coins_awpf_mc_amt        = 'Outpt Drg AWPF Min Coins MC    '
  pbp_b15_coins_awpf_mc_amt_max    = 'Outpt Drg AWPF Max Coins MC    '
  pbp_b15_coins_mc_cov             = 'Outpt Drg MC Coins Cov         '
  pbp_b15_coins_mc_pct             = 'Outpt Drg MC Coins Pct         '
  pbp_b15_coins_mc_yn              = 'Outpt Drg Coinsurance YN       '
  pbp_b15_coins_mcoacp_mc_amt      = 'Outpt Drg OACP Coins MC Amt    '
  pbp_b15_coins_prp_mc_pct         = 'Outpt Drg PRP Coins MC Pct     '
  pbp_b15_copay_max_mc_amt         = 'Outpt Drg Copay Max MCB Amt    '
  pbp_b15_copay_mc_yn              = 'Outpt Drg Copayment MC YN      '
  pbp_b15_copay_min_mc_amt         = 'Outpt Drg Copay Min MCB Amt    '
  pbp_b15_ded_amt                  = 'Outpt Drg Deductible Amt       '
  pbp_b15_ded_cdt                  = 'Outpt Drg Deductible CDT       '
  pbp_b15_ded_yn                   = 'Outpt Drg Deductible YN        '
  pbp_b15_grp1_coins_awp_amt_max   = 'Outpt Drg G1 AWP Max Coin Amt  '
  pbp_b15_grp1_coins_awpd_pct      = 'Outpt Drg G1 AWPD Coins DPct   '
  pbp_b15_grp1_coins_awpf_amt      = 'Outpt Drg G1 AWP Min Coin Amt  '
  pbp_b15_grp1_coins_cov           = 'Outpt Drg G1 Coins Cov         '
  pbp_b15_grp1_coins_mcoacp_amt    = 'Outpt Drg G1 OACP Coins Amt    '
  pbp_b15_grp1_coins_pct_drp       = 'Outpt Drg G1 DRP Coins Pct     '
  pbp_b15_grp1_coins_pct_hmo       = 'Outpt Drg G1 HMO Coins Pct     '
  pbp_b15_grp1_coins_pct_mo        = 'Outpt Drg G1 MO Coins Pct      '
  pbp_b15_grp1_coins_pct_oth       = 'Outpt Drg G1 Other Coins Pct   '
  pbp_b15_grp1_coins_prp_pct       = 'Outpt Drg G1 PRP Coins DPct    '
  pbp_b15_grp1_coins_yn            = 'Outpt Drg G1 Coinsurance YN    '
  pbp_b15_grp1_copay_drp_amt       = 'Outpt Drg G1 DRP Copay Amt     '
  pbp_b15_grp1_copay_hmo_amt       = 'Outpt Drg G1 HMOCopay Amt      '
  pbp_b15_grp1_copay_mo_amt        = 'Outpt Drg G1 MO Copay Amt      '
  pbp_b15_grp1_copay_oth_amt       = 'Outpt Drg G1 Other Copay Amt   '
  pbp_b15_grp1_copay_yn            = 'Outpt Drg G1 Copayment YN      '
  pbp_b15_grp1_drp_days            = 'Outpt Drg G1 DRP # Days        '
  pbp_b15_grp1_drug_types          = 'Drug Types Covered for Group 1 '
  pbp_b15_grp1_hmo_days            = 'Outpt Drg G1 HMO # Days        '
  pbp_b15_grp1_label               = 'Group 1 Label                  '
  pbp_b15_grp1_maxplan_amt_1mth    = 'Outpt Drg G1 M Max Plan Amt    '
  pbp_b15_grp1_maxplan_amt_1yr     = 'Outpt Drg G1 A Max Plan Amt    '
  pbp_b15_grp1_maxplan_amt_3mth    = 'Outpt Drg G1 Q Max Plan Amt    '
  pbp_b15_grp1_maxplan_amt_6mth    = 'Outpt Drg G1 S Max Plan Amt    '
  pbp_b15_grp1_maxplan_amt_oth     = 'Outpt Drg G1 O Max Plan Amt    '
  pbp_b15_grp1_maxplan_amt_pres    = 'Group 1 Max Plan Amount        '
  pbp_b15_grp1_maxplan_awpd_pct    = 'Outpt Drg G1 AWPD Max Plan Pct '
  pbp_b15_grp1_maxplan_awpf_amt    = 'Outpt Drg G1 AWPF Max Plan Min '
  pbp_b15_grp1_maxplan_cov         = 'Outpt Drg G1 Max Plan Cov      '
  pbp_b15_grp1_maxplan_mcoac_amt   = 'Outpt Drg G1 OACP Max Plan Amt '
  pbp_b15_grp1_maxplan_per         = 'Outpt Drg G1 Max Plan Per      '
  pbp_b15_grp1_maxplan_prp_pct     = 'Outpt Drg G1 PRP Max Plan Pct  '
  pbp_b15_grp1_maxplan_yn          = 'Outpt Drg G1 Max Plan YN       '
  pbp_b15_grp1_maxpln_awp_amt_mx   = 'Outpt Drg G1 AWPF Max Plan Max '
  pbp_b15_grp1_mo_days             = 'Outpt Drg G1 MO # Days         '
  pbp_b15_grp1_oth_days            = 'Outpt Drg G1 Other # Days      '
  pbp_b15_grp1_place               = 'Outpt Drg G1 Place             '
  pbp_b15_grp2_coins_awp_amt_max   = 'Outpt Drg G2 AWPF Max Coins    '
  pbp_b15_grp2_coins_awpd_pct      = 'Outpt Drg G2 AWPD Coins Pct    '
  pbp_b15_grp2_coins_awpf_amt      = 'Outpt Drg G2 AWPF Min Coins    '
  pbp_b15_grp2_coins_cov           = 'Outpt Drg G2 Coins Cov         '
  pbp_b15_grp2_coins_mcoacp_amt    = 'Outpt Drg G2 OACP Coins Amt    '
  pbp_b15_grp2_coins_pct_drp       = 'Outpt Drg G2 DRP Coins Pct     '
  pbp_b15_grp2_coins_pct_hmo       = 'Outpt Drg G2 HMO Coins Pct     '
  pbp_b15_grp2_coins_pct_mo        = 'Outpt Drg G2 MO Coins Pct      '
  pbp_b15_grp2_coins_pct_oth       = 'Outpt Drg G2 Other Coins Pct   '
  pbp_b15_grp2_coins_prp_pct       = 'Outpt Drg G2 PRP Coins Pct     '
  pbp_b15_grp2_coins_yn            = 'Outpt Drg G2 Coinsurance YN    '
  pbp_b15_grp2_copay_drp_amt       = 'Outpt Drg G2 DRP Copay Amt     '
  pbp_b15_grp2_copay_hmo_amt       = 'Outpt Drg G2 HMO Copay Amt     '
  pbp_b15_grp2_copay_mo_amt        = 'Outpt Drg G2 MO Copay Amt      '
  pbp_b15_grp2_copay_oth_amt       = 'Outpt Drg G2 Other Copay Amt   '
  pbp_b15_grp2_copay_yn            = 'Outpt Drg G2 Copayment YN      '
  pbp_b15_grp2_drp_days            = 'Outpt Drg G2 DRP # Days        '
  pbp_b15_grp2_drug_types          = 'Drug Types Covered for Group 2 '
  pbp_b15_grp2_hmo_days            = 'Outpt Drg G2 HMO # Days        '
  pbp_b15_grp2_label               = 'Group 2 Label                  '
  pbp_b15_grp2_maxplan_amt_1mth    = 'Outpt Drg G2 M Max Plan Amt    '
  pbp_b15_grp2_maxplan_amt_1yr     = 'Outpt Drg G2 A Max Plan Amt    '
  pbp_b15_grp2_maxplan_amt_3mth    = 'Outpt Drg G2 Q Max Plan Amt    '
  pbp_b15_grp2_maxplan_amt_6mth    = 'Outpt Drg G2 S Max Plan Amt    '
  pbp_b15_grp2_maxplan_amt_oth     = 'Outpt Drg G2 O Max Plan Amt    '
  pbp_b15_grp2_maxplan_amt_pres    = 'Group 2 Max Plan Amount        '
  pbp_b15_grp2_maxplan_awpd_pct    = 'Outpt Drg G2 AWPD Max Pln Pct  '
  pbp_b15_grp2_maxplan_awpf_amt    = 'Outpt Drg G2 AWPF Max Pln Min  '
  pbp_b15_grp2_maxplan_cov         = 'Outpt Drg G2 Max Plan Cov      '
  pbp_b15_grp2_maxplan_mcoac_amt   = 'Outpt Drg G2 OACP Max Pln Amt  '
  pbp_b15_grp2_maxplan_per         = 'Outpt Drg G2 Max Plan Per      '
  pbp_b15_grp2_maxplan_prp_pct     = 'Outpt Drg G2 PRP Max Plan Pct  '
  pbp_b15_grp2_maxplan_yn          = 'Outpt Drg G2 Max Plan YN       '
  pbp_b15_grp2_maxpln_awp_amt_mx   = 'Outpt Drg G2 AWPF Max Pln Max  '
  pbp_b15_grp2_mo_days             = 'Outpt Drg G2 MO # Days         '
  pbp_b15_grp2_oth_days            = 'Outpt Drg G2 Other # Days      '
  pbp_b15_grp2_place               = 'Outpt Drg G2 Place             '
  pbp_b15_grp3_coins_awp_amt_max   = 'Outpt Drg G3 AWPF Max Coin Amt '
  pbp_b15_grp3_coins_awpd_pct      = 'Outpt Drg G3 AWPD Coins Pct    '
  pbp_b15_grp3_coins_awpf_amt      = 'Outpt Drg G3 AWPF Min Coin Amt '
  pbp_b15_grp3_coins_cov           = 'Outpt Drg G3 Coins Cov         '
  pbp_b15_grp3_coins_mcoacp_amt    = 'Outpt Drg G3 OACP Coins Amt    '
  pbp_b15_grp3_coins_pct_drp       = 'Outpt Drg G3 DRP Coins Pct     '
  pbp_b15_grp3_coins_pct_hmo       = 'Outpt Drg G3 HMO Coins Pct     '
  pbp_b15_grp3_coins_pct_mo        = 'Outpt Drg G3 MO Coins Pct      '
  pbp_b15_grp3_coins_pct_oth       = 'Outpt Drg G3 Other Coins Pct   '
  pbp_b15_grp3_coins_prp_pct       = 'Outpt Drg G3 PRP Coins Pct     '
  pbp_b15_grp3_coins_yn            = 'Outpt Drg G3 Coinsurance YN    '
  pbp_b15_grp3_copay_drp_amt       = 'Outpt Drg G3 DRP Copay Amt     '
  pbp_b15_grp3_copay_hmo_amt       = 'Outpt Drg G3 HMO Copay Amt     '
  pbp_b15_grp3_copay_mo_amt        = 'Outpt Drg G3 MO Copay Amt      '
  pbp_b15_grp3_copay_oth_amt       = 'Outpt Drg G3 Other Copay Amt   '
  pbp_b15_grp3_copay_yn            = 'Outpt Drg G3 Copayment YN      '
  pbp_b15_grp3_drp_days            = 'Outpt Drg G3 DRP # Days        '
  pbp_b15_grp3_drug_types          = 'Drug Types Covered for Group 3 '
  pbp_b15_grp3_hmo_days            = 'Outpt Drg G3 HMO # Days        '
  pbp_b15_grp3_label               = 'Group 3 Label                  '
  pbp_b15_grp3_maxplan_amt_1mth    = 'Outpt Drg G3 M Max Plan Amt    '
  pbp_b15_grp3_maxplan_amt_1yr     = 'Outpt Drg G3 A Max Plan Amt    '
  pbp_b15_grp3_maxplan_amt_3mth    = 'Outpt Drg G3 Q Max Plan Amt    '
  pbp_b15_grp3_maxplan_amt_6mth    = 'Outpt Drg G3 S Max Plan Amt    '
  pbp_b15_grp3_maxplan_amt_oth     = 'Outpt Drg G3 O Max Plan Amt    '
  pbp_b15_grp3_maxplan_amt_pres    = 'Group 3 Max Plan Amount        '
  pbp_b15_grp3_maxplan_awpd_pct    = 'Outpt Drg G3 AWPD Max Plan Pct '
  pbp_b15_grp3_maxplan_awpf_amt    = 'Outpt Drg G3 AWPF Max Plan Min '
  pbp_b15_grp3_maxplan_cov         = 'Outpt Drg G3 Max Plan Cov      '
  pbp_b15_grp3_maxplan_mcoac_amt   = 'Outpt Drg G3 OACP Max Plan Amt '
  pbp_b15_grp3_maxplan_per         = 'Outpt Drg G3 Max Plan Per      '
  pbp_b15_grp3_maxplan_prp_pct     = 'Outpt Drg G3 PRP Max Plan Pct  '
  pbp_b15_grp3_maxplan_yn          = 'Outpt Drg G3 Max Plan YN       '
  pbp_b15_grp3_maxpln_awp_amt_mx   = 'Outpt Drg G3 AWPF Max Plan Max '
  pbp_b15_grp3_mo_days             = 'Outpt Drg G3 MO # Days         '
  pbp_b15_grp3_oth_days            = 'Outpt Drg G3 Other # Days      '
  pbp_b15_grp3_place               = 'Outpt Drg G3 Place             '
  pbp_b15_grp4_coins_awp_amt_max   = 'Outpt Drg G4 AWPF Max Coins    '
  pbp_b15_grp4_coins_awpd_pct      = 'Outpt Drg G4 AWPD Coins Pct    '
  pbp_b15_grp4_coins_awpf_amt      = 'Outpt Drg G4 AWPF Min Coins    '
  pbp_b15_grp4_coins_cov           = 'Outpt Drg G4 Coins Cov         '
  pbp_b15_grp4_coins_mcoacp_amt    = 'Outpt Drg G4 OACP Coins Amt    '
  pbp_b15_grp4_coins_pct_drp       = 'Outpt Drg G4 DRP Coins Pct     '
  pbp_b15_grp4_coins_pct_hmo       = 'Outpt Drg G4 HMO Coins Pct     '
  pbp_b15_grp4_coins_pct_mo        = 'Outpt Drg G4 MO Coins Pct      '
  pbp_b15_grp4_coins_pct_oth       = 'Outpt Drg G4 Other Coins Pct   '
  pbp_b15_grp4_coins_prp_pct       = 'Outpt Drg G4 PRP Coins Pct     '
  pbp_b15_grp4_coins_yn            = 'Outpt Drg G4 Coins YN          '
  pbp_b15_grp4_copay_drp_amt       = 'Outpt Drg G4 DRP Copay Amt     '
  pbp_b15_grp4_copay_hmo_amt       = 'Outpt Drg G4 HMO Copay Amt     '
  pbp_b15_grp4_copay_mo_amt        = 'Outpt Drg G4 MO Copay Amt      '
  pbp_b15_grp4_copay_oth_amt       = 'Outpt Drg G4 Other Copay Amt   '
  pbp_b15_grp4_copay_yn            = 'Outpt Drg G4 Copayment YN      '
  pbp_b15_grp4_drp_days            = 'Outpt Drg G4 DRP # Days        '
  pbp_b15_grp4_drug_types          = 'Drug Types Covered for Group 4 '
  pbp_b15_grp4_hmo_days            = 'Outpt Drg G4 HMO # Days        '
  pbp_b15_grp4_label               = 'Group 4 Label                  '
  pbp_b15_grp4_maxplan_amt_1mth    = 'Outpt Drg G4 M Max Plan Amt    '
  pbp_b15_grp4_maxplan_amt_1yr     = 'Outpt Drg G4 A Max Plan Amt    '
  pbp_b15_grp4_maxplan_amt_3mth    = 'Outpt Drg G4 Q Max Plan Amt    '
  pbp_b15_grp4_maxplan_amt_6mth    = 'Outpt Drg G4 S Max Plan Amt    '
  pbp_b15_grp4_maxplan_amt_oth     = 'Outpt Drg G4 O Max Plan Amt    '
  pbp_b15_grp4_maxplan_amt_pres    = 'Group 4 Max Plan Amount        '
  pbp_b15_grp4_maxplan_awpd_pct    = 'Outpt Drg G4 AWPD Max Pln Pct  '
  pbp_b15_grp4_maxplan_awpf_amt    = 'Outpt Drg G4 AWPF Max Pln Min  '
  pbp_b15_grp4_maxplan_cov         = 'Outpt Drg G4 Max Plan Cov      '
  pbp_b15_grp4_maxplan_mcoac_amt   = 'Outpt Drg G4 OACP Max Pln Amt  '
  pbp_b15_grp4_maxplan_per         = 'Outpt Drg G4 Max Plan Per      '
  pbp_b15_grp4_maxplan_prp_pct     = 'Outpt Drg G4 PRP Max Plan Pct  '
  pbp_b15_grp4_maxplan_yn          = 'Outpt Drg G4 Max Plan YN       '
  pbp_b15_grp4_maxpln_awp_amt_mx   = 'Outpt Drg G4 AWPF Max Pln Max  '
  pbp_b15_grp4_mo_days             = 'Outpt Drg G4 MO # Days         '
  pbp_b15_grp4_oth_days            = 'Outpt Drg G4 Other # Days      '
  pbp_b15_grp4_place               = 'Outpt Drg G4 Place             '
  pbp_b15_grp5_coins_awp_amt_max   = 'Outpt Drg G5 AWPF Max Coins    '
  pbp_b15_grp5_coins_awpd_pct      = 'Outpt Drg G5 AWPD Coins Pct    '
  pbp_b15_grp5_coins_awpf_amt      = 'Outpt Drg G5 AWPF Min Coins    '
  pbp_b15_grp5_coins_cov           = 'Outpt Drg G5 Coins Cov         '
  pbp_b15_grp5_coins_mcoacp_amt    = 'Outpt Drg G5 OACP Coins Amt    '
  pbp_b15_grp5_coins_pct_drp       = 'Outpt Drg G5 DRP Coins Pct     '
  pbp_b15_grp5_coins_pct_hmo       = 'Outpt Drg G5 HMO Coins Pct     '
  pbp_b15_grp5_coins_pct_mo        = 'Outpt Drg G5 MO Coins Pct      '
  pbp_b15_grp5_coins_pct_oth       = 'Outpt Drg G5 Other Coins Pct   '
  pbp_b15_grp5_coins_prp_pct       = 'Outpt Drg G5 PRP Coins Pct     '
  pbp_b15_grp5_coins_yn            = 'Outpt Drg G5 Coins YN          '
  pbp_b15_grp5_copay_drp_amt       = 'Outpt Drg G5 DRP Copay Amt     '
  pbp_b15_grp5_copay_hmo_amt       = 'Outpt Drg G5 HMO Copay Amt     '
  pbp_b15_grp5_copay_mo_amt        = 'Outpt Drg G5 MO Copay Amt      '
  pbp_b15_grp5_copay_oth_amt       = 'Outpt Drg G5 Other Copay Amt   '
  pbp_b15_grp5_copay_yn            = 'Outpt Drg G5 Copayment YN      '
  pbp_b15_grp5_drp_days            = 'Outpt Drg G5 DRP # Days        '
  pbp_b15_grp5_drug_types          = 'Drug Types Covered for Group 5 '
  pbp_b15_grp5_hmo_days            = 'Outpt Drg G5 HMO # Days        '
  pbp_b15_grp5_label               = 'Group 5 Label                  '
  pbp_b15_grp5_maxplan_amt_1mth    = 'Outpt Drg G5 M Max Plan Amt    '
  pbp_b15_grp5_maxplan_amt_1yr     = 'Outpt Drg G5 A Max Plan Amt    '
  pbp_b15_grp5_maxplan_amt_3mth    = 'Outpt Drg G5 Q Max Plan Amt    '
  pbp_b15_grp5_maxplan_amt_6mth    = 'Outpt Drg G5 S Max Plan Amt    '
  pbp_b15_grp5_maxplan_amt_oth     = 'Outpt Drg G5 O Max Plan Amt    '
  pbp_b15_grp5_maxplan_amt_pres    = 'Group 5 Max Plan Amount        '
  pbp_b15_grp5_maxplan_awpd_pct    = 'Outpt Drg G5 AWPD Max Pln Pct  '
  pbp_b15_grp5_maxplan_awpf_amt    = 'Outpt Drg G5 AWPF Max Pln Min  '
  pbp_b15_grp5_maxplan_cov         = 'Outpt Drg G5 Max Plan Cov      '
  pbp_b15_grp5_maxplan_mcoac_amt   = 'Outpt Drg G5 OACP Max Pln Amt  '
  pbp_b15_grp5_maxplan_per         = 'Outpt Drg G5 Max Plan Per      '
  pbp_b15_grp5_maxplan_prp_pct     = 'Outpt Drg G5 PRP Max Plan Pct  '
  pbp_b15_grp5_maxplan_yn          = 'Outpt Drg G5 Max Plan YN       '
  pbp_b15_grp5_maxpln_awp_amt_mx   = 'Outpt Drg G5 AWPF Max Pln Max  '
  pbp_b15_grp5_mo_days             = 'Outpt Drg G5 MO # Days         '
  pbp_b15_grp5_oth_days            = 'Outpt Drg G5 Other # Days      '
  pbp_b15_grp5_place               = 'Outpt Drg G5 Place             '
  pbp_b15_maxenr_amt               = 'Outpt Drg Max Enr Amt          '
  pbp_b15_maxenr_cdt               = 'Outpt Drg Max Enr CDT          '
  pbp_b15_maxenr_per               = 'Max Enr Cost Period            '
  pbp_b15_maxenr_yn                = 'Outpt Drg Max Enr YN           '
  pbp_b15_maxplan_amt_1mth         = 'Outpt Drg M CDT Max Plan Amt   '
  pbp_b15_maxplan_amt_1yr          = 'Outpt Drg A CDT Max Plan Amt   '
  pbp_b15_maxplan_amt_3mth         = 'Outpt Drg Q CDT Max Plan Amt   '
  pbp_b15_maxplan_amt_6mth         = 'Outpt Drg S CDT Max Plan Amt   '
  pbp_b15_maxplan_amt_cdt_1mth     = 'Outpt Drg M CDT Max Plan Amt   '
  pbp_b15_maxplan_amt_cdt_1yr      = 'Outpt Drg A CDT Max Plan Amt   '
  pbp_b15_maxplan_amt_cdt_3mth     = 'Outpt Drg Q CDT Max Plan Amt   '
  pbp_b15_maxplan_amt_cdt_6mth     = 'Outpt Drg S CDT Max Plan Amt   '
  pbp_b15_maxplan_amt_cdt_oth      = 'Outpt Drg O CDT Max Plan Amt   '
  pbp_b15_maxplan_amt_oth          = 'Outpt Drg O CDT Max Plan Amt   '
  pbp_b15_maxplan_awpd_cdt_pct     = 'Outpt Drg AWPD Max Pln CDT Pct '
  pbp_b15_maxplan_awpf_cdt_amt     = 'Outpt Drg AWPF Max Plan CDTMIN '
  pbp_b15_maxplan_cdt              = 'Outpt Drg CDT Max Plan         '
  pbp_b15_maxplan_cov_cdt          = 'Outpt Drg CDT Max Plan Cov     '
  pbp_b15_maxplan_grp_unlm_yn      = 'Outpt Drg Max Plan Gen Lim YN  '
  pbp_b15_maxplan_grp_waived       = 'Group Maxplan Cov Waived       '
  pbp_b15_maxplan_mcoacp_cdt_amt   = 'Outpt Drg OACP Max Pln CDT Amt '
  pbp_b15_maxplan_net_copay_yn     = 'Max Plan Cov Net of Copay      '
  pbp_b15_maxplan_per              = 'Outpt Drg CDT Max Plan Per     '
  pbp_b15_maxplan_per_cdt          = 'Outpt Drg CDT Max Plan Per     '
  pbp_b15_maxplan_prp_cdt_pct      = 'Outpt Drg PRP Max Plan CDT Pct '
  pbp_b15_maxplan_types            = 'B15 Max Plan Types             '
  pbp_b15_maxplan_unused_yn        = 'Outpt Drg Max Plan Unused YN   '
  pbp_b15_maxplan_yn               = 'Outpt Drg Max Plan 1 YN        '
  pbp_b15_maxpln_awpf_cdt_amt_mx   = 'Outpt Drg AWPF Max Plan CDTMAX '
;
run;

proc sort data = pbp_b15 out = out.pbp_b15;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b15 (obs = 10);
  title 'pbp b15 data';
run;

proc means data =  out.pbp_b15;
  title 'pbp b15 file';
run;

proc freq data = out.pbp_b15;
  table
  orgtype
  pbp_b15_addl_cost
  pbp_b15_auth
  pbp_b15_bendesc_amo
  pbp_b15_bendesc_yn
  pbp_b15_coins_mc_cov
  pbp_b15_coins_mc_yn
  pbp_b15_copay_mc_yn
  pbp_b15_ded_cdt
  pbp_b15_ded_yn
  pbp_b15_grp1_coins_cov
  pbp_b15_grp1_coins_yn
  pbp_b15_grp1_copay_yn
  pbp_b15_grp1_drug_types
  pbp_b15_grp1_label
  pbp_b15_grp1_maxplan_cov
  pbp_b15_grp1_maxplan_per
  pbp_b15_grp1_maxplan_yn
  pbp_b15_grp1_place
  pbp_b15_grp2_coins_cov
  pbp_b15_grp2_coins_yn
  pbp_b15_grp2_copay_yn
  pbp_b15_grp2_drug_types
  pbp_b15_grp2_label
  pbp_b15_grp2_maxplan_cov
  pbp_b15_grp2_maxplan_per
  pbp_b15_grp2_maxplan_yn
  pbp_b15_grp2_place
  pbp_b15_grp3_coins_cov
  pbp_b15_grp3_coins_yn
  pbp_b15_grp3_copay_yn
  pbp_b15_grp3_drug_types
  pbp_b15_grp3_label
  pbp_b15_grp3_maxplan_cov
  pbp_b15_grp3_maxplan_per
  pbp_b15_grp3_maxplan_yn
  pbp_b15_grp3_place
  pbp_b15_grp4_coins_cov
  pbp_b15_grp4_coins_yn
  pbp_b15_grp4_copay_yn
  pbp_b15_grp4_drug_types
  pbp_b15_grp4_label
  pbp_b15_grp4_maxplan_cov
  pbp_b15_grp4_maxplan_per
  pbp_b15_grp4_maxplan_yn
  pbp_b15_grp4_place
  pbp_b15_grp5_coins_cov
  pbp_b15_grp5_coins_yn
  pbp_b15_grp5_copay_yn
  pbp_b15_grp5_drug_types
  pbp_b15_grp5_label
  pbp_b15_grp5_maxplan_cov
  pbp_b15_grp5_maxplan_per
  pbp_b15_grp5_maxplan_yn
  pbp_b15_grp5_place
  pbp_b15_maxenr_cdt
  pbp_b15_maxenr_per
  pbp_b15_maxenr_yn
  pbp_b15_maxplan_cdt
  pbp_b15_maxplan_cov_cdt
  pbp_b15_maxplan_grp_unlm_yn
  pbp_b15_maxplan_grp_waived
  pbp_b15_maxplan_net_copay_yn
  pbp_b15_maxplan_per
  pbp_b15_maxplan_per_cdt
  pbp_b15_maxplan_types
  pbp_b15_maxplan_unused_yn
  pbp_b15_maxplan_yn / missing;
  run;

proc contents data = out.pbp_b15;
  title 'pbp b15 data';
run;
