*pbp_b18.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b18;

length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_b18a_bendesc_yn              $1
  pbp_b18a_bendesc_amo_rht         $1
  pbp_b18a_bendesc_enh             $2
  pbp_b18a_bendesc_lim_rht         $1
  pbp_b18a_bendesc_per_rht         $1
  pbp_b18a_bendesc_amo_fha         $1
  pbp_b18a_bendesc_lim_fha         $1
  pbp_b18a_bendesc_per_fha         $1
  pbp_b18a_maxplan_yn              $1
  pbp_b18a_maxplan_per             $1
  pbp_b18a_maxplan_cov             $1
  pbp_b18a_maxenr_yn               $1
  pbp_b18a_maxenr_per              $1
  pbp_b18a_coins_yn                $1
  pbp_b18a_coins_cov               $1
  pbp_b18a_coins_cov_rht           $1
  pbp_b18a_coins_cov_fha           $1
  pbp_b18a_ded_yn                  $1
  pbp_b18a_copay_yn                $1
  pbp_b18a_auth                    $5
  pbp_b18a_refer_yn                $1
  pbp_b18b_bendesc_yn              $1
  pbp_b18b_bendesc_enh             $4
  pbp_b18b_bendesc_amo_at          $1
  pbp_b18b_bendesc_lim_at          $1
  pbp_b18b_bendesc_per_at          $1
  pbp_b18b_bendesc_amo_ie          $1
  pbp_b18b_bendesc_lim_ie          $1
  pbp_b18b_bendesc_per_ie          $1
  pbp_b18b_bendesc_amo_oe          $1
  pbp_b18b_bendesc_lim_oe          $1
  pbp_b18b_bendesc_per_oe          $1
  pbp_b18b_bendesc_amo_ote         $1
  pbp_b18b_bendesc_lim_ote         $1
  pbp_b18b_bendesc_per_ote         $1
  pbp_b18b_maxplan_yn              $1
  pbp_b18b_maxplan_type            $1
  pbp_b18b_maxplan_per             $1
  pbp_b18b_maxplan_cov             $1
  pbp_b18b_maxenr_yn               $1
  pbp_b18b_maxenr_type             $1
  pbp_b18b_maxenr_per              $1
  pbp_b18b_coins_yn                $1
  pbp_b18b_coins_cov_at            $1
  pbp_b18b_coins_cov_ie            $1
  pbp_b18b_coins_cov_oe            $1
  pbp_b18b_coins_cov_ote           $1
  pbp_b18b_ded_yn                  $1
  pbp_b18b_copay_yn                $1
  pbp_b18b_auth                    $5
  pbp_b18b_refer_yn                $1
;

infile '.\pbp\pbp_b18_hearing_exams_aids.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
pbp_a_hnumber
pbp_a_plan_identifier
pbp_a_ben_cov
pbp_a_plan_type
orgtype
pbp_b18a_auth
pbp_b18a_bendesc_amo_fha
pbp_b18a_bendesc_amo_rht
pbp_b18a_bendesc_enh
pbp_b18a_bendesc_lim_fha
pbp_b18a_bendesc_lim_rht
pbp_b18a_bendesc_numv_cl
pbp_b18a_bendesc_numv_fha
pbp_b18a_bendesc_per_fha
pbp_b18a_bendesc_per_rht
pbp_b18a_bendesc_yn
pbp_b18a_coins_cov
pbp_b18a_coins_cov_fha
pbp_b18a_coins_cov_rht
pbp_b18a_coins_pct_fha
pbp_b18a_coins_pct_max_fha
pbp_b18a_coins_pct_max_rht
pbp_b18a_coins_pct_rht
pbp_b18a_coins_yn
pbp_b18a_copay_amt
pbp_b18a_copay_amt_fha
pbp_b18a_copay_amt_max_fha
pbp_b18a_copay_amt_max_rht
pbp_b18a_copay_amt_rht
pbp_b18a_copay_yn
pbp_b18a_ded_amt
pbp_b18a_ded_yn
pbp_b18a_maxenr_amt
pbp_b18a_maxenr_per
pbp_b18a_maxenr_yn
pbp_b18a_maxplan_amt
pbp_b18a_maxplan_cov
pbp_b18a_maxplan_per
pbp_b18a_maxplan_yn
pbp_b18a_med_coins_pct
pbp_b18a_refer_yn
pbp_b18b_bendesc_amo_at
pbp_b18b_bendesc_amo_ie
pbp_b18b_bendesc_amo_oe
pbp_b18b_bendesc_amo_ote
pbp_b18b_bendesc_enh
pbp_b18b_bendesc_lim_at
pbp_b18b_bendesc_lim_ie
pbp_b18b_bendesc_lim_oe
pbp_b18b_bendesc_lim_ote
pbp_b18b_bendesc_numv_at
pbp_b18b_bendesc_numv_ie
pbp_b18b_bendesc_numv_oe
pbp_b18b_bendesc_numv_ote
pbp_b18b_bendesc_per_at
pbp_b18b_bendesc_per_ie
pbp_b18b_bendesc_per_oe
pbp_b18b_bendesc_per_ote
pbp_b18b_bendesc_yn
pbp_b18b_coins_cov_at
pbp_b18b_coins_cov_ie
pbp_b18b_coins_cov_oe
pbp_b18b_coins_cov_ote
pbp_b18b_coins_pct_at
pbp_b18b_coins_pct_ie
pbp_b18b_coins_pct_oe
pbp_b18b_coins_pct_ote
pbp_b18b_coins_yn
pbp_b18b_copay_amt_per_ie
pbp_b18b_copay_at_max_amt
pbp_b18b_copay_at_min_amt
pbp_b18b_copay_yn
pbp_b18b_ded_amt
pbp_b18b_ded_yn
pbp_b18b_maxenr_amt
pbp_b18b_maxenr_per
pbp_b18b_maxenr_type
pbp_b18b_maxenr_yn
pbp_b18b_maxplan_amt
pbp_b18b_maxplan_cov
pbp_b18b_maxplan_pct
pbp_b18b_maxplan_per
pbp_b18b_maxplan_type
pbp_b18b_maxplan_yn
pbp_b18b_auth
pbp_b18b_copay_amt_per2_ie
pbp_b18b_copay_amt_per2_oe
pbp_b18b_copay_amt_per2_ote
pbp_b18b_copay_amt_per_oe
pbp_b18b_copay_amt_per_ote
pbp_b18b_refer_yn;

  label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_b18a_bendesc_yn              = 'Hearing Exams Ben Desc YN      '
  pbp_b18a_bendesc_enh             = 'Hearing Exams Ben Desc Enhance '
  pbp_b18a_bendesc_amo_rht         = 'Hearing Exams RHT Ben Desc AMO '
  pbp_b18a_bendesc_lim_rht         = 'Hearing Exams RHT Ben Desc Lim '
  pbp_b18a_bendesc_numv_cl         = 'Hearing Exams RHT Ben Desc Num '
  pbp_b18a_bendesc_per_rht         = 'Hearing Exams RHT Ben Desc Per '
  pbp_b18a_bendesc_amo_fha         = 'Hearing Exams FHA Ben Desc AMO '
  pbp_b18a_bendesc_lim_fha         = 'Hearing Exams FHA Ben Desc Lim '
  pbp_b18a_bendesc_numv_fha        = 'Hearing Exams FHA Ben Desc Num '
  pbp_b18a_bendesc_per_fha         = 'Hearing Exams FHA Ben Desc Per '
  pbp_b18a_maxplan_yn              = 'Hearing Exams Max Plan YN      '
  pbp_b18a_maxplan_amt             = 'Hearing Exams Max Plan Amt     '
  pbp_b18a_maxplan_per             = 'Hearing Exams Max Plan Per     '
  pbp_b18a_maxplan_cov             = 'Hearing Exams Max Plan Cov     '
  pbp_b18a_maxenr_yn               = 'Hearing Exams Max Enr YN       '
  pbp_b18a_maxenr_amt              = 'Hearing Exams Max Enr Amt      '
  pbp_b18a_maxenr_per              = 'Hearing Exams Max Enr Per      '
  pbp_b18a_coins_yn                = 'Hearing Exams Coinsurance YN   '
  pbp_b18a_med_coins_pct           = 'Hearing Exams MC Coins Pct     '
  pbp_b18a_coins_cov               = 'Hearing Exams MC Coins Cov     '
  pbp_b18a_coins_pct_rht           = 'Hearing Exms RHT Min Coins Pct '
  pbp_b18a_coins_pct_max_rht       = 'Hearing Exms RHT Max Coins Pct '
  pbp_b18a_coins_cov_rht           = 'Hearing Exams RHT Coins Cov    '
  pbp_b18a_coins_pct_fha           = 'Hearing Exms FHA Min Coins Pct '
  pbp_b18a_coins_pct_max_fha       = 'Hearing Exms FHA Max Coins Pct '
  pbp_b18a_coins_cov_fha           = 'Hearing Exams FHA Coins Cov    '
  pbp_b18a_ded_yn                  = 'Hearing Exams Deductible YN    '
  pbp_b18a_ded_amt                 = 'Hearing Exams Deductible Amt   '
  pbp_b18a_copay_yn                = 'Hearing Exams Copayment YN     '
  pbp_b18a_copay_amt               = 'Hearing Exams MC Copay Amt     '
  pbp_b18a_copay_amt_rht           = 'Hearing Exms RHT Min Copay Amt '
  pbp_b18a_copay_amt_max_rht       = 'Hearing Exms RHT Max Copay Amt '
  pbp_b18a_copay_amt_fha           = 'Hearing Exms FHA Min Copay Amt '
  pbp_b18a_copay_amt_max_fha       = 'Hearing Exms FHA Max Copay Amt '
  pbp_b18a_auth                    = 'Hearing Exams Auth             '
  pbp_b18a_refer_yn                = 'Hearing Exams Referral YN      '
  pbp_b18b_bendesc_yn              = 'Hearing Aids Ben Desc YN       '
  pbp_b18b_bendesc_enh             = 'Hearing Aids Ben Desc Enhance  '
  pbp_b18b_bendesc_amo_at          = 'Hearing Aids AT Ben Desc AMO   '
  pbp_b18b_bendesc_lim_at          = 'Hearing Aids AT Ben Desc Lim   '
  pbp_b18b_bendesc_numv_at         = 'Hearing Aids AT Ben Desc Num   '
  pbp_b18b_bendesc_per_at          = 'Hearing Aids AT Ben Desc Per   '
  pbp_b18b_bendesc_amo_ie          = 'Hearing Aids IE Ben Desc AMO   '
  pbp_b18b_bendesc_lim_ie          = 'Hearing Aids IE Ben Desc Lim   '
  pbp_b18b_bendesc_numv_ie         = 'Hearing Aids IE Ben Desc Num   '
  pbp_b18b_bendesc_per_ie          = 'Hearing Aids IE Ben Desc Per   '
  pbp_b18b_bendesc_amo_oe          = 'Hearing Aids OE Ben Desc AMO   '
  pbp_b18b_bendesc_lim_oe          = 'Hearing Aids OE Ben Desc Lim   '
  pbp_b18b_bendesc_numv_oe         = 'Hearing Aids OE Ben Desc Num   '
  pbp_b18b_bendesc_per_oe          = 'Hearing Aids OE Ben Desc Per   '
  pbp_b18b_bendesc_amo_ote         = 'Hearing Aids OTE Ben Desc AMO  '
  pbp_b18b_bendesc_lim_ote         = 'Hearing Aids OTE Ben Desc Lim  '
  pbp_b18b_bendesc_numv_ote        = 'Hearing Aids OTE Ben Desc Num  '
  pbp_b18b_bendesc_per_ote         = 'Hearing Aids OTE Ben Desc Per  '
  pbp_b18b_maxplan_yn              = 'Hearing Aids Max Plan YN       '
  pbp_b18b_maxplan_type            = 'Hearing Aids Max Plan Type     '
  pbp_b18b_maxplan_amt             = 'Hearing Aids Max Plan Amt      '
  pbp_b18b_maxplan_per             = 'Hearing Aids Max Plan Per      '
  pbp_b18b_maxplan_cov             = 'Hearing Aids Max Plan Cov      '
  pbp_b18b_maxplan_pct             = 'Hearg Aids Max Plan Discnt Pct '
  pbp_b18b_maxenr_yn               = 'Hearing Aids Max Enr YN        '
  pbp_b18b_maxenr_type             = 'Hearing Aids Max Enr Type      '
  pbp_b18b_maxenr_amt              = 'Hearing Aids Max Enr Amt       '
  pbp_b18b_maxenr_per              = 'Hearing Aids Max Enr Per       '
  pbp_b18b_coins_yn                = 'Hearing Aids Coinsurance YN    '
  pbp_b18b_coins_pct_at            = 'Hearing Aids AT Coins Pct      '
  pbp_b18b_coins_cov_at            = 'Hearing Aids AT Coins Cov      '
  pbp_b18b_coins_pct_ie            = 'Hearing Aids IE Coins Pct      '
  pbp_b18b_coins_cov_ie            = 'Hearing Aids IE Coins Cov      '
  pbp_b18b_coins_pct_oe            = 'Hearing Aids OE Coins Pct      '
  pbp_b18b_coins_cov_oe            = 'Hearing Aids OE Coins Cov      '
  pbp_b18b_coins_pct_ote           = 'Hearing Aids OTE Coins Pct     '
  pbp_b18b_coins_cov_ote           = 'Hearing Aids OTE Coins Cov     '
  pbp_b18b_ded_yn                  = 'Hearing Aids Deductible YN     '
  pbp_b18b_ded_amt                 = 'Hearing Aids Deductible Amt    '
  pbp_b18b_copay_yn                = 'Hearing Aids Copayment YN      '
  pbp_b18b_copay_at_min_amt        = 'Hearing Aids AT Min Copay Amt  '
  pbp_b18b_copay_at_max_amt        = 'Hearing Aids AT Max Copay Amt  '
  pbp_b18b_copay_amt_per_ie        = 'Hearing Aids IE Copay Amt      '
  pbp_b18b_copay_amt_per2_ie       = 'Hearing Aids 2 IE Copay Amt    '
  pbp_b18b_copay_amt_per_oe        = 'Hearing Aids OE Copay Amt      '
  pbp_b18b_copay_amt_per2_oe       = 'Hearing Aids 2 OE Copay Amt    '
  pbp_b18b_copay_amt_per_ote       = 'Hearing Aids OTE Copay Amt     '
  pbp_b18b_copay_amt_per2_ote      = 'Hearing Aids 2 OTE Copay Amt   '
  pbp_b18b_auth                    = 'Hearing Aids Auth              '
  pbp_b18b_refer_yn                = 'Hearing Aids Referral YN       '
;

run;

proc sort data = pbp_b18 out = out.pbp_b18;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b18(obs = 10);
  title 'pbp b18 data';
run;

proc means data =  out.pbp_b18;
  title 'pbp b18 file';
run;

proc freq data = out.pbp_b18;
  table
  pbp_a_ben_cov pbp_a_plan_type orgtype
  pbp_b18a_bendesc_yn
  pbp_b18a_bendesc_amo_rht
  pbp_b18a_bendesc_lim_rht
  pbp_b18a_bendesc_per_rht
  pbp_b18a_bendesc_amo_fha
  pbp_b18a_bendesc_lim_fha
  pbp_b18a_bendesc_per_fha
  pbp_b18a_maxplan_yn
  pbp_b18a_maxplan_per
  pbp_b18a_maxplan_cov
  pbp_b18a_maxenr_yn
  pbp_b18a_maxenr_per
  pbp_b18a_coins_yn
  pbp_b18a_coins_cov
  pbp_b18a_coins_cov_rht
  pbp_b18a_coins_cov_fha
  pbp_b18a_ded_yn
  pbp_b18a_copay_yn
  pbp_b18a_auth
  pbp_b18a_refer_yn
  pbp_b18b_bendesc_yn
  pbp_b18b_bendesc_amo_at
  pbp_b18b_bendesc_lim_at
  pbp_b18b_bendesc_per_at
  pbp_b18b_bendesc_amo_ie
  pbp_b18b_bendesc_lim_ie
  pbp_b18b_bendesc_per_ie
  pbp_b18b_bendesc_amo_oe
  pbp_b18b_bendesc_lim_oe
  pbp_b18b_bendesc_per_oe
  pbp_b18b_bendesc_amo_ote
  pbp_b18b_bendesc_lim_ote
  pbp_b18b_bendesc_per_ote
  pbp_b18b_maxplan_yn
  pbp_b18b_maxplan_type
  pbp_b18b_maxplan_per
  pbp_b18b_maxplan_cov
  pbp_b18b_maxenr_yn
  pbp_b18b_maxenr_type
  pbp_b18b_maxenr_per
  pbp_b18b_coins_yn
  pbp_b18b_coins_cov_at
  pbp_b18b_coins_cov_ie
  pbp_b18b_coins_cov_oe
  pbp_b18b_coins_cov_ote
  pbp_b18b_ded_yn
  pbp_b18b_copay_yn
  pbp_b18b_auth
  pbp_b18b_refer_yn / missing;
run;

proc contents data = out.pbp_b18;
  title 'pbp b18 data';
run;
