*pbp_b1a.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b1a;

length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_b1a_coins_ad_intrvl_num      $1
  pbp_b1a_coins_mcs_intrvl_num     $1
  pbp_b1a_coins_nmcs_intrvl_num    $1
  pbp_b1a_coins_ps_num_bonly       $1
  pbp_b1a_copay_ad_intrvl_num      $1
  pbp_b1a_copay_mcs_intrvl_num     $1
  pbp_b1a_copay_nmcs_intrvl_num    $1
  pbp_b1a_copay_ps_num_bonly       $1
  pbp_b1a_bendesc_yn               $1
  pbp_b1a_bendesc_ad_up_nmcs       $3
  pbp_b1a_bendesc_amo_ad           $1
  pbp_b1a_bendesc_lim_ad           $1
  pbp_b1a_bendesc_amo_nmcs         $1
  pbp_b1a_bendesc_amo_up           $1
  pbp_b1a_maxenr_yn                $1
  pbp_b1a_maxenr_per               $1
  pbp_b1a_coins_yn                 $1
  pbp_b1a_coins_cov_mcs            $1
  pbp_b1a_coins_cov_ad             $1
  pbp_b1a_coins_nmcs_struc_yn      $1
  pbp_b1a_coins_cov_nmcs           $1
  pbp_b1a_coins_cov_up             $1
  pbp_b1a_ded_yn                   $1
  pbp_b1a_copay_yn                 $1
  pbp_b1a_copay_nmcs_struc_yn      $1
  pbp_b1a_auth                     $5
  pbp_b1a_refer_yn                 $1
  pbp_b1a_bendesc_yn_bonly         $1
  pbp_b1a_bendesc_amo_iact_bonly   $1
  pbp_b1a_bendesc_ulim_bonly       $1
  pbp_b1a_bendesc_per_bonly        $1
  pbp_b1a_maxplan_yn_bonly         $1
  pbp_b1a_maxplan_per_bonly        $1
  pbp_b1a_maxplan_cov_bonly        $1
  pbp_b1a_maxenr_yn_bonly          $1
  pbp_b1a_maxenr_per_bonly         $1
  pbp_b1a_coins_yn_bonly           $1
  pbp_b1a_coins_cov_bonly          $1
  pbp_b1a_ded_yn_bonly             $1
  pbp_b1a_copay_yn_bonly           $1
  pbp_b1a_auth_bonly               $5
  pbp_b1a_refer_yn_bonly           $1
  pbp_b1a_cost_share_vary_yn       $1
;

infile '.\pbp\pbp_b1a_inpat_hosp.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
pbp_a_hnumber
pbp_a_plan_identifier
pbp_a_ben_cov
pbp_a_plan_type
orgtype
pbp_b1a_auth
pbp_b1a_auth_bonly
pbp_b1a_bendesc_ad_up_nmcs
pbp_b1a_bendesc_amo_ad
pbp_b1a_bendesc_amo_iact_bonly
pbp_b1a_bendesc_amo_nmcs
pbp_b1a_bendesc_amo_up
pbp_b1a_bendesc_amt_ad
pbp_b1a_bendesc_amt_days_bonly
pbp_b1a_bendesc_lim_ad
pbp_b1a_bendesc_per_bonly
pbp_b1a_bendesc_ulim_bonly
pbp_b1a_bendesc_yn
pbp_b1a_bendesc_yn_bonly
pbp_b1a_coins_ad_bgnd_intrvl1
pbp_b1a_coins_ad_bgnd_intrvl2
pbp_b1a_coins_ad_bgnd_intrvl3
pbp_b1a_coins_ad_endd_intrvl1
pbp_b1a_coins_ad_endd_intrvl2
pbp_b1a_coins_ad_endd_intrvl3
pbp_b1a_coins_ad_intrvl_num
pbp_b1a_coins_ad_pct_intrvl1
pbp_b1a_coins_ad_pct_intrvl2
pbp_b1a_coins_ad_pct_intrvl3
pbp_b1a_coins_cov_ad
pbp_b1a_coins_cov_bonly
pbp_b1a_coins_cov_mcs
pbp_b1a_coins_cov_nmcs
pbp_b1a_coins_cov_up
pbp_b1a_coins_mcs_bgnd_intrvl1
pbp_b1a_coins_mcs_bgnd_intrvl2
pbp_b1a_coins_mcs_bgnd_intrvl3
pbp_b1a_coins_mcs_endd_intrvl1
pbp_b1a_coins_mcs_endd_intrvl2
pbp_b1a_coins_mcs_endd_intrvl3
pbp_b1a_coins_mcs_intrvl_num
pbp_b1a_coins_mcs_pct
pbp_b1a_coins_mcs_pct_intrvl1
pbp_b1a_coins_mcs_pct_intrvl2
pbp_b1a_coins_mcs_pct_intrvl3
pbp_b1a_coins_nmcs_bgnd_ntrvl1
pbp_b1a_coins_nmcs_bgnd_ntrvl2
pbp_b1a_coins_nmcs_bgnd_ntrvl3
pbp_b1a_coins_nmcs_endd_ntrvl1
pbp_b1a_coins_nmcs_endd_ntrvl2
pbp_b1a_coins_nmcs_endd_ntrvl3
pbp_b1a_coins_nmcs_intrvl_num
pbp_b1a_coins_nmcs_pct
pbp_b1a_coins_nmcs_pct_intrvl1
pbp_b1a_coins_nmcs_pct_intrvl2
pbp_b1a_coins_nmcs_pct_intrvl3
pbp_b1a_coins_nmcs_struc_yn
pbp_b1a_coins_pct_bonly
pbp_b1a_coins_pct_up
pbp_b1a_coins_ps_bgnd1_bonly
pbp_b1a_coins_ps_bgnd2_bonly
pbp_b1a_coins_ps_bgnd3_bonly
pbp_b1a_coins_ps_endd1_bonly
pbp_b1a_coins_ps_endd2_bonly
pbp_b1a_coins_ps_endd3_bonly
pbp_b1a_coins_ps_num_bonly
pbp_b1a_coins_ps_pct1_bonly
pbp_b1a_coins_ps_pct2_bonly
pbp_b1a_coins_ps_pct3_bonly
pbp_b1a_coins_yn
pbp_b1a_coins_yn_bonly
pbp_b1a_copay_ad_amt_intrvl1
pbp_b1a_copay_ad_amt_intrvl2
pbp_b1a_copay_ad_amt_intrvl3
pbp_b1a_copay_ad_bgnd_intrvl1
pbp_b1a_copay_ad_bgnd_intrvl2
pbp_b1a_copay_ad_bgnd_intrvl3
pbp_b1a_copay_ad_endd_intrvl1
pbp_b1a_copay_ad_endd_intrvl2
pbp_b1a_copay_ad_endd_intrvl3
pbp_b1a_copay_ad_intrvl_num
pbp_b1a_copay_amt_ps_bonly
pbp_b1a_copay_mcs_amt
pbp_b1a_copay_mcs_amt_intrvl1
pbp_b1a_copay_mcs_amt_intrvl2
pbp_b1a_copay_mcs_amt_intrvl3
pbp_b1a_copay_mcs_bgnd_intrvl1
pbp_b1a_copay_mcs_bgnd_intrvl2
pbp_b1a_copay_mcs_bgnd_intrvl3
pbp_b1a_copay_mcs_endd_intrvl1
pbp_b1a_copay_mcs_endd_intrvl2
pbp_b1a_copay_mcs_endd_intrvl3
pbp_b1a_copay_mcs_intrvl_num
pbp_b1a_copay_nmcs_amt
pbp_b1a_copay_nmcs_amt_intrvl1
pbp_b1a_copay_nmcs_amt_intrvl2
pbp_b1a_copay_nmcs_amt_intrvl3
pbp_b1a_copay_nmcs_bgnd_ntrvl1
pbp_b1a_copay_nmcs_bgnd_ntrvl2
pbp_b1a_copay_nmcs_bgnd_ntrvl3
pbp_b1a_copay_nmcs_endd_ntrvl1
pbp_b1a_copay_nmcs_endd_ntrvl2
pbp_b1a_copay_nmcs_endd_ntrvl3
pbp_b1a_copay_nmcs_intrvl_num
pbp_b1a_copay_nmcs_struc_yn
pbp_b1a_copay_ps_amt1_bonly
pbp_b1a_copay_ps_amt2_bonly
pbp_b1a_copay_ps_amt3_bonly
pbp_b1a_copay_ps_bgnd1_bonly
pbp_b1a_copay_ps_bgnd2_bonly
pbp_b1a_copay_ps_bgnd3_bonly
pbp_b1a_copay_ps_endd1_bonly
pbp_b1a_copay_ps_endd2_bonly
pbp_b1a_copay_ps_endd3_bonly
pbp_b1a_copay_ps_num_bonly
pbp_b1a_copay_up_amt_day
pbp_b1a_copay_up_amt_stay
pbp_b1a_copay_yn
pbp_b1a_copay_yn_bonly
pbp_b1a_cost_share_vary_yn
pbp_b1a_ded_amt
pbp_b1a_ded_amt_bonly
pbp_b1a_ded_yn
pbp_b1a_ded_yn_bonly
pbp_b1a_maxenr_amt
pbp_b1a_maxenr_amt_bonly
pbp_b1a_maxenr_per
pbp_b1a_maxenr_per_bonly
pbp_b1a_maxenr_yn
pbp_b1a_maxenr_yn_bonly
pbp_b1a_maxplan_amt_bonly
pbp_b1a_maxplan_cov_bonly
pbp_b1a_maxplan_per_bonly
pbp_b1a_maxplan_yn_bonly
pbp_b1a_refer_yn
pbp_b1a_refer_yn_bonly;

  label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_b1a_bendesc_yn               = 'IHA Ben Desc YN                '
  pbp_b1a_bendesc_ad_up_nmcs       = 'IHA Ben Desc AD/UP/NMCS Enhanc '
  pbp_b1a_bendesc_amo_ad           = 'IHA Ben Desc AD AMO            '
  pbp_b1a_bendesc_lim_ad           = 'IHA Ben Desc AD Lim YN         '
  pbp_b1a_bendesc_amt_ad           = 'IHA Ben Desc AD Amt            '
  pbp_b1a_bendesc_amo_nmcs         = 'IHA Ben Desc NMCS AMO          '
  pbp_b1a_bendesc_amo_up           = 'IHA Ben Desc UP AMO            '
  pbp_b1a_maxenr_yn                = 'IHA Max Enr YN                 '
  pbp_b1a_maxenr_amt               = 'IHA Max Enr Amt                '
  pbp_b1a_maxenr_per               = 'IHA Max Enr Per                '
  pbp_b1a_coins_yn                 = 'IHA Coinsurance YN             '
  pbp_b1a_coins_mcs_pct            = 'IHA MCS Coins Pct              '
  pbp_b1a_coins_mcs_intrvl_num     = 'IHA MCS Coins Interval Num     '
  pbp_b1a_coins_mcs_pct_intrvl1    = 'IHA MCS Coins Pct Intrvl 1     '
  pbp_b1a_coins_mcs_bgnd_intrvl1   = 'IHA MCS Coins Bgn Day Intrvl 1 '
  pbp_b1a_coins_mcs_endd_intrvl1   = 'IHA MCS Coins End Day Intrvl 1 '
  pbp_b1a_coins_mcs_pct_intrvl2    = 'IHA MCS Coins Pct Intrvl 2     '
  pbp_b1a_coins_mcs_bgnd_intrvl2   = 'IHA MCS Coins Bgn Day Intrvl 2 '
  pbp_b1a_coins_mcs_endd_intrvl2   = 'IHA MCS Coins End Day Intrvl 2 '
  pbp_b1a_coins_mcs_pct_intrvl3    = 'IHA MCS Coins Pct Intrvl 3     '
  pbp_b1a_coins_mcs_bgnd_intrvl3   = 'IHA MCS Coins Bgn Day Intrvl 3 '
  pbp_b1a_coins_mcs_endd_intrvl3   = 'IHA MCS Coins End Day Intrvl 3 '
  pbp_b1a_coins_cov_mcs            = 'IHA MCS Coins Cov              '
  pbp_b1a_coins_ad_intrvl_num      = 'IHA AD Coins Interval Num      '
  pbp_b1a_coins_ad_pct_intrvl1     = 'IHA AD Coins Pct Intrvl 1      '
  pbp_b1a_coins_ad_bgnd_intrvl1    = 'IHA AD Coins Bgn Day Intrvl 1  '
  pbp_b1a_coins_ad_endd_intrvl1    = 'IHA AD Coins End Day Intrvl 1  '
  pbp_b1a_coins_ad_pct_intrvl2     = 'IHA AD Coins Pct Intrvl 2      '
  pbp_b1a_coins_ad_bgnd_intrvl2    = 'IHA AD Coins Bgn Day Intrvl 2  '
  pbp_b1a_coins_ad_endd_intrvl2    = 'IHA AD Coins End Day Intrvl 2  '
  pbp_b1a_coins_ad_pct_intrvl3     = 'IHA AD Coins Pct Intrvl 3      '
  pbp_b1a_coins_ad_bgnd_intrvl3    = 'IHA AD Coins Bgn Day Intrvl 3  '
  pbp_b1a_coins_ad_endd_intrvl3    = 'IHA AD Coins End Day Intrvl 3  '
  pbp_b1a_coins_cov_ad             = 'IHA AD Coins Cov               '
  pbp_b1a_coins_nmcs_struc_yn      = 'IHA NMCS Coins Structure YN    '
  pbp_b1a_coins_nmcs_pct           = 'IHA NMCS Coins Pct             '
  pbp_b1a_coins_nmcs_intrvl_num    = 'IHA NMCS Coins Interval Num    '
  pbp_b1a_coins_nmcs_pct_intrvl1   = 'IHA NMCS Coins Pct Intrvl 1    '
  pbp_b1a_coins_nmcs_bgnd_ntrvl1   = 'IHA NMCS Coins BgnDay Intrvl 1 '
  pbp_b1a_coins_nmcs_endd_ntrvl1   = 'IHA NMCS Coins EndDay Intrvl 1 '
  pbp_b1a_coins_nmcs_pct_intrvl2   = 'IHA NMCS Coins Pct Intrvl 2    '
  pbp_b1a_coins_nmcs_bgnd_ntrvl2   = 'IHA NMCS Coins BgnDay Intrvl 2 '
  pbp_b1a_coins_nmcs_endd_ntrvl2   = 'IHA NMCS Coins EndDay Intrvl 2 '
  pbp_b1a_coins_nmcs_pct_intrvl3   = 'IHA NMCS Coins Pct Intrvl 3    '
  pbp_b1a_coins_nmcs_bgnd_ntrvl3   = 'IHA NMCS Coins BgnDay Intrvl 3 '
  pbp_b1a_coins_nmcs_endd_ntrvl3   = 'IHA NMCS Coins EndDay Intrvl 3 '
  pbp_b1a_coins_cov_nmcs           = 'IHA NMCS Coins Cov             '
  pbp_b1a_coins_pct_up             = 'IHA UP Coin Pct                '
  pbp_b1a_coins_cov_up             = 'IHA UP Coins Cov               '
  pbp_b1a_ded_yn                   = 'IHA Deductible YN              '
  pbp_b1a_ded_amt                  = 'IHA Deductible Amt             '
  pbp_b1a_copay_yn                 = 'IHA Copayment YN               '
  pbp_b1a_copay_mcs_amt            = 'IHA MCS Copay Amt              '
  pbp_b1a_copay_mcs_intrvl_num     = 'IHA MCS Copay Interval Num     '
  pbp_b1a_copay_mcs_amt_intrvl1    = 'IHA MCS Copay Amt Interval 1   '
  pbp_b1a_copay_mcs_bgnd_intrvl1   = 'IHA MCS Copay Bgn Day Intrvl 1 '
  pbp_b1a_copay_mcs_endd_intrvl1   = 'IHA MCS Copay End Day Intrvl 1 '
  pbp_b1a_copay_mcs_amt_intrvl2    = 'IHA MCS Copay Amt Interval 2   '
  pbp_b1a_copay_mcs_bgnd_intrvl2   = 'IHA MCS Copay Bgn Day Intrvl 2 '
  pbp_b1a_copay_mcs_endd_intrvl2   = 'IHA MCS Copay End Day Intrvl 2 '
  pbp_b1a_copay_mcs_amt_intrvl3    = 'IHA MCS Copay Amt Interval 3   '
  pbp_b1a_copay_mcs_bgnd_intrvl3   = 'IHA MCS Copay Bgn Day Intrvl 3 '
  pbp_b1a_copay_mcs_endd_intrvl3   = 'IHA MCS Copay End Day Intrvl 3 '
  pbp_b1a_copay_ad_intrvl_num      = 'IHA AD Copay Interval Num      '
  pbp_b1a_copay_ad_amt_intrvl1     = 'IHA AD Copay Amt Interval 1    '
  pbp_b1a_copay_ad_bgnd_intrvl1    = 'IHA AD Copay Bgn Day Intrvl 1  '
  pbp_b1a_copay_ad_endd_intrvl1    = 'IHA AD Copay End Day Intrvl 1  '
  pbp_b1a_copay_ad_amt_intrvl2     = 'IHA AD Copay Amt Interval 2    '
  pbp_b1a_copay_ad_bgnd_intrvl2    = 'IHA AD Copay Bgn Day Intrvl 2  '
  pbp_b1a_copay_ad_endd_intrvl2    = 'IHA AD Copay End Day Intrvl 2  '
  pbp_b1a_copay_ad_amt_intrvl3     = 'IHA AD Copay Amt Interval 3    '
  pbp_b1a_copay_ad_bgnd_intrvl3    = 'IHA AD Copay Bgn Day Intrvl 3  '
  pbp_b1a_copay_ad_endd_intrvl3    = 'IHA AD Copay End Day Intrvl 3  '
  pbp_b1a_copay_nmcs_struc_yn      = 'IHA NMCS Copay Structure YN    '
  pbp_b1a_copay_nmcs_amt           = 'IHA NMCS Copay Amt             '
  pbp_b1a_copay_nmcs_intrvl_num    = 'IHA NMCS Copay Interval Num    '
  pbp_b1a_copay_nmcs_amt_intrvl1   = 'IHA NMCS Copay Amt Interval 1  '
  pbp_b1a_copay_nmcs_bgnd_ntrvl1   = 'IHA NMCS Copay BgnDay Intrvl 1 '
  pbp_b1a_copay_nmcs_endd_ntrvl1   = 'IHA NMCS Copay EndDay Intrvl 1 '
  pbp_b1a_copay_nmcs_amt_intrvl2   = 'IHA NMCS Copay Amt Interval 2  '
  pbp_b1a_copay_nmcs_bgnd_ntrvl2   = 'IHA NMCS Copay BgnDay Intrvl 2 '
  pbp_b1a_copay_nmcs_endd_ntrvl2   = 'IHA NMCS Copay EndDay Intrvl 2 '
  pbp_b1a_copay_nmcs_amt_intrvl3   = 'IHA NMCS Copay Amt Interval 3  '
  pbp_b1a_copay_nmcs_bgnd_ntrvl3   = 'IHA NMCS Copay BgnDay Intrvl 3 '
  pbp_b1a_copay_nmcs_endd_ntrvl3   = 'IHA NMCS Copay EndDay Intrvl 3 '
  pbp_b1a_copay_up_amt_stay        = 'IHA UP Copay Stay Amt          '
  pbp_b1a_copay_up_amt_day         = 'IHA UP Copay Day Amt           '
  pbp_b1a_auth                     = 'IHA Auth                       '
  pbp_b1a_refer_yn                 = 'IHA Referral YN                '
  pbp_b1a_bendesc_yn_bonly         = 'IHA Ben Desc YN                '
  pbp_b1a_bendesc_amo_iact_bonly   = 'IHA Ben Desc AMO               '
  pbp_b1a_bendesc_ulim_bonly       = 'IHA Ben Desc Lim YN            '
  pbp_b1a_bendesc_amt_days_bonly   = 'IHA Ben Desc Num               '
  pbp_b1a_bendesc_per_bonly        = 'IHA Ben Desc Per               '
  pbp_b1a_maxplan_yn_bonly         = 'IHA Max Plan YN                '
  pbp_b1a_maxplan_amt_bonly        = 'IHA Max Plan Amt               '
  pbp_b1a_maxplan_per_bonly        = 'IHA Max Plan Per               '
  pbp_b1a_maxplan_cov_bonly        = 'IHA Max Plan Cov               '
  pbp_b1a_maxenr_yn_bonly          = 'IHA Max Enr YN                 '
  pbp_b1a_maxenr_amt_bonly         = 'IHA Max Enr Amt                '
  pbp_b1a_maxenr_per_bonly         = 'IHA Max Enr Per                '
  pbp_b1a_coins_yn_bonly           = 'IHA Coinsurance YN             '
  pbp_b1a_coins_pct_bonly          = 'IHA Coins Pct                  '
  pbp_b1a_coins_ps_num_bonly       = 'IHA PS Coins Interval Num      '
  pbp_b1a_coins_ps_pct1_bonly      = 'IHA PS Coins Pct Intrvl 1      '
  pbp_b1a_coins_ps_bgnd1_bonly     = 'IHA PS Coins Bgn Day Intrvl 1  '
  pbp_b1a_coins_ps_endd1_bonly     = 'IHA PS Coins End Day Intrvl 1  '
  pbp_b1a_coins_ps_pct2_bonly      = 'IHA PS Coins Pct Intrvl 2      '
  pbp_b1a_coins_ps_bgnd2_bonly     = 'IHA PS Coins Bgn Day Intrvl 2  '
  pbp_b1a_coins_ps_endd2_bonly     = 'IHA PS Coins End Day Intrvl 2  '
  pbp_b1a_coins_ps_pct3_bonly      = 'IHA PS Coins Pct Intrvl 3      '
  pbp_b1a_coins_ps_bgnd3_bonly     = 'IHA PS Coins Bgn Day Intrvl 3  '
  pbp_b1a_coins_ps_endd3_bonly     = 'IHA PS Coins End Day Intrvl 3  '
  pbp_b1a_coins_cov_bonly          = 'IHA PS Coins Cov               '
  pbp_b1a_ded_yn_bonly             = 'IHA Deductible YN              '
  pbp_b1a_ded_amt_bonly            = 'IHA Deductible Amt             '
  pbp_b1a_copay_yn_bonly           = 'IHA Copayment YN               '
  pbp_b1a_copay_amt_ps_bonly       = 'IHA PS Copay Amt               '
  pbp_b1a_copay_ps_num_bonly       = 'IHA PS Copay Interval Num      '
  pbp_b1a_copay_ps_amt1_bonly      = 'IHA PS Copay Amt Interval 1    '
  pbp_b1a_copay_ps_bgnd1_bonly     = 'IHA PS Copay Bgn Day Intrvl 1  '
  pbp_b1a_copay_ps_endd1_bonly     = 'IHA PS Copay End Day Intrvl 1  '
  pbp_b1a_copay_ps_amt2_bonly      = 'IHA PS Copay Amt Interval 2    '
  pbp_b1a_copay_ps_bgnd2_bonly     = 'IHA PS Copay Bgn Day Intrvl 2  '
  pbp_b1a_copay_ps_endd2_bonly     = 'IHA PS Copay End Day Intrvl 2  '
  pbp_b1a_copay_ps_amt3_bonly      = 'IHA PS Copay Amt Interval 3    '
  pbp_b1a_copay_ps_bgnd3_bonly     = 'IHA PS Copay Bgn Day Intrvl 3  '
  pbp_b1a_copay_ps_endd3_bonly     = 'IHA PS Copay End Day Intrvl 3  '
  pbp_b1a_auth_bonly               = 'IHA Auth                       '
  pbp_b1a_refer_yn_bonly           = 'IHA Referral YN                '
  pbp_b1a_cost_share_vary_yn       = 'IHA Cost Share Vary YN         '
  ;
run;

proc sort data = pbp_b1a out = out.pbp_b1a;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_b1a (obs = 10);
  title 'pbp b1a data';
run;

proc means data =  out.pbp_b1a;
  title 'pbp b1a file';
run;

proc freq data = out.pbp_b1a;
  table
  orgtype
  pbp_b1a_bendesc_yn
  pbp_b1a_bendesc_ad_up_nmcs
  pbp_b1a_coins_ad_intrvl_num
  pbp_b1a_coins_mcs_intrvl_num
  pbp_b1a_coins_nmcs_intrvl_num
  pbp_b1a_coins_ps_num_bonly
  pbp_b1a_copay_ad_intrvl_num
  pbp_b1a_copay_mcs_intrvl_num
  pbp_b1a_copay_nmcs_intrvl_num
  pbp_b1a_copay_ps_num_bonly
  pbp_b1a_bendesc_amo_ad
  pbp_b1a_bendesc_lim_ad
  pbp_b1a_bendesc_amo_nmcs
  pbp_b1a_bendesc_amo_up
  pbp_b1a_maxenr_yn
  pbp_b1a_maxenr_per
  pbp_b1a_coins_yn
  pbp_b1a_coins_cov_mcs
  pbp_b1a_coins_cov_ad
  pbp_b1a_coins_nmcs_struc_yn
  pbp_b1a_coins_cov_nmcs
  pbp_b1a_coins_cov_up
  pbp_b1a_ded_yn
  pbp_b1a_copay_yn
  pbp_b1a_copay_nmcs_struc_yn
  pbp_b1a_auth
  pbp_b1a_refer_yn
  pbp_b1a_bendesc_yn_bonly
  pbp_b1a_bendesc_amo_iact_bonly
  pbp_b1a_bendesc_ulim_bonly
  pbp_b1a_bendesc_per_bonly
  pbp_b1a_maxplan_yn_bonly
  pbp_b1a_maxplan_per_bonly
  pbp_b1a_maxplan_cov_bonly
  pbp_b1a_maxenr_yn_bonly
  pbp_b1a_maxenr_per_bonly
  pbp_b1a_coins_yn_bonly
  pbp_b1a_coins_cov_bonly
  pbp_b1a_ded_yn_bonly
  pbp_b1a_copay_yn_bonly
  pbp_b1a_auth_bonly
  pbp_b1a_cost_share_vary_yn
  pbp_b1a_refer_yn_bonly / missing;
run;

proc contents data = out.pbp_b1a;
  title 'pbp b1a data';
run;




