*pbp_step7f.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_step7f;

length
  pbp_a_hnumber                    $5
  pbp_a_plan_identifier            $3
  pbp_a_ben_cov                    $1
  pbp_a_plan_type                  $2
  orgtype                          $2
  pbp_d_opt_identifier             $3
  pbp_b7f_bendesc_rf               $1
  pbp_b7f_bendecs_yn               $1
  pbp_b7f_bendesc_amo_rf           $1
  pbp_b7f_bendesc_lim_rf           $1
  pbp_b7f_bendesc_per_rf           $1
  pbp_b7f_maxplan_yn               $1
  pbp_b7f_maxplan_per              $1
  pbp_b7f_maxplan_covb             $1
  pbp_b7f_maxenr_yn                $1
  pbp_b7f_maxenr_per               $1
  pbp_b7f_coins_yn                 $1
  pbp_b7f_coins_cov_mc             $1
  pbp_b7f_coins_cov_rf             $1
  pbp_b7f_ded_yn                   $1
  pbp_b7f_copay_yn                 $1
  pbp_b7f_auth                     $5
  pbp_b7f_refer_yn                 $1
;

infile '.\pbp\pbp_step7f.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
pbp_a_hnumber
pbp_a_plan_identifier
pbp_a_ben_cov
pbp_a_plan_type
orgtype
pbp_d_opt_identifier
pbp_b7f_auth
pbp_b7f_bendecs_yn
pbp_b7f_bendesc_amo_rf
pbp_b7f_bendesc_amt_rf
pbp_b7f_bendesc_lim_rf
pbp_b7f_bendesc_per_rf
pbp_b7f_bendesc_rf
pbp_b7f_coins_cov_mc
pbp_b7f_coins_cov_rf
pbp_b7f_coins_pct_mc_max
pbp_b7f_coins_pct_mc_min
pbp_b7f_coins_pct_rf_max
pbp_b7f_coins_pct_rf_min
pbp_b7f_coins_yn
pbp_b7f_copay_mc_amt_max
pbp_b7f_copay_mc_amt_min
pbp_b7f_copay_rf_amt_max
pbp_b7f_copay_rf_amt_min
pbp_b7f_copay_yn
pbp_b7f_ded_amt
pbp_b7f_ded_yn
pbp_b7f_maxenr_amt
pbp_b7f_maxenr_per
pbp_b7f_maxenr_yn
pbp_b7f_maxplan_amt
pbp_b7f_maxplan_covb
pbp_b7f_maxplan_per
pbp_b7f_maxplan_yn
pbp_b7f_refer_yn;

  label
  orgtype                          = 'Organization Type              '
  pbp_a_ben_cov                    = 'Coverage Criteria              '
  pbp_a_hnumber                    = 'H Number                       '
  pbp_a_plan_identifier            = 'Plan Identifier                '
  pbp_a_plan_type                  = 'Select type of Plan            '
  pbp_d_opt_identifier             = 'Option D Identifier            '
  pbp_b7f_bendecs_yn               = 'Podiatrist Ben Desc YN         '
  pbp_b7f_bendesc_rf               = 'Podiatrist RF Ben Desc Enhance '
  pbp_b7f_bendesc_amo_rf           = 'Podiatrist RF Ben Desc AMO     '
  pbp_b7f_bendesc_lim_rf           = 'Podiatrist RF Ben Desc Lim YN  '
  pbp_b7f_bendesc_amt_rf           = 'Podiatrist RF Ben Desc Amt     '
  pbp_b7f_bendesc_per_rf           = 'Podiatrist RF Ben Desc Per     '
  pbp_b7f_maxplan_yn               = 'Podiatrist Max Plan YN         '
  pbp_b7f_maxplan_amt              = 'Podiatrist Max Plan Amt        '
  pbp_b7f_maxplan_per              = 'Podiatrist Max Plan Per        '
  pbp_b7f_maxplan_covb             = 'Podiatrist Max Plan Cov        '
  pbp_b7f_maxenr_yn                = 'Podiatrist Max Enr YN          '
  pbp_b7f_maxenr_amt               = 'Podiatrist Max Enr Amt         '
  pbp_b7f_maxenr_per               = 'Podiatrist Max Enr Per         '
  pbp_b7f_coins_yn                 = 'Podiatrist Coinsurance YN      '
  pbp_b7f_coins_pct_mc_min         = 'Podiatrist MC Min Coins Pct    '
  pbp_b7f_coins_pct_mc_max         = 'Podiatrist MC Max Coins Pct    '
  pbp_b7f_coins_cov_mc             = 'Podiatrist MC Coins Cov        '
  pbp_b7f_coins_pct_rf_min         = 'Podiatry RF Min Coins Pct      '
  pbp_b7f_coins_pct_rf_max         = 'Podiatry RF Max Coins Pct      '
  pbp_b7f_coins_cov_rf             = 'Podiatrist RF Coins Cov        '
  pbp_b7f_ded_yn                   = 'Podiatrist Deductible YN       '
  pbp_b7f_ded_amt                  = 'Podiatrist Deductible Amt      '
  pbp_b7f_copay_yn                 = 'Podiatrist Copayment YN        '
  pbp_b7f_copay_mc_amt_min         = 'Podiatrist MC Min Copay Amt    '
  pbp_b7f_copay_mc_amt_max         = 'Podiatrist MC Max Copay Amt    '
  pbp_b7f_copay_rf_amt_min         = 'Podiatrist RF Min Copay Amt    '
  pbp_b7f_copay_rf_amt_max         = 'Podiatrist RF Max Copay Amt    '
  pbp_b7f_auth                     = 'Podiatrist Auth                '
  pbp_b7f_refer_yn                 = 'Podiatrist Referral YN         '
;

run;

proc sort data = pbp_step7f out = out.pbp_step7f;
   by pbp_a_hnumber pbp_a_plan_identifier;
run;

proc print data = out.pbp_step7f (obs = 10);
  title 'pbp step7f data';
run;

proc means data =  out.pbp_step7f;
  title 'pbp step7f file';
run;

proc freq data = out.pbp_step7f;
  table
  orgtype pbp_d_opt_identifier
  pbp_b7f_bendecs_yn
  pbp_b7f_bendesc_amo_rf
  pbp_b7f_bendesc_lim_rf
  pbp_b7f_bendesc_per_rf
  pbp_b7f_maxplan_yn
  pbp_b7f_maxplan_per
  pbp_b7f_maxplan_covb
  pbp_b7f_bendesc_rf
  pbp_b7f_maxenr_yn
  pbp_b7f_maxenr_per
  pbp_b7f_coins_yn
  pbp_b7f_coins_cov_mc
  pbp_b7f_coins_cov_rf
  pbp_b7f_ded_yn
  pbp_b7f_copay_yn
  pbp_b7f_auth
  pbp_b7f_refer_yn / missing;
run;

proc contents data = out.pbp_step7f;
  title 'pbp step7f data';
run;
