*pbp_Section_A.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_Section_A;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_a_npffs_flag                 $1
	pbp_a_org_name                   $50
	pbp_a_org_marketing_name         $50
	pbp_a_org_website                $50
	pbp_a_contract_number            $5
	pbp_a_plan_identifier            $3
	pbp_a_contract_period            $4
	pbp_a_org_type                   $2
	pbp_a_plan_type                  $2
	pbp_a_ben_cov                    $1
	pbp_a_plan_name                  $50
	pbp_a_service_area               $7
	pbp_a_plan_geog_name             $50
	pbp_a_eghp_yn                    $1
	pbp_a_segment_name               $50
	pbp_a_special_need_flag          $1
	pbp_a_special_need_plan_type     $1
	pbp_a_snp_full_dual              $1
	pbp_a_snp_part_dual              $1
	pbp_a_continue_yn                $1
	pbp_a_continue_costshare_yn      $1
	pbp_a_ttytdd_curmbr_phone        $14
	pbp_a_ttytdd_prombr_phone        $14
	pbp_a_curmbr_phone               $14
	pbp_a_prombr_phone               $14
	pbp_a_pd_curmbr_phone            $14
	pbp_a_pd_prombr_phone            $14
	pbp_a_pd_ttytdd_curmbr_phone     $14
	pbp_a_pd_ttytdd_prombr_phone     $14
;

infile '.\pbp\pbp_Section_A.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_a_npffs_flag
	pbp_a_org_name
	pbp_a_org_marketing_name
	pbp_a_org_website
	pbp_a_contract_number
	pbp_a_plan_identifier
	pbp_a_contract_period
	pbp_a_org_type
	pbp_a_plan_type
	pbp_a_ben_cov
	pbp_a_plan_name
	pbp_a_service_area
	pbp_a_plan_geog_name
	pbp_a_eghp_yn
	pbp_a_segment_id
	pbp_a_segment_name
	pbp_a_special_need_flag
	pbp_a_special_need_plan_type
	pbp_a_snp_full_dual
	pbp_a_snp_part_dual
	pbp_a_continue_yn
	pbp_a_continue_costshare_yn
	pbp_a_ttytdd_curmbr_phone
	pbp_a_ttytdd_prombr_phone
	pbp_a_curmbr_phone
	pbp_a_prombr_phone
	pbp_a_est_memb
	pbp_a_pd_curmbr_phone
	pbp_a_pd_prombr_phone
	pbp_a_pd_ttytdd_curmbr_phone
	pbp_a_pd_ttytdd_prombr_phone
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_a_npffs_flag                 = 'Network PFFS Flag'
	pbp_a_org_name                   = 'Organization Legal Name'
	pbp_a_org_marketing_name         = 'Organization Marketing Name'
	pbp_a_org_website                = 'Organization Web Site'
	pbp_a_contract_number            = 'Contract Number'
	pbp_a_plan_identifier            = 'Plan Identifier'
	pbp_a_contract_period            = 'Contract Period'
	pbp_a_org_type                   = 'Organization Type'
	pbp_a_plan_type                  = 'Plan Type'
	pbp_a_ben_cov                    = 'Enrollee Type'
	pbp_a_plan_name                  = 'Plan Name'
	pbp_a_service_area               = 'Service Area(s)'
	pbp_a_plan_geog_name             = 'Plan Geographic Name'
	pbp_a_eghp_yn                    = 'EGHP Plan YN'
	pbp_a_segment_id                 = 'Segment ID:'
	pbp_a_segment_name               = 'Segment Name'
	pbp_a_special_need_flag          = 'Is this a Special Needs Plan?'
	pbp_a_special_need_plan_type     = 'Special Needs Plan Type'
	pbp_a_snp_full_dual              = 'Special Needs Plan Full Dual'
	pbp_a_snp_part_dual              = 'Special Needs Plan Part Dual'
	pbp_a_continue_yn                = 'Continuation Area YN'
	pbp_a_continue_costshare_yn      = 'Continuation Area Same Cost YN'
	pbp_a_ttytdd_curmbr_phone        = 'Cur Mbr TTYTDD Num'
	pbp_a_ttytdd_prombr_phone        = 'Pro Mbr TTYTDD Num'
	pbp_a_curmbr_phone               = 'Cur Mbr Phone Num'
	pbp_a_prombr_phone               = 'Pro Mbr Phone Num'
	pbp_a_est_memb                   = 'CY 2007 Est Monthly Membership'
	pbp_a_pd_curmbr_phone            = 'Cur Mbr Part D Phone Num'
	pbp_a_pd_prombr_phone            = 'Pro Mbr Part D Phone Num'
	pbp_a_pd_ttytdd_curmbr_phone     = 'Cur Mbr Part D TTYTDD Num'
	pbp_a_pd_ttytdd_prombr_phone     = 'Pro Mbr Part D TTYTDD Num'
;

run;

proc sort data = pbp_Section_A out=out.pbp_Section_A;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_Section_A(obs = 10);
  title 'pbp_Section_A file ';
run;

proc means data = out.pbp_Section_A;
  title 'pbp_Section_A file ';
run;

proc freq data = out.pbp_Section_A;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_a_npffs_flag
	pbp_a_contract_number
	pbp_a_plan_identifier
	pbp_a_contract_period
	pbp_a_org_type
	pbp_a_plan_type
	pbp_a_ben_cov
	pbp_a_eghp_yn
	pbp_a_segment_id
	pbp_a_special_need_flag
	pbp_a_special_need_plan_type
	pbp_a_snp_full_dual
	pbp_a_snp_part_dual
	pbp_a_continue_yn
	pbp_a_continue_costshare_yn
/ missing;
run;

proc contents data = out.pbp_Section_A;
  title 'pbp_Section_A data';
run;
